/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.visit.VisitorReplaceArgs;
import org.matheclipse.core.visit.VisitorReplaceSlots;

public class Lambda {
    private Lambda() {
    }

    public static IExpr replaceSlots(IExpr expr, IAST slotsList) {
        return expr.accept(new VisitorReplaceSlots(slotsList));
    }

    public static IExpr replaceSlotsOrElse(IExpr expr, IAST slotsList, IExpr elseExpr) {
        IExpr temp = expr.accept(new VisitorReplaceSlots(slotsList));
        return temp.orElse(elseExpr);
    }

    public static IExpr replaceArgs(IExpr expr, IAST exprsList) {
        return expr.accept(new VisitorReplaceArgs(exprsList));
    }

    public static IAST forEachAppend(IAST ast, IASTAppendable result, Function<IExpr, IExpr> function) {
        int size = ast.size();
        for (int i = 1; i < size; ++i) {
            result.append(function.apply(ast.get(i)));
        }
        return result;
    }

    public static void forEach(IAST ast, Predicate<IExpr> predicate, Consumer<IExpr> consumer) {
        int size = ast.size();
        for (int i = 1; i < size; ++i) {
            IExpr t = ast.get(i);
            if (!predicate.test(t)) continue;
            consumer.accept(t);
        }
    }

    @Deprecated
    public static IExpr existsLeft(IAST ast, BiPredicate<IExpr, IExpr> stopPredicate, IExpr stopExpr, IExpr resultExpr) {
        int size = ast.size();
        for (int i = 2; i < size; ++i) {
            if (!stopPredicate.test(ast.get(i - 1), ast.get(i))) continue;
            return stopExpr;
        }
        return resultExpr;
    }

    @Deprecated
    public static boolean exists(IAST ast, Predicate<IExpr> stopPredicate, int offset) {
        int size = ast.size();
        for (int i = offset; i < size; ++i) {
            if (!stopPredicate.test(ast.get(i))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean forAll(IAST ast, Predicate<IExpr> stopPredicate, int offset) {
        int size = ast.size();
        for (int i = offset; i < size; ++i) {
            if (stopPredicate.test(ast.get(i))) continue;
            return false;
        }
        return true;
    }

    private static IExpr testMap(IAST ast, Predicate<IExpr> predicate, Function<IExpr, IExpr> function) {
        IASTAppendable result = F.NIL;
        int size = ast.size();
        for (int i = 1; i < size; ++i) {
            IExpr temp = ast.get(i);
            if (!predicate.test(temp)) continue;
            if (!result.isPresent()) {
                result = ast.copyAppendable();
            }
            if ((temp = function.apply(temp)) == null) continue;
            result.set(i, function.apply(temp));
        }
        return result;
    }

    private static IExpr testMap2(IAST list, Predicate<IExpr> predicate, Function<IExpr, IExpr> function1, Function<IExpr, IExpr> function2) {
        IASTAppendable result = F.NIL;
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            IExpr temp = list.get(i);
            if (predicate.test(temp)) {
                if (!result.isPresent()) {
                    result = list.copyAppendable();
                    for (int j = 0; j < i; ++j) {
                        result.set(j, function2.apply(temp));
                    }
                }
                result.set(i, function1.apply(temp));
                continue;
            }
            if (result == null) continue;
            result.set(i, function2.apply(temp));
        }
        return result;
    }
}

