/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.QuantityFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.NoEvalException;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IIterator;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.tensor.qty.IUnit;

public class Iterator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IIterator<IExpr> create(IAST list, int position, EvalEngine engine) {
        Object str;
        EvalEngine evalEngine = engine;
        boolean localNumericMode = evalEngine.isNumericMode();
        try {
            ISymbol variable;
            IExpr step;
            IExpr upperLimit;
            IExpr lowerLimit;
            if (list.hasNumericArgument()) {
                evalEngine.setNumericMode(true);
            }
            boolean fNumericMode = evalEngine.isNumericMode();
            int iterationLimit = evalEngine.getIterationLimit();
            switch (list.size()) {
                case 2: {
                    lowerLimit = F.C1;
                    upperLimit = evalEngine.evalWithoutNumericReset(list.arg1());
                    step = F.C1;
                    variable = null;
                    if (upperLimit instanceof Num) {
                        DoubleIterator doubleIterator = new DoubleIterator(variable, 1.0, ((INum)upperLimit).doubleValue(), 1.0);
                        return doubleIterator;
                    }
                    if (upperLimit.isInteger()) {
                        try {
                            int iUpperLimit = ((IInteger)upperLimit).toInt();
                            if (iUpperLimit > iterationLimit && iterationLimit > 0) {
                                IterationLimitExceeded.throwIt(iUpperLimit, upperLimit);
                            }
                            IntIterator intIterator = new IntIterator(variable, 1, iUpperLimit, 1);
                            return intIterator;
                        }
                        catch (ArithmeticException iUpperLimit) {}
                    } else if (upperLimit.isRational()) {
                        try {
                            int iUpperLimit = ((IRational)upperLimit).floor().toInt();
                            if (iUpperLimit > iterationLimit && iterationLimit > 0) {
                                IterationLimitExceeded.throwIt(iUpperLimit, upperLimit);
                            }
                            RationalIterator rationalIterator = new RationalIterator(variable, F.C1, (IRational)upperLimit, F.C1);
                            return rationalIterator;
                        }
                        catch (ArithmeticException iUpperLimit) {}
                    } else {
                        if (upperLimit.isQuantity()) {
                            QuantityIterator iUpperLimit = new QuantityIterator(variable, (IQuantity)upperLimit);
                            return iUpperLimit;
                        }
                        if (upperLimit.isReal()) {
                            ISignedNumberIterator iUpperLimit = new ISignedNumberIterator(variable, F.C1, (ISignedNumber)upperLimit, F.C1);
                            return iUpperLimit;
                        }
                    }
                    if (list.arg1().isVariable()) break;
                    throw new ArgumentTypeException(IOFunctions.getMessage("vloc", F.list(list.arg1()), EvalEngine.get()));
                }
                case 3: {
                    IIterator<IExpr> iUpperLimit2;
                    lowerLimit = F.C1;
                    upperLimit = evalEngine.evalWithoutNumericReset(list.arg2());
                    step = F.C1;
                    if (!(list.arg1() instanceof ISymbol)) throw new ArgumentTypeException(IOFunctions.getMessage("itraw", F.list(list.arg1()), EvalEngine.get()));
                    Object sym = (ISymbol)list.arg1();
                    if (!sym.isVariable()) throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list((IExpr)sym), EvalEngine.get()));
                    if (sym.isProtected()) {
                        throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list((IExpr)sym), EvalEngine.get()));
                    }
                    variable = sym;
                    if (upperLimit.isList()) {
                        sym = new ExprListIterator(variable, (IAST)upperLimit, evalEngine);
                        return sym;
                    }
                    if (upperLimit instanceof Num) {
                        sym = new DoubleIterator(variable, 1.0, ((INum)upperLimit).doubleValue(), 1.0);
                        return sym;
                    }
                    if (upperLimit.isInteger()) {
                        try {
                            int iUpperLimit2 = ((IInteger)upperLimit).toInt();
                            IntIterator intIterator = new IntIterator(variable, 1, iUpperLimit2, 1);
                            return intIterator;
                        }
                        catch (ArithmeticException iUpperLimit2) {
                            break;
                        }
                    }
                    if (upperLimit.isRational()) {
                        try {
                            iUpperLimit2 = new RationalIterator(variable, F.C1, (IRational)upperLimit, F.C1);
                            return iUpperLimit2;
                        }
                        catch (ArithmeticException iUpperLimit2) {
                            break;
                        }
                    }
                    if (upperLimit.isQuantity()) {
                        iUpperLimit2 = new QuantityIterator(variable, (IQuantity)upperLimit);
                        return iUpperLimit2;
                    }
                    if (!upperLimit.isReal()) break;
                    iUpperLimit2 = new ISignedNumberIterator(variable, F.C1, (ISignedNumber)upperLimit, F.C1);
                    return iUpperLimit2;
                }
                case 4: {
                    Object iLowerLimit;
                    lowerLimit = evalEngine.evalWithoutNumericReset(list.arg2());
                    upperLimit = evalEngine.evalWithoutNumericReset(list.arg3());
                    step = F.C1;
                    if (!list.arg1().isSymbol()) throw new ArgumentTypeException(IOFunctions.getMessage("itraw", F.list(list.arg1()), EvalEngine.get()));
                    Object sym = (ISymbol)list.arg1();
                    if (!sym.isVariable()) throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list((IExpr)sym), EvalEngine.get()));
                    if (sym.isProtected()) {
                        throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list((IExpr)sym), EvalEngine.get()));
                    }
                    variable = sym;
                    if (lowerLimit instanceof Num && upperLimit instanceof Num) {
                        sym = new DoubleIterator(variable, ((INum)lowerLimit).doubleValue(), ((INum)upperLimit).doubleValue(), 1.0);
                        return sym;
                    }
                    if (lowerLimit.isInteger() && upperLimit.isInteger()) {
                        try {
                            int iLowerLimit2 = ((IInteger)lowerLimit).toInt();
                            int iUpperLimit = ((IInteger)upperLimit).toInt();
                            IntIterator intIterator = new IntIterator(variable, iLowerLimit2, iUpperLimit, 1);
                            return intIterator;
                        }
                        catch (ArithmeticException iLowerLimit2) {
                            break;
                        }
                    }
                    if (lowerLimit.isRational() && upperLimit.isRational()) {
                        try {
                            iLowerLimit = new RationalIterator(variable, (IRational)lowerLimit, (IRational)upperLimit, F.C1);
                            return iLowerLimit;
                        }
                        catch (ArithmeticException iLowerLimit2) {
                            break;
                        }
                    }
                    if (lowerLimit.isQuantity() && upperLimit.isQuantity()) {
                        iLowerLimit = new QuantityIterator(variable, (IQuantity)lowerLimit, (IQuantity)upperLimit);
                        return iLowerLimit;
                    }
                    if (!lowerLimit.isReal() || !upperLimit.isReal()) break;
                    iLowerLimit = (ISignedNumber)lowerLimit;
                    ISignedNumber iUpperLimit = (ISignedNumber)upperLimit;
                    ISignedNumberIterator iSignedNumberIterator = new ISignedNumberIterator(variable, (ISignedNumber)iLowerLimit, iUpperLimit, F.C1);
                    return iSignedNumberIterator;
                }
                case 5: {
                    Object iLowerLimit;
                    lowerLimit = evalEngine.evalWithoutNumericReset(list.arg2());
                    upperLimit = evalEngine.evalWithoutNumericReset(list.arg3());
                    step = evalEngine.evalWithoutNumericReset(list.arg4());
                    if (!(list.arg1() instanceof ISymbol)) throw new ArgumentTypeException(IOFunctions.getMessage("itraw", F.list(list.arg1()), EvalEngine.get()));
                    Object sym = (ISymbol)list.arg1();
                    if (!sym.isVariable()) throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list((IExpr)sym), EvalEngine.get()));
                    if (sym.isProtected()) {
                        throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list((IExpr)sym), EvalEngine.get()));
                    }
                    variable = sym;
                    if (lowerLimit instanceof Num && upperLimit instanceof Num && step instanceof Num) {
                        sym = new DoubleIterator(variable, ((INum)lowerLimit).doubleValue(), ((INum)upperLimit).doubleValue(), ((INum)step).doubleValue());
                        return sym;
                    }
                    if (lowerLimit.isInteger() && upperLimit.isInteger() && step.isInteger()) {
                        try {
                            int iLowerLimit3 = ((IInteger)lowerLimit).toInt();
                            int iUpperLimit = ((IInteger)upperLimit).toInt();
                            int iStep = ((IInteger)step).toInt();
                            IntIterator intIterator = new IntIterator(variable, iLowerLimit3, iUpperLimit, iStep);
                            return intIterator;
                        }
                        catch (ArithmeticException iLowerLimit3) {
                            break;
                        }
                    }
                    if (lowerLimit.isRational() && upperLimit.isRational() && step.isRational()) {
                        try {
                            iLowerLimit = new RationalIterator(variable, (IRational)lowerLimit, (IRational)upperLimit, (IRational)step);
                            return iLowerLimit;
                        }
                        catch (ArithmeticException iLowerLimit3) {
                            break;
                        }
                    }
                    if (lowerLimit.isQuantity() && upperLimit.isQuantity() && step.isQuantity()) {
                        iLowerLimit = new QuantityIterator(variable, (IQuantity)lowerLimit, (IQuantity)upperLimit, (IQuantity)step);
                        return iLowerLimit;
                    }
                    if (!lowerLimit.isReal() || !upperLimit.isReal() || !step.isReal()) break;
                    iLowerLimit = new ISignedNumberIterator(variable, (ISignedNumber)lowerLimit, (ISignedNumber)upperLimit, (ISignedNumber)step);
                    return iLowerLimit;
                }
                default: {
                    String str2 = IOFunctions.getMessage("itform", F.list(list, F.ZZ(position)), EvalEngine.get());
                    throw new ArgumentTypeException(str2);
                }
            }
            str = new ExprIterator(variable, lowerLimit, upperLimit, step, fNumericMode, evalEngine);
            return str;
        }
        catch (LimitException le) {
            throw le;
        }
        catch (ArgumentTypeException atex) {
            throw atex;
        }
        catch (RuntimeException rex) {
            str = IOFunctions.getMessage("itform", F.list(list, F.ZZ(position)), EvalEngine.get());
            throw new ArgumentTypeException((String)str);
        }
        finally {
            evalEngine.setNumericMode(localNumericMode);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IIterator<IExpr> create(IAST list, ISymbol symbol, EvalEngine engine) {
        EvalEngine evalEngine = engine;
        if (symbol != null) {
            if (!symbol.isVariable()) throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(symbol), EvalEngine.get()));
            if (symbol.isProtected()) {
                throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(symbol), EvalEngine.get()));
            }
        }
        boolean localNumericMode = evalEngine.isNumericMode();
        try {
            ISymbol variable;
            IExpr step;
            IExpr upperLimit;
            IExpr lowerLimit;
            if (list.hasNumericArgument()) {
                evalEngine.setNumericMode(true);
            }
            boolean fNumericMode = evalEngine.isNumericMode();
            switch (list.size()) {
                case 2: {
                    lowerLimit = F.C1;
                    upperLimit = evalEngine.evalWithoutNumericReset(list.arg1());
                    step = F.C1;
                    variable = symbol;
                    if (upperLimit instanceof Num) {
                        DoubleIterator doubleIterator = new DoubleIterator(variable, 1.0, ((INum)upperLimit).doubleValue(), 1.0);
                        return doubleIterator;
                    }
                    if (upperLimit.isInteger()) {
                        try {
                            int iUpperLimit = ((IInteger)upperLimit).toInt();
                            IntIterator intIterator = new IntIterator(symbol, 1, iUpperLimit, 1);
                            return intIterator;
                        }
                        catch (ArithmeticException iUpperLimit) {
                            break;
                        }
                    }
                    if (upperLimit.isRational()) {
                        try {
                            RationalIterator iUpperLimit = new RationalIterator(symbol, F.C1, (IRational)upperLimit, F.C1);
                            return iUpperLimit;
                        }
                        catch (ArithmeticException iUpperLimit) {
                            break;
                        }
                    }
                    if (upperLimit.isQuantity()) {
                        QuantityIterator iUpperLimit = new QuantityIterator(symbol, (IQuantity)upperLimit);
                        return iUpperLimit;
                    }
                    if (!upperLimit.isReal()) break;
                    ISignedNumberIterator iUpperLimit = new ISignedNumberIterator(variable, F.C1, (ISignedNumber)upperLimit, F.C1);
                    return iUpperLimit;
                }
                case 3: {
                    lowerLimit = evalEngine.evalWithoutNumericReset(list.arg1());
                    upperLimit = evalEngine.evalWithoutNumericReset(list.arg2());
                    step = F.C1;
                    variable = symbol;
                    if (upperLimit.isList()) {
                        if (variable == null) throw new ArgumentTypeException(IOFunctions.getMessage("itraw", F.list(list.arg1()), EvalEngine.get()));
                        if (!variable.isVariable()) throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(variable), EvalEngine.get()));
                        if (variable.isProtected()) {
                            throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(variable), EvalEngine.get()));
                        }
                        ExprListIterator iUpperLimit = new ExprListIterator(variable, (IAST)upperLimit, evalEngine);
                        return iUpperLimit;
                    }
                    if (lowerLimit instanceof Num && upperLimit instanceof Num) {
                        DoubleIterator iUpperLimit = new DoubleIterator(variable, ((INum)lowerLimit).doubleValue(), ((INum)upperLimit).doubleValue(), 1.0);
                        return iUpperLimit;
                    }
                    if (lowerLimit.isInteger() && upperLimit.isInteger()) {
                        try {
                            int iLowerLimit = ((IInteger)lowerLimit).toInt();
                            int iUpperLimit = ((IInteger)upperLimit).toInt();
                            IntIterator intIterator = new IntIterator(symbol, iLowerLimit, iUpperLimit, 1);
                            return intIterator;
                        }
                        catch (ArithmeticException iLowerLimit) {
                            break;
                        }
                    }
                    if (lowerLimit.isRational() && upperLimit.isRational()) {
                        try {
                            RationalIterator iLowerLimit = new RationalIterator(symbol, (IRational)lowerLimit, (IRational)upperLimit, F.C1);
                            return iLowerLimit;
                        }
                        catch (ArithmeticException iLowerLimit) {
                            break;
                        }
                    }
                    if (lowerLimit.isQuantity() && upperLimit.isQuantity()) {
                        QuantityIterator iLowerLimit = new QuantityIterator(symbol, (IQuantity)lowerLimit, (IQuantity)upperLimit);
                        return iLowerLimit;
                    }
                    if (!lowerLimit.isReal() || !upperLimit.isReal()) break;
                    ISignedNumberIterator iLowerLimit = new ISignedNumberIterator(variable, (ISignedNumber)lowerLimit, (ISignedNumber)upperLimit, F.C1);
                    return iLowerLimit;
                }
                case 4: {
                    lowerLimit = evalEngine.evalWithoutNumericReset(list.arg1());
                    upperLimit = evalEngine.evalWithoutNumericReset(list.arg2());
                    step = evalEngine.evalWithoutNumericReset(list.arg3());
                    variable = symbol;
                    if (lowerLimit instanceof Num && upperLimit instanceof Num && step instanceof Num) {
                        DoubleIterator iLowerLimit = new DoubleIterator(variable, ((INum)lowerLimit).doubleValue(), ((INum)upperLimit).doubleValue(), ((INum)step).doubleValue());
                        return iLowerLimit;
                    }
                    if (lowerLimit.isInteger() && upperLimit.isInteger() && step.isInteger()) {
                        try {
                            int iLowerLimit = ((IInteger)lowerLimit).toInt();
                            int iUpperLimit = ((IInteger)upperLimit).toInt();
                            int iStep = ((IInteger)step).toInt();
                            IntIterator intIterator = new IntIterator(symbol, iLowerLimit, iUpperLimit, iStep);
                            return intIterator;
                        }
                        catch (ArithmeticException iLowerLimit) {
                            break;
                        }
                    }
                    if (lowerLimit.isRational() && upperLimit.isRational() && step.isRational()) {
                        try {
                            RationalIterator iLowerLimit = new RationalIterator(symbol, (IRational)lowerLimit, (IRational)upperLimit, (IRational)step);
                            return iLowerLimit;
                        }
                        catch (ArithmeticException iLowerLimit) {
                            break;
                        }
                    }
                    if (lowerLimit.isQuantity() && upperLimit.isQuantity() && step.isQuantity()) {
                        QuantityIterator iLowerLimit = new QuantityIterator(symbol, (IQuantity)lowerLimit, (IQuantity)upperLimit, (IQuantity)step);
                        return iLowerLimit;
                    }
                    if (!lowerLimit.isReal() || !upperLimit.isReal() || !step.isReal()) break;
                    ISignedNumberIterator iLowerLimit = new ISignedNumberIterator(variable, (ISignedNumber)lowerLimit, (ISignedNumber)upperLimit, (ISignedNumber)step);
                    return iLowerLimit;
                }
                default: {
                    lowerLimit = null;
                    upperLimit = null;
                    step = null;
                    variable = null;
                }
            }
            ExprIterator iLowerLimit = new ExprIterator(variable, lowerLimit, upperLimit, step, fNumericMode, evalEngine);
            return iLowerLimit;
        }
        catch (LimitException le) {
            throw le;
        }
        catch (ArgumentTypeException atex) {
            throw atex;
        }
        catch (RuntimeException rex) {
            throw new ClassCastException();
        }
        finally {
            evalEngine.setNumericMode(localNumericMode);
        }
    }

    private static class IntIterator
    implements IIterator<IExpr> {
        int count;
        int lowerLimit;
        int upperLimit;
        int step;
        final ISymbol variable;
        IExpr variableValue = null;
        final IExpr originalLowerLimit;
        final IExpr originalUpperLimit;
        final IExpr originalStep;

        public IntIterator(ISymbol symbol, int lowerLimit, int upperLimit, int step) {
            this.variable = symbol;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
            this.step = step;
            this.originalLowerLimit = F.ZZ(lowerLimit);
            this.originalUpperLimit = F.ZZ(upperLimit);
            this.originalStep = F.ZZ(step);
        }

        public IntIterator(int lowerLimit, int upperLimit, int step) {
            this(null, lowerLimit, upperLimit, step);
        }

        public IntIterator(int lowerLimit, int upperLimit) {
            this(null, lowerLimit, upperLimit, 1);
        }

        public IntIterator(int upperLimit) {
            this(null, 1, upperLimit, 1);
        }

        @Override
        public int allocHint() {
            if (this.step < 0) {
                return (this.lowerLimit - this.upperLimit) / -this.step + 1;
            }
            return (this.upperLimit - this.lowerLimit) / this.step + 1;
        }

        @Override
        public IExpr getLowerLimit() {
            return this.originalLowerLimit;
        }

        @Override
        public IExpr getStep() {
            return this.originalStep;
        }

        @Override
        public IExpr getUpperLimit() {
            return this.originalUpperLimit;
        }

        @Override
        public ISymbol getVariable() {
            return this.variable;
        }

        @Override
        public boolean hasNext() {
            if (this.step < 0) {
                return this.count >= this.upperLimit;
            }
            return this.count <= this.upperLimit;
        }

        @Override
        public boolean isNumericFunction() {
            return true;
        }

        @Override
        public boolean isSetIterator() {
            return this.variable != null;
        }

        @Override
        public boolean isValidVariable() {
            return this.variable != null;
        }

        @Override
        public IExpr next() {
            IInteger temp = F.ZZ(this.count);
            if (this.variable != null) {
                this.variable.assignValue(temp, false);
            }
            this.count += this.step;
            return temp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setUp() {
            if (this.variable != null) {
                this.variableValue = this.variable.assignedValue();
            }
            this.count = this.lowerLimit;
            if (this.step < 0 ? this.lowerLimit < this.upperLimit : this.lowerLimit > this.upperLimit) {
                return false;
            }
            if (this.variable != null) {
                this.variable.assignValue(this.originalLowerLimit, false);
            }
            return true;
        }

        @Override
        public void tearDown() {
            if (this.variable != null) {
                this.variable.assignValue(this.variableValue, false);
            }
        }
    }

    private static class ISignedNumberIterator
    implements IIterator<IExpr> {
        ISignedNumber count;
        ISignedNumber lowerLimit;
        ISignedNumber upperLimit;
        ISignedNumber step;
        final ISymbol variable;
        IExpr variableValue;
        final ISignedNumber originalLowerLimit;
        final ISignedNumber originalUpperLimit;
        final ISignedNumber originalStep;

        public ISignedNumberIterator(ISymbol symbol, ISignedNumber lowerLimit, ISignedNumber upperLimit, ISignedNumber step) {
            this.variable = symbol;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
            this.step = step;
            this.originalLowerLimit = lowerLimit;
            this.originalUpperLimit = upperLimit;
            this.originalStep = step;
        }

        @Override
        public int allocHint() {
            return 10;
        }

        @Override
        public IExpr getLowerLimit() {
            return this.originalLowerLimit;
        }

        @Override
        public IExpr getStep() {
            return this.originalStep;
        }

        @Override
        public IExpr getUpperLimit() {
            return this.originalUpperLimit;
        }

        @Override
        public ISymbol getVariable() {
            return this.variable;
        }

        @Override
        public boolean hasNext() {
            if (this.step.isNegative()) {
                return this.count.greaterEqualThan(this.upperLimit).isTrue();
            }
            return this.count.lessEqualThan(this.upperLimit).isTrue();
        }

        @Override
        public boolean isNumericFunction() {
            return true;
        }

        @Override
        public boolean isSetIterator() {
            return this.variable != null;
        }

        @Override
        public boolean isValidVariable() {
            return this.variable != null;
        }

        @Override
        public IExpr next() {
            ISignedNumber temp = this.count;
            if (this.variable != null) {
                this.variable.assignValue(temp, false);
            }
            this.count = (ISignedNumber)this.count.plus(this.step);
            return temp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setUp() {
            if (this.variable != null) {
                this.variableValue = this.variable.assignedValue();
            }
            this.count = this.lowerLimit;
            if (this.step.isNegative() ? this.lowerLimit.lessThan(this.upperLimit).isTrue() : this.lowerLimit.greaterThan(this.upperLimit).isTrue()) {
                return false;
            }
            if (this.variable != null) {
                this.variable.assignValue(this.originalLowerLimit, false);
            }
            return true;
        }

        @Override
        public void tearDown() {
            if (this.variable != null) {
                this.variable.assignValue(this.variableValue, false);
            }
        }
    }

    private static class QuantityIterator
    implements IIterator<IExpr> {
        IQuantity count;
        IQuantity lowerLimit;
        IQuantity upperLimit;
        IQuantity step;
        final ISymbol variable;
        IExpr variableValue = null;
        final IUnit unit;
        final IQuantity originalLowerLimit;
        final IQuantity originalUpperLimit;
        final IQuantity originalStep;

        public QuantityIterator(ISymbol symbol, IQuantity lowerLimit, IQuantity upperLimit, IQuantity step) {
            this.unit = lowerLimit.unit();
            if (!lowerLimit.unit().equals(this.unit)) {
                lowerLimit = (IQuantity)QuantityFunctions.unitConvert(lowerLimit, this.unit);
            }
            if (!upperLimit.unit().equals(this.unit)) {
                upperLimit = (IQuantity)QuantityFunctions.unitConvert(upperLimit, this.unit);
            }
            this.variable = symbol;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
            this.step = step;
            this.originalLowerLimit = lowerLimit;
            this.originalUpperLimit = upperLimit;
            this.originalStep = step;
        }

        public QuantityIterator(ISymbol symbol, IQuantity lowerLimit, IQuantity upperLimit) {
            this.unit = lowerLimit.unit();
            if (!lowerLimit.unit().equals(this.unit)) {
                lowerLimit = (IQuantity)QuantityFunctions.unitConvert(lowerLimit, this.unit);
            }
            if (!upperLimit.unit().equals(this.unit)) {
                upperLimit = (IQuantity)QuantityFunctions.unitConvert(upperLimit, this.unit);
            }
            this.step = IQuantity.of(F.C1, this.unit);
            this.variable = symbol;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
            this.originalLowerLimit = lowerLimit;
            this.originalUpperLimit = upperLimit;
            this.originalStep = this.step;
        }

        public QuantityIterator(ISymbol symbol, IQuantity upperLimit) {
            this.unit = upperLimit.unit();
            if (!upperLimit.unit().equals(this.unit)) {
                upperLimit = (IQuantity)QuantityFunctions.unitConvert(upperLimit, this.unit);
            }
            this.lowerLimit = IQuantity.of(F.C1, this.unit);
            this.step = IQuantity.of(F.C1, this.unit);
            this.variable = symbol;
            this.upperLimit = upperLimit;
            this.originalLowerLimit = this.lowerLimit;
            this.originalUpperLimit = upperLimit;
            this.originalStep = this.step;
        }

        @Override
        public int allocHint() {
            return 10;
        }

        @Override
        public IExpr getLowerLimit() {
            return this.originalLowerLimit;
        }

        @Override
        public IExpr getStep() {
            return this.originalStep;
        }

        @Override
        public IExpr getUpperLimit() {
            return this.originalUpperLimit;
        }

        @Override
        public ISymbol getVariable() {
            return this.variable;
        }

        @Override
        public boolean hasNext() {
            if (this.step.isNegative()) {
                return this.count.greaterEqualThan(this.upperLimit).isTrue();
            }
            return this.count.lessEqualThan(this.upperLimit).isTrue();
        }

        @Override
        public boolean isNumericFunction() {
            return true;
        }

        @Override
        public boolean isSetIterator() {
            return this.variable != null;
        }

        @Override
        public boolean isValidVariable() {
            return this.variable != null;
        }

        @Override
        public IExpr next() {
            IQuantity temp = this.count;
            if (this.variable != null) {
                this.variable.assignValue(temp, false);
            }
            this.count = (IQuantity)this.count.plus(this.step);
            return temp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setUp() {
            this.count = this.lowerLimit;
            if (this.step.isNegative() ? this.lowerLimit.lessThan(this.upperLimit).isTrue() : this.lowerLimit.greaterThan(this.upperLimit).isTrue()) {
                return false;
            }
            if (this.variable != null) {
                this.variableValue = this.variable.assignedValue();
                this.variable.assignValue(this.originalLowerLimit, false);
            }
            return true;
        }

        @Override
        public void tearDown() {
            if (this.variable != null) {
                this.variable.assignValue(this.variableValue, false);
            }
        }
    }

    private static class RationalIterator
    implements IIterator<IExpr> {
        IRational count;
        IRational lowerLimit;
        IRational upperLimit;
        IRational step;
        final ISymbol variable;
        IExpr variableValue = null;
        final IRational originalLowerLimit;
        final IRational originalUpperLimit;
        final IRational originalStep;

        public RationalIterator(ISymbol symbol, IRational lowerLimit, IRational upperLimit, IRational step) {
            this.variable = symbol;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
            this.step = step;
            this.originalLowerLimit = lowerLimit;
            this.originalUpperLimit = upperLimit;
            this.originalStep = step;
        }

        @Override
        public int allocHint() {
            IRational temp = this.lowerLimit.subtract(this.upperLimit).divideBy(this.step);
            IInteger hint = temp.numerator().div(temp.denominator());
            int alloc = hint.toInt();
            if (alloc < 0) {
                return -alloc + 1;
            }
            return alloc + 1;
        }

        @Override
        public IExpr getLowerLimit() {
            return this.originalLowerLimit;
        }

        @Override
        public IExpr getStep() {
            return this.originalStep;
        }

        @Override
        public IExpr getUpperLimit() {
            return this.originalUpperLimit;
        }

        @Override
        public ISymbol getVariable() {
            return this.variable;
        }

        @Override
        public boolean hasNext() {
            if (this.step.isNegative()) {
                return this.count.greaterEqualThan(this.upperLimit).isTrue();
            }
            return this.count.lessEqualThan(this.upperLimit).isTrue();
        }

        @Override
        public boolean isNumericFunction() {
            return true;
        }

        @Override
        public boolean isSetIterator() {
            return this.variable != null;
        }

        @Override
        public boolean isValidVariable() {
            return this.variable != null;
        }

        @Override
        public IExpr next() {
            IRational temp = this.count;
            if (this.variable != null) {
                this.variable.assignValue(temp, false);
            }
            this.count = (IRational)this.count.plus(this.step);
            return temp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setUp() {
            this.count = this.lowerLimit;
            if (this.step.isNegative() ? this.lowerLimit.lessThan(this.upperLimit).isTrue() : this.lowerLimit.greaterThan(this.upperLimit).isTrue()) {
                return false;
            }
            if (this.variable != null) {
                this.variableValue = this.variable.assignedValue();
                this.variable.assignValue(this.originalLowerLimit, false);
            }
            return true;
        }

        @Override
        public void tearDown() {
            if (this.variable != null) {
                this.variable.assignValue(this.variableValue, false);
            }
        }
    }

    private static class DoubleIterator
    implements IIterator<IExpr> {
        double count;
        double lowerLimit;
        double upperLimit;
        double step;
        final ISymbol variable;
        IExpr variableValue;
        final IExpr originalLowerLimit;
        final IExpr originalUpperLimit;
        final IExpr originalStep;

        public DoubleIterator(ISymbol symbol, double lowerLimit, double upperLimit, double step) {
            this.variable = symbol;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
            this.step = step;
            this.originalLowerLimit = F.num(lowerLimit);
            this.originalUpperLimit = F.num(upperLimit);
            this.originalStep = F.num(step);
        }

        @Override
        public int allocHint() {
            if (this.step < 0.0) {
                return (int)Math.round((this.lowerLimit - this.upperLimit) / -this.step + 1.0);
            }
            return (int)Math.round((this.upperLimit - this.lowerLimit) / this.step + 1.0);
        }

        @Override
        public IExpr getLowerLimit() {
            return this.originalLowerLimit;
        }

        @Override
        public IExpr getStep() {
            return this.originalStep;
        }

        @Override
        public IExpr getUpperLimit() {
            return this.originalUpperLimit;
        }

        @Override
        public ISymbol getVariable() {
            return this.variable;
        }

        @Override
        public boolean hasNext() {
            if (this.step < 0.0) {
                return this.count >= this.upperLimit || F.isFuzzyEquals(this.count, this.upperLimit, Config.SPECIAL_FUNCTIONS_TOLERANCE);
            }
            return this.count <= this.upperLimit || F.isFuzzyEquals(this.count, this.upperLimit, Config.SPECIAL_FUNCTIONS_TOLERANCE);
        }

        @Override
        public boolean isNumericFunction() {
            return true;
        }

        @Override
        public boolean isSetIterator() {
            return this.variable != null;
        }

        @Override
        public boolean isValidVariable() {
            return this.variable != null;
        }

        @Override
        public IExpr next() {
            INum temp = F.num(this.count);
            if (this.variable != null) {
                this.variable.assignValue(temp, false);
            }
            this.count += this.step;
            return temp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setUp() {
            if (this.variable != null) {
                this.variableValue = this.variable.assignedValue();
            }
            this.count = this.lowerLimit;
            if (this.step < 0.0 ? this.lowerLimit < this.upperLimit : this.lowerLimit > this.upperLimit) {
                return false;
            }
            if (this.variable != null) {
                this.variable.assignValue(this.originalLowerLimit, false);
            }
            return true;
        }

        @Override
        public void tearDown() {
            if (this.variable != null) {
                this.variable.assignValue(this.variableValue, false);
            }
        }
    }

    private static class ExprListIterator
    implements IIterator<IExpr> {
        IExpr count;
        EvalEngine evalEngine;
        IAST maxCounterOrList;
        int maxCounterOrListIndex;
        final IAST originalList;
        final ISymbol variable;

        public ExprListIterator(ISymbol symbol, IAST originalList, EvalEngine engine) {
            this.variable = symbol;
            this.evalEngine = engine;
            this.originalList = originalList;
        }

        @Override
        public int allocHint() {
            return 10;
        }

        @Override
        public ISymbol getVariable() {
            return this.variable;
        }

        @Override
        public boolean hasNext() {
            if (this.maxCounterOrList == null) {
                throw NoEvalException.CONST;
            }
            return this.maxCounterOrListIndex <= this.maxCounterOrList.size();
        }

        @Override
        public boolean isNumericFunction() {
            return false;
        }

        @Override
        public boolean isSetIterator() {
            return this.variable != null;
        }

        @Override
        public boolean isValidVariable() {
            return this.variable != null;
        }

        @Override
        public IExpr next() {
            if (this.variable != null && this.variable != this.count) {
                this.variable.assignValue(this.count, false);
            }
            IExpr temp = this.count;
            if (this.maxCounterOrList.isList()) {
                if (this.maxCounterOrListIndex == this.maxCounterOrList.size()) {
                    ++this.maxCounterOrListIndex;
                    return temp;
                }
                this.count = this.maxCounterOrList.get(this.maxCounterOrListIndex++);
            }
            return temp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setUp() {
            this.maxCounterOrList = this.originalList;
            this.maxCounterOrList = this.originalList.map(x -> this.evalEngine.evalWithoutNumericReset((IExpr)x));
            this.maxCounterOrListIndex = 1;
            if (this.maxCounterOrListIndex >= this.maxCounterOrList.size()) {
                return false;
            }
            this.count = this.maxCounterOrList.get(this.maxCounterOrListIndex++);
            if (this.variable != null && this.variable != this.count) {
                this.variable.assignValue(this.count, false);
            }
            return true;
        }

        @Override
        public void tearDown() {
            if (this.variable != null) {
                this.variable.assignValue(null, false);
            }
        }
    }

    private static class ExprIterator
    implements IIterator<IExpr> {
        IExpr count;
        final boolean fNumericMode;
        EvalEngine evalEngine;
        IExpr lowerLimit;
        IExpr maxCounterOrList;
        int maxCounterOrListIndex;
        IExpr step;
        final IExpr originalLowerLimit;
        final IExpr originalUpperLimit;
        final IExpr originalStep;
        final ISymbol variable;

        public ExprIterator(ISymbol symbol, IExpr originalStart, IExpr originalMaxCount, IExpr originalStep, boolean numericMode, EvalEngine engine) {
            this.variable = symbol;
            this.evalEngine = engine;
            this.originalLowerLimit = originalStart;
            this.originalUpperLimit = originalMaxCount;
            this.originalStep = originalStep;
            this.fNumericMode = numericMode;
        }

        @Override
        public int allocHint() {
            return 10;
        }

        @Override
        public IExpr getLowerLimit() {
            return this.originalLowerLimit;
        }

        @Override
        public IExpr getStep() {
            return this.originalStep;
        }

        @Override
        public IExpr getUpperLimit() {
            return this.originalUpperLimit;
        }

        @Override
        public ISymbol getVariable() {
            return this.variable;
        }

        @Override
        public boolean hasNext() {
            if (this.maxCounterOrList == null) {
                throw NoEvalException.CONST;
            }
            if (this.maxCounterOrList.isDirectedInfinity() || this.count.isDirectedInfinity()) {
                throw NoEvalException.CONST;
            }
            if (this.maxCounterOrList.isList()) {
                if (this.maxCounterOrListIndex <= ((IAST)this.maxCounterOrList).size()) {
                    return true;
                }
            } else {
                if (this.step.isZero()) {
                    throw NoEvalException.CONST;
                }
                if (this.step.isReal() && (this.step.isNegative() ? S.LessEqual.ofQ(this.evalEngine, this.maxCounterOrList, this.count) : S.LessEqual.ofQ(this.evalEngine, this.count, this.maxCounterOrList))) {
                    return true;
                }
                IExpr sub = this.evalEngine.evaluate(F.Divide(F.Subtract(this.maxCounterOrList, this.count), this.step));
                if (sub.isReal()) {
                    return !sub.isNegative();
                }
                try {
                    double d = sub.evalDouble();
                    return !(d < 0.0);
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public boolean isNumericFunction() {
            return this.originalLowerLimit.isNumericFunction(true) && this.originalStep.isNumericFunction(true) && this.originalUpperLimit.isNumericFunction(true);
        }

        @Override
        public boolean isSetIterator() {
            return this.variable != null && this.originalUpperLimit != null && this.originalUpperLimit.isList();
        }

        @Override
        public boolean isValidVariable() {
            return this.variable != null && this.originalLowerLimit != null && this.originalStep != null && this.originalUpperLimit != null && !this.originalUpperLimit.isList();
        }

        @Override
        public IExpr next() {
            if (this.variable != null && this.variable != this.count) {
                this.variable.assignValue(this.count, false);
            }
            IExpr temp = this.count;
            if (this.maxCounterOrList.isList()) {
                if (this.maxCounterOrListIndex == ((IAST)this.maxCounterOrList).size()) {
                    ++this.maxCounterOrListIndex;
                    return temp;
                }
                this.count = ((IAST)this.maxCounterOrList).get(this.maxCounterOrListIndex++);
            } else {
                this.count = this.evalEngine.evaluate(this.count.add(this.step));
            }
            return temp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean setUp() {
            this.lowerLimit = this.originalLowerLimit;
            if (!this.originalLowerLimit.isReal()) {
                this.lowerLimit = this.evalEngine.evalWithoutNumericReset(this.originalLowerLimit);
            }
            this.maxCounterOrList = this.originalUpperLimit;
            if (!this.originalUpperLimit.isReal()) {
                this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(this.originalUpperLimit);
            }
            this.maxCounterOrListIndex = 1;
            this.step = this.originalStep;
            if (!this.originalStep.isReal()) {
                this.step = this.evalEngine.evalWithoutNumericReset(this.originalStep);
            }
            if (this.step.isReal() && (this.step.isNegative() ? this.evalEngine.evaluate(F.Less(this.lowerLimit, this.maxCounterOrList)) == S.True : this.evalEngine.evaluate(F.Less(this.maxCounterOrList, this.lowerLimit)) == S.True)) {
                return false;
            }
            if (this.maxCounterOrList.isList()) {
                if (this.maxCounterOrListIndex >= this.maxCounterOrList.size()) return false;
                this.count = this.maxCounterOrList.getAt(this.maxCounterOrListIndex++);
            } else {
                this.count = this.lowerLimit;
            }
            if (this.variable == null || this.variable == this.count) return true;
            this.variable.assignValue(this.count, false);
            return true;
        }

        @Override
        public void tearDown() {
            if (this.variable != null) {
                this.variable.assignValue(null, false);
            }
            EvalEngine.get().setNumericMode(this.fNumericMode);
        }
    }
}

