/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class IntRangeSpec {
    final int min;
    final int max;

    public int minimum() {
        return this.min;
    }

    public int maximum() {
        return this.max;
    }

    public IntRangeSpec(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static IntRangeSpec createNonNegative() {
        return new IntRangeSpec(0, Integer.MAX_VALUE);
    }

    public static IntRangeSpec createNonNegative(IAST ast, int position) {
        IntRangeSpec range = null;
        if (ast.size() <= position) {
            range = IntRangeSpec.createNonNegative();
        } else if (ast.size() > position) {
            range = IntRangeSpec.createNonNegative(ast.get(position));
        }
        return range;
    }

    public static IntRangeSpec createNonNegative(IExpr specification) {
        int min = 0;
        int max = Integer.MAX_VALUE;
        if (!specification.equals(S.All) && !specification.isInfinity()) {
            if (specification.isInteger()) {
                max = specification.toIntDefault(-1);
                if (max < 0) {
                    return null;
                }
            } else if (specification.isAST(S.List, 2)) {
                min = specification.first().toIntDefault(-1);
                if (min < 0) {
                    return null;
                }
                max = min;
            } else if (specification.isAST(S.List, 3)) {
                min = specification.first().toIntDefault(-1);
                if (min < 0) {
                    return null;
                }
                max = specification.second().toIntDefault(-1);
                if (max < 0) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return new IntRangeSpec(min, max);
    }

    public boolean isIncluded(int value) {
        return this.min <= value && value <= this.max;
    }
}

