/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.util.AbstractAssumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IDistribution;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Assumptions
extends AbstractAssumptions {
    private HashMap<IExpr, ISymbol> elementsMap = new HashMap();
    private HashMap<IExpr, IAST> distributionsMap = new HashMap();
    private Map<IExpr, IAST> tensorsMap = new HashMap<IExpr, IAST>();
    private HashMap<IExpr, SignedNumberRelations> valueMap = new HashMap();
    private IExpr $assumptions = F.NIL;

    private static boolean addDistribution(IAST element, Assumptions assumptions) {
        IEvaluator evaluator;
        IAST dist;
        ISymbol head;
        if (element.arg2().isAST() && (head = (ISymbol)(dist = (IAST)element.arg2()).head()) instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof IDistribution) {
            IExpr arg1 = element.arg1();
            if (arg1.isAST(S.Alternatives)) {
                ((IAST)arg1).forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> assumptions.distributionsMap.put((IExpr)x, dist)));
            } else {
                assumptions.distributionsMap.put(arg1, dist);
            }
            return true;
        }
        return false;
    }

    private static boolean addElement(IAST element, Assumptions assumptions) {
        if (element.size() >= 3) {
            IExpr arg1 = element.arg1();
            if (arg1.isAlternatives()) {
                IASTMutable list = ((IAST)arg1).apply((IExpr)S.List);
                list = list.mapThread(element, 1);
                for (int i = 1; i < list.size(); ++i) {
                    IExpr arg = list.get(i);
                    if (!arg.isAST()) {
                        return false;
                    }
                    if (Assumptions.addElement((IAST)arg, assumptions)) continue;
                    return false;
                }
                return true;
            }
            if (element.arg2().isSymbol()) {
                ISymbol domain = (ISymbol)element.arg2();
                if (S.isDomain(domain)) {
                    if (arg1.isAST(S.Alternatives)) {
                        ((IAST)arg1).forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> assumptions.elementsMap.put((IExpr)x, domain)));
                    } else {
                        assumptions.elementsMap.put(arg1, domain);
                    }
                    return true;
                }
            } else if (element.arg2().isAST((IExpr)S.Arrays, 2, 3)) {
                IAST arrays = (IAST)element.arg2();
                ISymbol domain = S.Complexes;
                if (arrays.size() > 2 && arrays.arg2().isSymbol() && !S.isDomain(domain = (ISymbol)arrays.arg2())) {
                    return false;
                }
                if (arrays.arg1().isList() && arrays.arg1().argSize() >= 2) {
                    assumptions.tensorsMap.put(arg1, F.Arrays(arrays.arg1(), (IExpr)domain));
                    return true;
                }
                IOFunctions.printMessage(S.Arrays, "rankl", F.list(arrays.arg1(), F.C2), EvalEngine.get());
            } else if (element.arg2().isAST((IExpr)S.Matrices, 2, 4)) {
                IAST matrices = (IAST)element.arg2();
                ISymbol domain = S.Complexes;
                if (matrices.size() > 2 && matrices.arg2().isSymbol() && !S.isDomain(domain = (ISymbol)matrices.arg2())) {
                    return false;
                }
                if (matrices.arg1().isList() && matrices.arg1().argSize() == 2) {
                    assumptions.tensorsMap.put(arg1, F.Matrices(matrices.arg1(), domain));
                    return true;
                }
                IOFunctions.printMessage(S.Matrices, "rankl", F.list(matrices.arg1(), F.C2), EvalEngine.get());
            } else if (element.arg2().isAST((IExpr)S.Vectors, 2, 3)) {
                IAST vectors = (IAST)element.arg2();
                ISymbol domain = S.Complexes;
                if (vectors.size() > 2 && vectors.arg2().isSymbol() && !S.isDomain(domain = (ISymbol)vectors.arg2())) {
                    return false;
                }
                if (!vectors.arg1().isList()) {
                    assumptions.tensorsMap.put(arg1, F.Vectors(vectors.arg1(), domain));
                    return true;
                }
                IOFunctions.printMessage(S.Vectors, "rankl", F.list(vectors.arg1(), F.C2), EvalEngine.get());
            }
        }
        return false;
    }

    private static boolean addEqual(IAST equalsAST, Assumptions assumptions) {
        if (equalsAST.arg2().isReal()) {
            ISignedNumber num = (ISignedNumber)equalsAST.arg2();
            IExpr key = equalsAST.arg1();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addEquals(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        if (equalsAST.arg1().isReal()) {
            ISignedNumber num = (ISignedNumber)equalsAST.arg1();
            IExpr key = equalsAST.arg2();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addEquals(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        return false;
    }

    private static boolean addGreater(IAST greaterAST, Assumptions assumptions) {
        if (greaterAST.isAST3()) {
            IExpr arg1 = greaterAST.arg1();
            IExpr arg2 = greaterAST.arg2();
            IExpr arg3 = greaterAST.arg3();
            if (arg1.isReal() && arg3.isReal() && !arg2.isNumber() && ((ISignedNumber)arg1).isGT((ISignedNumber)arg3)) {
                ISignedNumber num1 = (ISignedNumber)arg1;
                ISignedNumber num3 = (ISignedNumber)arg3;
                IExpr key = arg2;
                SignedNumberRelations gla = assumptions.valueMap.get(key);
                if (gla == null) {
                    gla = new SignedNumberRelations();
                }
                gla.addLess(num1);
                gla.addGreater(num3);
                assumptions.valueMap.put(key, gla);
                return true;
            }
            return false;
        }
        ISignedNumber num = null;
        num = greaterAST.arg2().isReal() ? (ISignedNumber)greaterAST.arg2() : greaterAST.arg2().evalReal();
        if (num != null) {
            IExpr key = greaterAST.arg1();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addGreater(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        num = null;
        num = greaterAST.arg1().isReal() ? (ISignedNumber)greaterAST.arg1() : greaterAST.arg1().evalReal();
        if (num != null) {
            IExpr key = greaterAST.arg2();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addLess(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        return false;
    }

    private static boolean addGreaterEqual(IAST greaterEqualAST, Assumptions assumptions) {
        if (greaterEqualAST.isAST3()) {
            IExpr arg1 = greaterEqualAST.arg1();
            IExpr arg2 = greaterEqualAST.arg2();
            IExpr arg3 = greaterEqualAST.arg3();
            if (arg1.isReal() && arg3.isReal() && !arg2.isNumber() && !((ISignedNumber)arg1).isLT((ISignedNumber)arg3)) {
                ISignedNumber num1 = (ISignedNumber)arg1;
                ISignedNumber num3 = (ISignedNumber)arg3;
                IExpr key = arg2;
                SignedNumberRelations gla = assumptions.valueMap.get(key);
                if (gla == null) {
                    gla = new SignedNumberRelations();
                }
                gla.addLessEqual(num1);
                gla.addGreaterEqual(num3);
                assumptions.valueMap.put(key, gla);
                return true;
            }
            return false;
        }
        ISignedNumber num = null;
        num = greaterEqualAST.arg2().isReal() ? (ISignedNumber)greaterEqualAST.arg2() : greaterEqualAST.arg2().evalReal();
        if (num != null) {
            IExpr key = greaterEqualAST.arg1();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addGreaterEqual(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        num = null;
        num = greaterEqualAST.arg1().isReal() ? (ISignedNumber)greaterEqualAST.arg1() : greaterEqualAST.arg1().evalReal();
        if (num != null) {
            IExpr key = greaterEqualAST.arg2();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addLessEqual(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        return false;
    }

    private static boolean addLess(IAST lessAST, Assumptions assumptions) {
        if (lessAST.isAST3()) {
            IExpr arg1 = lessAST.arg1();
            IExpr arg2 = lessAST.arg2();
            IExpr arg3 = lessAST.arg3();
            if (arg1.isReal() && arg3.isReal() && !arg2.isNumber() && ((ISignedNumber)arg1).isLT((ISignedNumber)arg3)) {
                ISignedNumber num1 = (ISignedNumber)arg1;
                ISignedNumber num3 = (ISignedNumber)arg3;
                IExpr key = arg2;
                SignedNumberRelations gla = assumptions.valueMap.get(key);
                if (gla == null) {
                    gla = new SignedNumberRelations();
                }
                gla.addGreater(num1);
                gla.addLess(num3);
                assumptions.valueMap.put(key, gla);
                return true;
            }
            return false;
        }
        ISignedNumber num = null;
        num = lessAST.arg2().isReal() ? (ISignedNumber)lessAST.arg2() : lessAST.arg2().evalReal();
        if (num != null) {
            IExpr key = lessAST.arg1();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addLess(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        num = null;
        num = lessAST.arg1().isReal() ? (ISignedNumber)lessAST.arg1() : lessAST.arg1().evalReal();
        if (num != null) {
            IExpr key = lessAST.arg2();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addGreater(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        return false;
    }

    private static boolean addLessEqual(IAST lessEqualAST, Assumptions assumptions) {
        if (lessEqualAST.isAST3()) {
            IExpr arg1 = lessEqualAST.arg1();
            IExpr arg2 = lessEqualAST.arg2();
            IExpr arg3 = lessEqualAST.arg3();
            if (arg1.isReal() && arg3.isReal() && !arg2.isNumber() && ((ISignedNumber)arg1).isLE((ISignedNumber)arg3)) {
                ISignedNumber num1 = (ISignedNumber)arg1;
                ISignedNumber num3 = (ISignedNumber)arg3;
                IExpr key = arg2;
                SignedNumberRelations gla = assumptions.valueMap.get(key);
                if (gla == null) {
                    gla = new SignedNumberRelations();
                }
                gla.addGreaterEqual(num1);
                gla.addLessEqual(num3);
                assumptions.valueMap.put(key, gla);
                return true;
            }
            return false;
        }
        ISignedNumber num = null;
        num = lessEqualAST.arg2().isReal() ? (ISignedNumber)lessEqualAST.arg2() : lessEqualAST.arg2().evalReal();
        if (num != null) {
            IExpr key = lessEqualAST.arg1();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addLessEqual(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        num = null;
        num = lessEqualAST.arg1().isReal() ? (ISignedNumber)lessEqualAST.arg1() : lessEqualAST.arg1().evalReal();
        if (num != null) {
            IExpr key = lessEqualAST.arg2();
            SignedNumberRelations gla = assumptions.valueMap.get(key);
            if (gla == null) {
                gla = new SignedNumberRelations();
            }
            gla.addGreaterEqual(num);
            assumptions.valueMap.put(key, gla);
            return true;
        }
        return false;
    }

    private static IAssumptions addList(IAST ast, Assumptions assumptions) {
        for (int i = 1; i < ast.size(); ++i) {
            IAST temp;
            if (!ast.get(i).isAST() || !((temp = (IAST)ast.get(i)).isAST(S.Element, 3) ? !Assumptions.addElement(temp, assumptions) : (temp.isAST((IExpr)S.Greater, 3, 4) ? !Assumptions.addGreater(temp, assumptions) : (temp.isAST((IExpr)S.GreaterEqual, 3, 4) ? !Assumptions.addGreaterEqual(temp, assumptions) : (temp.isAST((IExpr)S.Less, 3, 4) ? !Assumptions.addLess(temp, assumptions) : (temp.isAST((IExpr)S.LessEqual, 3, 4) ? !Assumptions.addLessEqual(temp, assumptions) : temp.isAST(S.Equal, 3) && !Assumptions.addLess(temp, assumptions))))))) continue;
            return null;
        }
        return assumptions;
    }

    public static IAssumptions getInstance(IExpr expr) {
        if (expr.isAST()) {
            Assumptions assumptions = new Assumptions();
            assumptions.$assumptions = expr;
            if (expr.isList()) {
                Assumptions.addList((IAST)expr, assumptions);
            } else if (expr.isAST()) {
                assumptions.addAssumption(expr);
            }
            return assumptions;
        }
        return null;
    }

    private Assumptions() {
    }

    @Override
    public IAssumptions addAssumption(IExpr expr) {
        if (expr.isAST()) {
            IAST ast = (IAST)expr;
            if (ast.isAST(S.Element, 3)) {
                if (Assumptions.addElement(ast, this)) {
                    return this;
                }
            } else if (ast.isAST((IExpr)S.Greater, 3, 4)) {
                if (Assumptions.addGreater(ast, this)) {
                    return this;
                }
            } else if (ast.isAST((IExpr)S.GreaterEqual, 3, 4)) {
                if (Assumptions.addGreaterEqual(ast, this)) {
                    return this;
                }
            } else if (ast.isAST((IExpr)S.Less, 3, 4)) {
                if (Assumptions.addLess(ast, this)) {
                    return this;
                }
            } else if (ast.isAST((IExpr)S.LessEqual, 3, 4)) {
                if (Assumptions.addLessEqual(ast, this)) {
                    return this;
                }
            } else if (ast.isAST(S.Equal, 3)) {
                if (Assumptions.addEqual(ast, this)) {
                    return this;
                }
            } else {
                if (ast.isAnd() || ast.isSameHeadSizeGE(S.List, 2)) {
                    return Assumptions.addList(ast, this);
                }
                if (ast.isAST(S.Distributed, 3) && Assumptions.addDistribution(ast, this)) {
                    return this;
                }
            }
        }
        return this;
    }

    @Override
    public IAssumptions copy() {
        Assumptions assumptions = new Assumptions();
        assumptions.distributionsMap = new HashMap<IExpr, IAST>(this.distributionsMap);
        assumptions.elementsMap = new HashMap<IExpr, ISymbol>(this.elementsMap);
        assumptions.valueMap = new HashMap<IExpr, SignedNumberRelations>(this.valueMap);
        assumptions.$assumptions = (IExpr)this.$assumptions.copy();
        return assumptions;
    }

    @Override
    public final IAST distribution(IExpr expr) {
        IAST dist = this.distributionsMap.get(expr);
        return dist == null ? F.NIL : dist;
    }

    @Override
    public boolean isEqual(IExpr expr, ISignedNumber number) {
        ISignedNumber num;
        SignedNumberRelations gla = this.valueMap.get(expr);
        return gla != null && (num = gla.getEquals()) != null && num.equals(number);
    }

    @Override
    public final IAST tensors(IExpr expr) {
        IAST tensor = this.tensorsMap.get(expr);
        return tensor == null ? F.NIL : tensor;
    }

    @Override
    public IExpr get$Assumptions() {
        return this.$assumptions;
    }

    @Override
    public Map<IExpr, IAST> getTensorsMap() {
        return this.tensorsMap;
    }

    @Override
    public boolean isAlgebraic(IExpr expr) {
        return this.isDomain(expr, S.Algebraics);
    }

    @Override
    public boolean isBoolean(IExpr expr) {
        return this.isDomain(expr, S.Booleans);
    }

    @Override
    public boolean isComplex(IExpr expr) {
        return this.isDomain(expr, S.Complexes);
    }

    private final boolean isDomain(IExpr expr, ISymbol domain) {
        ISymbol mappedDomain = this.elementsMap.get(expr);
        return mappedDomain != null && mappedDomain.equals(domain);
    }

    @Override
    public boolean isGreaterEqual(IExpr expr, ISignedNumber number) {
        SignedNumberRelations gla = this.valueMap.get(expr);
        if (gla != null) {
            boolean result = false;
            ISignedNumber num = gla.getGreater();
            if (num != null && num.equals(number)) {
                result = true;
            }
            if (!result && (num = gla.getGreaterEqual()) != null && num.equals(number)) {
                result = true;
            }
            if (result) {
                return true;
            }
            return this.isGreaterThan(expr, number);
        }
        return false;
    }

    @Override
    public boolean isGreaterThan(IExpr expr, ISignedNumber number) {
        SignedNumberRelations gla = this.valueMap.get(expr);
        if (gla != null) {
            boolean result = false;
            ISignedNumber num = gla.getGreater();
            if (num != null) {
                if (!num.equals(number) && num.isLE(number)) {
                    return false;
                }
                result = true;
            }
            if (!result && (num = gla.getGreaterEqual()) != null) {
                if (num.isLE(number)) {
                    return false;
                }
                result = true;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean isInteger(IExpr expr) {
        return this.isDomain(expr, S.Integers);
    }

    @Override
    public boolean isLessEqual(IExpr expr, ISignedNumber number) {
        SignedNumberRelations gla = this.valueMap.get(expr);
        if (gla != null) {
            boolean result = false;
            ISignedNumber num = gla.getLess();
            if (num != null && num.equals(number)) {
                result = true;
            }
            if (!result && (num = gla.getLessEqual()) != null && num.equals(number)) {
                result = true;
            }
            if (result) {
                return true;
            }
            return this.isLessThan(expr, number);
        }
        return false;
    }

    @Override
    public boolean isLessThan(IExpr expr, ISignedNumber number) {
        SignedNumberRelations gla = this.valueMap.get(expr);
        if (gla != null) {
            boolean result = false;
            ISignedNumber num = gla.getLess();
            if (num != null) {
                if (!num.equals(number) && num.isGE(number)) {
                    return false;
                }
                result = true;
            }
            if (!result && (num = gla.getLessEqual()) != null) {
                if (num.isGE(number)) {
                    return false;
                }
                result = true;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean isNegative(IExpr expr) {
        return this.isLessThan(expr, F.C0);
    }

    @Override
    public boolean isNonNegative(IExpr expr) {
        return this.isGreaterEqual(expr, F.C0);
    }

    @Override
    public boolean isPositive(IExpr expr) {
        return this.isGreaterThan(expr, F.C0);
    }

    @Override
    public boolean isPrime(IExpr expr) {
        return this.isDomain(expr, S.Primes);
    }

    @Override
    public boolean isRational(IExpr expr) {
        return this.isDomain(expr, S.Rationals);
    }

    @Override
    public boolean isReal(IExpr expr) {
        SignedNumberRelations gla = this.valueMap.get(expr);
        if (gla != null && gla.isLessOrGreaterRelation()) {
            return true;
        }
        return this.isDomain(expr, S.Reals);
    }

    @Override
    public int[] reduceRange(IExpr x, int[] xRange) {
        IExpr temp = this.elementsMap.get(x);
        if (temp != null) {
            return null;
        }
        temp = this.distributionsMap.get(x);
        if (temp != null) {
            return null;
        }
        SignedNumberRelations rr = this.valueMap.get(x);
        if (rr != null) {
            int i;
            int[] newXRange = new int[]{xRange[0], xRange[1]};
            boolean evaled = false;
            ISignedNumber num = rr.getLess();
            if (num != null) {
                i = num.toIntDefault();
                if (i == Integer.MIN_VALUE) {
                    i = num.ceilFraction().toIntDefault();
                }
                if (i != Integer.MIN_VALUE && newXRange[1] >= i) {
                    evaled = true;
                    newXRange[1] = i - 1;
                }
            }
            if ((num = rr.getLessEqual()) != null) {
                i = num.toIntDefault();
                if (i == Integer.MIN_VALUE) {
                    i = num.floorFraction().toIntDefault();
                }
                if (i != Integer.MIN_VALUE && newXRange[1] > i) {
                    evaled = true;
                    newXRange[1] = i;
                }
            }
            if ((num = rr.getGreater()) != null) {
                i = num.toIntDefault();
                if (i == Integer.MIN_VALUE) {
                    i = num.floorFraction().toIntDefault();
                }
                if (i != Integer.MIN_VALUE && newXRange[0] <= i) {
                    evaled = true;
                    newXRange[0] = i + 1;
                }
            }
            if ((num = rr.getGreaterEqual()) != null) {
                i = num.toIntDefault();
                if (i == Integer.MIN_VALUE) {
                    i = num.ceilFraction().toIntDefault();
                }
                if (i != Integer.MIN_VALUE && newXRange[0] < i) {
                    evaled = true;
                    newXRange[0] = i;
                }
            }
            if ((num = rr.getEquals()) != null) {
                i = num.toIntDefault();
                if (i == Integer.MIN_VALUE) {
                    i = num.ceilFraction().toIntDefault();
                }
                if (i != Integer.MIN_VALUE) {
                    if (newXRange[0] < i) {
                        evaled = true;
                        newXRange[0] = i;
                    }
                    if (newXRange[1] > i) {
                        evaled = true;
                        newXRange[1] = i;
                    }
                }
            }
            if (evaled) {
                return newXRange;
            }
        }
        return null;
    }

    @Override
    public void set$Assumptions(IExpr $assumptions) {
        this.$assumptions = $assumptions;
    }

    private static class SignedNumberRelations {
        static final int GREATER_ID = 0;
        static final int GREATEREQUAL_ID = 1;
        static final int LESS_ID = 2;
        static final int LESSEQUAL_ID = 3;
        static final int EQUALS_ID = 4;
        private final ISignedNumber[] values = new ISignedNumber[5];

        public final void addEquals(ISignedNumber expr) {
            this.values[4] = expr;
        }

        public final void addGreater(ISignedNumber expr) {
            this.values[0] = expr;
        }

        public final void addGreaterEqual(ISignedNumber expr) {
            this.values[1] = expr;
        }

        public final void addLess(ISignedNumber expr) {
            this.values[2] = expr;
        }

        public final void addLessEqual(ISignedNumber expr) {
            this.values[3] = expr;
        }

        public final ISignedNumber getEquals() {
            return this.values[4];
        }

        public final ISignedNumber getGreater() {
            return this.values[0];
        }

        public final ISignedNumber getGreaterEqual() {
            return this.values[1];
        }

        public final ISignedNumber getLess() {
            return this.values[2];
        }

        public final ISignedNumber getLessEqual() {
            return this.values[3];
        }

        public final boolean isLessOrGreaterRelation() {
            for (int i = 0; i <= 3; ++i) {
                if (this.values == null) continue;
                return true;
            }
            return false;
        }
    }
}

