/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import org.matheclipse.core.interfaces.ISymbol;

public class ArraySet<T>
extends AbstractSet<T>
implements Iterable<T> {
    private int size = 0;
    private final int capacity;
    private Object[] array;

    public ArraySet() {
        this(3);
    }

    public ArraySet(int capacity) {
        this.capacity = capacity;
        this.array = null;
    }

    @Override
    public final boolean add(T key) {
        if (this.array == null) {
            this.array = new Object[this.capacity];
            this.array[this.size++] = key;
            return true;
        }
        int index = Arrays.binarySearch(this.array, 0, this.size, key);
        if (index < 0) {
            int insertIndex = -index - 1;
            if (this.size < this.array.length - 1) {
                if (insertIndex < this.size) {
                    System.arraycopy(this.array, insertIndex, this.array, insertIndex + 1, this.size - insertIndex);
                }
                this.array[insertIndex] = key;
            } else {
                Object[] newArray = new Object[this.array.length + 1];
                System.arraycopy(this.array, 0, newArray, 0, insertIndex);
                System.arraycopy(this.array, insertIndex, newArray, insertIndex + 1, this.array.length - insertIndex);
                newArray[insertIndex] = key;
                this.array = newArray;
            }
            ++this.size;
            return true;
        }
        return false;
    }

    public final T get(int position) {
        return (T)(this.array == null ? null : this.array[position]);
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final boolean contains(ISymbol key) {
        return this.array == null ? false : Arrays.binarySearch(this.array, 0, this.size, key) >= 0;
    }

    @Override
    public final Iterator<T> iterator() {
        Iterator iter = new Iterator<T>(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < ArraySet.this.size;
            }

            @Override
            public T next() {
                if (this.offset < ArraySet.this.size) {
                    return ArraySet.this.array[this.offset++];
                }
                return null;
            }
        };
        return iter;
    }
}

