/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.eval.util.ISequence;

public abstract class AbstractSequence
implements ISequence {
    protected final int fStartOffset;
    protected final int fEndOffset;
    protected final int fStep;

    protected AbstractSequence(int startOffset, int endOffset, int step) {
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
        this.fStep = step;
    }

    @Override
    public int getStartOffset() {
        return this.fStartOffset;
    }

    @Override
    public int getEndOffset() {
        return this.fEndOffset;
    }

    @Override
    public int getStep() {
        return this.fStep;
    }

    @Override
    public int[] getIndices() {
        int j = this.getStart();
        int step = this.getStep();
        int end = this.getEnd();
        int alloc = end - j;
        alloc = alloc % step == 0 ? alloc / step - 1 : (alloc /= step);
        int k = 0;
        int[] result = new int[alloc + 1];
        for (int i = j; i < end; i += step) {
            result[k++] = i;
        }
        return result;
    }
}

