/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.ISignedNumberConstant;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public abstract class AbstractAssumptions
implements IAssumptions {
    @Override
    public IAssumptions addAssumption(IExpr expr) {
        return null;
    }

    @Override
    public IAST distribution(IExpr expr) {
        return F.NIL;
    }

    @Override
    public Map<IExpr, IAST> getTensorsMap() {
        return new HashMap<IExpr, IAST>();
    }

    @Override
    public IAST tensors(IExpr expr) {
        return F.NIL;
    }

    public static ISymbol assumeAlgebraic(IExpr expr) {
        IAssumptions assumptions;
        if (expr.isRational()) {
            return S.True;
        }
        if (expr.isNumber()) {
            return S.True;
        }
        if (expr.isDirectedInfinity()) {
            return S.False;
        }
        if (expr == S.Undefined) {
            return S.Undefined;
        }
        if (expr.isSymbol()) {
            if (expr.equals(S.Degree)) {
                return S.False;
            }
            if (expr.equals(S.Pi)) {
                return S.False;
            }
            if (expr.equals(S.E)) {
                return S.False;
            }
        }
        if ((assumptions = EvalEngine.get().getAssumptions()) != null) {
            if (assumptions.isAlgebraic(expr)) {
                return S.True;
            }
            if (assumptions.isRational(expr)) {
                return S.True;
            }
            if (assumptions.isInteger(expr)) {
                return S.True;
            }
            if (assumptions.isPrime(expr)) {
                return S.True;
            }
        }
        return null;
    }

    public static ISymbol assumeArray(IExpr expr) {
        IAST temp;
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null && (temp = assumptions.tensors(expr)).isAST((IExpr)S.Arrays, 2, 4)) {
            return S.True;
        }
        return null;
    }

    public static ISymbol assumeMatrices(IExpr expr) {
        IAST temp;
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null && (temp = assumptions.tensors(expr)).isAST((IExpr)S.Matrices, 3, 4)) {
            return S.True;
        }
        return null;
    }

    public static ISymbol assumeVectors(IExpr expr) {
        IAST temp;
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null && (temp = assumptions.tensors(expr)).isAST((IExpr)S.Vectors, 3, 4)) {
            return S.True;
        }
        return null;
    }

    public static ISymbol assumeBoolean(IExpr expr) {
        if (expr.isTrue() || expr.isFalse()) {
            return S.True;
        }
        if (expr.isNumber()) {
            return S.False;
        }
        if (expr.isDirectedInfinity()) {
            return S.False;
        }
        if (expr == S.Undefined) {
            return S.Undefined;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null && assumptions.isBoolean(expr)) {
            return S.True;
        }
        return null;
    }

    public static ISymbol assumeComplex(IExpr expr) {
        if (expr.isNumber()) {
            return S.True;
        }
        if (expr.isRealConstant()) {
            return S.True;
        }
        if (expr.isDirectedInfinity()) {
            return S.False;
        }
        if (expr == S.Undefined) {
            return S.Undefined;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null) {
            if (assumptions.isComplex(expr)) {
                return S.True;
            }
            if (assumptions.isRational(expr)) {
                return S.True;
            }
            if (assumptions.isInteger(expr)) {
                return S.True;
            }
            if (assumptions.isPrime(expr)) {
                return S.True;
            }
            if (assumptions.isReal(expr)) {
                return S.True;
            }
            if (assumptions.isAlgebraic(expr)) {
                return S.True;
            }
        }
        return null;
    }

    public static boolean assumeEqual(IExpr expr, ISignedNumber number) {
        if (expr.isNumber()) {
            return ((INumber)expr).equals(number);
        }
        if (expr.isRealConstant()) {
            return F.isFuzzyEquals(((ISignedNumberConstant)((Object)((IBuiltInSymbol)expr).getEvaluator())).evalReal(), number.doubleValue(), Config.MACHINE_EPSILON);
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        return assumptions != null && assumptions.isEqual(expr, number);
    }

    public static ISymbol assumeInteger(IExpr expr) {
        if (expr.isInteger()) {
            return S.True;
        }
        if (expr.isNumber()) {
            return S.False;
        }
        if (expr.isDirectedInfinity()) {
            return S.False;
        }
        if (expr == S.Undefined) {
            return S.Undefined;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null) {
            if (assumptions.isInteger(expr)) {
                return S.True;
            }
            if (assumptions.isPrime(expr)) {
                return S.True;
            }
        }
        return null;
    }

    public static boolean assumeNegative(IExpr expr) {
        if (expr.isReal()) {
            return expr.isNegative();
        }
        if (expr.isNumber()) {
            return false;
        }
        if (expr.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)((IBuiltInSymbol)expr).getEvaluator())).evalReal() < 0.0;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        return assumptions != null && assumptions.isNegative(expr);
    }

    public static boolean assumeLessEqual(IExpr expr, ISignedNumber number) {
        if (expr.isReal()) {
            return ((ISignedNumber)expr).isLE(number);
        }
        if (expr.isNumber()) {
            return false;
        }
        if (expr.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)((IBuiltInSymbol)expr).getEvaluator())).evalReal() <= number.doubleValue();
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        return assumptions != null && assumptions.isLessEqual(expr, number);
    }

    public static boolean assumeLessThan(IExpr expr, ISignedNumber number) {
        if (expr.isReal()) {
            return ((ISignedNumber)expr).isLT(number);
        }
        if (expr.isNumber()) {
            return false;
        }
        if (expr.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)((IBuiltInSymbol)expr).getEvaluator())).evalReal() < number.doubleValue();
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        return assumptions != null && assumptions.isLessThan(expr, number);
    }

    public static boolean assumeNonNegative(IExpr expr) {
        if (expr.isReal()) {
            return ((ISignedNumber)expr).isNonNegativeResult();
        }
        if (expr.isNumber()) {
            return false;
        }
        if (expr.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)((IBuiltInSymbol)expr).getEvaluator())).evalReal() >= 0.0;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        return assumptions != null && assumptions.isNonNegative(expr);
    }

    public static boolean assumeGreaterEqual(IExpr expr, ISignedNumber number) {
        if (expr.isReal()) {
            return ((ISignedNumber)expr).isGT(number);
        }
        if (expr.isNumber()) {
            return false;
        }
        if (expr.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)((IBuiltInSymbol)expr).getEvaluator())).evalReal() >= number.doubleValue();
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        return assumptions != null && assumptions.isGreaterEqual(expr, number);
    }

    public static boolean assumePositive(IExpr expr) {
        if (expr.isReal()) {
            return ((ISignedNumber)expr).isPositive();
        }
        if (expr.isNumber()) {
            return false;
        }
        if (expr.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)((IBuiltInSymbol)expr).getEvaluator())).evalReal() > 0.0;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        return assumptions != null && assumptions.isPositive(expr);
    }

    public static boolean assumeGreaterThan(IExpr expr, ISignedNumber number) {
        if (expr.isReal()) {
            return ((ISignedNumber)expr).isGT(number);
        }
        if (expr.isNumber()) {
            return false;
        }
        if (expr.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)((IBuiltInSymbol)expr).getEvaluator())).evalReal() > number.doubleValue();
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        return assumptions != null && assumptions.isGreaterThan(expr, number);
    }

    public static IExpr assumePrime(IExpr expr) {
        if (expr.isInteger() && ((IInteger)expr).isProbablePrime()) {
            return S.True;
        }
        if (expr.isNumber()) {
            return S.False;
        }
        if (expr.isDirectedInfinity()) {
            return S.False;
        }
        if (expr == S.Undefined) {
            return S.Undefined;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null && assumptions.isPrime(expr)) {
            return S.True;
        }
        return F.NIL;
    }

    public static ISymbol assumeRational(IExpr expr) {
        if (expr.isRational()) {
            return S.True;
        }
        if (expr.isNumber()) {
            return S.False;
        }
        if (expr.isDirectedInfinity()) {
            return S.False;
        }
        if (expr == S.Undefined) {
            return S.Undefined;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null) {
            if (assumptions.isRational(expr)) {
                return S.True;
            }
            if (assumptions.isInteger(expr)) {
                return S.True;
            }
            if (assumptions.isPrime(expr)) {
                return S.True;
            }
        }
        return null;
    }

    public static ISymbol assumeReal(IExpr expr) {
        if (expr.isReal()) {
            return S.True;
        }
        if (expr.isNumber()) {
            return S.False;
        }
        if (expr.isRealConstant()) {
            return S.True;
        }
        if (expr.isDirectedInfinity()) {
            return S.False;
        }
        if (expr == S.Undefined) {
            return S.Undefined;
        }
        IAssumptions assumptions = EvalEngine.get().getAssumptions();
        if (assumptions != null) {
            if (assumptions.isReal(expr)) {
                return S.True;
            }
            if (assumptions.isInteger(expr)) {
                return S.True;
            }
            if (assumptions.isPrime(expr)) {
                return S.True;
            }
            if (assumptions.isRational(expr)) {
                return S.True;
            }
        }
        return null;
    }

    public static boolean isNegativeResult(IAST ast) {
        ISignedNumber e = ast.evalReal();
        if (e != null) {
            return e.isNegative();
        }
        IExpr head = ast.head();
        if (head.isSymbol()) {
            ISymbol symbol = (ISymbol)head;
            int size = ast.size();
            if (size == 2) {
                IExpr arg1 = ast.arg1();
                if (symbol.equals(S.Log) && AbstractAssumptions.assumePositive(arg1) && AbstractAssumptions.assumeLessThan(arg1, F.C1)) {
                    return true;
                }
            }
            if (ast.isPlus()) {
                for (int i = 1; i < size; ++i) {
                    IExpr x = ast.get(i);
                    if (x.isNegativeResult() || AbstractAssumptions.assumeNegative(x)) continue;
                    return false;
                }
                return true;
            }
            if (ast.isTimes()) {
                boolean flag = false;
                for (int i = 1; i < size; ++i) {
                    IExpr x = ast.get(i);
                    if (x.isNonNegativeResult() || AbstractAssumptions.assumeNonNegative(x)) continue;
                    if (!x.isNegativeResult() && !AbstractAssumptions.assumeNegative(x)) {
                        return false;
                    }
                    flag = !flag;
                }
                return flag;
            }
            if (ast.isPower()) {
                IInteger iArg2;
                IExpr base = ast.base();
                IExpr exponent = ast.exponent();
                return base.isNegativeResult() && exponent.isInteger() && (iArg2 = (IInteger)exponent).isOdd();
            }
        }
        return false;
    }

    public static boolean isNonNegativeResult(IAST ast) {
        ISignedNumber e = ast.evalReal();
        if (e != null) {
            return !e.isNegative();
        }
        IExpr head = ast.head();
        if (head.isSymbol()) {
            ISymbol symbol = (ISymbol)head;
            int size = ast.size();
            if (size == 2) {
                IExpr arg1 = ast.arg1();
                if (symbol.equals(S.Abs)) {
                    return true;
                }
                if (symbol.equals(S.Log) && AbstractAssumptions.assumeGreaterEqual(arg1, F.C1)) {
                    return true;
                }
            }
            if (ast.isPlus()) {
                for (int i = 1; i < size; ++i) {
                    IExpr x = ast.get(i);
                    if (x.isNonNegativeResult() || AbstractAssumptions.assumeNonNegative(x)) continue;
                    return false;
                }
                return true;
            }
            if (ast.isTimes()) {
                boolean flag = true;
                for (int i = 1; i < size; ++i) {
                    IExpr x = ast.get(i);
                    if (x.isNonNegativeResult() || AbstractAssumptions.assumeNonNegative(x)) continue;
                    if (!x.isNegativeResult() && !AbstractAssumptions.assumeNegative(x)) {
                        return false;
                    }
                    flag = !flag;
                }
                return flag;
            }
            if (ast.isPower()) {
                IInteger iArg2;
                IExpr base = ast.base();
                IExpr exponent = ast.exponent();
                if (base.isRealResult() && exponent.isInteger() && (iArg2 = (IInteger)exponent).isEven()) {
                    return true;
                }
                return base.isE() && exponent.isRealResult();
            }
        }
        return false;
    }

    public static boolean isPositiveResult(IAST ast) {
        ISignedNumber e = ast.evalReal();
        if (e != null) {
            return e.isPositive();
        }
        IExpr head = ast.head();
        if (head.isSymbol()) {
            ISymbol symbol = (ISymbol)head;
            int size = ast.size();
            if (size == 2) {
                IExpr arg1 = ast.arg1();
                if (symbol.equals(S.Abs) && (AbstractAssumptions.assumeNegative(arg1) || AbstractAssumptions.assumePositive(arg1))) {
                    return true;
                }
                if (symbol.equals(S.Log) && AbstractAssumptions.assumeGreaterThan(arg1, F.C1)) {
                    return true;
                }
            }
            if (ast.isPlus()) {
                for (int i = 1; i < size; ++i) {
                    IExpr x = ast.get(i);
                    if (x.isPositiveResult() || AbstractAssumptions.assumePositive(x)) continue;
                    return false;
                }
                return true;
            }
            if (ast.isTimes()) {
                boolean flag = true;
                for (int i = 1; i < size; ++i) {
                    IExpr x = ast.get(i);
                    if (x.isPositiveResult() || AbstractAssumptions.assumePositive(x)) continue;
                    if (!x.isNegativeResult() && !AbstractAssumptions.assumeNegative(x)) {
                        return false;
                    }
                    flag = !flag;
                }
                return flag;
            }
            if (ast.isPower()) {
                IExpr base = ast.base();
                IExpr exponent = ast.exponent();
                if (exponent.isInteger()) {
                    IInteger iArg2 = (IInteger)exponent;
                    if (base.isNegativeResult() && iArg2.isEven()) {
                        return true;
                    }
                    if (base.isPositiveResult() && exponent.isInteger() && iArg2.isEven()) {
                        return true;
                    }
                }
                return base.isE() && exponent.isRealResult();
            }
        }
        return false;
    }

    @Override
    public boolean isAlgebraic(IExpr expr) {
        return false;
    }

    @Override
    public boolean isBoolean(IExpr expr) {
        return false;
    }

    @Override
    public boolean isComplex(IExpr expr) {
        return false;
    }

    @Override
    public boolean isEqual(IExpr expr, ISignedNumber number) {
        return false;
    }

    @Override
    public boolean isGreaterEqual(IExpr expr, ISignedNumber number) {
        return false;
    }

    @Override
    public boolean isGreaterThan(IExpr expr, ISignedNumber number) {
        return false;
    }

    @Override
    public boolean isInteger(IExpr expr) {
        return false;
    }

    @Override
    public boolean isLessEqual(IExpr expr, ISignedNumber number) {
        return false;
    }

    @Override
    public boolean isLessThan(IExpr expr, ISignedNumber number) {
        return false;
    }

    @Override
    public boolean isNegative(IExpr expr) {
        return false;
    }

    @Override
    public boolean isNonNegative(IExpr expr) {
        return false;
    }

    @Override
    public boolean isPositive(IExpr expr) {
        return false;
    }

    @Override
    public boolean isPrime(IExpr expr) {
        return false;
    }

    @Override
    public boolean isRational(IExpr expr) {
        return false;
    }

    @Override
    public boolean isReal(IExpr expr) {
        return false;
    }
}

