/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.interfaces.AbstractArg1;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;

public abstract class AbstractTrigArg1
extends AbstractArg1 {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        return this.evaluateArg1(ast.arg1(), engine);
    }

    @Override
    public IExpr numericEval(IAST ast, EvalEngine engine) {
        IExpr arg1 = ast.arg1();
        try {
            if (arg1 instanceof INum) {
                INumber x = ((INumber)arg1).evaluatePrecision(engine);
                if (x instanceof ApfloatNum) {
                    return this.e1ApfloatArg(((INum)x).apfloatValue());
                }
                return this.e1DblArg(((Num)arg1).doubleValue());
            }
            if (arg1 instanceof IComplexNum) {
                if (arg1 instanceof ApcomplexNum) {
                    return this.e1ApcomplexArg(((ApcomplexNum)arg1).apcomplexValue());
                }
                return this.e1ComplexArg(((ComplexNum)arg1).complexValue());
            }
        }
        catch (LimitException le) {
            throw le;
        }
        catch (RuntimeException rex) {
            LOGGER.log(EvalEngine.get().getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            return F.NIL;
        }
        return this.evaluateArg1(arg1, engine);
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_1;
    }

    @Override
    public IExpr e1DblArg(double d) {
        return F.NIL;
    }

    @Override
    public IExpr e1ComplexArg(Complex c) {
        return F.NIL;
    }

    public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
        return F.NIL;
    }
}

