/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.RealMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractMatrix1Expr;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IExpr;

public abstract class AbstractMatrix1Matrix
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        boolean togetherMode = engine.isTogetherMode();
        try {
            FieldMatrix<IExpr> matrix;
            engine.setTogetherMode(true);
            int[] dims = this.checkMatrixDimensions(ast.arg1());
            if (dims != null && (matrix = Convert.list2Matrix(ast.arg1())) != null) {
                Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                matrix = this.matrixEval(matrix, zeroChecker);
                IASTAppendable iASTAppendable = Convert.matrix2List(matrix);
                return iASTAppendable;
            }
        }
        catch (LimitException le) {
            throw le;
        }
        catch (MathRuntimeException mre) {
            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
        }
        catch (RuntimeException rex) {
            LOGGER.debug("AbstractMatrix1Matrix.evaluate() failed", (Throwable)rex);
        }
        finally {
            engine.setTogetherMode(togetherMode);
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr numericEval(IAST ast, EvalEngine engine) {
        boolean togetherMode = engine.isTogetherMode();
        try {
            engine.setTogetherMode(true);
            int[] dims = this.checkMatrixDimensions(ast.arg1());
            if (dims != null) {
                if (engine.isArbitraryMode()) {
                    FieldMatrix<IExpr> fieldMatrix = Convert.list2Matrix(ast.arg1());
                    if (fieldMatrix == null) {
                        IAssociation iAssociation = F.NIL;
                        return iAssociation;
                    }
                    Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                    fieldMatrix = this.matrixEval(fieldMatrix, zeroChecker);
                    IASTAppendable iASTAppendable = Convert.matrix2List(fieldMatrix);
                    return iASTAppendable;
                }
                RealMatrix matrix = ast.arg1().toRealMatrix();
                if (matrix != null && (matrix = this.realMatrixEval(matrix)) != null) {
                    IASTMutable iASTMutable = Convert.realMatrix2List(matrix);
                    return iASTMutable;
                }
            }
            IAssociation iAssociation = F.NIL;
            return iAssociation;
        }
        catch (LimitException le) {
            throw le;
        }
        catch (RuntimeException rex) {
            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            IAssociation iAssociation = F.NIL;
            return iAssociation;
        }
        finally {
            engine.setTogetherMode(togetherMode);
        }
    }

    public int[] checkMatrixDimensions(IExpr arg1) {
        return arg1.isMatrix();
    }

    public abstract FieldMatrix<IExpr> matrixEval(FieldMatrix<IExpr> var1, Predicate<IExpr> var2);

    public abstract RealMatrix realMatrixEval(RealMatrix var1);
}

