/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.RealMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public abstract class AbstractMatrix1Expr
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final PossibleZeroQTest POSSIBLE_ZEROQ_TEST = new PossibleZeroQTest();

    public int[] checkMatrixDimensions(IExpr arg1) {
        return arg1.isMatrix();
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        try {
            FieldMatrix<IExpr> matrix;
            int[] dim = this.checkMatrixDimensions(ast.arg1());
            if (dim != null && (matrix = Convert.list2Matrix(ast.arg1())) != null) {
                Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                return this.matrixEval(matrix, zeroChecker);
            }
        }
        catch (LimitException le) {
            throw le;
        }
        catch (MathRuntimeException mre) {
            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
        }
        catch (RuntimeException e) {
            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_2;
    }

    public abstract IExpr matrixEval(FieldMatrix<IExpr> var1, Predicate<IExpr> var2);

    @Override
    public IExpr numericEval(IAST ast, EvalEngine engine) {
        IExpr arg1 = ast.arg1();
        int[] dim = this.checkMatrixDimensions(arg1);
        if (dim != null) {
            try {
                if (engine.isArbitraryMode()) {
                    FieldMatrix<IExpr> fieldMatrix = Convert.list2Matrix(arg1);
                    if (fieldMatrix != null) {
                        Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                        return this.matrixEval(fieldMatrix, zeroChecker);
                    }
                    return F.NIL;
                }
                RealMatrix matrix = arg1.toRealMatrix();
                if (matrix != null) {
                    return this.realMatrixEval(matrix);
                }
                FieldMatrix<IExpr> fieldMatrix = Convert.list2Matrix(arg1);
                if (fieldMatrix != null) {
                    Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                    return this.matrixEval(fieldMatrix, zeroChecker);
                }
            }
            catch (LimitException le) {
                throw le;
            }
            catch (MathRuntimeException mre) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
            }
            catch (RuntimeException e) {
                LOGGER.debug("AbstractMatrix1Expr.numericEval() failed", (Throwable)e);
            }
        }
        return F.NIL;
    }

    public static Predicate<IExpr> optionZeroTest(IAST ast, int start, EvalEngine engine) {
        OptionArgs options;
        IExpr zeroTest;
        Predicate<IExpr> zeroChecker = POSSIBLE_ZEROQ_TEST;
        if (ast.size() > 1 && (zeroTest = (options = new OptionArgs(ast.topHead(), ast, start, ast.size(), engine)).getOption(S.ZeroTest)).isPresent() && !zeroTest.equals(S.Automatic)) {
            zeroChecker = Predicates.isTrue(engine, zeroTest);
        }
        return zeroChecker;
    }

    public abstract IExpr realMatrixEval(RealMatrix var1);

    public static class PossibleZeroQTest
    implements Predicate<IExpr> {
        @Override
        public boolean test(IExpr x) {
            return x.isPossibleZero(false);
        }
    }
}

