/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public abstract class AbstractFunctionOptionEvaluator
extends AbstractFunctionEvaluator {
    protected IBuiltInSymbol[] optionSymbols = null;

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr[] option;
        int argSize = ast.argSize();
        if (this.optionSymbols == null) {
            option = new IExpr[]{};
        } else {
            option = new IExpr[this.optionSymbols.length];
            argSize = AbstractFunctionEvaluator.determineOptions(option, ast, ast.argSize(), this.expectedArgSize(ast), this.optionSymbols, engine);
        }
        return this.evaluate(ast, argSize, option, engine);
    }

    protected void setOptions(ISymbol symbol, IBuiltInSymbol lhsOptionSymbol, IExpr rhsValue) {
        this.optionSymbols = new IBuiltInSymbol[]{lhsOptionSymbol};
        super.setOptions(symbol, F.list(F.Rule((IExpr)lhsOptionSymbol, rhsValue)));
    }

    protected void setOptions(ISymbol symbol, IBuiltInSymbol[] lhsOptionSymbols, IExpr[] rhsValues) {
        this.optionSymbols = lhsOptionSymbols;
        IASTAppendable list = F.ListAlloc(rhsValues.length);
        for (int i = 0; i < rhsValues.length; ++i) {
            list.append(F.Rule((IExpr)lhsOptionSymbols[i], rhsValues[i]));
        }
        super.setOptions(symbol, list);
    }

    public IBuiltInSymbol[] getOptionSymbols() {
        return this.optionSymbols;
    }

    public abstract IExpr evaluate(IAST var1, int var2, IExpr[] var3, EvalEngine var4);
}

