/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.PatternMatching;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;

public abstract class AbstractFunctionEvaluator
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IExpr extractFactorFromExpression(IExpr expression, INumber factor) {
        return AbstractFunctionEvaluator.extractFactorFromExpression(expression, factor, true);
    }

    public static IExpr extractFactorFromExpression(IExpr expression, INumber factor, boolean checkTimes) {
        IAST timesAST;
        IExpr arg1;
        if (expression.isNumber()) {
            if (((INumber)expression).equals(factor)) {
                return F.C1;
            }
        } else if (expression.isAST() && checkTimes && expression.isTimes() && (arg1 = (timesAST = (IAST)expression).arg1()).isNumber() && ((INumber)arg1).isImaginaryUnit()) {
            return timesAST.rest().oneIdentity(factor);
        }
        return F.NIL;
    }

    public static IExpr getNormalizedNegativeExpression(IExpr expression) {
        return AbstractFunctionEvaluator.getNormalizedNegativeExpression(expression, true);
    }

    public static IExpr getNormalizedNegativeExpression(IExpr expression, boolean checkTimesPlus) {
        IASTMutable result = F.NIL;
        if (expression.isNumber()) {
            if (((INumber)expression).complexSign() < 0) {
                return ((INumber)expression).negate();
            }
            return F.NIL;
        }
        if (expression.isAST()) {
            if (checkTimesPlus && expression.isTimes()) {
                IAST timesAST = (IAST)expression;
                IExpr arg1 = timesAST.arg1();
                if (arg1.isNumber()) {
                    if (((INumber)arg1).complexSign() < 0) {
                        IExpr negNum = ((INumber)arg1).negate();
                        if (negNum.isOne()) {
                            return timesAST.rest().oneIdentity1();
                        }
                        return timesAST.setAtCopy(1, negNum);
                    }
                } else if (arg1.isNegativeInfinity()) {
                    return timesAST.setAtCopy(1, F.CInfinity);
                }
            } else if (checkTimesPlus && expression.isPlus()) {
                IAST plusAST = (IAST)expression;
                IExpr arg1 = plusAST.arg1();
                if (arg1.isNumber()) {
                    if (((INumber)arg1).complexSign() < 0) {
                        result = plusAST.copy();
                        result.set(1, arg1.negate());
                        for (int i = 2; i < plusAST.size(); ++i) {
                            result.set(i, plusAST.get(i).negate());
                        }
                        return result;
                    }
                } else {
                    IExpr arg1Negated;
                    if (arg1.isNegativeInfinity()) {
                        result = plusAST.copy();
                        result.set(1, F.CInfinity);
                        for (int i = 2; i < plusAST.size(); ++i) {
                            result.set(i, plusAST.get(i).negate());
                        }
                        return result;
                    }
                    if (arg1.isTimes() && (arg1Negated = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1, checkTimesPlus)).isPresent()) {
                        result = plusAST.copy();
                        result.set(1, arg1Negated);
                        for (int i = 2; i < plusAST.size(); ++i) {
                            IExpr temp = plusAST.get(i);
                            result.set(i, temp.negate());
                        }
                        return result;
                    }
                }
            } else if (expression.isDirectedInfinity() && expression.isAST1()) {
                IExpr arg1 = expression.first();
                if (arg1.isMinusOne()) {
                    return F.CInfinity;
                }
                if (arg1.isNegativeImaginaryUnit()) {
                    return F.DirectedInfinity(F.CI);
                }
            }
        }
        return F.NIL;
    }

    public static boolean isNegativeWeighted(IAST ast, boolean checkTimesPlus) {
        return AbstractFunctionEvaluator.isNegativeWeighted(ast, checkTimesPlus, ast.size() / 2);
    }

    public static boolean isNegativeWeighted(IAST ast, boolean checkTimesPlus, int maxNegativeExpr) {
        int count = maxNegativeExpr - 1;
        for (int i = 1; i < ast.size(); ++i) {
            if (!AbstractFunctionEvaluator.isNegativeValued(ast.get(i), checkTimesPlus) || --count >= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isNegativeValued(IExpr expression, boolean checkTimesPlus) {
        IAST plusAST;
        IExpr arg1;
        IExpr arg12;
        if (expression.isNumber()) {
            return ((INumber)expression).complexSign() < 0;
        }
        return expression.isAST() && (checkTimesPlus && expression.isTimes() ? ((arg12 = expression.first()).isNumber() ? ((INumber)arg12).complexSign() < 0 : arg12.isNegativeInfinity()) : (checkTimesPlus && expression.isPlus() ? ((arg1 = (plusAST = (IAST)expression).arg1()).isNumber() ? ((INumber)arg1).complexSign() < 0 : arg1.isNegativeInfinity() || arg1.isTimes() && AbstractFunctionEvaluator.isNegativeValued(arg1, checkTimesPlus)) : expression.isDirectedInfinity() && expression.isAST1() && ((arg1 = expression.first()).isMinusOne() || arg1.isNegativeImaginaryUnit())));
    }

    public static IAST getPeriodicParts(IExpr expr, IExpr period) {
        IASTMutable result = F.binaryAST2((IExpr)S.List, F.C0, (IExpr)F.C1);
        if (expr.equals(period)) {
            return result;
        }
        if (expr.isAST()) {
            IAST ast = (IAST)expr;
            if (ast.isTimes()) {
                for (int i = 1; i < ast.size(); ++i) {
                    if (!ast.get(i).equals(period)) continue;
                    result.set(2, ast.splice(i).oneIdentity1());
                    return result;
                }
                return F.NIL;
            }
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    IAST temp = AbstractFunctionEvaluator.getPeriodicParts(ast.get(i), period);
                    if (!temp.isPresent() || !temp.arg1().isZero()) continue;
                    result.set(1, ast.splice(i).oneIdentity0());
                    result.set(2, temp.arg2());
                    return result;
                }
            }
        }
        return F.NIL;
    }

    public static IAST peelOff(IAST plusAST, EvalEngine engine) {
        IRational k = null;
        for (int i = 1; i < plusAST.size(); ++i) {
            IExpr temp = plusAST.get(i);
            if (temp.equals(S.Pi)) {
                k = F.C1;
                break;
            }
            if (!temp.isTimes2() || !temp.first().isRational() || !temp.second().equals(S.Pi)) continue;
            k = (IRational)temp.first();
            break;
        }
        if (k != null) {
            IASTMutable result = F.binaryAST2((IExpr)S.List, plusAST, (IExpr)F.C0);
            IASTMutable m1 = F.Times((IExpr)k.mod(F.C1D2), (IExpr)S.Pi);
            IExpr m2 = S.Subtract.of(engine, F.Times((IExpr)k, (IExpr)S.Pi), m1);
            result.set(1, S.Subtract.of(plusAST, m2));
            result.set(2, m2);
            return result;
        }
        return F.NIL;
    }

    public static IExpr peelOffPlusRational(IAST plusAST, EvalEngine engine) {
        IInteger k = null;
        for (int i = 1; i < plusAST.size(); ++i) {
            IExpr peeled;
            IExpr temp = plusAST.get(i);
            if (temp.equals(S.Pi)) {
                k = F.C1;
                return k;
            }
            if (!temp.isTimes() || !(peeled = AbstractFunctionEvaluator.peelOfTimes((IAST)temp, S.Pi)).isPresent() || !peeled.isRational() && !peeled.isIntegerResult()) continue;
            return peeled;
        }
        return null;
    }

    public static IAST peelOffPlusI(IAST plusAST, EvalEngine engine) {
        for (int i = 1; i < plusAST.size(); ++i) {
            IExpr x;
            IExpr peeled;
            IExpr arg = plusAST.get(i);
            if (!arg.isTimes() || !(peeled = AbstractFunctionEvaluator.peelOfTimes((IAST)arg, S.Pi)).isPresent() || !(x = S.Times.of(F.CNI, peeled)).isRational() && !x.isIntegerResult()) continue;
            return F.list(x, arg);
        }
        return F.NIL;
    }

    public static IExpr peelOfTimes(IAST astTimes, IExpr period) {
        for (int i = 1; i < astTimes.size(); ++i) {
            if (!astTimes.get(i).equals(period)) continue;
            return astTimes.splice(i).oneIdentity1();
        }
        return F.NIL;
    }

    public static IExpr peelOfTimes(IAST astTimes, IExpr period1, IExpr period2) {
        IASTAppendable result = F.NIL;
        for (int i = 1; i < astTimes.size(); ++i) {
            if (!astTimes.get(i).equals(period1)) continue;
            result = astTimes.copyAppendable();
            result.remove(i);
            for (int j = 1; j < result.size(); ++j) {
                if (!result.get(j).equals(period2)) continue;
                result.remove(j);
                return result;
            }
            return F.NIL;
        }
        return F.NIL;
    }

    public static IExpr getPowerNegativeExpression(IExpr expression, boolean checkTimesPlus) {
        IASTMutable result = F.NIL;
        if (expression.isNumber()) {
            if (((INumber)expression).complexSign() < 0) {
                return ((INumber)expression).negate();
            }
            return F.NIL;
        }
        if (expression.isAST()) {
            if (checkTimesPlus && expression.isTimes()) {
                IAST timesAST = (IAST)expression;
                IExpr arg1 = timesAST.arg1();
                if (arg1.isNumber()) {
                    if (((INumber)arg1).complexSign() < 0) {
                        IExpr negNum = ((INumber)arg1).negate();
                        if (negNum.isOne()) {
                            return timesAST.rest().oneIdentity1();
                        }
                        return timesAST.setAtCopy(1, negNum);
                    }
                } else {
                    if (arg1.isNegativeInfinity()) {
                        return timesAST.setAtCopy(1, F.CInfinity);
                    }
                    if (arg1.isNegative()) {
                        IExpr negNum = arg1.negate();
                        return timesAST.setAtCopy(1, negNum);
                    }
                }
            } else if (checkTimesPlus && expression.isPlus()) {
                IAST plusAST = (IAST)expression;
                IExpr arg1 = plusAST.arg1();
                if (arg1.isNumber()) {
                    if (((INumber)arg1).complexSign() < 0) {
                        result = plusAST.copy();
                        result.set(1, arg1.negate());
                        for (int i = 2; i < plusAST.size(); ++i) {
                            result.set(i, plusAST.get(i).negate());
                        }
                        return result;
                    }
                } else {
                    IExpr arg1Negated;
                    if (arg1.isNegativeInfinity()) {
                        result = plusAST.copy();
                        result.set(1, F.CInfinity);
                        for (int i = 2; i < plusAST.size(); ++i) {
                            result.set(i, plusAST.get(i).negate());
                        }
                        return result;
                    }
                    if (arg1.isTimes() && (arg1Negated = AbstractFunctionEvaluator.getPowerNegativeExpression(arg1, checkTimesPlus)).isPresent()) {
                        int positiveElementsCounter = 0;
                        result = plusAST.copy();
                        result.set(1, arg1Negated);
                        for (int i = 2; i < plusAST.size(); ++i) {
                            IExpr temp = plusAST.get(i);
                            if (!temp.isTimes() && !temp.isPower()) {
                                return F.NIL;
                            }
                            arg1Negated = AbstractFunctionEvaluator.getPowerNegativeExpression(temp, checkTimesPlus);
                            if (arg1Negated.isPresent()) {
                                result.set(i, arg1Negated);
                                continue;
                            }
                            if (++positiveElementsCounter * 2 > plusAST.argSize()) {
                                return F.NIL;
                            }
                            result.set(i, temp.negate());
                        }
                        return result;
                    }
                }
            } else if (expression.isDirectedInfinity() && expression.isAST1()) {
                IExpr arg1 = expression.first();
                if (arg1.isMinusOne()) {
                    return F.CInfinity;
                }
                if (arg1.isNegativeImaginaryUnit()) {
                    return F.DirectedInfinity(F.CI);
                }
            }
        }
        return F.NIL;
    }

    public static IExpr getPureImaginaryPart(IExpr expr) {
        IAST plus;
        IExpr arg;
        IExpr temp = AbstractFunctionEvaluator.pureImaginaryPart(expr);
        if (temp.isPresent()) {
            return temp;
        }
        if (expr.isPlus() && (arg = AbstractFunctionEvaluator.pureImaginaryPart((plus = (IAST)expr).arg1())).isPresent()) {
            IASTMutable result = plus.setAtCopy(1, arg);
            for (int i = 2; i < plus.size(); ++i) {
                arg = AbstractFunctionEvaluator.pureImaginaryPart(plus.get(i));
                if (!arg.isPresent()) {
                    return F.NIL;
                }
                result.set(i, arg);
            }
            return result;
        }
        return F.NIL;
    }

    public static IExpr getComplexExpr(IExpr expr, IExpr factor) {
        if (expr.isComplex() && (expr.re().isZero() || expr.re().isNegative())) {
            return F.Times(factor, expr);
        }
        if (expr.isTimes() && expr.first().isComplex()) {
            IComplex arg1 = (IComplex)expr.first();
            if (arg1.re().isZero() || arg1.re().isNegative()) {
                return F.Times(factor, expr);
            }
        } else if (expr.isPlus()) {
            IExpr arg1 = expr.first();
            if (arg1.isComplex() && (arg1.re().isZero() || arg1.re().isNegative())) {
                return F.Distribute(F.Times(factor, expr));
            }
            if (arg1.isTimes() && arg1.first().isComplex() && ((arg1 = arg1.first()).re().isZero() || arg1.re().isNegative())) {
                return F.Distribute(F.Times(factor, expr));
            }
        }
        return F.NIL;
    }

    public static IExpr imaginaryPart(IExpr expr, boolean unequalsZero) {
        IExpr imPart = S.Im.of(expr);
        if (unequalsZero && imPart.isZero()) {
            return F.NIL;
        }
        if (imPart.isNumber() || imPart.isFree(S.Im)) {
            return imPart;
        }
        return F.NIL;
    }

    public static IExpr realPart(IExpr expr, boolean unequalsZero) {
        IExpr rePart = S.Re.of(expr);
        if (unequalsZero && rePart.isZero()) {
            return F.NIL;
        }
        if (rePart.isNumber() || rePart.isFree(S.Re)) {
            return rePart;
        }
        return F.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSerializedRules(ISymbol symbol) {
        EvalEngine engine = EvalEngine.get();
        boolean oldPackageMode = engine.isPackageMode();
        boolean oldTraceMode = engine.isTraceMode();
        engine.setPackageMode(true);
        engine.setTraceMode(false);
        try (InputStream in = AbstractFunctionEvaluator.class.getResourceAsStream("/ser/" + symbol.getSymbolName().toLowerCase(Locale.ENGLISH) + ".ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            symbol.readRules(ois);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("AbstractFunctionEvaluator.initSerializedRules() failed", (Throwable)e);
        }
        finally {
            engine.setPackageMode(oldPackageMode);
            engine.setTraceMode(oldTraceMode);
        }
    }

    private static IExpr pureImaginaryPart(IExpr expr) {
        IAST times;
        IExpr arg1;
        if (expr.isComplex() && ((IComplex)expr).re().isZero()) {
            IComplex compl = (IComplex)expr;
            return compl.im();
        }
        if (expr.isTimes() && (arg1 = (times = (IAST)expr).arg1()).isComplex() && ((IComplex)arg1).re().isZero()) {
            return times.setAtCopy(1, ((IComplex)arg1).im());
        }
        return F.NIL;
    }

    public void createRuleFromMethod(ISymbol symbol, String patternString, String methodName) {
        PatternMatcherAndInvoker pm = new PatternMatcherAndInvoker(patternString, (IFunctionEvaluator)this, methodName);
        symbol.putDownRule(pm);
    }

    @Override
    public abstract IExpr evaluate(IAST var1, EvalEngine var2);

    public IAST getRuleAST() {
        return null;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        if (this.getRuleAST() != null) {
            // empty if block
        }
        if (Config.SERIALIZE_SYMBOLS && newSymbol.containsRules()) {
            try (FileOutputStream out = new FileOutputStream("c:\\temp\\ser\\" + newSymbol.getSymbolName() + ".ser");
                 ObjectOutputStream oos = new ObjectOutputStream(out);){
                newSymbol.writeRules(oos);
            }
            catch (IOException e) {
                LOGGER.error("AbstractFunctionEvaluator.setUp() failed", (Throwable)e);
            }
        }
    }

    public static int determineOptions(IExpr[] options, IAST ast, int argSize, int[] expectedArgSize, IBuiltInSymbol[] optionSymbol, EvalEngine engine) {
        argSize = AbstractFunctionEvaluator.determineArgumentOptions(options, ast, argSize, expectedArgSize, optionSymbol);
        AbstractFunctionEvaluator.determineDefaultOptions(options, ast, optionSymbol, engine);
        return argSize;
    }

    private static int determineArgumentOptions(IExpr[] options, IAST ast, int argSize, int[] expectedArgSize, IBuiltInSymbol[] optionSymbol) {
        int minNumberOfArgs = 1;
        if (expectedArgSize != null && (minNumberOfArgs = expectedArgSize[0]) < 1) {
            minNumberOfArgs = 1;
        }
        int counter = 0;
        boolean evaled = true;
        block0: while (argSize > minNumberOfArgs && evaled && counter < optionSymbol.length) {
            IExpr arg = ast.get(argSize);
            if (arg.isRule()) {
                evaled = false;
                for (int i = 0; i < optionSymbol.length; ++i) {
                    if (!optionSymbol[i].equals(arg.first())) continue;
                    options[i] = arg.second();
                    --argSize;
                    ++counter;
                    evaled = true;
                    continue block0;
                }
                continue;
            }
            if (arg.isListOfRules(true) && !arg.isEmptyList()) {
                IAST listOfRules = (IAST)arg;
                block2: for (int j = 1; j < listOfRules.size(); ++j) {
                    IAST rule = (IAST)listOfRules.get(j);
                    evaled = false;
                    for (int i = 0; i < optionSymbol.length; ++i) {
                        if (!optionSymbol[i].equals(rule.first())) continue;
                        options[i] = rule.second();
                        --argSize;
                        ++counter;
                        evaled = true;
                        continue block2;
                    }
                }
                continue;
            }
            evaled = false;
            break;
        }
        return argSize;
    }

    private static void determineDefaultOptions(IExpr[] options, IAST ast, IBuiltInSymbol[] optionSymbol, EvalEngine engine) {
        IAST temp;
        int optionNullStart = -1;
        for (int i = 0; i < options.length; ++i) {
            if (options[i] != null) continue;
            optionNullStart = i;
            break;
        }
        if (optionNullStart >= 0 && (temp = PatternMatching.optionsList(ast.topHead(), false)).isList() && temp.size() > 1) {
            IAST list = temp;
            block1: for (int i = optionNullStart; i < options.length; ++i) {
                if (options[i] != null) continue;
                options[i] = S.None;
                for (int j = 1; j < list.size(); ++j) {
                    IAST rule = (IAST)list.get(j);
                    if (!optionSymbol[i].equals(rule.first())) continue;
                    options[i] = rule.second();
                    continue block1;
                }
            }
        }
    }
}

