/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.hash.HashedOrderlessMatcher;

public abstract class AbstractArgMultiple
extends AbstractArg2 {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (ast.isAST2()) {
            IExpr temp = this.binaryOperator(ast, ast.arg1(), ast.arg2(), engine);
            if (temp.isPresent()) {
                return temp;
            }
            return this.evaluateHashsRepeated(ast, engine);
        }
        if (ast.size() > 3) {
            IASTAppendable tempAST = ast.copyAppendable();
            ISymbol sym = tempAST.topHead();
            IASTAppendable result = F.ast(sym);
            IExpr temp = tempAST.arg1();
            boolean evaled = false;
            int i = 2;
            while (i < tempAST.size()) {
                IExpr tres = this.binaryOperator(ast, temp, tempAST.get(i), engine);
                if (!tres.isPresent()) {
                    for (int j = i + 1; j < tempAST.size(); ++j) {
                        tres = this.binaryOperator(ast, temp, tempAST.get(j), engine);
                        if (!tres.isPresent()) continue;
                        evaled = true;
                        temp = tres;
                        tempAST.remove(j);
                        break;
                    }
                    if (tres.isPresent()) continue;
                    result.append(temp);
                    if (i == tempAST.argSize()) {
                        result.append(tempAST.get(i));
                    } else {
                        temp = tempAST.get(i);
                    }
                    ++i;
                    continue;
                }
                evaled = true;
                temp = tres;
                if (i == tempAST.argSize()) {
                    result.append(temp);
                }
                ++i;
            }
            if (evaled) {
                if (result.isAST1() && sym.hasOneIdentityAttribute()) {
                    return result.arg1();
                }
                return result;
            }
            if (tempAST.size() > 2) {
                return this.evaluateHashsRepeated(tempAST, engine);
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return null;
    }

    public HashedOrderlessMatcher getHashRuleMap() {
        return null;
    }

    public IAST evaluateHashsRepeated(IAST orderlessAST, EvalEngine engine) {
        HashedOrderlessMatcher hashRuleMap = this.getHashRuleMap();
        if (hashRuleMap == null) {
            return F.NIL;
        }
        return hashRuleMap.evaluateRepeated(orderlessAST, engine);
    }

    public void defineHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, IExpr condition) {
        this.getHashRuleMap().defineHashRule(lhs1, lhs2, rhs, condition);
    }

    public void setUpHashRule2(IExpr lhs1, IExpr lhs2, IExpr rhs, IExpr condition) {
        this.getHashRuleMap().definePatternHashRule(lhs1, lhs2, rhs, condition);
    }

    @Override
    public IExpr binaryOperator(IAST ast, IExpr o0, IExpr o1, EvalEngine engine) {
        IExpr result = F.NIL;
        try {
            if (o0 instanceof INumber || o1 instanceof INumber) {
                if (o0 instanceof INum) {
                    if (o1 instanceof INum) {
                        result = this.e2DblArg((INum)o0, (INum)o1);
                    } else if (o1.isInteger()) {
                        result = this.e2DblArg((INum)o0, F.num((IInteger)o1));
                    } else if (o1.isFraction()) {
                        result = this.e2DblArg((INum)o0, F.num((IFraction)o1));
                    } else if (o1 instanceof IComplexNum) {
                        result = o0 instanceof ApfloatNum ? this.e2DblComArg(F.complexNum(((INum)o0).apfloatValue()), (IComplexNum)o1) : this.e2DblComArg(F.complexNum(((INum)o0).getRealPart()), (IComplexNum)o1);
                    }
                    if (result.isPresent()) {
                        return result;
                    }
                    return this.e2ObjArg(ast, o0, o1);
                }
                if (o1 instanceof INum) {
                    if (o0.isInteger()) {
                        result = this.e2DblArg(F.num((IInteger)o0), (INum)o1);
                    } else if (o0.isFraction()) {
                        result = this.e2DblArg(F.num((IFraction)o0), (INum)o1);
                    } else if (o0 instanceof IComplexNum) {
                        result = o1 instanceof ApfloatNum ? this.e2DblComArg((IComplexNum)o0, F.complexNum(((INum)o1).apfloatValue())) : this.e2DblComArg((IComplexNum)o0, F.complexNum(((INum)o1).getRealPart()));
                    }
                    if (result.isPresent()) {
                        return result;
                    }
                    return this.e2ObjArg(null, o0, o1);
                }
                if (o0 instanceof IComplexNum) {
                    if (o1.isInteger()) {
                        result = this.e2DblComArg((IComplexNum)o0, F.complexNum((IInteger)o1));
                    } else if (o1.isFraction()) {
                        result = this.e2DblComArg((IComplexNum)o0, F.complexNum((IFraction)o1));
                    } else if (o1 instanceof IComplexNum) {
                        result = this.e2DblComArg((IComplexNum)o0, (IComplexNum)o1);
                    }
                    if (result.isPresent()) {
                        return result;
                    }
                    return this.e2ObjArg(null, o0, o1);
                }
                if (o1 instanceof IComplexNum) {
                    if (o0.isInteger()) {
                        result = this.e2DblComArg(F.complexNum((IInteger)o0), (IComplexNum)o1);
                    } else if (o0.isFraction()) {
                        result = this.e2DblComArg(F.complexNum((IFraction)o0), (IComplexNum)o1);
                    }
                    if (result.isPresent()) {
                        return result;
                    }
                    return this.e2ObjArg(ast, o0, o1);
                }
                if (o0 instanceof IInteger) {
                    if (o1 instanceof IInteger) {
                        return this.e2IntArg((IInteger)o0, (IInteger)o1);
                    }
                    if (o1 instanceof IFraction) {
                        return this.e2FraArg(F.fraction((IInteger)o0, F.C1), (IFraction)o1);
                    }
                    if (o1 instanceof IComplex) {
                        return this.e2ComArg(F.complex((IInteger)o0, F.C0), (IComplex)o1);
                    }
                } else if (o0 instanceof IFraction) {
                    if (o1 instanceof IInteger) {
                        return this.e2FraArg((IFraction)o0, F.fraction((IInteger)o1, F.C1));
                    }
                    if (o1 instanceof IFraction) {
                        return this.e2FraArg((IFraction)o0, (IFraction)o1);
                    }
                    if (o1 instanceof IComplex) {
                        return this.e2ComArg(F.complex((IFraction)o0), (IComplex)o1);
                    }
                } else if (o0 instanceof IComplex) {
                    if (o1 instanceof IInteger) {
                        return this.eComIntArg((IComplex)o0, (IInteger)o1);
                    }
                    if (o1 instanceof IFraction) {
                        return this.e2ComArg((IComplex)o0, F.complex((IFraction)o1));
                    }
                    if (o1 instanceof IComplex) {
                        return this.e2ComArg((IComplex)o0, (IComplex)o1);
                    }
                }
            }
            if ((result = this.e2ObjArg(ast, o0, o1)).isPresent()) {
                return result;
            }
            if (o0 instanceof ISymbol) {
                if (o1 instanceof ISymbol) {
                    return this.e2SymArg((ISymbol)o0, (ISymbol)o1);
                }
            } else {
                if (o1 instanceof IInteger && o0 instanceof IAST) {
                    return this.eFunIntArg((IAST)o0, (IInteger)o1);
                }
                if (o1 instanceof IAST && o0 instanceof IAST) {
                    return this.e2FunArg((IAST)o0, (IAST)o1);
                }
            }
        }
        catch (LimitException le) {
            throw le;
        }
        catch (RuntimeException rex) {
            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
        }
        return F.NIL;
    }

    @Override
    public abstract IExpr e2IntArg(IInteger var1, IInteger var2);
}

