/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public abstract class AbstractArg12
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    public IExpr unaryOperator(IExpr arg0) {
        IExpr result = this.e1ObjArg(arg0);
        if (result.isPresent()) {
            return result;
        }
        if (arg0 instanceof IAST && (result = this.e1FunArg((IAST)arg0)).isPresent()) {
            return result;
        }
        int hier = arg0.hierarchy();
        if (hier <= 8) {
            if (hier <= 4) {
                if (hier == 2) {
                    INumber x = ((INumber)arg0).evaluatePrecision(EvalEngine.get());
                    if (x instanceof ApfloatNum) {
                        return this.e1ApfloatArg(((ApfloatNum)x).apfloatValue());
                    }
                    return this.e1DblArg((INum)x);
                }
                if (arg0 instanceof ApcomplexNum) {
                    return this.e1ApcomplexArg(((ApcomplexNum)arg0).apcomplexValue());
                }
                return this.e1DblComArg((IComplexNum)arg0);
            }
            return this.e1IntArg((IInteger)arg0);
        }
        if (hier <= 32) {
            if (hier == 16) {
                return this.e1FraArg((IFraction)arg0);
            }
            return this.e1ComArg((IComplex)arg0);
        }
        if (hier == 512) {
            return this.e1SymArg((ISymbol)arg0);
        }
        return F.NIL;
    }

    public IExpr e1ObjArg(IExpr o) {
        return F.NIL;
    }

    public IExpr e1DblArg(INum d) {
        return F.NIL;
    }

    public IExpr e1DblComArg(IComplexNum c) {
        return F.NIL;
    }

    public IExpr e1ApfloatArg(Apfloat arg1) {
        return F.NIL;
    }

    public IExpr e1ApcomplexArg(Apcomplex arg1) {
        return F.NIL;
    }

    public IExpr e1IntArg(IInteger i) {
        return F.NIL;
    }

    public IExpr e1FraArg(IFraction f) {
        return F.NIL;
    }

    public IExpr e1ComArg(IComplex c) {
        return F.NIL;
    }

    public IExpr e1SymArg(ISymbol s) {
        return F.NIL;
    }

    public IExpr e1FunArg(IAST f) {
        return F.NIL;
    }

    public IExpr binaryOperator(IAST ast, IExpr o0, IExpr o1) {
        IExpr result = this.e2ObjArg(o0, o1);
        if (result.isPresent()) {
            return result;
        }
        if (o0.isInexactNumber() && o1.isInexactNumber()) {
            try {
                EvalEngine engine = EvalEngine.get();
                INumber arg1 = ((INumber)o0).evaluatePrecision(engine);
                INumber arg2 = ((INumber)o1).evaluatePrecision(engine);
                if (arg1 instanceof ApcomplexNum) {
                    if (arg2.isNumber()) {
                        result = this.e2ApcomplexArg((ApcomplexNum)arg1, arg2.apcomplexNumValue());
                    }
                } else if (arg2 instanceof ApcomplexNum) {
                    if (arg1.isNumber()) {
                        result = this.e2ApcomplexArg(arg1.apcomplexNumValue(), (ApcomplexNum)arg2);
                    }
                } else if (arg1 instanceof ComplexNum) {
                    if (arg2.isNumber()) {
                        result = this.e2DblComArg((ComplexNum)arg1, arg2.complexNumValue());
                    }
                } else if (arg2 instanceof ComplexNum && arg1.isNumber()) {
                    result = this.e2DblComArg(arg1.complexNumValue(), (ComplexNum)arg2);
                }
                if (arg1 instanceof ApfloatNum) {
                    if (arg2.isReal()) {
                        result = this.e2ApfloatArg((ApfloatNum)arg1, ((ISignedNumber)arg2).apfloatNumValue());
                    }
                } else if (arg2 instanceof ApfloatNum) {
                    if (arg1.isReal()) {
                        result = this.e2ApfloatArg(((ISignedNumber)arg1).apfloatNumValue(), (ApfloatNum)arg2);
                    }
                } else if (arg1 instanceof Num) {
                    if (arg2.isReal()) {
                        result = this.e2DblArg((Num)arg1, ((ISignedNumber)arg2).numValue());
                    }
                } else if (arg2 instanceof Num && arg1.isReal()) {
                    result = this.e2DblArg(((ISignedNumber)arg1).numValue(), (Num)arg2);
                }
                if (result.isPresent()) {
                    return result;
                }
            }
            catch (LimitException le) {
                throw le;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("AbstractArg12.binaryOperator() failed", (Throwable)rex);
                return F.NIL;
            }
        }
        if (o0 instanceof IInteger) {
            if (o1 instanceof IInteger) {
                return this.e2IntArg((IInteger)o0, (IInteger)o1);
            }
            if (o1 instanceof IFraction) {
                return this.e2FraArg(F.fraction((IInteger)o0, F.C1), (IFraction)o1);
            }
            if (o1 instanceof IComplex) {
                return this.e2ComArg(F.complex((IInteger)o0, F.C0), (IComplex)o1);
            }
            return F.NIL;
        }
        if (o0 instanceof IFraction) {
            if (o1 instanceof IInteger) {
                return this.e2FraArg((IFraction)o0, F.fraction((IInteger)o1, F.C1));
            }
            if (o1 instanceof IFraction) {
                return this.e2FraArg((IFraction)o0, (IFraction)o1);
            }
            if (o1 instanceof IComplex) {
                return this.e2ComArg(F.complex((IFraction)o0), (IComplex)o1);
            }
            return F.NIL;
        }
        if (o0 instanceof IComplex) {
            if (o1 instanceof IInteger) {
                return this.eComIntArg((IComplex)o0, (IInteger)o1);
            }
            if (o1 instanceof IFraction) {
                return this.eComFraArg((IComplex)o0, (IFraction)o1);
            }
            if (o1 instanceof IComplex) {
                return this.e2ComArg((IComplex)o0, (IComplex)o1);
            }
            return F.NIL;
        }
        if (o0 instanceof ISymbol) {
            if (o1 instanceof ISymbol) {
                return this.e2SymArg((ISymbol)o0, (ISymbol)o1);
            }
            return F.NIL;
        }
        if (o0 instanceof IAST) {
            if (o1 instanceof IInteger) {
                return this.eFunIntArg((IAST)o0, (IInteger)o1);
            }
            if (o1 instanceof IAST) {
                return this.e2FunArg((IAST)o0, (IAST)o1);
            }
        }
        return F.NIL;
    }

    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return F.NIL;
    }

    public IExpr e2DblArg(INum d0, INum d1) {
        return F.NIL;
    }

    public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
        return F.NIL;
    }

    public IExpr e2ApfloatArg(ApfloatNum d0, ApfloatNum d1) {
        return F.NIL;
    }

    public IExpr e2ApcomplexArg(ApcomplexNum c0, ApcomplexNum c1) {
        return F.NIL;
    }

    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        return F.NIL;
    }

    public IExpr e2SymArg(ISymbol s0, ISymbol s1) {
        return F.NIL;
    }

    public IExpr e2FunArg(IAST f0, IAST f1) {
        return F.NIL;
    }

    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        return F.NIL;
    }

    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        return F.NIL;
    }

    public IExpr eComFraArg(IComplex c0, IFraction i1) {
        return F.NIL;
    }

    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        return F.NIL;
    }

    public IExpr eFunIntArg(IAST f0, IInteger i1) {
        return F.NIL;
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        try {
            if (ast.size() == 2 || ast.size() == 3) {
                if (ast.size() != 3) {
                    return this.unaryOperator(ast.arg1());
                }
                return this.binaryOperator(ast, ast.arg1(), ast.arg2());
            }
        }
        catch (LimitException le) {
            throw le;
        }
        catch (RuntimeException rex) {
            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_2;
    }
}

