/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.exception;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.ContextPath;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.Scanner;

public final class Validate {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int checkIntType(IAST ast, int pos) {
        return Validate.checkIntType(ast, pos, 0);
    }

    public static long[] checkListOfLongs(IAST ast, IExpr arg, long startValue, boolean quiet, EvalEngine engine) {
        IAST list;
        if (arg.isList() && (list = (IAST)arg).argSize() > 0) {
            long[] result = new long[list.argSize()];
            long longValue = 0L;
            try {
                for (int i = 1; i < list.size(); ++i) {
                    IExpr expr = list.get(i);
                    if (expr instanceof IInteger) {
                        longValue = ((IInteger)expr).toLong();
                    } else if (expr instanceof INum) {
                        longValue = ((INum)expr).toLong();
                    }
                    if (startValue > longValue) {
                        if (!quiet) {
                            IOFunctions.printMessage(ast.topHead(), "listoflongs", F.list(arg), engine);
                        }
                        return null;
                    }
                    result[i - 1] = longValue;
                }
                return result;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (!quiet) {
            IOFunctions.printMessage(ast.topHead(), "listoflongs", F.list(arg), engine);
        }
        return null;
    }

    public static BigInteger[] checkListOfBigIntegers(IAST ast, IExpr arg, boolean nonNegative, EvalEngine engine) {
        IAST list;
        if (arg.isNonEmptyList() && (list = (IAST)arg).argSize() > 0) {
            BigInteger[] result = new BigInteger[list.argSize()];
            try {
                for (int i = 1; i < list.size(); ++i) {
                    BigInteger longValue = null;
                    IExpr expr = list.get(i);
                    if (expr instanceof IInteger) {
                        longValue = ((IInteger)expr).toBigNumerator();
                    } else if (expr instanceof INum) {
                        longValue = BigInteger.valueOf(((INum)expr).toLong());
                    }
                    if (longValue == null || nonNegative && longValue.compareTo(BigInteger.ZERO) <= 0) {
                        IOFunctions.printMessage(ast.topHead(), "coef", F.list(arg, ast.topHead()), engine);
                        return null;
                    }
                    result[i - 1] = longValue;
                }
                return result;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("Validate.checkListOfBigIntegers() failed", (Throwable)rex);
            }
        }
        IOFunctions.printMessage(ast.topHead(), "coef", F.list(arg, ast.topHead()), engine);
        return null;
    }

    public static int[] checkListOfInts(IAST ast, IExpr arg, boolean nonNegative, boolean quiet, EvalEngine engine) {
        IAST list;
        if (arg.isNonEmptyList() && (list = (IAST)arg).argSize() > 0) {
            int[] result = new int[list.argSize()];
            try {
                for (int i = 1; i < list.size(); ++i) {
                    IExpr expr = list.get(i);
                    int intValue = expr.toIntDefault();
                    if (intValue == Integer.MIN_VALUE) {
                        if (!quiet) {
                            IOFunctions.printMessage(ast.topHead(), "coef", F.list(arg, ast.topHead()), engine);
                        }
                        return null;
                    }
                    if (nonNegative && intValue < 0) {
                        if (!quiet) {
                            IOFunctions.printMessage(ast.topHead(), "coef", F.list(arg, ast.topHead()), engine);
                        }
                        return null;
                    }
                    result[i - 1] = intValue;
                }
                return result;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("Validate.checkListOfInts() failed", (Throwable)rex);
            }
        }
        if (!quiet) {
            IOFunctions.printMessage(ast.topHead(), "coef", F.list(arg, ast.topHead()), engine);
        }
        return null;
    }

    public static int[] checkListOfInts(IAST ast, IExpr arg, int minValue, int maxValue, EvalEngine engine) {
        IAST list;
        if (arg.isList() && (list = (IAST)arg).argSize() > 0) {
            int[] result = new int[list.argSize()];
            int intValue = 0;
            try {
                for (int i = 1; i < list.size(); ++i) {
                    intValue = list.get(i).toIntDefault();
                    if (intValue == Integer.MIN_VALUE) {
                        IOFunctions.printMessage(ast.topHead(), "listofints", F.list(arg), engine);
                        return null;
                    }
                    if (minValue > intValue || intValue > maxValue) {
                        IOFunctions.printMessage(ast.topHead(), "listofints", F.list(arg), engine);
                        return null;
                    }
                    result[i - 1] = intValue;
                }
                return result;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        IOFunctions.printMessage(ast.topHead(), "listofints", F.list(arg), engine);
        return null;
    }

    public static int[][] checkListOfSequenceSpec(IAST ast, IExpr arg, int position, int stringLength, int minValue, int maxValue, EvalEngine engine) {
        IAST list;
        if (arg.isList() && (list = (IAST)arg).argSize() > 0) {
            int[][] result = new int[list.argSize()][2];
            int intValue = 0;
            try {
                for (int i = 1; i < list.size(); ++i) {
                    IExpr expr = list.get(i);
                    if (expr.isList2()) {
                        intValue = expr.first().toIntDefault();
                        if (intValue == Integer.MIN_VALUE) {
                            IOFunctions.printMessage(ast.topHead(), "mseqs", F.list(F.ZZ(position), ast), engine);
                            return null;
                        }
                        result[i - 1][0] = intValue;
                        intValue = expr.second().toIntDefault();
                        if (intValue == Integer.MIN_VALUE) {
                            IOFunctions.printMessage(ast.topHead(), "mseqs", F.list(F.ZZ(position), ast), engine);
                            return null;
                        }
                        result[i - 1][0] = intValue;
                        continue;
                    }
                    intValue = expr.toIntDefault();
                    if (intValue == Integer.MIN_VALUE) {
                        IOFunctions.printMessage(ast.topHead(), "listofints", F.list(arg), engine);
                        return null;
                    }
                    if (minValue > intValue || intValue > maxValue) {
                        IOFunctions.printMessage(ast.topHead(), "listofints", F.list(arg), engine);
                        return null;
                    }
                    if (intValue >= 0) {
                        result[i - 1][0] = 1;
                        result[i - 1][1] = intValue;
                        continue;
                    }
                    result[i - 1][0] = stringLength + intValue;
                    result[i - 1][1] = stringLength;
                }
                return result;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        IOFunctions.printMessage(ast.topHead(), "listofints", F.list(arg), engine);
        return null;
    }

    public static int[] checkDimension(IAST ast, IExpr arg, EvalEngine engine) {
        IAST list;
        if (arg.isInteger()) {
            int n = arg.toIntDefault();
            if (n > 0) {
                return new int[]{n};
            }
        } else if (arg.isList() && (list = (IAST)arg).argSize() > 0) {
            int[] result = new int[list.argSize()];
            int intValue = 0;
            try {
                for (int i = 1; i < list.size(); ++i) {
                    intValue = list.get(i).toIntDefault();
                    if (intValue <= 0) {
                        IOFunctions.printMessage(ast.topHead(), "posdim", F.list(arg), engine);
                        return null;
                    }
                    result[i - 1] = intValue;
                }
                return result;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        IOFunctions.printMessage(ast.topHead(), "posdim", F.list(arg), engine);
        return null;
    }

    public static int checkIntType(IAST ast, int position, int startValue) {
        IExpr arg = ast.get(position);
        if (arg instanceof IntegerSym) {
            int result = ((IntegerSym)arg).toInt();
            if (startValue > result) {
                String str = IOFunctions.getMessage("intm", F.list(ast, F.ZZ(position)), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        if (arg.isReal()) {
            int result = arg.toIntDefault();
            if (result == Integer.MIN_VALUE || startValue > result) {
                String str = IOFunctions.getMessage("intm", F.list(ast, F.ZZ(position)), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        String str = IOFunctions.getMessage("intm", F.list(ast, F.ZZ(position)), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public static int checkNonNegativeIntType(IAST ast, int pos) {
        if (ast.get(pos) instanceof IntegerSym) {
            int result = ast.get(pos).toIntDefault();
            if (result == Integer.MIN_VALUE || 0 > result) {
                String str = IOFunctions.getMessage("intnm", F.list(ast, F.ZZ(pos)), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        if (ast.get(pos).isReal()) {
            int result = ast.get(pos).toIntDefault();
            if (result == Integer.MIN_VALUE || 0 > result) {
                String str = IOFunctions.getMessage("intnm", F.list(ast, F.ZZ(pos)), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        String str = IOFunctions.getMessage("intnm", F.list(ast, F.ZZ(pos)), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public static int checkPositiveIntType(IAST ast, int pos) {
        if (ast.get(pos) instanceof IntegerSym) {
            int result = ast.get(pos).toIntDefault();
            if (result == Integer.MIN_VALUE || 0 >= result) {
                String str = IOFunctions.getMessage("intpm", F.list(ast.topHead(), F.ZZ(pos)), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        if (ast.get(pos).isReal()) {
            int result = ast.get(pos).toIntDefault();
            if (result == Integer.MIN_VALUE || 0 >= result) {
                String str = IOFunctions.getMessage("intpm", F.list(ast.topHead(), F.ZZ(pos)), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        String str = IOFunctions.getMessage("intpm", F.list(ast.topHead(), F.ZZ(pos)), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public static int checkIntLevelType(IExpr expr) {
        return Validate.checkIntLevelType(expr, 0);
    }

    public static int checkIntLevelType(IExpr expr, int startValue) {
        if (expr.isInfinity()) {
            int result = Integer.MAX_VALUE;
            if (startValue > result) {
                String str = IOFunctions.getMessage("intlevel", F.list(F.ZZ(startValue), F.CInfinity), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        if (expr.isReal()) {
            int result = expr.toIntDefault();
            if (result == Integer.MIN_VALUE || startValue > result) {
                String str = IOFunctions.getMessage("intlevel", F.list(F.ZZ(startValue), expr), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        if (expr.isNegativeInfinity()) {
            int result = Integer.MIN_VALUE;
            if (startValue > result) {
                String str = IOFunctions.getMessage("intlevel", F.list(F.ZZ(startValue), F.CNInfinity), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return result;
        }
        String str = IOFunctions.getMessage("intlevel", F.list(F.ZZ(startValue), expr), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public static int checkIntType(ISymbol head, IExpr expr, int startValue, EvalEngine engine) {
        int result = expr.toIntDefault();
        if (result == Integer.MIN_VALUE || startValue > result) {
            IOFunctions.printMessage(head, "intjava", F.list(F.ZZ(startValue), expr), engine);
            return Integer.MIN_VALUE;
        }
        return result;
    }

    public static int throwIntType(IExpr expr, int startValue, EvalEngine engine) {
        int result = expr.toIntDefault();
        if (result == Integer.MIN_VALUE || startValue > result) {
            String str = IOFunctions.getMessage("intjava", F.list(F.ZZ(startValue), expr), engine);
            throw new ArgumentTypeException(str);
        }
        return result;
    }

    public static IAST checkListType(IAST ast, int position, EvalEngine engine) {
        if (ast.get(position).isList()) {
            return (IAST)ast.get(position);
        }
        return IOFunctions.printMessage(ast.topHead(), "list", F.list(F.ZZ(position), ast), engine);
    }

    public static IExpr checkStringType(IAST ast, int position, EvalEngine engine) {
        if (ast.get(position) instanceof IStringX) {
            return ast.get(position);
        }
        return IOFunctions.printMessage(ast.topHead(), "string", F.list(F.ZZ(position), ast), engine);
    }

    public static String checkContextName(IAST ast, int position) {
        IStringX strX;
        String contextName;
        if (ast.get(position).isString() && (contextName = (strX = (IStringX)ast.get(position)).toString()).length() > 0) {
            if (contextName.charAt(contextName.length() - 1) != '`') {
                String str = IOFunctions.getMessage("cxt", F.list(strX), EvalEngine.get());
                throw new ArgumentTypeException(str);
            }
            return contextName;
        }
        String str = IOFunctions.getMessage("cxt", F.list(ast.get(position)), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public static IAST checkSymbolOrSymbolList(IAST ast, int position, EvalEngine engine) {
        if (ast.get(position).isList()) {
            IAST listOfSymbols = (IAST)ast.get(position);
            for (int i = 1; i < listOfSymbols.size(); ++i) {
                if (Validate.checkSymbolType(listOfSymbols, i, engine).isPresent()) continue;
                return F.NIL;
            }
            return listOfSymbols;
        }
        IExpr temp = Validate.checkSymbolType(ast, position, engine);
        if (temp.isPresent()) {
            return F.list(temp);
        }
        return F.NIL;
    }

    public static IAST checkLocalVariableList(IAST ast, int position, EvalEngine engine) {
        if (ast.get(position).isList()) {
            IAST listOfSymbols = (IAST)ast.get(position);
            listOfSymbols = F.flattenSequence(listOfSymbols).orElse(listOfSymbols);
            for (int i = 1; i < listOfSymbols.size(); ++i) {
                IExpr arg = listOfSymbols.get(i);
                if (arg.isSymbol() || (arg.isAST(S.Set, 3) || arg.isAST(S.SetDelayed, 3)) && arg.first().isSymbol()) continue;
                return IOFunctions.printMessage(ast.topHead(), "lvsym", F.list(ast.get(position), arg), engine);
            }
            return listOfSymbols;
        }
        return IOFunctions.printMessage(ast.topHead(), "lvlist", F.list(ast.get(position)), engine);
    }

    public static IAST checkIsVariableOrVariableList(IAST ast, int position, ISymbol head, EvalEngine engine) {
        IAST vars = null;
        IExpr temp = null;
        if (ast.get(position).isList()) {
            vars = (IAST)ast.get(position);
            for (int i = 1; i < vars.size(); ++i) {
                temp = Validate.checkIsVariable(vars, i, head, engine);
                if (temp.isPresent()) continue;
                return F.NIL;
            }
            return vars;
        }
        temp = Validate.checkIsVariable(ast, position, head, engine);
        if (!temp.isPresent()) {
            return F.NIL;
        }
        return F.list(temp);
    }

    public static IExpr checkSymbolType(IAST ast, int position, EvalEngine engine) {
        IExpr arg = ast.get(position);
        if (arg.isSymbol()) {
            return arg;
        }
        return IOFunctions.printMessage(ast.topHead(), "sym", F.list(arg, F.ZZ(position)), engine);
    }

    public static IExpr checkIsVariable(IAST ast, int position, EvalEngine engine) {
        return Validate.checkIsVariable(ast, position, ast.topHead(), engine);
    }

    public static IExpr checkIsVariable(IAST ast, int position, ISymbol head, EvalEngine engine) {
        IExpr arg = ast.get(position);
        if (arg.isVariable()) {
            return arg;
        }
        return IOFunctions.printMessage(head, "ivar", F.list(arg), engine);
    }

    public static IAST checkASTUpRuleType(IExpr expr) {
        if (expr.isAST()) {
            return (IAST)expr;
        }
        String str = IOFunctions.getMessage("setraw", F.list(expr), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public static IAST checkASTType(IAST ast, IExpr arg1, int position, EvalEngine engine) {
        if (arg1.isAST()) {
            return (IAST)arg1;
        }
        return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.ZZ(position), ast), engine);
    }

    public static IAST checkASTOrAssociationType(IAST ast, IExpr arg1, int position, EvalEngine engine) {
        if (arg1.isASTOrAssociation()) {
            return (IAST)arg1;
        }
        return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.ZZ(position), ast), engine);
    }

    private Validate() {
    }

    public static IASTAppendable checkEquations(IAST ast, int position) {
        IExpr expr = ast.get(position);
        int size = expr.size();
        IASTAppendable termsEqualNumberList = F.ListAlloc(size > 0 ? size : 1);
        if (expr.isList() || expr.isAnd()) {
            IAST listOrAndAST = (IAST)expr;
            for (int i = 1; i < size; ++i) {
                Validate.checkEquation(listOrAndAST.get(i), termsEqualNumberList);
            }
            return termsEqualNumberList;
        }
        Validate.checkEquation(expr, termsEqualNumberList);
        return termsEqualNumberList;
    }

    public static IASTAppendable checkEquationsAndInequations(IAST ast, int position) {
        IASTAppendable termsEqualZeroList;
        IExpr expr = ast.get(position);
        IAST eqns = null;
        if (expr.isList() || expr.isAnd()) {
            eqns = (IAST)expr;
            termsEqualZeroList = F.ListAlloc(eqns.size());
            for (int i = 1; i < eqns.size(); ++i) {
                IExpr arg = eqns.get(i);
                if (!arg.isAST2()) {
                    throw new ArgumentTypeException("binary equation or inequation expression expected at position " + i);
                }
                IAST eq = (IAST)arg;
                Validate.checkEquationAndInequation(eq, termsEqualZeroList);
            }
        } else {
            termsEqualZeroList = F.ListAlloc();
            Validate.checkEquationAndInequation(expr, termsEqualZeroList);
        }
        return termsEqualZeroList;
    }

    private static void checkEquationAndInequation(IExpr eq, IASTAppendable termsEqualZeroList) {
        if (eq.isEqual()) {
            IAST equal = (IAST)eq;
            IExpr subtract = EvalEngine.get().evaluate(F.Subtract(equal.arg1(), equal.arg2()));
            if (subtract.isList()) {
                IAST list = (IAST)subtract;
                IASTAppendable result = F.ListAlloc(list.size());
                for (int i = 1; i < list.size(); ++i) {
                    IExpr arg = list.get(i);
                    termsEqualZeroList.append(F.Equal(arg.isTimes() ? arg : F.evalExpandAll(arg), (IExpr)F.C0));
                }
                return;
            }
            termsEqualZeroList.append(F.Equal(subtract.isTimes() ? subtract : F.evalExpandAll(subtract), (IExpr)F.C0));
            return;
        }
        if (eq.isAST2()) {
            IAST equal = (IAST)eq;
            IExpr head = equal.head();
            if (head.equals(S.Equal) || head.equals(S.Unequal) || head.equals(S.Greater) || head.equals(S.GreaterEqual) || head.equals(S.Less) || head.equals(S.LessEqual)) {
                IExpr[] arr = new IExpr[]{F.expandAll(equal.arg1(), true, true), F.expandAll(equal.arg2(), true, true)};
                termsEqualZeroList.append(F.ast(arr, head));
                return;
            }
        } else {
            if (eq.isTrue()) {
                termsEqualZeroList.append(S.True);
                return;
            }
            if (eq.isFalse()) {
                termsEqualZeroList.append(S.False);
                return;
            }
        }
        throw new ArgumentTypeException("binary equation or inequation expression expected instead of " + eq.toString());
    }

    private static void checkEquation(IExpr expr, IASTAppendable termsEqualNumberList) {
        if (expr.isASTSizeGE(S.Equal, 3)) {
            IAST equal = (IAST)expr;
            IExpr last = equal.last();
            for (int i = 1; i < equal.size() - 1; ++i) {
                IExpr temp = F.evalExpandAll(F.Subtract(equal.get(i), last));
                termsEqualNumberList.append(temp);
            }
        } else if (expr.isTrue()) {
            termsEqualNumberList.append(S.True);
        } else if (expr.isFalse()) {
            termsEqualNumberList.append(S.False);
        } else {
            throw new ArgumentTypeException("Equal[] expression (a==b) expected instead of " + expr.toString());
        }
    }

    public static void printException(Appendable buf, Throwable e) {
        LOGGER.debug("Exception encountered", e);
        String msg = e.getMessage();
        try {
            if (msg != null) {
                buf.append("\n" + e.getClass().getName() + ": " + msg);
            } else {
                buf.append("\n" + e.getClass().getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int checkUpTo(IAST upToAST, EvalEngine engine) {
        int upTo = Integer.MIN_VALUE;
        upTo = upToAST.arg1().isInfinity() ? Integer.MAX_VALUE : upToAST.arg1().toIntDefault();
        if (upTo < 0) {
            IOFunctions.printMessage(S.UpTo, "innf", F.list(F.C1, upToAST), engine);
            return Integer.MIN_VALUE;
        }
        return upTo;
    }

    @Deprecated
    public static IExpr checkIdentifier(IExpr expr, IAST ast, EvalEngine engine) {
        ISymbol sym = null;
        if (expr.isString()) {
            String identifier = expr.toString();
            if (!Scanner.isIdentifier((String)identifier)) {
                return IOFunctions.printMessage(ast.topHead(), "sym", F.list(expr, F.C1), engine);
            }
            sym = F.symbol(identifier, engine);
        } else if (expr.isSymbol()) {
            sym = (ISymbol)expr;
        } else {
            return IOFunctions.printMessage(ast.topHead(), "sym", F.list(expr, F.C1), engine);
        }
        return sym;
    }

    public static IExpr checkIdentifierHoldPattern(IExpr expr, IAST ast, EvalEngine engine) {
        ISymbol sym = null;
        if (expr.isString()) {
            String identifier = expr.toString();
            if (!Scanner.isIdentifier((String)identifier)) {
                return IOFunctions.printMessage(ast.topHead(), "sym", F.list(expr, F.C1), engine);
            }
            int indx = identifier.lastIndexOf(96);
            if (indx > 0) {
                ContextPath contextPath = engine.getContextPath();
                Context context = contextPath.getContext(identifier.substring(0, indx + 1));
                sym = contextPath.symbol(identifier.substring(indx + 1), context, engine.isRelaxedSyntax());
            } else {
                sym = F.symbol(identifier, engine);
            }
        } else if (expr.isSymbol()) {
            sym = (ISymbol)expr;
        } else if (expr.isAST(S.HoldPattern, 2) && expr.first().isSymbol()) {
            sym = (ISymbol)expr.first();
        } else {
            return IOFunctions.printMessage(ast.topHead(), "ssle", F.list(expr, F.C1), engine);
        }
        return sym;
    }

    public static String checkMessageNameTag(IExpr expr, IAST ast, EvalEngine engine) {
        if (expr.isString() || expr.isSymbol()) {
            return expr.toString();
        }
        IOFunctions.printMessage(ast.topHead(), "sym", F.list(expr, F.C1), engine);
        return null;
    }
}

