/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.exception;

import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class RuleCreationError
extends ValidateException {
    private static final long serialVersionUID = 4289111239388531874L;
    private final IExpr fLHS;

    public RuleCreationError(IExpr lhs) {
        this.fLHS = lhs;
    }

    public String getMessage() {
        if (this.fLHS == null) {
            return "Operation not allowed in server mode.";
        }
        Context context = this.fLHS.topHead().getContext();
        return "Not allowed left-hand-side expression: \"" + this.fLHS + "\" from context \"" + context + "\"\nPlease use names which aren't predefined by the system.";
    }

    @Override
    public String getMessage(ISymbol symbol) {
        if (this.fLHS == null) {
            return symbol + ": Operation not allowed in server mode.";
        }
        Context context = this.fLHS.topHead().getContext();
        return symbol + ": Not allowed left-hand-side expression: \"" + this.fLHS + "\" from context \"" + context + "\"\nPlease use names which aren't predefined by the system.";
    }
}

