/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.exception;

import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;

public class IterationLimitExceeded
extends LimitException {
    private static final long serialVersionUID = -5953619629034039117L;
    private final long fLimit;
    private final IExpr fExpr;

    public IterationLimitExceeded(long limit, IExpr expr) {
        this.fLimit = limit;
        this.fExpr = expr;
    }

    public String getMessage() {
        return this.fExpr.topHead().toString() + ": " + IOFunctions.getMessage("itlim", F.list(F.ZZ(this.fLimit)), EvalEngine.get());
    }

    public static void throwIt(long iterationCounter, IExpr expr) {
        throw new IterationLimitExceeded(iterationCounter, expr);
    }
}

