/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.exception;

import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ArgumentTypeException
extends ValidateException {
    private static final long serialVersionUID = 4017342168597803850L;
    private final String fMessage;

    public ArgumentTypeException(String message) {
        this.fMessage = message;
    }

    public ArgumentTypeException(String messageShortcut, IAST listOfArgs) {
        String message;
        this.fMessage = message = IOFunctions.getMessage(messageShortcut, listOfArgs);
    }

    public String getMessage() {
        return this.fMessage;
    }

    public static void throwNIL() {
        String str = IOFunctions.getMessage("nil", F.CEmptyList, EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public static void throwArg(IExpr arg1, IExpr arg2) {
        String str = IOFunctions.getMessage("argillegal", F.list(arg1, arg2), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    @Override
    public String getMessage(ISymbol symbol) {
        return symbol + ": " + this.fMessage;
    }
}

