/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.util.Stack;
import java.util.function.Predicate;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.AbstractEvalStepListener;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public final class TraceStack
extends AbstractEvalStepListener {
    final Stack<IASTAppendable> fStack = new Stack();
    final Predicate<IExpr> fMatcher;
    final IAST fList;
    IASTAppendable fTraceList;

    public TraceStack(Predicate<IExpr> matcher) {
        this.fMatcher = matcher;
        this.fList = F.ListAlloc(7);
        this.pushList();
    }

    public void pushList() {
        this.fTraceList = this.fList.copyAppendable(7);
        this.fStack.push(this.fTraceList);
    }

    public void popList(boolean commitTraceFrame) {
        IASTAppendable traceList = this.fTraceList;
        this.fStack.pop();
        this.fTraceList = this.fStack.peek();
        if (traceList.size() > 1 && commitTraceFrame) {
            this.fTraceList.append(traceList);
        }
    }

    public IASTAppendable getList() {
        return this.fTraceList;
    }

    public void add(IExpr expr) {
        if (this.fMatcher != null) {
            if (this.fMatcher.test(expr.head())) {
                this.fTraceList.append(F.HoldForm(expr));
            }
        } else {
            this.fTraceList.append(F.HoldForm(expr));
        }
    }

    public void addIfEmpty(IExpr expr) {
        if (this.fTraceList.isAST0()) {
            this.add(expr);
        }
    }

    public void setList(IASTAppendable list) {
        this.fTraceList = list;
        this.fStack.pop();
        this.fStack.push(list);
    }

    @Override
    public void setUp(IExpr inputExpr, int recursionDepth) {
        this.pushList();
    }

    @Override
    public void tearDown(int recursionDepth, boolean commitTraceFrame) {
        this.popList(commitTraceFrame);
    }

    @Override
    public void add(IExpr inputExpr, IExpr resultExpr, int recursionDepth, long iterationCounter, IExpr hint) {
        if (iterationCounter <= 0L) {
            this.addIfEmpty(inputExpr);
            this.add(resultExpr);
        } else {
            this.add(resultExpr);
        }
    }
}

