/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IExpr;

public class TimeConstrainedEvaluator
extends EvalUtilities
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    protected IExpr fEvaluationResult;
    protected Throwable fException;
    protected IExpr fParsedExpression;
    private long fMilliSeconds;
    private final boolean fRelaxedSyntax;
    private boolean fTraceEvaluation;

    public TimeConstrainedEvaluator(EvalEngine evalEngine, boolean msie, long milliSeconds) {
        this(evalEngine, msie, milliSeconds, false);
    }

    public TimeConstrainedEvaluator(EvalEngine evalEngine, boolean msie, long milliSeconds, boolean relaxedSyntax) {
        super(evalEngine, msie, relaxedSyntax);
        this.fMilliSeconds = milliSeconds;
        this.fRelaxedSyntax = relaxedSyntax;
        this.fTraceEvaluation = false;
    }

    @Override
    public void run() {
        try {
            this.fEvaluationResult = this.fTraceEvaluation ? this.evalTrace(this.fParsedExpression, null) : this.evaluate(this.fParsedExpression);
        }
        catch (Exception e) {
            LOGGER.debug("TimeConstrainedEvaluator.run() failed", (Throwable)e);
            this.fException = e;
        }
        catch (OutOfMemoryError e) {
            LOGGER.debug("TimeConstrainedEvaluator.run()", (Throwable)e);
            this.fEvaluationResult = F.$str("OutOfMemoryError");
        }
        catch (StackOverflowError e) {
            LOGGER.debug("TimeConstrainedEvaluator.run()", (Throwable)e);
            this.fEvaluationResult = F.$str("StackOverflowError");
        }
    }

    public IExpr constrainedEval(Writer writer, String inputString, boolean traceEvaluation) throws Exception {
        this.fEvaluationResult = F.NIL;
        this.fException = null;
        this.fParsedExpression = null;
        EvalEngine.setReset(this.fEvalEngine);
        this.fEvalEngine.setStopRequested(false);
        this.fTraceEvaluation = traceEvaluation;
        this.fParsedExpression = this.fEvalEngine.parse(inputString);
        return this.constrainedEval(writer, this.fParsedExpression);
    }

    public IExpr constrainedEval(Writer writer, IExpr inputExpression) throws Exception {
        this.fEvaluationResult = F.NIL;
        this.fException = null;
        this.fParsedExpression = inputExpression;
        this.fEvalEngine.setStopRequested(false);
        Thread thread = new Thread((Runnable)this, "TimeConstrainedEvaluator");
        thread.start();
        thread.join(this.fMilliSeconds);
        if (thread.isAlive()) {
            thread.interrupt();
            this.fEvalEngine.stopRequest();
            Thread.sleep(500L);
            if (thread.isAlive()) {
                thread.stop();
                return F.NIL;
            }
        }
        if (this.fException != null) {
            writer.write((String)(this.fException.getMessage() != null ? this.fException.getMessage() : "Exception: " + this.fException.getClass().getName()));
            writer.write(10);
        }
        if (!this.fEvaluationResult.isPresent() || this.fEvaluationResult.equals(S.Null) || !OutputFormFactory.get(this.fRelaxedSyntax).convert(writer, this.fEvaluationResult)) {
            // empty if block
        }
        return this.fEvaluationResult;
    }

    public IExpr getParsedExpression() {
        return this.fParsedExpression;
    }
}

