/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.IOException;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.form.tex.TeXFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.parser.ExprParser;

public class TeXUtilities {
    private static final Logger LOGGER = LogManager.getLogger();
    protected EvalEngine fEvalEngine;
    ExprParser fParser;

    public TeXUtilities(EvalEngine evalEngine, boolean relaxedSyntax) {
        this.fEvalEngine = evalEngine;
        EvalEngine.set(evalEngine);
        this.fParser = new ExprParser(evalEngine, relaxedSyntax);
    }

    public synchronized boolean toTeX(String inputExpression, Writer out, boolean reset) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                if (reset) {
                    EvalEngine.setReset(this.fEvalEngine);
                }
                parsedExpression = this.fParser.parse(inputExpression);
                return this.toTeX(parsedExpression, out);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("TeXUtilities.toTeX() failed", (Throwable)rex);
            }
        }
        return false;
    }

    public synchronized boolean toTeX(IExpr objectExpression, Writer out) {
        StringBuilder buf = new StringBuilder();
        if (objectExpression != null) {
            int exponentFigures = this.fEvalEngine.getSignificantFigures() - 1;
            int significantFigures = this.fEvalEngine.getSignificantFigures() + 1;
            try {
                TeXFormFactory teXFactory;
                IExpr result = objectExpression;
                if (objectExpression.isAST()) {
                    result = this.fEvalEngine.evalHoldPattern((IAST)objectExpression, true, true);
                }
                if ((teXFactory = new TeXFormFactory(exponentFigures, significantFigures)).convert(buf, result, 0)) {
                    out.write(buf.toString());
                    return true;
                }
                out.write("ERROR-IN-TEXFORM");
            }
            catch (IOException result) {
            }
            catch (RuntimeException rex) {
                LOGGER.debug("TeXUtilities.toTeX() failed", (Throwable)rex);
            }
            return false;
        }
        return true;
    }

    public void stopRequest() {
        this.fEvalEngine.stopRequest();
    }
}

