/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.OutputStream;
import java.io.PrintStream;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.eval.exception.SymjaMathException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.math.MathException;

public class SymjaInterpreter
extends EvalUtilities {
    String codeString;
    PrintStream outStream;

    public SymjaInterpreter(String codeString, OutputStream out) {
        super(new EvalEngine(), false, true);
        this.codeString = codeString;
        this.outStream = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        this.fEvalEngine.setOutPrintStream(this.outStream);
    }

    public String interpreter(String function) {
        IExpr expr;
        Object evalStr = this.codeString;
        EvalEngine engine = EvalEngine.get();
        EvalEngine.setReset(engine);
        try {
            ExprParser p = new ExprParser(engine, true);
            if (function != null) {
                evalStr = function + "(" + this.codeString + ")";
            }
            expr = p.parse((String)evalStr);
        }
        catch (SyntaxError e1) {
            try {
                ExprParser p = new ExprParser(engine);
                if (function != null) {
                    evalStr = function + "[" + this.codeString + "]";
                }
                expr = p.parse((String)evalStr);
            }
            catch (Exception e2) {
                this.outStream.println(e2.getMessage());
                return "";
            }
        }
        StringBuilder buf = new StringBuilder();
        try {
            IExpr result = this.evaluate(expr);
            if (result.isPresent()) {
                if (result.equals(S.Null)) {
                    return buf.toString();
                }
                if (OutputFormFactory.get(engine.isRelaxedSyntax()).convert(buf, result)) {
                    return buf.toString();
                }
            }
            return "ERROR-IN-OUTPUTFORM";
        }
        catch (SymjaMathException sma) {
            Throwable me = sma.getCause();
            Validate.printException(buf, me);
            if (expr.equals(S.Null)) {
                return buf.toString();
            }
            if (OutputFormFactory.get(engine.isRelaxedSyntax()).convert(buf, expr)) {
                return buf.toString();
            }
        }
        catch (RuntimeException re) {
            Throwable me = re.getCause();
            if (me instanceof MathException) {
                Validate.printException(buf, me);
            } else {
                Validate.printException(buf, re);
            }
        }
        catch (Exception ex) {
            Validate.printException(buf, ex);
        }
        catch (StackOverflowError soe) {
            Validate.printException(buf, soe);
        }
        catch (OutOfMemoryError oome) {
            Validate.printException(buf, oome);
        }
        return buf.toString();
    }

    public String interpreter(IAST function) {
        IExpr expr;
        String evalStr = this.codeString;
        EvalEngine engine = EvalEngine.get();
        EvalEngine.setReset(engine);
        try {
            ExprParser p = new ExprParser(engine, true);
            expr = p.parse(evalStr);
        }
        catch (SyntaxError e1) {
            try {
                ExprParser p = new ExprParser(engine);
                expr = p.parse(evalStr);
            }
            catch (Exception e2) {
                this.outStream.println(e2.getMessage());
                return "";
            }
        }
        StringBuilder buf = new StringBuilder();
        try {
            if (function != null) {
                expr = function.replaceAll(F.Rule((IExpr)F.Slot1, expr));
            }
            if (expr.isPresent()) {
                IExpr result = this.evaluate(expr);
                if (result.isPresent()) {
                    if (result.equals(S.Null)) {
                        return buf.toString();
                    }
                    if (OutputFormFactory.get(engine.isRelaxedSyntax()).convert(buf, result)) {
                        return buf.toString();
                    }
                }
                return "ERROR-IN-OUTPUTFORM";
            }
        }
        catch (RuntimeException re) {
            Throwable me = re.getCause();
            if (me instanceof MathException) {
                Validate.printException(buf, me);
            } else {
                Validate.printException(buf, re);
            }
        }
        catch (Exception e) {
            Validate.printException(buf, e);
        }
        return buf.toString();
    }

    public void eval(String function) {
        String result = this.interpreter(function);
        this.outStream.print(result);
    }

    public void evalReplaceAll(IAST function) {
        String result = this.interpreter(function);
        this.outStream.print(result);
    }
}

