/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.SymjaMathException;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntervalSym;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.tensor.qty.IQuantity;

public final class PlusOp {
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<IExpr, IExpr> plusMap;
    private boolean evaled;
    private IExpr numberValue;
    private final int capacity;

    public PlusOp(int capacity) {
        this.capacity = capacity;
        this.plusMap = null;
        this.evaled = false;
        this.numberValue = F.NIL;
    }

    private Map<IExpr, IExpr> getMap() {
        if (this.plusMap == null) {
            this.plusMap = new HashMap<IExpr, IExpr>(this.capacity + 5 + this.capacity / 10);
        }
        return this.plusMap;
    }

    private boolean addMerge(IExpr key, IExpr value) {
        Map<IExpr, IExpr> map = this.getMap();
        IExpr temp = map.get(key);
        if (temp == null) {
            map.put(key, value);
            return false;
        }
        if (temp.isNumber() && value.isNumber()) {
            if ((temp = temp.plus(value)).isZero()) {
                map.remove(key);
                return true;
            }
        } else if (temp.head().equals(S.Plus)) {
            if (!(temp instanceof IASTAppendable)) {
                temp = ((IAST)temp).copyAppendable();
            }
            ((IASTAppendable)temp).append(value);
        } else {
            temp = F.Plus(temp, value);
        }
        map.put(key, temp);
        return true;
    }

    public IExpr getSum() {
        if (this.plusMap == null) {
            if (this.numberValue.isPresent() && !this.numberValue.isZero()) {
                return this.numberValue;
            }
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(this.plusMap.size() + 1);
        if (this.numberValue.isPresent() && !this.numberValue.isZero()) {
            if (this.numberValue.isComplexInfinity()) {
                return this.numberValue;
            }
            result.append(this.numberValue);
        }
        for (Map.Entry<IExpr, IExpr> element : this.plusMap.entrySet()) {
            IASTMutable times;
            IExpr key = element.getKey();
            IExpr value = element.getValue();
            if (value.isOne()) {
                if (key.isPlus()) {
                    result.appendArgs((IAST)key);
                    continue;
                }
                if (key.isTimes()) {
                    EvalAttributes.sortWithFlags((IASTMutable)key);
                }
                result.append(key);
                continue;
            }
            if (key.isTimes()) {
                times = F.TimesAlloc(((IAST)key).size());
                times.append(value);
                times.appendArgs((IAST)key);
                EvalAttributes.sortWithFlags(times);
                result.append(times);
                continue;
            }
            times = F.Times(value, key);
            EvalAttributes.sortWithFlags(times);
            result.append(times);
        }
        IExpr temp = result.oneIdentity0();
        if (temp.isPlus()) {
            EvalAttributes.sortWithFlags((IASTMutable)temp);
        }
        return temp;
    }

    public boolean isEvaled() {
        return this.evaled;
    }

    private IExpr negativeInfinityPlus(IExpr o1) {
        if (o1.isInfinity()) {
            LOGGER.log(EvalEngine.get().getLogLevel(), "Indeterminate expression Infinity-Infinity");
            return S.Indeterminate;
        }
        if (o1.isNegativeInfinity()) {
            return F.CNInfinity;
        }
        return F.CNInfinity;
    }

    public IExpr plus(IExpr arg) {
        if (arg.isIndeterminate()) {
            return S.Indeterminate;
        }
        try {
            if (this.numberValue.isPresent() && this.numberValue.isDirectedInfinity()) {
                if (this.numberValue.isComplexInfinity()) {
                    if (arg.isDirectedInfinity()) {
                        return S.Indeterminate;
                    }
                    this.numberValue = F.CComplexInfinity;
                    this.evaled = true;
                    return F.NIL;
                }
                if (this.numberValue.isInfinity()) {
                    if (arg.isInfinity()) {
                        this.evaled = true;
                        return F.NIL;
                    }
                    if (arg.isDirectedInfinity()) {
                        return S.Indeterminate;
                    }
                    if (arg.isRealResult()) {
                        this.evaled = true;
                        return F.NIL;
                    }
                } else if (this.numberValue.isNegativeInfinity()) {
                    if (arg.isNegativeInfinity()) {
                        this.evaled = true;
                        return F.NIL;
                    }
                    if (arg.isDirectedInfinity()) {
                        IOFunctions.printMessage(S.Infinity, "indet", F.list(F.Plus(this.numberValue, arg)), EvalEngine.get());
                        return S.Indeterminate;
                    }
                    if (arg.isRealResult()) {
                        this.evaled = true;
                        return F.NIL;
                    }
                }
            }
            if (arg.isNumber()) {
                if (arg.isZero()) {
                    this.evaled = true;
                    return F.NIL;
                }
                if (!this.numberValue.isPresent()) {
                    this.numberValue = arg;
                    return F.NIL;
                }
                if (this.numberValue.isNumber()) {
                    this.numberValue = this.numberValue.plus(arg);
                    this.evaled = true;
                    return F.NIL;
                }
                if (this.numberValue.isInfinity()) {
                    if (arg.isNegativeInfinity()) {
                        IOFunctions.printMessage(S.Infinity, "indet", F.list(F.Plus(this.numberValue, arg)), EvalEngine.get());
                        return S.Indeterminate;
                    }
                    this.numberValue = F.CInfinity;
                    this.evaled = true;
                    return F.NIL;
                }
                if (this.numberValue.isNegativeInfinity()) {
                    this.numberValue = this.negativeInfinityPlus(arg);
                    if (this.numberValue.isIndeterminate()) {
                        return S.Indeterminate;
                    }
                    this.evaled = true;
                    return F.NIL;
                }
                return F.NIL;
            }
            if (arg.isQuantity()) {
                if (!this.numberValue.isPresent()) {
                    this.numberValue = arg;
                    return F.NIL;
                }
                IQuantity q = (IQuantity)arg;
                IExpr temp = q.plus(this.numberValue, true);
                if (temp.isPresent()) {
                    this.evaled = true;
                    this.numberValue = temp;
                } else if (this.addMerge(q, F.C1)) {
                    this.evaled = true;
                }
                return F.NIL;
            }
            if (arg.isAST()) {
                IAST ast = (IAST)arg;
                int headID = ((IAST)arg).headID();
                if (headID >= 355) {
                    switch (headID) {
                        case 355: {
                            if (!arg.isDirectedInfinity()) break;
                            if (!this.numberValue.isPresent()) {
                                this.numberValue = arg;
                                if (arg.isComplexInfinity()) {
                                    if (this.plusMap != null && this.plusMap.size() > 0) {
                                        this.evaled = true;
                                    }
                                } else if (this.plusMap != null) {
                                    Iterator<Map.Entry<IExpr, IExpr>> iterator = this.plusMap.entrySet().iterator();
                                    while (iterator.hasNext()) {
                                        Map.Entry<IExpr, IExpr> entry = iterator.next();
                                        if (!entry.getKey().isRealResult()) continue;
                                        iterator.remove();
                                        this.evaled = true;
                                    }
                                }
                                return F.NIL;
                            }
                            if (arg.isInfinity()) {
                                if (this.numberValue.isNegativeInfinity()) {
                                    IOFunctions.printMessage(S.Infinity, "indet", F.list(F.Plus(arg, this.numberValue)), EvalEngine.get());
                                    return S.Indeterminate;
                                }
                                this.numberValue = F.CInfinity;
                                this.evaled = true;
                                return F.NIL;
                            }
                            if (arg.isNegativeInfinity()) {
                                this.numberValue = this.negativeInfinityPlus(this.numberValue);
                                if (this.numberValue.isIndeterminate()) {
                                    return S.Indeterminate;
                                }
                                this.evaled = true;
                                return F.NIL;
                            }
                            if (!arg.isComplexInfinity()) break;
                            if (this.numberValue.isDirectedInfinity()) {
                                IOFunctions.printMessage(S.Infinity, "indet", F.list(F.Plus(arg, this.numberValue)), EvalEngine.get());
                                return S.Indeterminate;
                            }
                            this.numberValue = F.CComplexInfinity;
                            this.evaled = true;
                            return F.NIL;
                        }
                        case 1341: {
                            if (ast.size() > 1) {
                                if (ast.arg1().isNumber()) {
                                    if (this.addMerge(ast.rest().oneIdentity1(), ast.arg1())) {
                                        this.evaled = true;
                                    }
                                    return F.NIL;
                                }
                                if (this.addMerge(ast, F.C1)) {
                                    this.evaled = true;
                                }
                            }
                            return F.NIL;
                        }
                        case 677: {
                            if (!arg.isInterval()) break;
                            if (!this.numberValue.isPresent()) {
                                this.numberValue = arg;
                                return F.NIL;
                            }
                            IExpr temp = this.numberValue.isInterval() ? IntervalSym.plus((IAST)this.numberValue, (IAST)arg) : IntervalSym.plus(this.numberValue, (IAST)arg);
                            if (temp.isPresent()) {
                                this.numberValue = temp;
                                this.evaled = true;
                            } else if (this.addMerge(arg, F.C1)) {
                                this.evaled = true;
                            }
                            return F.NIL;
                        }
                        case 1176: {
                            if (!(arg instanceof ASTSeriesData)) break;
                            if (!this.numberValue.isPresent()) {
                                this.numberValue = arg;
                                return F.NIL;
                            }
                            this.numberValue = ((ASTSeriesData)arg).plus(this.numberValue);
                            this.evaled = true;
                            return F.NIL;
                        }
                    }
                }
            }
            if (this.addMerge(arg, F.C1)) {
                this.evaled = true;
            }
        }
        catch (LimitException | ValidateException e) {
            LOGGER.debug("PlusOp.plus() failed", (Throwable)((Object)e));
            throw e;
        }
        catch (SymjaMathException sme) {
            LOGGER.debug("PlusOp.plus() failed", (Throwable)((Object)sme));
        }
        return F.NIL;
    }
}

