/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.ByteArrayOutputStream;
import org.matheclipse.core.eval.EvalDouble;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.ExprEvaluator;
import org.matheclipse.core.eval.SymjaInterpreter;
import org.matheclipse.core.eval.exception.SymjaMathException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.core.reflection.system.NIntegrate;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.eval.DoubleVariable;
import org.matheclipse.parser.client.eval.IDoubleValue;
import org.matheclipse.parser.client.math.MathException;

public class MathUtils {
    public static Double[][] rom;

    private static double romberg(int i, int j) {
        if (j == 0) {
            return rom[i][0];
        }
        if (rom[i][j] != null) {
            return rom[i][j];
        }
        double temp = (Math.pow(4.0, j) * MathUtils.romberg(i, j - 1) - MathUtils.romberg(i - 1, j - 1)) / (Math.pow(4.0, j) - 1.0);
        MathUtils.rom[i][j] = temp;
        return temp;
    }

    public static double arcLength(String f, String v, String a, String b) throws MathException {
        String var = v;
        EvalDouble parser = new EvalDouble(true);
        parser.defineVariable(var);
        ASTNode fun = parser.parse(f);
        String integrand = "sqrt(1+(" + parser.derivative(fun, var) + ")^2)";
        return MathUtils.integrate(integrand, v, a, b);
    }

    public static double integrate(String fun, String v, String aS, String bS) throws MathException {
        return MathUtils.integrate("LegendreGauss", fun, v, aS, bS);
    }

    public static double integrate(String method, String fun, String v, String aS, String bS) throws MathException {
        ExprEvaluator parser = new ExprEvaluator();
        double a = parser.evalf(aS);
        double b = parser.evalf(bS);
        IExpr function = MathUtils.parse(fun, null);
        IExpr var = MathUtils.parse(v, null);
        IAST list = F.list(var, F.num(a), F.num(b));
        return NIntegrate.integrate("LegendreGauss", list, a, b, function, 100, 10000);
    }

    public static double integrate(String fun, String v1, String v2, String[] bounds) {
        String integVarX = v1;
        String integVarY = v2;
        EvalDouble integParser = new EvalDouble(true);
        integParser.defineVariable(integVarX);
        integParser.defineVariable(integVarY);
        double x1 = integParser.evaluate(bounds[0]);
        double x2 = integParser.evaluate(bounds[1]);
        ASTNode y1 = integParser.parse(bounds[2]);
        ASTNode y2 = integParser.parse(bounds[3]);
        ASTNode integFun = integParser.parse(fun);
        int romI = 9;
        Double[][] romX = new Double[romI][romI];
        for (int i = 0; i < romI; ++i) {
            double step = (x2 - x1) / Math.pow(2.0, i);
            double aTemp = x1;
            rom = new Double[romI][romI];
            integParser.defineVariable(integVarX, aTemp);
            double a = integParser.evaluateNode(y1);
            double b = integParser.evaluateNode(y2);
            for (int j = 0; j < romI; ++j) {
                double stepY = (b - a) / Math.pow(2.0, j);
                double aTempY = a;
                integParser.defineVariable(integVarY, a);
                double valueY = integParser.evaluateNode(integFun) / 2.0;
                int k = 0;
                while ((double)k < Math.pow(2.0, j) - 1.0) {
                    integParser.defineVariable(integVarY, aTempY += stepY);
                    valueY += integParser.evaluateNode(integFun);
                    ++k;
                }
                integParser.defineVariable(integVarY, b);
                valueY += integParser.evaluateNode(integFun) / 2.0;
                MathUtils.rom[j][0] = valueY *= stepY;
            }
            double valueX = MathUtils.romberg(romI - 1, romI - 1) / 2.0;
            int l = 0;
            while ((double)l < Math.pow(2.0, i) - 1.0) {
                rom = new Double[romI][romI];
                integParser.defineVariable(integVarX, aTemp += step);
                a = integParser.evaluateNode(y1);
                b = integParser.evaluateNode(y2);
                for (int j = 0; j < romI; ++j) {
                    double stepY = (b - a) / Math.pow(2.0, j);
                    double aTempY = a;
                    integParser.defineVariable(integVarY, a);
                    double valueY = integParser.evaluateNode(integFun) / 2.0;
                    int k = 0;
                    while ((double)k < Math.pow(2.0, j) - 1.0) {
                        integParser.defineVariable(integVarY, aTempY += stepY);
                        valueY += integParser.evaluateNode(integFun);
                        ++k;
                    }
                    integParser.defineVariable(integVarY, b);
                    valueY += integParser.evaluateNode(integFun) / 2.0;
                    MathUtils.rom[j][0] = valueY *= stepY;
                }
                valueX += MathUtils.romberg(romI - 1, romI - 1);
                ++l;
            }
            integParser.defineVariable(integVarX, x2);
            a = integParser.evaluateNode(y1);
            b = integParser.evaluateNode(y2);
            rom = new Double[romI][romI];
            for (int j = 0; j < romI; ++j) {
                double stepY = (b - a) / Math.pow(2.0, j);
                double aTempY = a;
                integParser.defineVariable(integVarY, a);
                double valueY = integParser.evaluateNode(integFun) / 2.0;
                int k = 0;
                while ((double)k < Math.pow(2.0, j) - 1.0) {
                    integParser.defineVariable(integVarY, aTempY += stepY);
                    valueY += integParser.evaluateNode(integFun);
                    ++k;
                }
                integParser.defineVariable(integVarY, b);
                valueY += integParser.evaluateNode(integFun) / 2.0;
                MathUtils.rom[j][0] = valueY *= stepY;
            }
            valueX += MathUtils.romberg(romI - 1, romI - 1) / 2.0;
            romX[i][0] = valueX *= step;
        }
        rom = romX;
        return MathUtils.romberg(romI - 1, romI - 1);
    }

    public static double getFunctionVal(String f, double s) {
        EvalDouble dEval = new EvalDouble(true);
        return dEval.evaluate(f);
    }

    public static double getFunctionVal(String f, String v, String x) {
        EvalDouble parser = new EvalDouble(true);
        String var = v;
        parser.defineVariable(var);
        ASTNode fun = parser.parse(f);
        ASTNode val = parser.parse(x);
        parser.defineVariable(var, parser.evaluateNode(val));
        return parser.evaluateNode(fun);
    }

    public static String getFunctionVal(String fun, String[] var, String resp, String[] vals) throws MathException {
        EvalDouble parParser = new EvalDouble(true);
        double[] values = new double[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            values[i] = parParser.evaluate(vals[i]);
        }
        String respVar = null;
        for (int i = 0; i < var.length; ++i) {
            if (var[i].equals(resp)) {
                respVar = resp;
                parParser.defineVariable(respVar, values[i]);
                continue;
            }
            String temp = var[i];
            parParser.defineVariable(temp, values[i]);
        }
        if (respVar != null) {
            ASTNode f = parParser.parse(fun);
            return "" + parParser.evaluateNode(f);
        }
        throw new SymjaMathException("MathUtils:getFunctionVal - cannot compute function values");
    }

    public static boolean isValid(String fun, String[] var) {
        EvalDouble dEval = new EvalDouble(true);
        for (String v : var) {
            dEval.defineVariable(v, (IDoubleValue)new DoubleVariable(0.0));
        }
        try {
            dEval.parse(fun);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean[] isValid(String[] fun, String[] var) {
        EvalDouble dEval = new EvalDouble(true);
        for (String v : var) {
            dEval.defineVariable(v, (IDoubleValue)new DoubleVariable(0.0));
        }
        boolean[] b = new boolean[fun.length];
        for (int i = 0; i < fun.length; ++i) {
            try {
                dEval.parse(fun[i]);
                b[i] = true;
                continue;
            }
            catch (Exception e) {
                b[i] = false;
            }
        }
        return b;
    }

    public static String getDerivative(String fun, String[] var, String resp) {
        IExpr sym = MathUtils.parse(resp, null);
        if (sym instanceof ISymbol) {
            return MathUtils.evaluateReaplaceAll(fun, F.D(F.Slot1, sym));
        }
        return "error in MathUtils#getDerivative()";
    }

    public static String getPowerSeries(String fun, String v, String cen, int iter) throws MathException {
        IExpr center;
        IExpr sym = MathUtils.parse(v, null);
        if (sym instanceof ISymbol && (center = MathUtils.parse(cen, null)) != null) {
            return MathUtils.evaluateReaplaceAll(fun, F.Taylor(F.Slot1, F.list(sym, center, F.ZZ(iter))));
        }
        return "error in MathUtils#getPowerSeries()";
    }

    public static String tangentLine(String f, String x, String v) throws MathException {
        String var = v;
        EvalDouble parser = new EvalDouble(true);
        parser.defineVariable(var);
        ASTNode fun = parser.parse(f);
        parser.defineVariable(var, parser.evaluateNode(parser.parse(x)));
        double m = parser.evaluateNode(parser.derivative(fun, var));
        Object out = m == 1.0 ? var : (m == -1.0 ? "-" + var : (m == 0.0 ? "" : m + "*" + var));
        double b = parser.evaluateNode(fun) - m * parser.evaluate(var);
        if (b > 0.0) {
            out = !((String)out).equals("") ? (String)out + "+" + b : (String)out + b;
        } else if (b < 0.0) {
            out = (String)out + "-" + (b *= -1.0);
        }
        if (((String)out).equals("")) {
            out = "0";
        }
        return out;
    }

    public static double surfaceArea(String fun, String v1, String v2, String[] bounds) throws MathException {
        String integVarX = v1;
        String integVarY = v2;
        EvalDouble integParser = new EvalDouble(true);
        integParser.defineVariable(integVarX);
        integParser.defineVariable(integVarY);
        String funX = integParser.derivative(integParser.parse((String)fun), integVarX).toString();
        String funY = integParser.derivative(integParser.parse((String)fun), integVarY).toString();
        fun = "sqrt(1+(" + funX + ")^2+(" + funY + ")^2)";
        return MathUtils.integrate((String)fun, v1, v2, bounds);
    }

    public static String evaluate(String codeString, String function) {
        Object result = null;
        try (ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();){
            SymjaInterpreter _commandInterpreter = new SymjaInterpreter(codeString, _outputStream);
            try {
                _commandInterpreter.eval(function);
                result = _outputStream.toString("UTF-8");
            }
            catch (Throwable t) {
                result = "UNSUPPORTED OPERATION!\n[\n" + codeString + "\n]\n" + t.toString();
            }
        }
        catch (Throwable t) {
            result = "UNSUPPORTED OPERATION!\n[\n" + codeString + "\n]\n" + t.toString();
        }
        return result;
    }

    public static String evaluateReaplaceAll(String codeString, IAST function) {
        Object result = null;
        try (ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();){
            SymjaInterpreter _commandInterpreter = new SymjaInterpreter(codeString, _outputStream);
            try {
                _commandInterpreter.evalReplaceAll(function);
                result = _outputStream.toString("UTF-8");
            }
            catch (Throwable t) {
                result = "UNSUPPORTED OPERATION!\n[\n" + codeString + "\n]\n" + t.toString();
            }
        }
        catch (Throwable t) {
            result = "UNSUPPORTED OPERATION!\n[\n" + codeString + "\n]\n" + t.toString();
        }
        return result;
    }

    public static IExpr parse(String evalStr, IAST function) {
        try {
            ExprParser p = new ExprParser(EvalEngine.get(), true);
            return p.parse(evalStr);
        }
        catch (MathException e1) {
            try {
                ExprParser p = new ExprParser(EvalEngine.get(), false);
                return p.parse(evalStr);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }
}

