/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.IOException;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.mathml.MathMLFormFactory;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.parser.ExprParser;

public class MathMLUtilities {
    private static final Logger LOGGER = LogManager.getLogger();
    protected EvalEngine fEvalEngine;
    boolean fMSIE;
    boolean fMathMLHeader;
    private static final IExpr.SourceCodeProperties JAVA_FORM_PROPERTIES;

    public MathMLUtilities(EvalEngine evalEngine, boolean mathMLTagPrefix, boolean mathMLHeader) {
        this.fEvalEngine = evalEngine;
        EvalEngine.setReset(this.fEvalEngine);
        this.fMSIE = mathMLTagPrefix;
        this.fMathMLHeader = mathMLHeader;
    }

    public EvalEngine getEvalEngine() {
        return this.fEvalEngine;
    }

    public synchronized boolean toMathML(String inputExpression, Writer out) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                ExprParser parser = new ExprParser(this.fEvalEngine);
                parsedExpression = parser.parse(inputExpression);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("MathMLUtilities.toMathML() failed", (Throwable)rex);
            }
        }
        return this.toMathML(parsedExpression, out);
    }

    public synchronized boolean toMathML(IExpr objectExpression, Writer out) {
        return this.toMathML(objectExpression, out, false);
    }

    public synchronized boolean toMathML(IExpr objectExpression, Writer out, boolean useXmlns) {
        StringBuilder buf = new StringBuilder();
        if (objectExpression != null) {
            try {
                MathMLFormFactory mathMLFactory = new MathMLFormFactory(this.fMSIE ? "m:" : "", this.fEvalEngine.isRelaxedSyntax(), null, this.fEvalEngine.getSignificantFigures() - 1, this.fEvalEngine.getSignificantFigures() + 1);
                if (mathMLFactory.convert(buf, objectExpression, Integer.MIN_VALUE, false)) {
                    if (this.fMSIE) {
                        out.write("<m:math>");
                        out.write(buf.toString());
                        out.write("</m:math>");
                    } else {
                        if (this.fMathMLHeader) {
                            out.write("<?xml version=\"1.0\"?>\n<!DOCTYPE math PUBLIC \"-//W3C//DTD MathML 2.0//EN\" \"http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\">\n<math mode=\"display\">\n");
                        } else if (useXmlns) {
                            out.write("<math xmlns=\"http://www.w3.org/1999/xhtml\">");
                        } else {
                            out.write("<math>");
                        }
                        out.write(buf.toString());
                        out.write("</math>");
                    }
                    return true;
                }
            }
            catch (IOException mathMLFactory) {
            }
            catch (RuntimeException rex) {
                LOGGER.debug("MathMLUtilities.toMathML() failed", (Throwable)rex);
            }
            return false;
        }
        return true;
    }

    private synchronized void toJava(String inputExpression, Writer out, boolean strictJava) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                ExprParser parser = new ExprParser(this.fEvalEngine);
                parsedExpression = parser.parse(inputExpression);
                out.write(parsedExpression.internalJavaString(JAVA_FORM_PROPERTIES, -1, x -> null).toString());
            }
            catch (IOException parser) {
            }
            catch (RuntimeException rex) {
                LOGGER.debug("MathMLUtilities.toJava() failed", (Throwable)rex);
            }
        }
    }

    public void stopRequest() {
        this.fEvalEngine.stopRequest();
    }

    static {
        F.initSymbols();
        JAVA_FORM_PROPERTIES = IExpr.SourceCodeProperties.of(false, false, IExpr.SourceCodeProperties.Prefix.CLASS_NAME, false);
    }
}

