/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Serializable;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;

public class LastCalculationsHistory
implements Serializable {
    private static final long serialVersionUID = -5542189869048554333L;
    private final IExpr[] fOutHistory;
    private final int fMaximumCapacity;
    private int fIndex;
    private int fAllEntriesCounter;

    public LastCalculationsHistory(int n) {
        this.fMaximumCapacity = n;
        this.fOutHistory = new IExpr[this.fMaximumCapacity];
        this.fIndex = 0;
        this.fAllEntriesCounter = 0;
    }

    public void add(IExpr entry) {
        this.fOutHistory[this.fIndex++] = entry;
        ++this.fAllEntriesCounter;
        if (this.fIndex == this.fMaximumCapacity) {
            this.fIndex = 0;
        }
    }

    public IExpr entry(int index) {
        if (index > this.fAllEntriesCounter || index == 0) {
            return F.NIL;
        }
        if (index > 0) {
            index -= this.fAllEntriesCounter + 1;
        }
        if (index <= 0) {
            if (index == Integer.MIN_VALUE) {
                return F.NIL;
            }
            if (this.fMaximumCapacity < (index *= -1)) {
                return F.NIL;
            }
            IExpr temp = index > this.fIndex ? this.fOutHistory[this.fMaximumCapacity + this.fIndex - index] : this.fOutHistory[this.fIndex - index];
            if (temp == null) {
                return F.NIL;
            }
            return temp;
        }
        return F.NIL;
    }

    public int getCounter() {
        return this.fAllEntriesCounter;
    }

    public int size() {
        return this.fOutHistory.length;
    }
}

