/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalControlledCallable;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.BreakException;
import org.matheclipse.core.eval.exception.ContinueException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.SymjaMathException;
import org.matheclipse.core.eval.exception.ThrowException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.parser.client.SyntaxError;

public class ExprEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<ISymbol, IExpr> fVariableMap = new IdentityHashMap<ISymbol, IExpr>();
    private final List<ISymbol> fVariables = new ArrayList<ISymbol>();
    private EvalEngine fEngine;
    private IExpr fExpr;

    public ExprEvaluator() {
        this(true, 0);
    }

    public ExprEvaluator(boolean outListDisabled, short historyCapacity) {
        this(new EvalEngine(true), outListDisabled, historyCapacity);
    }

    public ExprEvaluator(EvalEngine engine, boolean outListDisabled, short historyCapacity) {
        this.fEngine = engine;
        EvalEngine.set(engine);
        if (!outListDisabled) {
            engine.setOutListDisabled(outListDisabled, historyCapacity);
        }
    }

    public void clearVariables() {
        this.fVariableMap.clear();
        for (int i = 0; i < this.fVariables.size(); ++i) {
            this.fVariables.get(i).assignValue(null, false);
        }
    }

    public ISymbol defineVariable(ISymbol variable) {
        return this.defineVariable(variable, null);
    }

    public ISymbol defineVariable(ISymbol variable, double value) {
        return this.defineVariable(variable, (IExpr)F.num(value));
    }

    public ISymbol defineVariable(ISymbol variable, IExpr value) {
        if (value != null) {
            IExpr temp = this.fEngine.evaluate(value);
            variable.assignValue(temp, false);
        }
        this.fVariables.add(variable);
        this.fVariableMap.put(variable, value);
        return variable;
    }

    public ISymbol defineVariable(String variableName) {
        return this.defineVariable(F.symbol(variableName, this.fEngine), null);
    }

    public void defineVariable(String variableName, boolean value) {
        this.defineVariable(F.symbol(variableName, this.fEngine), (IExpr)(value ? S.True : S.False));
    }

    public ISymbol defineVariable(String variableName, double value) {
        return this.defineVariable(F.symbol(variableName, this.fEngine), (IExpr)F.num(value));
    }

    public ISymbol defineVariable(String variableName, IExpr value) {
        return this.defineVariable(F.symbol(variableName, this.fEngine), value);
    }

    @Deprecated
    public final IExpr evaluate() {
        return this.eval();
    }

    @Deprecated
    public final IExpr evaluate(IExpr expr) {
        return this.eval(expr);
    }

    @Deprecated
    public final IExpr evaluate(String inputExpression) {
        return this.eval(inputExpression);
    }

    public IExpr eval() {
        if (this.fExpr == null) {
            throw new SyntaxError(0, 0, 0, " ", "No parser input defined", 1);
        }
        return this.eval(this.fExpr);
    }

    public IExpr eval(IExpr expr) {
        this.fExpr = expr;
        EvalEngine[] engineRef = new EvalEngine[]{this.fEngine};
        IExpr result = ExprEvaluator.evalTopLevel(expr, engineRef);
        this.fEngine = engineRef[0];
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IExpr evalTopLevel(IExpr expr, EvalEngine[] engineRef) {
        try {
            IExpr iExpr = ExprEvaluator.evalTryCatch(expr, engineRef);
            return iExpr;
        }
        catch (SymjaMathException sma) {
            LOGGER.debug("ExprEvaluator.evalTopLevel() failed", (Throwable)((Object)sma));
            IExpr iExpr = expr;
            return iExpr;
        }
        finally {
            engineRef[0] = EvalEngine.get();
        }
    }

    public static IExpr evalTryCatch(IExpr expr, EvalEngine[] engineRef) {
        IExpr temp;
        EvalEngine engine = engineRef[0];
        EvalEngine.set(engine);
        IExpr preRead = S.$PreRead.assignedValue();
        try {
            temp = preRead != null && preRead.isPresent() ? engine.evaluate(F.unaryAST1(preRead, expr)) : engine.evaluate(expr);
        }
        catch (ReturnException rex) {
            LOGGER.debug("ExprEvaluator.evalTryCatch() failed", (Throwable)((Object)rex));
            return rex.getValue();
        }
        catch (BreakException | ContinueException conex) {
            LOGGER.debug("ExprEvaluator.evalTryCatch() failed", (Throwable)((Object)conex));
            IAST ast = F.Continue();
            if (conex instanceof BreakException) {
                ast = F.Break();
            }
            IOFunctions.printMessage(S.Continue, "nofwd", F.list(ast), engine);
            temp = F.Hold(ast);
        }
        catch (ThrowException e) {
            LOGGER.debug("ExprEvaluator.evalTryCatch() failed", (Throwable)((Object)e));
            IAST ast = F.Throw(e.getValue());
            IOFunctions.printMessage(S.Throw, "nocatch", F.list(ast), engine);
            temp = F.Hold(ast);
        }
        catch (IterationLimitExceeded e) {
            LOGGER.debug("ExprEvaluator.evalTryCatch() failed", (Throwable)((Object)e));
            int iterationLimit = engine.getIterationLimit();
            IOFunctions.printMessage(S.$IterationLimit, "itlim", F.list(iterationLimit < 0 ? F.CInfinity : F.ZZ(iterationLimit), expr), engine);
            temp = F.Hold(expr);
        }
        catch (RecursionLimitExceeded e) {
            LOGGER.debug("ExprEvaluator.evalTryCatch() failed", (Throwable)((Object)e));
            int recursionLimit = engine.getRecursionLimit();
            IOFunctions.printMessage(S.$RecursionLimit, "reclim2", F.list(recursionLimit < 0 ? F.CInfinity : F.ZZ(recursionLimit), expr), engine);
            temp = F.Hold(expr);
        }
        if (!engine.isOutListDisabled()) {
            engine.addInOut(expr, temp);
        }
        return temp;
    }

    public boolean isTrue(IExpr expr) {
        return this.eval(expr).isTrue();
    }

    public boolean isFalse(IExpr expr) {
        return this.eval(expr).isFalse();
    }

    public IExpr eval(String inputExpression) {
        if (inputExpression != null) {
            EvalEngine.setReset(this.fEngine);
            this.fExpr = this.fEngine.parse(inputExpression);
            if (this.fExpr != null) {
                return this.eval(this.fExpr);
            }
        }
        return null;
    }

    public IExpr parse(String inputExpression) {
        if (inputExpression != null) {
            EvalEngine.setReset(this.fEngine);
            return this.fEngine.parse(inputExpression);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public IExpr evaluateWithTimeout(String inputExpression, long timeoutDuration, TimeUnit timeUnit, boolean interruptible, EvalControlledCallable call) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public double evaluateDouble(String inputExpression) {
        return this.evalf(inputExpression);
    }

    public double evalf(String inputExpression) {
        if (inputExpression != null) {
            IExpr temp;
            EvalEngine.setReset(this.fEngine);
            this.fExpr = this.fEngine.parse(inputExpression);
            if (this.fExpr != null && (temp = this.eval(F.N(this.fExpr))).isReal()) {
                return ((ISignedNumber)temp).doubleValue();
            }
        }
        return Double.NaN;
    }

    public IExpr evalFunction(IExpr head, String ... args) {
        try {
            if (args != null) {
                IExpr[] exprArgs = new IExpr[args.length];
                for (int i = 0; i < args.length; ++i) {
                    exprArgs[i] = this.eval(args[i]);
                }
                IASTAppendable function = F.ast(exprArgs, head);
                return this.eval(function);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return F.NIL;
    }

    public double evalf(IExpr expr) {
        EvalEngine.setReset(this.fEngine);
        IExpr temp = this.eval(F.N(expr));
        if (temp.isReal()) {
            return ((ISignedNumber)temp).doubleValue();
        }
        return Double.NaN;
    }

    public Complex evalComplex(IExpr expr) {
        EvalEngine.setReset(this.fEngine);
        IExpr temp = this.eval(F.N(expr));
        if (temp.isNumber()) {
            return temp.evalComplex();
        }
        return Complex.NaN;
    }

    public Complex evalComplex(String inputExpression) {
        if (inputExpression != null) {
            IExpr temp;
            EvalEngine.setReset(this.fEngine);
            this.fExpr = this.fEngine.parse(inputExpression);
            if (this.fExpr != null && (temp = this.eval(F.N(this.fExpr))).isNumber()) {
                return temp.evalComplex();
            }
        }
        return Complex.NaN;
    }

    public EvalEngine getEvalEngine() {
        return this.fEngine;
    }

    public IExpr getVariable(String variableName) {
        return this.fVariableMap.get(F.symbol(variableName, this.fEngine));
    }

    public String toJavaForm(String inputExpression) throws SymjaMathException {
        if (inputExpression != null) {
            ExprParser parser = new ExprParser(this.fEngine);
            IExpr parsedExpression = parser.parse(inputExpression);
            return parsedExpression.internalFormString(false, 0).toString();
        }
        return "";
    }

    public String toScalaForm(String inputExpression) throws SymjaMathException {
        if (inputExpression != null) {
            ExprParser parser = new ExprParser(this.fEngine);
            IExpr parsedExpression = parser.parse(inputExpression);
            return parsedExpression.internalScalaString(false, 0).toString();
        }
        return "";
    }

    static {
        F.initSymbols();
    }
}

