/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Writer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.ExprEvaluator;
import org.matheclipse.core.eval.MathMLUtilities;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.parser.client.SyntaxError;

public class EvalUtilities
extends MathMLUtilities {
    private static final Logger LOGGER = LogManager.getLogger();

    public EvalUtilities() {
        this(new EvalEngine(), false, false);
    }

    public EvalUtilities(boolean mathMLTagPrefix, boolean relaxedSyntax) {
        this(new EvalEngine(relaxedSyntax), mathMLTagPrefix, relaxedSyntax);
    }

    public EvalUtilities(EvalEngine evalEngine, boolean mathMLTagPrefix, boolean relaxedSyntax) {
        super(evalEngine, mathMLTagPrefix, relaxedSyntax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr evaluate(String inputExpression) {
        EvalEngine.setReset(this.fEvalEngine);
        if (inputExpression != null) {
            try {
                IExpr parsedExpression = this.fEvalEngine.parse(inputExpression);
                if (parsedExpression != null) {
                    EvalEngine[] engineRef = new EvalEngine[]{this.fEvalEngine};
                    IExpr result = ExprEvaluator.evalTryCatch(parsedExpression, engineRef);
                    this.fEvalEngine = engineRef[0];
                    IExpr iExpr = result;
                    return iExpr;
                }
            }
            finally {
                this.fEvalEngine = EvalEngine.get();
            }
        }
        return F.NIL;
    }

    public static IExpr eval(String inputExpression, EvalEngine evalEngine) {
        if (inputExpression != null) {
            IExpr parsedExpression;
            EvalEngine.set(evalEngine);
            boolean SIMPLE_SYNTAX = true;
            try {
                ExprParser parser = new ExprParser(evalEngine, SIMPLE_SYNTAX);
                parsedExpression = parser.parse(inputExpression);
            }
            catch (SyntaxError se1) {
                try {
                    SIMPLE_SYNTAX = false;
                    ExprParser parser = new ExprParser(evalEngine, SIMPLE_SYNTAX);
                    parsedExpression = parser.parse(inputExpression);
                }
                catch (SyntaxError se2) {
                    throw se1;
                }
            }
            if (parsedExpression != null) {
                EvalEngine.setReset(evalEngine);
                IExpr temp = evalEngine.evaluate(parsedExpression);
                evalEngine.addInOut(parsedExpression, temp);
                return temp;
            }
        }
        return F.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr evaluate(IExpr parsedExpression) {
        if (parsedExpression != null) {
            try {
                IExpr temp = this.fEvalEngine.evaluate(parsedExpression);
                this.fEvalEngine.addInOut(parsedExpression, temp);
                IExpr iExpr = temp;
                return iExpr;
            }
            finally {
                this.fEvalEngine = EvalEngine.get();
            }
        }
        return F.NIL;
    }

    public String toJavaForm(String inputExpression) {
        if (inputExpression != null) {
            EvalEngine.setReset(this.fEvalEngine);
            ExprParser parser = new ExprParser(this.fEvalEngine);
            IExpr parsedExpression = parser.parse(inputExpression);
            return parsedExpression.internalFormString(false, 0).toString();
        }
        return "";
    }

    public IAST evalTrace(String inputExpression, Predicate<IExpr> matcher) {
        if (inputExpression != null) {
            EvalEngine.setReset(this.fEvalEngine);
            IExpr parsedExpression = this.fEvalEngine.parse(inputExpression);
            if (parsedExpression != null) {
                IAST temp = this.fEvalEngine.evalTrace(parsedExpression, matcher);
                this.fEvalEngine.addInOut(parsedExpression, temp);
                return temp;
            }
        }
        return F.NIL;
    }

    public IAST evalTrace(IExpr parsedExpression, Predicate<IExpr> matcher) throws RuntimeException {
        if (parsedExpression != null) {
            IAST temp = this.fEvalEngine.evalTrace(parsedExpression, matcher);
            return temp;
        }
        return F.NIL;
    }

    @Override
    public synchronized boolean toMathML(String inputExpression, Writer out) {
        try {
            IExpr result = this.evaluate(inputExpression);
            if (result.isPresent()) {
                return this.toMathML(result, out);
            }
        }
        catch (RuntimeException rex) {
            LOGGER.debug("EvalUtilities.toMathML() failed", (Throwable)rex);
        }
        return false;
    }
}

