/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.Serializable;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;

public class EvalHistory
implements Serializable {
    private static final long serialVersionUID = -5542189869048554333L;
    Int2ObjectAVLTreeMap<IExpr> fInHistory;
    Int2ObjectAVLTreeMap<IExpr> fOutHistory;
    private short fHistoryLength;
    private int fIndex;
    int[] historyIndices;
    private int fLine;

    public EvalHistory(short historyLength) {
        this.fHistoryLength = historyLength;
        this.historyIndices = new int[this.fHistoryLength + 1];
        this.fInHistory = new Int2ObjectAVLTreeMap();
        this.fOutHistory = new Int2ObjectAVLTreeMap();
        this.fIndex = 0;
        this.fLine = 0;
    }

    private void reset(short historyLength) {
        this.fHistoryLength = historyLength;
        this.historyIndices = new int[this.fHistoryLength + 1];
        this.fInHistory = new Int2ObjectAVLTreeMap();
        this.fOutHistory = new Int2ObjectAVLTreeMap();
        this.fIndex = 0;
        this.fLine = 0;
    }

    public void addInOut(IExpr inExpr, IExpr outExpr) {
        int deleteLine;
        int deletePosition = this.fIndex - this.fHistoryLength + 1;
        if (deletePosition < 0) {
            deletePosition = this.fHistoryLength + 1 + deletePosition;
        }
        if ((deleteLine = this.historyIndices[deletePosition]) != Integer.MIN_VALUE) {
            this.fInHistory.remove(deleteLine);
            this.fOutHistory.remove(deleteLine);
            this.historyIndices[deletePosition] = Integer.MIN_VALUE;
        }
        ++this.fLine;
        this.fInHistory.put(this.fLine, (Object)inExpr);
        this.fOutHistory.put(this.fLine, (Object)outExpr);
        ++this.fIndex;
        if (this.fIndex >= this.historyIndices.length) {
            this.fIndex = 1;
        }
        this.historyIndices[this.fIndex] = this.fLine;
    }

    public IAST definitionIn() {
        ObjectSortedSet set = this.fInHistory.int2ObjectEntrySet();
        return this.defintion((ObjectSortedSet<Int2ObjectMap.Entry<IExpr>>)set, S.In, true);
    }

    public IAST definitionOut() {
        ObjectSortedSet set = this.fOutHistory.int2ObjectEntrySet();
        return this.defintion((ObjectSortedSet<Int2ObjectMap.Entry<IExpr>>)set, S.Out, false);
    }

    private IAST defintion(ObjectSortedSet<Int2ObjectMap.Entry<IExpr>> set, IBuiltInSymbol symbol, boolean setDelayed) {
        IASTAppendable result = F.ListAlloc(set.size());
        for (Int2ObjectMap.Entry entry : set) {
            IASTMutable line = F.unaryAST1(symbol, F.ZZ(entry.getIntKey()));
            if (setDelayed) {
                result.append(F.SetDelayed(line, (IExpr)entry.getValue()));
                continue;
            }
            result.append(F.Set(line, (IExpr)entry.getValue()));
        }
        return result;
    }

    public short getHistoryLength() {
        return this.fHistoryLength;
    }

    public IExpr getIn(int index) {
        int line = this.historyIndices[this.fIndex];
        line = index < 0 ? line + index + 1 : index;
        IExpr value = (IExpr)this.fInHistory.get(line);
        return value == null ? F.NIL : value;
    }

    public int getLineCounter() {
        return this.fLine + 1;
    }

    public IExpr getOut(int index) {
        if (index > this.fLine || index == 0) {
            return F.NIL;
        }
        IExpr value = index < 0 ? (IExpr)this.fOutHistory.get(this.fLine + index + 1) : (IExpr)this.fOutHistory.get(index);
        return value == null ? F.NIL : value;
    }

    public void resetLineCounter(int line) {
        this.fLine = line - 1;
    }

    public void setHistoryLength(short historyLength) {
        this.reset(historyLength);
    }

    public int size() {
        return this.fOutHistory.size();
    }
}

