/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Arithmetic;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.PatternMatching;
import org.matheclipse.core.builtin.Programming;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalHistory;
import org.matheclipse.core.eval.TraceStack;
import org.matheclipse.core.eval.exception.AbortException;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.FlowControlException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.SymjaMathException;
import org.matheclipse.core.eval.exception.TimeoutException;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionOptionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.ContextPath;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.OptionsPattern;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.integrate.rubi.UtilityFunctionCtors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvalStepListener;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.core.parser.ExprParserFactory;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.visit.ModuleReplaceAll;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.math.MathException;

public class EvalEngine
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IStringX EVALUATION_LOOP = StringX.valueOf("EvalLoop");
    private final transient Cache<IAST, IExpr> globalASTCache = CacheBuilder.newBuilder().maximumSize(500L).build();
    private static final long serialVersionUID = 8402201556123198590L;
    public transient Cache<IAST, IExpr> rubiASTCache = null;
    public transient Map<Object, IExpr> rememberMap = null;
    public static final boolean DEBUG = false;
    private static AtomicLong MODULE_COUNTER = new AtomicLong();
    private static final transient ThreadLocal<EvalEngine> INSTANCE = ThreadLocal.withInitial(() -> new EvalEngine("ThreadLocal", 512, System.out, true));
    volatile transient boolean fStopRequested;
    transient int fRecursionCounter;
    transient long fTimeConstrainedMillis = -1L;
    transient long fSeconds;
    transient boolean fNumericMode;
    transient boolean fTogetherMode;
    transient boolean fEvalLHSMode;
    transient boolean fEvalRHSMode;
    transient boolean fFileSystemEnabled;
    transient String fSessionID;
    private transient String fMessageShortcut;
    private transient IdentityHashMap<IBuiltInSymbol, Integer> experimatalSymbols = new IdentityHashMap();
    transient boolean fTraceMode;
    transient IAssumptions fAssumptions = null;
    transient IEvalStepListener fTraceStack = null;
    transient PrintStream fOutPrintStream = null;
    transient PrintStream fErrorPrintStream = null;
    transient ArrayDeque<ContextPath> fContextPathStack;
    transient ContextPath fContextPath;
    transient String f$Input = null;
    transient String f$InputFileName = null;
    protected transient FixedPrecisionApfloatHelper fApfloatHelper;
    protected int fSignificantFigures;
    protected int fRecursionLimit;
    protected int fIterationLimit;
    protected boolean fPackageMode = Config.PACKAGE_MODE;
    private boolean fRelaxedSyntax;
    private transient List<IExpr> fReapList = null;
    public transient Set<ISymbol> fModifiedVariablesList;
    private transient boolean fOnOffMode = false;
    private transient boolean fOnOffUnique = false;
    transient Map<IExpr, IExpr> fOnOffUniqueMap = null;
    transient Map<ISymbol, ISymbol> fOnOffMap = null;
    transient Deque<IExpr> fStack;
    private transient EvalHistory fEvalHistory = null;
    private transient OptionsStack fOptionsStack;
    private transient IExpr fAnswer = null;
    private transient EvalEngine fCopiedEngine = null;
    private transient boolean fOutListDisabled = true;
    transient boolean fQuietMode = false;

    public static EvalEngine get() {
        return INSTANCE.get();
    }

    public static boolean isApfloat(long precision) {
        return precision > 16L;
    }

    public static void remove() {
        INSTANCE.remove();
    }

    public static void set(EvalEngine engine) {
        INSTANCE.set(engine);
    }

    public static void setReset(EvalEngine engine) {
        INSTANCE.set(engine);
        engine.reset();
    }

    public EvalEngine() {
        this("", 512, System.out, false);
    }

    public EvalEngine(boolean relaxedSyntax) {
        this("", 512, System.out, relaxedSyntax);
    }

    public EvalEngine(String sessionID, int recursionLimit, int iterationLimit, PrintStream outStream, PrintStream errorStream, boolean relaxedSyntax) {
        this.fSessionID = sessionID;
        this.fRecursionLimit = recursionLimit;
        this.fIterationLimit = iterationLimit;
        this.fOutPrintStream = outStream;
        this.fErrorPrintStream = errorStream == null ? outStream : errorStream;
        this.fRelaxedSyntax = relaxedSyntax;
        this.fOutListDisabled = true;
        this.init();
    }

    public EvalEngine(String sessionID, int recursionLimit, PrintStream out, boolean relaxedSyntax) {
        this(sessionID, recursionLimit, 1000, out, null, relaxedSyntax);
    }

    public EvalEngine(String sessionID, PrintStream out) {
        this(sessionID, 512, 1000, out, null, false);
    }

    public boolean addModifiedVariable(ISymbol arg0) {
        if (this.fModifiedVariablesList != null) {
            return this.fModifiedVariablesList.add(arg0);
        }
        return false;
    }

    public void addInOut(IExpr inExpr, IExpr outExpr) {
        this.fAnswer = outExpr != null && outExpr.isPresent() ? outExpr : S.Null;
        ISymbol ans = F.symbol("$ans", "Global`", null, this);
        ans.putDownRule(1, true, ans, this.fAnswer, false);
        if (this.fOutListDisabled) {
            return;
        }
        this.fEvalHistory.addInOut(inExpr, this.fAnswer);
    }

    public void addOptionsPattern(OptionsPattern op, IAST rule) {
        IExpr defaultOptions;
        IdentityHashMap optionsPattern = (IdentityHashMap)this.fOptionsStack.peek();
        IASTAppendable list = (IASTAppendable)optionsPattern.get(op.getOptionsPatternHead());
        if (list == null) {
            list = F.ListAlloc(10);
            optionsPattern.put(op.getOptionsPatternHead(), list);
        }
        if (rule != null && rule.isRuleAST()) {
            if (rule.first().isSymbol()) {
                list.append(F.binaryAST2((IExpr)rule.topHead(), ((ISymbol)rule.first()).getSymbolName(), rule.second()));
            } else {
                list.append(rule);
            }
        }
        if ((defaultOptions = op.getDefaultOptions()).isPresent()) {
            IAST optionsList = null;
            if (defaultOptions.isSymbol()) {
                optionsList = PatternMatching.optionsList((ISymbol)defaultOptions, true);
                PatternMatching.extractRules(optionsList, list);
            } else if (defaultOptions.isList()) {
                PatternMatching.extractRules(defaultOptions, list);
            } else if (defaultOptions.isRuleAST()) {
                PatternMatching.extractRules(defaultOptions, list);
            }
        }
    }

    public IExpr addEvaluatedTraceStep(IExpr inputExpr, IExpr rewrittenExpr, IExpr ... list) {
        if (this.fTraceStack != null) {
            IASTAppendable listOfHints = F.ast((IExpr)S.List, list.length + 1);
            listOfHints.appendAll(list, 0, list.length);
            this.fTraceStack.add(inputExpr, rewrittenExpr, this.getRecursionCounter(), -1L, listOfHints);
            IExpr evaluatedResult = this.evaluate(rewrittenExpr);
            listOfHints.append(evaluatedResult);
            return evaluatedResult;
        }
        return this.evaluate(rewrittenExpr);
    }

    public void addTraceStep(IExpr inputExpr, IExpr rewrittenExpr, IAST listOfHints) {
        if (this.fTraceStack != null) {
            this.fTraceStack.add(inputExpr, rewrittenExpr, this.getRecursionCounter(), -1L, listOfHints);
        }
    }

    public void addTraceStep(Supplier<IExpr> inputExpr, Supplier<IExpr> rewrittenExpr, IAST listOfHints) {
        if (this.fTraceStack != null) {
            this.fTraceStack.add(inputExpr.get(), rewrittenExpr.get(), this.getRecursionCounter(), -1L, listOfHints);
        }
    }

    public void addTraceStep(Supplier<IExpr> inputExpr, IExpr rewrittenExpr, IAST listOfHints) {
        if (this.fTraceStack != null) {
            this.fTraceStack.add(inputExpr.get(), rewrittenExpr, this.getRecursionCounter(), -1L, listOfHints);
        }
    }

    private void beginTrace(Predicate<IExpr> matcher) {
        this.setTraceMode(true);
        this.fTraceStack = new TraceStack(matcher);
    }

    public synchronized EvalEngine copy() {
        EvalEngine engine = new EvalEngine();
        engine.rubiASTCache = null;
        engine.rememberMap = this.rememberMap;
        engine.fAnswer = this.fAnswer;
        engine.fAssumptions = this.fAssumptions;
        engine.fContextPath = this.fContextPath.copy();
        engine.fErrorPrintStream = this.fErrorPrintStream;
        engine.fEvalLHSMode = this.fEvalLHSMode;
        engine.fEvalRHSMode = this.fEvalRHSMode;
        engine.fFileSystemEnabled = this.fFileSystemEnabled;
        engine.fIterationLimit = this.fIterationLimit;
        engine.fModifiedVariablesList = this.fModifiedVariablesList;
        engine.fNumericMode = this.fNumericMode;
        engine.fApfloatHelper = new FixedPrecisionApfloatHelper(this.getNumericPrecision());
        engine.fSignificantFigures = this.fSignificantFigures;
        engine.fEvalHistory = this.fEvalHistory;
        engine.fOptionsStack = this.fOptionsStack;
        engine.fOutListDisabled = this.fOutListDisabled;
        engine.fOutPrintStream = this.fOutPrintStream;
        engine.fOnOffMap = this.fOnOffMap;
        engine.fOnOffMode = this.fOnOffMode;
        engine.fOnOffUnique = this.fOnOffUnique;
        engine.fOnOffUniqueMap = this.fOnOffUniqueMap;
        engine.fPackageMode = this.fPackageMode;
        engine.fQuietMode = this.fQuietMode;
        engine.fReapList = this.fReapList;
        engine.fRecursionCounter = 0;
        engine.fRecursionLimit = this.fRecursionLimit;
        engine.fRelaxedSyntax = this.fRelaxedSyntax;
        engine.fSeconds = this.fSeconds;
        engine.fSessionID = this.fSessionID;
        engine.fStopRequested = false;
        engine.fTogetherMode = this.fTogetherMode;
        engine.fTraceMode = this.fTraceMode;
        engine.fTraceStack = this.fTraceStack;
        engine.f$Input = this.f$Input;
        engine.f$InputFileName = this.f$InputFileName;
        this.fCopiedEngine = engine;
        return engine;
    }

    public Context begin(String contextName, Context parentContext) {
        this.fContextPathStack.push(this.fContextPath);
        this.fContextPath = this.fContextPath.copy();
        Context packageContext = this.fContextPath.getContext(contextName, parentContext);
        this.setContext(packageContext);
        return packageContext;
    }

    public Context beginPackage(String contextName) {
        this.fContextPathStack.push(this.fContextPath);
        Context packageContext = this.fContextPath.getContext(contextName);
        this.setContextPath(new ContextPath(packageContext));
        ContextPath.PACKAGES.add(contextName);
        return packageContext;
    }

    public Context end() {
        if (this.fContextPathStack.size() > 0) {
            ContextPath p = this.fContextPath;
            Context c = this.fContextPath.currentContext();
            this.fContextPath = this.fContextPathStack.pop();
            this.fContextPath.synchronize(p);
            return c;
        }
        return null;
    }

    public void endPackage() {
        if (this.fContextPathStack.size() > 0) {
            ContextPath p = this.fContextPath;
            Context c = this.fContextPath.currentContext();
            this.fContextPath = this.fContextPathStack.pop();
            this.fContextPath.synchronize(p);
            this.fContextPath.add(0, c);
        }
    }

    public int decRecursionCounter() {
        return --this.fRecursionCounter;
    }

    private IAST endTrace() {
        this.setTraceMode(false);
        IASTAppendable ast = ((TraceStack)this.fTraceStack).getList();
        this.fTraceStack = null;
        if (ast.size() > 1) {
            return ast.getAST(1);
        }
        return ast;
    }

    public void evalArg(IASTMutable[] result0, IAST ast, IExpr arg, int i, boolean isNumericFunction) {
        IExpr evaledArg = this.evalLoop(arg);
        if (evaledArg.isPresent()) {
            if (!result0[0].isPresent()) {
                result0[0] = ast.copy();
                if (isNumericFunction && evaledArg.isNumericArgument()) {
                    result0[0].addEvalFlags(ast.getEvalFlags() & 0x60 | 0x10000);
                } else {
                    result0[0].addEvalFlags(ast.getEvalFlags() & 0x60);
                }
            }
            result0[0].set(i, evaledArg);
        } else if (isNumericFunction && arg.isNumericArgument()) {
            ast.addEvalFlags(ast.getEvalFlags() | 0x10000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IASTMutable evalArgs(IAST ast, int attributes) {
        IASTMutable[] rlist;
        boolean isNumericArgument;
        boolean isNumericFunction;
        boolean localNumericMode;
        boolean numericMode;
        int astSize;
        block26: {
            astSize = ast.size();
            if (astSize <= 1) return F.NIL;
            numericMode = this.fNumericMode;
            localNumericMode = this.fNumericMode;
            isNumericFunction = (0x400 & attributes) == 1024;
            isNumericArgument = ast.isNumericArgument();
            if (!this.fNumericMode && isNumericFunction && isNumericArgument) {
                localNumericMode = true;
            }
            rlist = new IASTMutable[]{F.NIL};
            IExpr x = ast.arg1();
            if ((0x20 & attributes) == 0) {
                try {
                    if (!x.isAST(S.Unevaluated)) {
                        this.selectNumericMode(attributes, 8192, localNumericMode);
                        this.evalArg(rlist, ast, x, 1, isNumericFunction);
                        if (astSize == 2 && rlist[0].isPresent()) {
                            IASTMutable iASTMutable = rlist[0];
                            return iASTMutable;
                        }
                    }
                    break block26;
                }
                finally {
                    if ((0x2000 & attributes) == 8192) {
                        this.fNumericMode = numericMode;
                    }
                }
            }
            if (!ast.isHoldAllCompleteAST()) {
                try {
                    if (x.isAST(S.Evaluate)) {
                        this.selectNumericMode(attributes, 8192, localNumericMode);
                        this.evalArg(rlist, ast, x, 1, isNumericFunction);
                        if (astSize == 2 && rlist[0].isPresent()) {
                            IASTMutable iASTMutable = rlist[0];
                            return iASTMutable;
                        }
                    }
                }
                finally {
                    if ((0x2000 & attributes) == 8192) {
                        this.fNumericMode = numericMode;
                    }
                }
            }
        }
        if (astSize > 2) {
            if ((0x40 & attributes) == 0) {
                numericMode = this.fNumericMode;
                try {
                    this.selectNumericMode(attributes, 16384, localNumericMode);
                    ast.forEach(2, astSize, (arg, i) -> {
                        if (!arg.isUnevaluated()) {
                            this.evalArg(rlist, ast, (IExpr)arg, i, isNumericFunction);
                        }
                    });
                }
                finally {
                    if ((0x4000 & attributes) == 16384) {
                        this.fNumericMode = numericMode;
                    }
                }
            }
            if (!ast.isHoldAllCompleteAST()) {
                numericMode = this.fNumericMode;
                try {
                    this.selectNumericMode(attributes, 16384, localNumericMode);
                    ast.forEach(2, astSize, (arg, i) -> {
                        if (arg.isAST(S.Evaluate)) {
                            this.evalArg(rlist, ast, (IExpr)arg, i, isNumericFunction);
                        }
                    });
                }
                finally {
                    if ((0x4000 & attributes) == 16384) {
                        this.fNumericMode = numericMode;
                    }
                }
            }
        }
        if (isNumericArgument) return rlist[0];
        if (!ast.isNumericArgument()) return rlist[0];
        if (rlist[0].isPresent()) return rlist[0];
        return this.evalArgs(ast, attributes);
    }

    private IExpr evalASTArg1(IAST ast) {
        IExpr result = ast.head().evaluateHead(ast, this);
        if (result.isPresent()) {
            return result;
        }
        ISymbol symbol = ast.topHead();
        int attributes = symbol.getAttributes();
        if ((attributes & 0x40000) != 262144 && (result = F.flattenSequence(ast)).isPresent()) {
            return result;
        }
        result = this.evalArgs(ast, attributes);
        if (result.isPresent()) {
            return result;
        }
        IExpr arg1 = ast.arg1();
        if (ISymbol.hasFlatAttribute(attributes)) {
            if (arg1.head().equals(symbol)) {
                return arg1;
            }
            if (arg1.isUnevaluated() && arg1.first().head().equals(symbol) && arg1.first().isAST()) {
                IAST unevaluated = (IAST)arg1.first();
                return unevaluated.map(symbol, x -> F.Unevaluated(x));
            }
        }
        if ((0x200 & attributes) == 512 && symbol.isBuiltInSymbol()) {
            IExpr temp;
            IEvaluator module;
            if (arg1.isRealVector() && ((IAST)arg1).size() > 1) {
                module = ((IBuiltInSymbol)symbol).getEvaluator();
                if (module instanceof DoubleUnaryOperator) {
                    DoubleUnaryOperator oper = (DoubleUnaryOperator)((Object)module);
                    return ASTRealVector.map((IAST)arg1, oper);
                }
            } else if (arg1.isRealMatrix() && (module = ((IBuiltInSymbol)symbol).getEvaluator()) instanceof DoubleUnaryOperator) {
                DoubleUnaryOperator oper = (DoubleUnaryOperator)((Object)module);
                return ASTRealMatrix.map((IAST)arg1, oper);
            }
            if (arg1.isList()) {
                return EvalAttributes.threadList(ast, S.List, ast.head(), ((IAST)arg1).argSize());
            }
            if (arg1.isAssociation()) {
                return ((IAssociation)arg1).mapThread(ast, 1);
            }
            if (arg1.isSparseArray()) {
                return ((ISparseArray)arg1).mapThread(ast, 1);
            }
            if (arg1.isConditionalExpression() && (temp = ast.extractConditionalExpression(true)).isPresent()) {
                return temp;
            }
        }
        if ((0x400 & attributes) == 1024 && ast.arg1().isIndeterminate()) {
            return S.Indeterminate;
        }
        if (!(arg1 instanceof IPatternObject) && arg1.isPresent()) {
            ISymbol lhsSymbol = arg1.isSymbol() ? (ISymbol)arg1 : arg1.topHead();
            return lhsSymbol.evalUpRules(ast, this);
        }
        return F.NIL;
    }

    private IExpr evalASTBuiltinFunction(ISymbol symbol, IAST ast) {
        IEvaluator evaluator;
        IExpr result;
        int attributes = symbol.getAttributes();
        if (this.fEvalLHSMode && ((0x60 & attributes) == 96 ? !symbol.equals(S.Set) && !symbol.equals(S.SetDelayed) && !symbol.equals(S.UpSet) && !symbol.equals(S.UpSetDelayed) : (0x400 & attributes) != 1024)) {
            return F.NIL;
        }
        if (!symbol.equals(S.Integrate) && (result = symbol.evalDownRule(this, ast)).isPresent()) {
            return result;
        }
        if (symbol.isBuiltInSymbol() && (evaluator = ((IBuiltInSymbol)symbol).getEvaluator()) instanceof IFunctionEvaluator) {
            if (ast.isEvalFlagOn(262144) && this.isSymbolicMode(attributes)) {
                return F.NIL;
            }
            IFunctionEvaluator functionEvaluator = (IFunctionEvaluator)evaluator;
            OptionsResult opres = this.checkBuiltinArguments(ast, functionEvaluator);
            if (opres == null) {
                return F.NIL;
            }
            ast = opres.result;
            try {
                if (evaluator instanceof AbstractFunctionOptionEvaluator) {
                    AbstractFunctionOptionEvaluator optionsEvaluator = (AbstractFunctionOptionEvaluator)evaluator;
                    IExpr result2 = optionsEvaluator.evaluate(ast, opres.argSize, opres.options, this);
                    if (result2.isPresent()) {
                        return result2;
                    }
                } else {
                    IExpr result3;
                    IExpr iExpr = result3 = this.fNumericMode ? functionEvaluator.numericEval(ast, this) : functionEvaluator.evaluate(ast, this);
                    if (result3.isPresent()) {
                        return result3;
                    }
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, this);
            }
            catch (FlowControlException e) {
                throw e;
            }
            catch (SymjaMathException ve) {
                LOGGER.log(this.getLogLevel(), (Object)ast.topHead(), (Throwable)((Object)ve));
                return F.NIL;
            }
        }
        return F.NIL;
    }

    public final boolean isSymbolicMode(int headAttributes) {
        return !this.fNumericMode && this.fAssumptions == null && (0x401E0 & headAttributes) == 0;
    }

    public OptionsResult checkBuiltinArguments(IAST ast, IFunctionEvaluator functionEvaluator) {
        AbstractFunctionOptionEvaluator optionEvaluator;
        OptionsResult opres = new OptionsResult(ast, ast.argSize(), null);
        int[] expected = functionEvaluator.expectedArgSize(ast);
        if (expected != null) {
            if (expected.length == 2 && !ast.head().isBuiltInSymbol()) {
                return null;
            }
            if (expected.length == 3 && expected[2] > 0) {
                switch (expected[2]) {
                    case 1: {
                        if (!ast.isAST1()) break;
                        opres.result = F.operatorForm1Append(ast);
                        if (opres.result.isPresent()) break;
                        return null;
                    }
                    case 2: {
                        if (!ast.head().isAST1()) break;
                        opres.result = F.operatorForm2Prepend(ast, expected, this);
                        if (opres.result.isPresent()) break;
                        return null;
                    }
                }
            }
            if ((ast = opres.result).argSize() < expected[0] || ast.argSize() > expected[1]) {
                AbstractFunctionOptionEvaluator optionEvaluator2;
                if (ast.isAST1() && expected.length > 2) {
                    return null;
                }
                if (ast.argSize() > expected[0] && functionEvaluator instanceof AbstractFunctionOptionEvaluator && (opres = this.getOptions(optionEvaluator2 = (AbstractFunctionOptionEvaluator)functionEvaluator, opres, ast, expected)) != null) {
                    return opres;
                }
                IOFunctions.printArgMessage(ast, expected, this);
                return null;
            }
        }
        if (functionEvaluator instanceof AbstractFunctionOptionEvaluator && (opres = this.getOptions(optionEvaluator = (AbstractFunctionOptionEvaluator)functionEvaluator, opres, ast, expected)) != null) {
            return opres;
        }
        return opres;
    }

    public boolean containsExperimental(IBuiltInSymbol symbol) {
        return this.experimatalSymbols.containsKey(symbol);
    }

    private OptionsResult getOptions(AbstractFunctionOptionEvaluator optionEvaluator, OptionsResult opres, IAST ast, int[] expected) {
        IBuiltInSymbol[] optionSymbols = optionEvaluator.getOptionSymbols();
        if (optionSymbols != null) {
            opres.options = new IExpr[optionSymbols.length];
            int argSize = AbstractFunctionEvaluator.determineOptions(opres.options, ast, ast.argSize(), expected, optionSymbols, this);
            if (argSize <= expected[1] && argSize >= expected[0]) {
                opres.argSize = argSize;
                return opres;
            }
        }
        return null;
    }

    public IExpr evalAttributes(ISymbol symbol, IASTMutable mutableAST) {
        int astSize = mutableAST.size();
        if (astSize == 2) {
            return this.evalASTArg1(mutableAST);
        }
        IExpr result = mutableAST.head().evaluateHead(mutableAST, this);
        if (result.isPresent()) {
            return result;
        }
        if (astSize != 1) {
            IExpr temp;
            IASTAppendable flattened;
            IASTAppendable returnResult = F.NIL;
            int attributes = symbol.getAttributes();
            if ((attributes & 0x40000) != 262144 && (result = F.flattenSequence(mutableAST)).isPresent()) {
                return result;
            }
            IASTMutable resultList = this.evalArgs(mutableAST, attributes);
            if (resultList.isPresent()) {
                return resultList;
            }
            if (ISymbol.hasFlatAttribute(attributes) && (flattened = EvalAttributes.flatten(mutableAST)).isPresent()) {
                returnResult = flattened;
                mutableAST = returnResult;
            }
            if ((result = this.evalTagSetPlusTimes(mutableAST)).isPresent()) {
                return result;
            }
            if ((0x200 & attributes) == 512 && (mutableAST.getEvalFlags() & 0x400) != 1024) {
                resultList = this.threadASTListArgs(mutableAST, S.Thread, "tdlen");
                if (resultList.isPresent()) {
                    return this.evalArgs(resultList, 0).orElse(resultList);
                }
                int indx = mutableAST.indexOf(x -> x.isAssociation());
                if (indx > 0) {
                    return ((IAssociation)mutableAST.get(indx)).mapThread(mutableAST, indx);
                }
            }
            if ((0x400 & attributes) == 1024) {
                if ((0x60 & attributes) != 96) {
                    if (mutableAST.exists(x -> x.isIndeterminate())) {
                        return S.Indeterminate;
                    }
                    temp = mutableAST.extractConditionalExpression(false);
                    if (temp.isPresent()) {
                        return temp;
                    }
                }
            } else if ((mutableAST.isBooleanFunction() || mutableAST.isComparatorFunction()) && (temp = mutableAST.extractConditionalExpression(false)).isPresent()) {
                return temp;
            }
            if (astSize > 2 && ISymbol.hasOrderlessAttribute(attributes)) {
                EvalAttributes.sortWithFlags(mutableAST);
            }
            return returnResult;
        }
        return F.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr evalBlock(Supplier<IExpr> supplier, IAST localVariablesList) {
        ISymbol[] symbolList = new ISymbol[localVariablesList.size()];
        IExpr[] blockVariables = new IExpr[localVariablesList.size()];
        RulesData[] blockVariablesRulesData = new RulesData[localVariablesList.size()];
        IExpr result = F.NIL;
        try {
            Programming.rememberBlockVariables(localVariablesList, symbolList, blockVariables, blockVariablesRulesData, this);
            result = supplier.get();
        }
        finally {
            if (localVariablesList.size() > 0) {
                for (int i = 1; i < localVariablesList.size(); ++i) {
                    IAST setFun;
                    ISymbol variableSymbol;
                    if (localVariablesList.get(i).isVariable()) {
                        variableSymbol = symbolList[i];
                        if (variableSymbol == null) continue;
                        variableSymbol.assignValue(blockVariables[i], false);
                        variableSymbol.setRulesData(blockVariablesRulesData[i]);
                        continue;
                    }
                    if (!localVariablesList.get(i).isAST(S.Set, 3) || !(setFun = (IAST)localVariablesList.get(i)).arg1().isVariable() || (variableSymbol = symbolList[i]) == null) continue;
                    variableSymbol.assignValue(blockVariables[i], false);
                    variableSymbol.setRulesData(blockVariablesRulesData[i]);
                }
            }
        }
        return result;
    }

    public IExpr evalBlock(IExpr expr, IAST localVariablesList) {
        return this.evalBlock(() -> this.evaluate(expr), localVariablesList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr evalModuleDummySymbol(IExpr expr, ISymbol symbol, IExpr localValue, boolean quiet) {
        boolean quietMode = this.isQuietMode();
        this.setQuietMode(quiet);
        IdentityHashMap<ISymbol, ISymbol> blockVariables = new IdentityHashMap<ISymbol, ISymbol>();
        IExpr result = F.NIL;
        try {
            ISymbol oldSymbol = symbol;
            ISymbol newSymbol = F.Dummy(oldSymbol.toString());
            blockVariables.put(oldSymbol, newSymbol);
            IExpr temp = F.subst(this.evaluate(localValue), blockVariables);
            this.evaluate(F.Set(newSymbol, temp));
            result = expr.accept(new ModuleReplaceAll(blockVariables, this, ""));
            IExpr iExpr = this.evaluate(result.orElse(expr));
            return iExpr;
        }
        finally {
            this.setQuietMode(quietMode);
            if (blockVariables.size() > 0) {
                IdentityHashMap<ISymbol, IExpr> globalVariables = new IdentityHashMap<ISymbol, IExpr>();
                for (Map.Entry entry : blockVariables.entrySet()) {
                    globalVariables.put((ISymbol)entry.getValue(), (IExpr)entry.getKey());
                }
                result = F.subst(result, globalVariables);
            }
        }
    }

    public final boolean evalBoolean(IExpr expr) throws ArgumentTypeException {
        if (expr.equals(S.True)) {
            return true;
        }
        if (expr.equals(S.False)) {
            return false;
        }
        if (expr.isNumericFunction(true)) {
            IExpr numericResult = this.evalN(expr);
            if (numericResult.equals(S.True)) {
                return true;
            }
            if (numericResult.equals(S.False)) {
                return false;
            }
        } else {
            IExpr temp = this.evaluateNIL(expr);
            if (temp.isNumericFunction(true)) {
                IExpr numericResult = this.evalN(temp);
                if (numericResult.equals(S.True)) {
                    return true;
                }
                if (numericResult.equals(S.False)) {
                    return false;
                }
            }
        }
        throw new ArgumentTypeException("conversion into a machine-size boolean value is not possible!");
    }

    public final double evalDouble(IExpr expr) throws ArgumentTypeException {
        return this.evalDouble(expr, Double.NaN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double evalDouble(IExpr expr, double defaultValue) {
        if (expr.isReal()) {
            return ((ISignedNumber)expr).doubleValue();
        }
        boolean quietMode = this.fQuietMode;
        try {
            this.fQuietMode = true;
            if (expr.isNumericFunction(true)) {
                IExpr result = this.evalN(expr);
                if (result.isReal()) {
                    double d = ((ISignedNumber)result).doubleValue();
                    return d;
                }
            } else {
                IExpr result;
                IExpr temp = this.evaluateNIL(expr);
                if (temp.isNumericFunction(true) && (result = this.evalN(temp)).isReal()) {
                    double d = ((ISignedNumber)result).doubleValue();
                    return d;
                }
            }
        }
        finally {
            this.fQuietMode = quietMode;
        }
        if (Double.isNaN(defaultValue)) {
            throw new ArgumentTypeException("Expression \"" + IOFunctions.shorten(expr) + "\" cannot be converted to a machine-sized double numeric value!");
        }
        return defaultValue;
    }

    public final int evalInt(IExpr expr) throws ArgumentTypeException {
        int result = Integer.MIN_VALUE;
        if (expr.isReal()) {
            result = expr.toIntDefault();
        }
        if (expr.isNumericFunction(true)) {
            IExpr numericResult = this.evalN(expr);
            if (numericResult.isReal()) {
                result = numericResult.toIntDefault();
            }
        } else {
            IExpr numericResult;
            IExpr temp = this.evaluateNIL(expr);
            if (temp.isNumericFunction(true) && (numericResult = this.evalN(temp)).isReal()) {
                result = numericResult.toIntDefault();
            }
        }
        if (result != Integer.MIN_VALUE) {
            return result;
        }
        throw new ArgumentTypeException("conversion into a machine-size integer value is not possible!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Complex evalComplex(IExpr expr) throws ArgumentTypeException {
        if (expr.isReal()) {
            return new Complex(((ISignedNumber)expr).doubleValue());
        }
        if (expr.isNumber()) {
            return new Complex(((INumber)expr).reDoubleValue(), ((INumber)expr).imDoubleValue());
        }
        boolean quietMode = this.fQuietMode;
        try {
            this.fQuietMode = true;
            if (expr.isNumericFunction(true)) {
                IExpr result = this.evalN(expr);
                if (result.isReal()) {
                    Complex complex = new Complex(((ISignedNumber)result).doubleValue());
                    return complex;
                }
                if (result.isNumber()) {
                    Complex complex = new Complex(((INumber)result).reDoubleValue(), ((INumber)result).imDoubleValue());
                    return complex;
                }
            } else {
                IExpr temp = this.evaluateNIL(expr);
                if (temp.isNumericFunction(true)) {
                    IExpr result = this.evalN(temp);
                    if (result.isReal()) {
                        Complex complex = new Complex(((ISignedNumber)result).doubleValue());
                        return complex;
                    }
                    if (result.isNumber()) {
                        Complex complex = new Complex(((INumber)result).reDoubleValue(), ((INumber)result).imDoubleValue());
                        return complex;
                    }
                }
            }
        }
        finally {
            this.fQuietMode = quietMode;
        }
        throw new ArgumentTypeException("conversion into a machine-size Complex numeric value is not possible!");
    }

    public IAST evalFlatOrderlessAttributesRecursive(IAST ast) {
        IASTAppendable result;
        if (ast.isEvalFlagOn(2048)) {
            return F.NIL;
        }
        ISymbol symbol = ast.topHead();
        int attributes = symbol.getAttributes();
        IASTMutable resultList = F.NIL;
        if ((0x60 & attributes) != 96) {
            IAST temp;
            int astSize = ast.size();
            if ((0x20 & attributes) == 0 && astSize > 1 && ast.arg1().isAST()) {
                IExpr expr = ast.arg1();
                if (ast.arg1().isAST()) {
                    temp = (IAST)ast.arg1();
                    expr = this.evalFlatOrderlessAttributesRecursive(temp);
                    if (expr.isPresent()) {
                        resultList = ast.setAtCopy(1, expr);
                    } else {
                        expr = ast.arg1();
                    }
                }
            }
            if (astSize > 2 && (0x40 & attributes) == 0) {
                for (int i = 2; i < astSize; ++i) {
                    IAST expr;
                    if (!ast.get(i).isAST() || !(expr = this.evalFlatOrderlessAttributesRecursive(temp = (IAST)ast.get(i))).isPresent()) continue;
                    if (!resultList.isPresent()) {
                        resultList = ast.copy();
                    }
                    resultList.set(i, expr);
                }
            }
        }
        if (resultList.isPresent()) {
            if (resultList.size() > 2) {
                IASTAppendable result2;
                if (ISymbol.hasFlatAttribute(attributes) && (result2 = EvalAttributes.flattenDeep(resultList)).isPresent()) {
                    resultList = result2;
                    if (ISymbol.hasOrderlessAttribute(attributes)) {
                        EvalAttributes.sortWithFlags(resultList);
                    }
                    resultList.addEvalFlags(2048);
                    return resultList;
                }
                if (ISymbol.hasOrderlessAttribute(attributes)) {
                    EvalAttributes.sortWithFlags(resultList);
                }
            }
            resultList.addEvalFlags(2048);
            return resultList;
        }
        if (ISymbol.hasFlatAttribute(attributes) && (result = EvalAttributes.flattenDeep(ast)).isPresent()) {
            resultList = result;
            if (ISymbol.hasOrderlessAttribute(attributes)) {
                EvalAttributes.sortWithFlags(resultList);
            }
            resultList.addEvalFlags(2048);
            return resultList;
        }
        if (ISymbol.hasOrderlessAttribute(attributes)) {
            if (EvalAttributes.sortWithFlags((IASTMutable)ast)) {
                ast.addEvalFlags(2048);
                return ast;
            }
            return ast;
        }
        return F.NIL;
    }

    public IExpr evalHoldPattern(IAST ast) {
        return this.evalHoldPattern(ast, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr evalHoldPattern(IAST ast, boolean noEvaluation, boolean evalNumericFunction) {
        boolean evalLHSMode = this.fEvalLHSMode;
        try {
            this.fEvalLHSMode = true;
            IExpr iExpr = this.evalSetAttributesRecursive(ast, noEvaluation, evalNumericFunction, 0);
            return iExpr;
        }
        finally {
            this.fEvalLHSMode = evalLHSMode;
        }
    }

    private final IExpr evalLoop(IExpr expr) {
        if (expr == null || !expr.isPresent()) {
            if (Config.FUZZ_TESTING) {
                throw new NullPointerException();
            }
            LOGGER.log(this.getLogLevel(), "Evaluation aborted in EvalEngine#evalLoop() because of undefined expression!");
            throw AbortException.ABORTED;
        }
        if (this.fRecursionLimit > 0 && this.fRecursionCounter > this.fRecursionLimit) {
            LOGGER.debug((Object)expr);
            RecursionLimitExceeded.throwIt(this.fRecursionLimit, expr);
        }
        if (this.fStopRequested || Thread.currentThread().isInterrupted()) {
            throw TimeoutException.TIMED_OUT;
        }
        IExpr result = expr;
        try {
            IExpr temp;
            ++this.fRecursionCounter;
            this.stackPush(expr);
            if (this.fTraceMode) {
                if (result.isUnevaluated()) {
                    IExpr iExpr = result.first();
                    return iExpr;
                }
                this.fTraceStack.setUp(expr, this.fRecursionCounter);
                temp = result.evaluate(this);
                if (temp.isPresent()) {
                    if (this.fStopRequested || Thread.currentThread().isInterrupted()) {
                        throw TimeoutException.TIMED_OUT;
                    }
                    this.fTraceStack.add(expr, temp, this.fRecursionCounter, 0L, EVALUATION_LOOP);
                    result = temp;
                    long iterationCounter = 1L;
                    while (true) {
                        if (result.isUnevaluated()) {
                            IExpr iExpr = result.first();
                            return iExpr;
                        }
                        temp = result.evaluate(this);
                        if (!temp.isPresent()) break;
                        if (this.fStopRequested || Thread.currentThread().isInterrupted()) {
                            throw TimeoutException.TIMED_OUT;
                        }
                        if (LOGGER.isDebugEnabled() && temp.equals(result)) {
                            IOFunctions.printMessage(result.topHead(), "itendless", F.list(temp), this);
                            IterationLimitExceeded.throwIt(this.fIterationLimit, result);
                        }
                        this.fTraceStack.add(result, temp, this.fRecursionCounter, iterationCounter, EVALUATION_LOOP);
                        result = temp;
                        if (this.fIterationLimit < 0 || (long)this.fIterationLimit > ++iterationCounter) continue;
                        IterationLimitExceeded.throwIt(iterationCounter, result);
                    }
                    IExpr iExpr = result;
                    return iExpr;
                }
            } else {
                if (result.isUnevaluated()) {
                    IExpr temp2 = result.first();
                    return temp2;
                }
                temp = result.evaluate(this);
                if (temp.isPresent()) {
                    if (this.fStopRequested || Thread.currentThread().isInterrupted()) {
                        throw TimeoutException.TIMED_OUT;
                    }
                    if (this.fOnOffMode) {
                        this.printOnOffTrace(expr, temp);
                    }
                    result = temp;
                    long iterationCounter = 1L;
                    while (true) {
                        if (result.isUnevaluated()) {
                            IExpr iExpr = result.first();
                            return iExpr;
                        }
                        temp = result.evaluate(this);
                        if (!temp.isPresent()) break;
                        if (this.fStopRequested || Thread.currentThread().isInterrupted()) {
                            throw TimeoutException.TIMED_OUT;
                        }
                        if (LOGGER.isDebugEnabled() && temp.equals(result)) {
                            IOFunctions.printMessage(result.topHead(), "itendless", F.list(temp), this);
                            IterationLimitExceeded.throwIt(this.fIterationLimit, result);
                        }
                        if (this.fOnOffMode) {
                            this.printOnOffTrace(result, temp);
                        }
                        if (this.fIterationLimit >= 0 && (long)this.fIterationLimit <= ++iterationCounter) {
                            IterationLimitExceeded.throwIt(iterationCounter, temp);
                        }
                        result = temp;
                    }
                    IExpr iExpr = result;
                    return iExpr;
                }
            }
            temp = F.NIL;
            return temp;
        }
        catch (UnsupportedOperationException uoe) {
            if (Config.FUZZ_TESTING) {
                throw new NullPointerException();
            }
            LOGGER.log(this.getLogLevel(), "Evaluation aborted: {}", (Object)result);
            throw AbortException.ABORTED;
        }
        finally {
            this.stackPop();
            if (this.fTraceMode) {
                this.fTraceStack.tearDown(this.fRecursionCounter, true);
            }
            --this.fRecursionCounter;
            if (this.fStopRequested) {
                throw TimeoutException.TIMED_OUT;
            }
        }
    }

    private void printOnOffTrace(IExpr unevaledExpr, IExpr evaledExpr) {
        boolean showExpr = true;
        if (this.fOnOffMap != null) {
            showExpr = this.fOnOffMap.containsKey(unevaledExpr.topHead());
        }
        if (showExpr) {
            if (this.fOnOffUniqueMap != null) {
                if (this.fOnOffUniqueMap.containsKey(unevaledExpr)) {
                    return;
                }
                this.fOnOffUniqueMap.put(unevaledExpr, evaledExpr);
            }
            PrintStream stream = this.getOutPrintStream();
            stream.println("  " + unevaledExpr.toString() + " --> " + evaledExpr.toString() + "\n");
        }
    }

    public final IExpr evalN(IExpr expr) {
        return this.evaluate(F.N(expr));
    }

    public final IAST evalArgsOrderlessN(IAST ast1) {
        IASTMutable copy = F.NIL;
        for (int i = 1; i < ast1.size(); ++i) {
            IExpr temp = ast1.get(i);
            if (temp.isInexactNumber() || !temp.isNumericFunction(true) || !(temp = this.evalLoop(F.N(temp))).isPresent()) continue;
            if (!copy.isPresent()) {
                copy = ast1.copy();
            }
            copy.set(i, this.evalN(temp));
        }
        if (copy.isPresent()) {
            EvalAttributes.sort(copy);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IExpr evalPattern(IExpr expr) {
        boolean numericMode = this.fNumericMode;
        try {
            if (expr.isFreeOfPatterns()) {
                IExpr iExpr = this.evalWithoutNumericReset(expr);
                return iExpr;
            }
            if (expr.isAST()) {
                if (expr.isOneIdentityAST1()) {
                    if (expr.first().isAST()) {
                        IExpr iExpr = this.evalHoldPattern((IAST)expr.first()).orElse(expr.first());
                        return iExpr;
                    }
                    IExpr iExpr = expr.first();
                    return iExpr;
                }
                IExpr iExpr = this.evalHoldPattern((IAST)expr).orElse(expr);
                return iExpr;
            }
            IExpr iExpr = expr;
            return iExpr;
        }
        catch (MathException ce) {
            IExpr iExpr = expr;
            return iExpr;
        }
        finally {
            this.fNumericMode = numericMode;
        }
    }

    public final IPatternMatcher evalPatternMatcher(IExpr patternExpression) {
        return new PatternMatcher(this.evalPattern(patternExpression));
    }

    public final IPatternMatcher evalPatternMatcher(IExpr patternExpression, IExpr rightHandside) {
        return new PatternMatcherAndEvaluator(this.evalPattern(patternExpression), rightHandside);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IExpr evalQuiet(IExpr expr) {
        boolean quiet = this.isQuietMode();
        try {
            this.setQuietMode(true);
            IExpr iExpr = this.evaluate(expr);
            return iExpr;
        }
        finally {
            this.setQuietMode(quiet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IExpr evalQuietNull(IExpr expr) {
        boolean quiet = this.isQuietMode();
        try {
            this.setQuietMode(true);
            IExpr iExpr = this.evaluateNIL(expr);
            return iExpr;
        }
        finally {
            this.setQuietMode(quiet);
        }
    }

    public IExpr evalRules(ISymbol symbol, IAST argsAST) {
        IAST ast = argsAST.exists(x -> x.isAST(S.Unevaluated, 2)) ? argsAST.map(x -> {
            if (x.isUnevaluated()) {
                return x.first();
            }
            return x;
        }, 1) : argsAST;
        IExpr temp = this.evalUpRules(ast);
        if (temp.isPresent()) {
            return temp;
        }
        return this.evalASTBuiltinFunction(symbol, ast);
    }

    public IExpr evalUpRules(IAST ast) {
        IExpr[] result = new IExpr[]{F.NIL};
        if (ast.exists(x -> {
            if (x.isSymbol()) {
                result[0] = ((ISymbol)x).evalUpRules(ast, this);
                if (result[0].isPresent()) {
                    return true;
                }
            } else if (!(x instanceof IPatternObject) && x.isPresent()) {
                result[0] = x.topHead().evalUpRules(ast, this);
                if (result[0].isPresent()) {
                    return true;
                }
            }
            return false;
        })) {
            return result[0];
        }
        return F.NIL;
    }

    private IASTMutable evalSetAttributeArg(IAST ast, int i, IAST argI, IASTMutable resultList, boolean noEvaluation, int level) {
        IExpr expr = this.evalSetAttributesRecursive(argI, noEvaluation, true, level + 1);
        if (expr != argI && expr.isPresent()) {
            if (resultList.isPresent()) {
                resultList.set(i, expr);
            } else {
                resultList = ast.setAtCopy(i, expr);
            }
        } else {
            expr = argI;
        }
        if (expr.isAST() && ((IAST)expr).size() == 2) {
            IExpr arg1 = ((IAST)expr).arg1();
            if (expr.isSqrt()) {
                if (resultList.isPresent()) {
                    resultList.set(i, S.Power.of(this, arg1, F.C1D2));
                } else {
                    resultList = ast.setAtCopy(i, S.Power.of(this, arg1, F.C1D2));
                }
            } else if (expr.isAST(S.Exp, 2)) {
                if (resultList.isPresent()) {
                    resultList.set(i, S.Power.of(this, S.E, arg1));
                } else {
                    resultList = ast.setAtCopy(i, S.Power.of(this, S.E, arg1));
                }
            }
        }
        return resultList;
    }

    @Deprecated
    public IExpr evalSetAttributes(IAST ast) {
        return this.evalHoldPattern(ast, false, false);
    }

    @Deprecated
    public IExpr evalSetAttributes(IAST ast, boolean noEvaluation) {
        return this.evalHoldPattern(ast, noEvaluation, false);
    }

    private IExpr evalSetAttributesRecursive(IAST ast, boolean noEvaluation, boolean evalNumericFunction, int level) {
        IASTAppendable result;
        int headID;
        IExpr headResult;
        IExpr head = ast.head();
        if (!(head instanceof IPatternObject) && !noEvaluation && (headResult = head.evaluate(this)).isPresent()) {
            ast = ast.apply(headResult);
            head = headResult;
        }
        ISymbol symbol = head.topHead();
        if (head.isSymbol()) {
            symbol = (ISymbol)head;
        }
        if (symbol.isBuiltInSymbol()) {
            ((IBuiltInSymbol)symbol).getEvaluator();
        }
        if ((headID = ast.headID()) >= 0 && (headID == 166 || headID == 168 || headID == 167 || headID == 984 || headID == 955 || headID == 957 || headID == 1122 || headID == 1123)) {
            return ((IFunctionEvaluator)((IBuiltInSymbol)ast.head()).getEvaluator()).evaluate(ast, this);
        }
        int attributes = symbol.getAttributes();
        IASTMutable resultList = F.NIL;
        if ((0x60 & attributes) != 96) {
            IAST f;
            IExpr temp;
            int astSize = ast.size();
            if ((0x20 & attributes) == 0 && astSize > 1) {
                IExpr expr = ast.arg1();
                if (expr.isAST()) {
                    resultList = this.evalSetAttributeArg(ast, 1, (IAST)expr, resultList, noEvaluation, level);
                } else if (!(expr instanceof IPatternObject) && !noEvaluation && (temp = expr.evaluate(this)).isPresent()) {
                    resultList = ast.setAtCopy(1, temp);
                }
            }
            if (astSize > 2 && (0x40 & attributes) == 0) {
                for (int i = 2; i < astSize; ++i) {
                    IExpr temp2;
                    IExpr expr = ast.get(i);
                    if (expr.isAST()) {
                        resultList = this.evalSetAttributeArg(ast, i, (IAST)expr, resultList, noEvaluation, level);
                        continue;
                    }
                    if (expr instanceof IPatternObject || noEvaluation || !(temp2 = expr.evaluate(this)).isPresent()) continue;
                    if (resultList.isPresent()) {
                        resultList.set(i, temp2);
                        continue;
                    }
                    resultList = ast.setAtCopy(i, temp2);
                }
            }
            if (evalNumericFunction && (0x60 & attributes) == 0 && (f = resultList.orElse(ast)).isNumericFunction(true) && (temp = this.evalLoop(f)).isPresent()) {
                return temp;
            }
        }
        if (resultList.isPresent()) {
            if (resultList.size() > 2) {
                IASTAppendable result2;
                if (ISymbol.hasFlatAttribute(attributes) && (result2 = EvalAttributes.flattenDeep(resultList)).isPresent()) {
                    return this.evalSetOrderless(result2, attributes, noEvaluation, level);
                }
                IExpr expr = this.evalSetOrderless(resultList, attributes, noEvaluation, level);
                if (expr.isPresent()) {
                    return expr;
                }
            }
            return resultList;
        }
        if ((ast.getEvalFlags() & 0x300) != 0) {
            return ast;
        }
        if (ISymbol.hasFlatAttribute(attributes) && (result = EvalAttributes.flattenDeep(ast)).isPresent()) {
            return this.evalSetOrderless(result, attributes, noEvaluation, level);
        }
        return this.evalSetOrderless(ast, attributes, noEvaluation, level);
    }

    private IExpr evalSetOrderless(IAST ast, int attributes, boolean noEvaluation, int level) {
        if (ISymbol.hasOrderlessAttribute(attributes)) {
            EvalAttributes.sortWithFlags((IASTMutable)ast);
            if (!noEvaluation) {
                if (ast.isPlus()) {
                    return Arithmetic.CONST_PLUS.evaluate(ast, this).orElse(ast);
                }
                if (ast.isTimes()) {
                    return Arithmetic.CONST_TIMES.evaluate(ast, this).orElse(ast);
                }
            }
        }
        if (level > 0 && !noEvaluation) {
            return this.evaluate(ast);
        }
        return ast;
    }

    private IExpr evalTagSetPlusTimes(IAST ast) {
        if (ast.isPlus()) {
            return UtilityFunctionCtors.evalRubiDistPlus(ast, this);
        }
        if (ast.isTimes()) {
            return UtilityFunctionCtors.evalRubiDistTimes(ast, this);
        }
        return F.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IAST evalTrace(IExpr expr, Predicate<IExpr> matcher) {
        IAST traceList = F.List();
        try {
            this.beginTrace(matcher);
            this.evaluate(expr);
        }
        finally {
            traceList = this.endTrace();
        }
        return traceList;
    }

    public final boolean evalTrue(IExpr expr) {
        if (expr.isBuiltInSymbol()) {
            if (expr.isTrue()) {
                return true;
            }
            if (expr.isFalse()) {
                return false;
            }
        }
        try {
            return this.evaluate(expr).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalTrue(IExpr head, IExpr arg1) {
        try {
            return this.evaluate(F.unaryAST1(head, arg1)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalTrue(IExpr head, IExpr arg1, IExpr arg2) {
        try {
            return this.evaluate(F.binaryAST2(head, arg1, arg2)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalEqual(IExpr lhs, IExpr rhs) {
        try {
            return this.evaluate(F.Equal(lhs, rhs)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalLess(IExpr lhs, IExpr rhs) {
        try {
            return this.evaluate(F.Less(lhs, rhs)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalLess(IExpr arg1, IExpr arg2, IExpr arg3) {
        try {
            return this.evaluate(F.ternaryAST3(S.Less, arg1, arg2, arg3)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalLessEqual(IExpr lhs, IExpr rhs) {
        try {
            return this.evaluate(F.LessEqual(lhs, rhs)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalGreater(IExpr lhs, IExpr rhs) {
        try {
            return this.evaluate(F.Greater(lhs, rhs)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalGreater(IExpr arg1, IExpr arg2, IExpr arg3) {
        try {
            return this.evaluate(F.ternaryAST3(S.Greater, arg1, arg2, arg3)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final boolean evalGreaterEqual(IExpr lhs, IExpr rhs) {
        try {
            return this.evaluate(F.GreaterEqual(lhs, rhs)).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    public final IBuiltInSymbol evalSymbolTrue(IExpr expr) {
        return this.evalTrue(expr) ? S.True : S.False;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IExpr evaluate(IExpr expr) {
        boolean numericMode = this.fNumericMode;
        try {
            IExpr iExpr = this.evalWithoutNumericReset(expr);
            return iExpr;
        }
        finally {
            this.fNumericMode = numericMode;
        }
    }

    public final IExpr evaluate(String expression) {
        return this.evaluate(this.parse(expression));
    }

    public final IExpr evaluate(String expression, boolean explicitTimes) {
        return this.evaluate(this.parse(expression, explicitTimes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IExpr evaluateNonNumeric(IExpr expr) {
        boolean numericMode = this.fNumericMode;
        try {
            this.fNumericMode = false;
            IExpr iExpr = this.evalWithoutNumericReset(expr);
            return iExpr;
        }
        finally {
            this.fNumericMode = numericMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IExpr evaluateNIL(IExpr expr) {
        boolean numericMode = this.fNumericMode;
        try {
            IExpr iExpr = this.evalLoop(expr);
            return iExpr;
        }
        finally {
            this.fNumericMode = numericMode;
        }
    }

    @Deprecated
    public final IExpr evaluateNull(IExpr expr) {
        return this.evaluateNIL(expr);
    }

    public final IExpr evalWithoutNumericReset(IExpr expr) {
        return this.evalLoop(expr).orElse(expr);
    }

    public FixedPrecisionApfloatHelper apfloatHelper() {
        return this.fApfloatHelper;
    }

    public IExpr getAnswer() {
        return this.fAnswer;
    }

    public IAssumptions getAssumptions() {
        return this.fAssumptions;
    }

    public IExpr getCache(IAST key) {
        return (IExpr)this.globalASTCache.getIfPresent((Object)key);
    }

    public final Context getContext() {
        return this.fContextPath.currentContext();
    }

    public String get$Input() {
        if (this.f$Input == null) {
            this.f$Input = "";
        }
        return this.f$Input;
    }

    public String get$InputFileName() {
        if (this.f$InputFileName == null) {
            this.f$InputFileName = "";
        }
        return this.f$InputFileName;
    }

    public void set$Input(String input) {
        this.f$Input = input == null ? "" : input;
    }

    public void set$InputFileName(String inputFileName) {
        this.f$InputFileName = inputFileName == null ? "" : inputFileName;
    }

    public ContextPath getContextPath() {
        return this.fContextPath;
    }

    public PrintStream getErrorPrintStream() {
        return this.fErrorPrintStream != null ? this.fErrorPrintStream : System.err;
    }

    public int getIterationLimit() {
        if (this.fStopRequested) {
            throw TimeoutException.TIMED_OUT;
        }
        return this.fIterationLimit;
    }

    public String getMessageShortcut() {
        return this.fMessageShortcut;
    }

    public Set<ISymbol> getModifiedVariables() {
        return this.fModifiedVariablesList;
    }

    public long getNumericPrecision() {
        if (this.fApfloatHelper != null) {
            return this.fApfloatHelper.precision();
        }
        return 15L;
    }

    public int getSignificantFigures() {
        return this.fSignificantFigures;
    }

    public EvalHistory getEvalHistory() {
        return this.fEvalHistory;
    }

    public OptionsStack pushOptionsStack() {
        this.fOptionsStack.push();
        return this.fOptionsStack;
    }

    public void putCache(IAST key, IExpr value) {
        this.globalASTCache.put((Object)key, (Object)value);
    }

    public void popOptionsStack() {
        this.fOptionsStack.pop();
    }

    public Iterator<IdentityHashMap<ISymbol, IASTAppendable>> optionsStackIterator() {
        return this.fOptionsStack.iterator();
    }

    public PrintStream getOutPrintStream() {
        return this.fOutPrintStream != null ? this.fOutPrintStream : System.out;
    }

    public List<IExpr> getReapList() {
        return this.fReapList;
    }

    public int getRecursionCounter() {
        if (this.fStopRequested) {
            throw TimeoutException.TIMED_OUT;
        }
        return this.fRecursionCounter;
    }

    public int getRecursionLimit() {
        if (this.fStopRequested) {
            throw TimeoutException.TIMED_OUT;
        }
        return this.fRecursionLimit;
    }

    public double getRemainingSeconds() {
        long timeConstrained = this.fTimeConstrainedMillis;
        if (timeConstrained < 0L) {
            return -1.0;
        }
        long timeRemaining = timeConstrained - System.currentTimeMillis();
        if (timeRemaining < 0L) {
            timeRemaining = 0L;
        }
        return (double)timeRemaining / 1000.0;
    }

    public long getTimeConstrainedMillis() {
        return this.fTimeConstrainedMillis;
    }

    public long getSeconds() {
        return this.fSeconds;
    }

    public String getSessionID() {
        return this.fSessionID;
    }

    public Deque<IExpr> getStack() {
        return this.fStack;
    }

    public IEvalStepListener getStepListener() {
        return this.fTraceStack;
    }

    public static long incModuleCounter() {
        return MODULE_COUNTER.incrementAndGet();
    }

    public static String uniqueName(String prefix) {
        return prefix + MODULE_COUNTER.incrementAndGet();
    }

    public static void resetModuleCounter4JUnit() {
        MODULE_COUNTER = new AtomicLong();
    }

    public void incExperimentalCounter(IBuiltInSymbol symbol) {
        Integer counter = this.experimatalSymbols.get(symbol);
        if (counter == null) {
            this.experimatalSymbols.put(symbol, 1);
            return;
        }
        counter = counter + 1;
        this.experimatalSymbols.put(symbol, counter);
    }

    public int incRecursionCounter() {
        return ++this.fRecursionCounter;
    }

    public final void init() {
        this.stackBegin();
        this.fAnswer = null;
        this.fAssumptions = null;
        S.$Assumptions.clearValue();
        this.fApfloatHelper = null;
        this.fSignificantFigures = 6;
        this.fRecursionCounter = 0;
        this.fNumericMode = false;
        this.fTogetherMode = false;
        this.fEvalLHSMode = false;
        this.fEvalRHSMode = false;
        this.fOnOffMode = false;
        this.fOnOffUnique = false;
        this.fOnOffUniqueMap = null;
        this.fOnOffMap = null;
        this.fTraceMode = false;
        this.fTraceStack = null;
        this.fStopRequested = false;
        this.fCopiedEngine = null;
        this.fSeconds = 0L;
        this.fModifiedVariablesList = null;
        this.fMessageShortcut = null;
        this.fContextPathStack = new ArrayDeque();
        this.fContextPath = ContextPath.initialContext();
        this.f$Input = "";
        this.f$InputFileName = "";
        this.fOptionsStack = new OptionsStack();
        this.rubiASTCache = null;
        this.rememberMap = new IdentityHashMap<Object, IExpr>();
    }

    public Deque<IExpr> stackBegin() {
        this.fStack = new ArrayDeque<IExpr>(256);
        return this.fStack;
    }

    public void stackPush(IExpr expr) {
        this.fStack.push(expr);
    }

    public IExpr stackPop() {
        if (this.fStack.isEmpty()) {
            return F.NIL;
        }
        return this.fStack.pop();
    }

    public final boolean isArbitraryMode() {
        return this.getNumericPrecision() > 16L;
    }

    @Deprecated
    public final boolean isApfloatMode() {
        return this.isArbitraryMode();
    }

    public final boolean isEvalLHSMode() {
        return this.fEvalLHSMode;
    }

    public final boolean isEvalRHSMode() {
        return this.fEvalRHSMode;
    }

    public final void setEvalRHSMode(boolean evalRHSMode) {
        this.fEvalRHSMode = evalRHSMode;
    }

    public final boolean isFileSystemEnabled() {
        return this.fFileSystemEnabled;
    }

    public final boolean isNumericMode() {
        return this.fNumericMode;
    }

    public final boolean isDoubleMode() {
        return this.fNumericMode && !this.isArbitraryMode();
    }

    public final boolean isOnOffMode() {
        return this.fOnOffMode;
    }

    public final boolean isOutListDisabled() {
        return this.fOutListDisabled;
    }

    public final boolean isPackageMode() {
        return this.fPackageMode;
    }

    public final boolean isQuietMode() {
        return this.fQuietMode;
    }

    public final boolean isRelaxedSyntax() {
        return this.fRelaxedSyntax;
    }

    public final boolean isStopRequested() {
        return this.fStopRequested;
    }

    public final boolean isTogetherMode() {
        return this.fTogetherMode;
    }

    public final boolean isTraceMode() {
        return this.fTraceMode;
    }

    public final IExpr parse(String expression) {
        return this.parse(expression, ParserConfig.EXPLICIT_TIMES_OPERATOR);
    }

    public final IExpr parse(String expression, boolean explicitTimes) {
        ExprParser parser = new ExprParser(this, ExprParserFactory.RELAXED_STYLE_FACTORY, this.fRelaxedSyntax, false, explicitTimes);
        return parser.parse(expression);
    }

    public Level getLogLevel() {
        return this.isQuietMode() ? Level.DEBUG : Level.ERROR;
    }

    private void reset() {
        this.stackBegin();
        this.fApfloatHelper = null;
        this.fSignificantFigures = 6;
        this.fNumericMode = false;
        this.fEvalLHSMode = false;
        this.fEvalRHSMode = false;
        this.fRecursionCounter = 0;
        this.fTogetherMode = false;
        this.fTraceMode = false;
        this.fTraceStack = null;
        this.fStopRequested = false;
        this.fCopiedEngine = null;
        this.fSeconds = 0L;
        this.fModifiedVariablesList = null;
        this.fMessageShortcut = null;
        this.rubiASTCache = null;
        this.fOptionsStack = new OptionsStack();
        if (this.fOnOffMode && this.fOnOffUnique) {
            this.fOnOffUniqueMap = new HashMap<IExpr, IExpr>();
        }
    }

    private void selectNumericMode(int attributes, int nHoldAttribute, boolean localNumericMode) {
        this.fNumericMode = (nHoldAttribute & attributes) == nHoldAttribute ? false : localNumericMode;
    }

    public void setAssumptions(IAssumptions assumptions) {
        this.fAssumptions = assumptions;
    }

    public void setContextPath(ContextPath contextPath) {
        this.fContextPath = contextPath;
    }

    public void setContext(Context context) {
        this.fContextPath.setCurrentContext(context);
    }

    public void setErrorPrintStream(PrintStream errorPrintStream) {
        this.fErrorPrintStream = errorPrintStream;
    }

    public void setFileSystemEnabled(boolean fFileSystemEnabled) {
        this.fFileSystemEnabled = fFileSystemEnabled;
    }

    public void setIterationLimit(int i) {
        this.fIterationLimit = i;
    }

    public void setMessageShortcut(String messageShortcut) {
        this.fMessageShortcut = messageShortcut;
    }

    public void setNumericMode(boolean numericMode) {
        this.fNumericMode = numericMode;
    }

    public void setNumericMode(boolean numericMode, long precision, int figures) {
        this.fNumericMode = numericMode;
        this.setNumericPrecision(precision);
        this.fSignificantFigures = figures;
    }

    public void setNumericPrecision(long precision) {
        this.fApfloatHelper = 16L > precision ? null : new FixedPrecisionApfloatHelper(precision);
    }

    public void setSignificantFigures(int figures) {
        this.fSignificantFigures = figures;
    }

    public void setOutListDisabled(boolean outListDisabled, short historyCapacity) {
        if (!outListDisabled) {
            if (this.fEvalHistory == null) {
                this.fEvalHistory = new EvalHistory(historyCapacity);
            }
        } else {
            this.fEvalHistory = null;
        }
        this.fOutListDisabled = outListDisabled;
    }

    public void setOnOffMode(boolean onOffMode, Map<ISymbol, ISymbol> headSymbolsMap, boolean uniqueTrace) {
        this.fOnOffMode = onOffMode;
        this.fOnOffMap = headSymbolsMap;
        this.fOnOffUnique = uniqueTrace;
        if (uniqueTrace) {
            this.fOnOffUniqueMap = new HashMap<IExpr, IExpr>();
        }
    }

    public void setOptionsPattern(ISymbol lhsHead, IPatternMap patternMap) {
        IdentityHashMap optionsPattern = (IdentityHashMap)this.fOptionsStack.peek();
        boolean setHead = patternMap.setOptionsPattern(this, lhsHead);
        if (!optionsPattern.isEmpty()) {
            for (Map.Entry element : optionsPattern.entrySet()) {
                ISymbol symbol = (ISymbol)element.getKey();
                IAST list = PatternMatching.optionsList((ISymbol)element.getKey(), true);
                if (list.size() <= 1) continue;
                IASTAppendable tempList = (IASTAppendable)optionsPattern.get(symbol);
                if (tempList == null) {
                    tempList = F.ListAlloc(10);
                    optionsPattern.put(symbol, tempList);
                }
                tempList.appendArgs(list);
            }
        }
        if (setHead) {
            optionsPattern.put(S.LHS_HEAD, F.ast(lhsHead));
        }
    }

    public void setOutListDisabled(EvalHistory history) {
        this.fEvalHistory = history;
        this.fOutListDisabled = false;
    }

    public void setOutPrintStream(PrintStream outPrintStream) {
        this.fOutPrintStream = outPrintStream;
    }

    public void setPrintStreamsOf(EvalEngine engine) {
        this.fOutPrintStream = engine.fOutPrintStream;
        this.fErrorPrintStream = engine.fErrorPrintStream;
    }

    public void setPackageMode(boolean packageMode) {
        this.fPackageMode = packageMode;
    }

    public void setQuietMode(boolean quietMode) {
        this.fQuietMode = quietMode;
    }

    public void setReapList(List<IExpr> reapList) {
        this.fReapList = reapList;
    }

    public void setRecursionLimit(int i) {
        this.fRecursionLimit = i;
    }

    public void setRelaxedSyntax(boolean fRelaxedSyntax) {
        this.fRelaxedSyntax = fRelaxedSyntax;
    }

    public void setTimeConstrainedMillis(long timeConstrainedMillis) {
        this.fTimeConstrainedMillis = timeConstrainedMillis;
    }

    public void setSeconds(long fSeconds) {
        this.fSeconds = fSeconds;
    }

    public void setSessionID(String string) {
        this.fSessionID = string;
    }

    public void setStack(Deque<IExpr> stack) {
        this.fStack = stack;
    }

    public void setStepListener(IEvalStepListener stepListener) {
        this.setTraceMode(true);
        this.fTraceStack = stepListener;
    }

    public void setStopRequested(boolean stopRequested) {
        this.fStopRequested = stopRequested;
        if (stopRequested && this.fCopiedEngine != null) {
            this.fCopiedEngine.setStopRequested(true);
        }
        this.fCopiedEngine = null;
    }

    public void setTogetherMode(boolean fTogetherMode) {
        this.fTogetherMode = fTogetherMode;
    }

    public void setTraceMode(boolean b) {
        this.fTraceMode = b;
    }

    public int sizeOut() {
        return this.fEvalHistory.size();
    }

    public void stopRequest() {
        this.setStopRequested(true);
    }

    public IASTMutable threadASTListArgs(IAST ast, ISymbol commandHead, String messageShortcut) {
        ISymbol[] head = new ISymbol[]{null};
        int[] listLength = new int[]{-1};
        if (ast.exists(x -> {
            if (x.isList()) {
                if (head[0] == null) {
                    head[0] = S.List;
                }
                if (listLength[0] < 0) {
                    listLength[0] = ((IAST)x).argSize();
                } else if (listLength[0] != ((IAST)x).argSize()) {
                    IOFunctions.printMessage(commandHead, messageShortcut, F.list(ast), EvalEngine.get());
                    return true;
                }
            } else if (x.isSparseArray()) {
                ISparseArray sp;
                int[] dimensions;
                if (head[0] == null) {
                    head[0] = S.SparseArray;
                }
                if ((dimensions = (sp = (ISparseArray)x).getDimension()).length > 0) {
                    if (listLength[0] < 0) {
                        listLength[0] = dimensions[0];
                    } else if (listLength[0] != dimensions[0]) {
                        IOFunctions.printMessage(S.Thread, "tdlen", F.list(ast), EvalEngine.get());
                        return true;
                    }
                }
            }
            return false;
        })) {
            return F.NIL;
        }
        if (listLength[0] != -1) {
            IASTMutable result = EvalAttributes.threadList(ast, head[0], ast.head(), listLength[0]);
            result.addEvalFlags(1024);
            return result;
        }
        ast.addEvalFlags(1024);
        return F.NIL;
    }

    public IAST preevalForwardBackwardAST(IAST ast, int offset) {
        IASTMutable preevaled = F.NIL;
        for (int i = offset; i < ast.size(); ++i) {
            IExpr arg = ast.get(i);
            if (!arg.isAST() || !(arg = this.preevalForwardBackward((IAST)arg)).isPresent()) continue;
            if (!preevaled.isPresent()) {
                preevaled = ast.copy();
            }
            preevaled.set(i, arg);
        }
        return preevaled.orElse(ast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExpr preevalForwardBackward(IAST arg1) {
        VariablesSet variablesSet = new VariablesSet(0, arg1);
        IASTAppendable moduleVariablesList = variablesSet.getVarList();
        List<IExpr> reapList = this.getReapList();
        boolean quietMode = this.isQuietMode();
        try {
            this.setQuietMode(true);
            this.setReapList(null);
            IdentityHashMap<IExpr, ISymbol> variablesMap = new IdentityHashMap<IExpr, ISymbol>();
            IdentityHashMap<ISymbol, IExpr> dummyVariablesMap = new IdentityHashMap<ISymbol, IExpr>();
            String varAppend = EvalEngine.uniqueName("$");
            for (int i = 1; i < moduleVariablesList.size(); ++i) {
                IExpr oldSymbol = moduleVariablesList.get(i);
                ISymbol newSymbol = F.Dummy(oldSymbol.toString() + varAppend);
                variablesMap.put(oldSymbol, newSymbol);
                dummyVariablesMap.put(newSymbol, oldSymbol);
            }
            IExpr expr = arg1.replaceAll(variablesMap);
            if (expr.isPresent()) {
                IExpr temp = this.evaluate(expr);
                IExpr iExpr = temp.replaceAll(dummyVariablesMap).orElse(temp);
                return iExpr;
            }
        }
        finally {
            this.setQuietMode(quietMode);
            this.setReapList(reapList);
        }
        return F.NIL;
    }

    public static FixedPrecisionApfloatHelper getApfloat() {
        FixedPrecisionApfloatHelper h = EvalEngine.get().fApfloatHelper;
        if (h == null) {
            h = new FixedPrecisionApfloatHelper(Config.MAX_PRECISION_APFLOAT - 1L);
        }
        return h;
    }

    public int getExperimentalCounter(IBuiltInSymbol symbol) {
        Integer counter = this.experimatalSymbols.get(symbol);
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    public static void setApfloat(FixedPrecisionApfloatHelper helper) {
        EvalEngine.get().fApfloatHelper = helper;
    }

    private static class OptionsStack
    extends ArrayDeque<IdentityHashMap<ISymbol, IASTAppendable>> {
        private static final long serialVersionUID = 2720088062330091827L;

        public void push() {
            this.push(new IdentityHashMap());
        }
    }

    public static class OptionsResult {
        public IAST result;
        public int argSize;
        public IExpr[] options;

        public OptionsResult(IAST ast, int argSize, IExpr[] options) {
            this.result = ast;
            this.argSize = argSize;
            this.options = options;
        }
    }
}

