/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.StringWriter;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.TimeoutException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.math.MathException;

public class EvalControlledCallable
implements Callable<IExpr> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final EvalEngine fEngine;
    private IExpr fExpr;

    public EvalControlledCallable(EvalEngine engine) {
        this.fEngine = engine;
    }

    public void setExpr(IExpr fExpr) {
        this.fExpr = fExpr;
    }

    @Override
    public IExpr call() {
        EvalEngine.remove();
        EvalEngine.setReset(this.fEngine);
        StringWriter buf = new StringWriter();
        try {
            IExpr temp;
            IExpr preRead = S.$PreRead.assignedValue();
            try {
                temp = preRead != null && preRead.isPresent() ? this.fEngine.evaluate(F.unaryAST1(preRead, this.fExpr)) : this.fEngine.evaluate(this.fExpr);
            }
            catch (IterationLimitExceeded e) {
                int iterationLimit = this.fEngine.getIterationLimit();
                IOFunctions.printMessage(S.$IterationLimit, "itlim", F.list(iterationLimit < 0 ? F.CInfinity : F.ZZ(iterationLimit), this.fExpr), this.fEngine);
                temp = F.Hold(this.fExpr);
            }
            catch (RecursionLimitExceeded e) {
                int recursionLimit = this.fEngine.getRecursionLimit();
                IOFunctions.printMessage(S.$RecursionLimit, "reclim2", F.list(recursionLimit < 0 ? F.CInfinity : F.ZZ(recursionLimit), this.fExpr), this.fEngine);
                temp = F.Hold(this.fExpr);
            }
            if (!this.fEngine.isOutListDisabled()) {
                this.fEngine.addInOut(this.fExpr, temp);
            }
            return temp;
        }
        catch (TimeoutException e) {
            return S.$Aborted;
        }
        catch (SyntaxError se) {
            LOGGER.error("EvalControlledCallable.call() failed", (Throwable)se);
        }
        catch (RuntimeException re) {
            Throwable me = re.getCause();
            if (me instanceof MathException) {
                Validate.printException(buf, me);
            } else {
                Validate.printException(buf, re);
            }
            LOGGER.error((Object)buf);
        }
        catch (Exception | OutOfMemoryError | StackOverflowError e) {
            LOGGER.debug("EvalControlledCallable.call() failed", e);
            Validate.printException(buf, e);
            LOGGER.error((Object)buf);
        }
        return S.$Aborted;
    }

    public void cancel() {
        this.fEngine.stopRequest();
    }
}

