/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import org.matheclipse.core.eval.interfaces.INumericComplex;
import org.matheclipse.core.eval.interfaces.INumericComplexConstant;
import org.matheclipse.core.eval.interfaces.ISignedNumberConstant;
import org.matheclipse.core.eval.util.DoubleStack;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class EvalComplex {
    public static double[] eval(DoubleStack stack, int top, IExpr expr) {
        if (expr instanceof IAST) {
            return EvalComplex.evalAST(stack, top, (IAST)expr);
        }
        if (expr instanceof ISignedNumber) {
            double[] result = new double[]{((ISignedNumber)expr).doubleValue(), 0.0};
            return result;
        }
        if (expr instanceof ComplexNum) {
            double[] res = new double[]{((ComplexNum)expr).getRealPart(), ((ComplexNum)expr).getImaginaryPart()};
            return res;
        }
        if (expr instanceof ISymbol) {
            return EvalComplex.evalSymbol((ISymbol)expr);
        }
        throw new UnsupportedOperationException();
    }

    public static double[] evalAST(DoubleStack stack, int top, IAST ast) {
        IEvaluator module;
        int newTop = top;
        ISymbol symbol = (ISymbol)ast.get(0);
        if (symbol.isBuiltInSymbol() && (module = ((IBuiltInSymbol)symbol).getEvaluator()) instanceof INumericComplex) {
            stack.ensureCapacity(top + ast.size() * 2);
            for (int i = 1; i < ast.size(); ++i) {
                double[] result = EvalComplex.eval(stack, newTop, ast.get(i));
                stack.push(result[0]);
                stack.push(result[1]);
            }
            return ((INumericComplex)((Object)module)).evalComplex(stack, ast.argSize());
        }
        IExpr result = F.evaln(ast);
        if (result instanceof ComplexNum) {
            double[] res = new double[]{((ComplexNum)result).getRealPart(), ((ComplexNum)result).getImaginaryPart()};
            return res;
        }
        if (result instanceof Num) {
            double[] res = new double[]{((Num)result).doubleValue(), 0.0};
            return res;
        }
        throw new UnsupportedOperationException();
    }

    public static double[] evalSymbol(ISymbol symbol) {
        IEvaluator module;
        IExpr expr = symbol.assignedValue();
        if (expr != null) {
            if (expr instanceof ISignedNumber) {
                double[] result = new double[]{((ISignedNumber)expr).doubleValue(), 0.0};
                return result;
            }
            if (expr instanceof ComplexNum) {
                double[] result = new double[]{((ComplexNum)expr).getRealPart(), ((ComplexNum)expr).getImaginaryPart()};
                return result;
            }
        }
        if (symbol.isRealConstant()) {
            double[] result = new double[]{((ISignedNumberConstant)((Object)((IBuiltInSymbol)symbol).getEvaluator())).evalReal(), 0.0};
            return result;
        }
        if (symbol.isBuiltInSymbol() && (module = ((IBuiltInSymbol)symbol).getEvaluator()) instanceof INumericComplexConstant) {
            return ((INumericComplexConstant)((Object)module)).evalComplex();
        }
        IExpr result = F.evaln(symbol);
        if (result instanceof ComplexNum) {
            double[] res = new double[]{((ComplexNum)result).getRealPart(), ((ComplexNum)result).getImaginaryPart()};
            return res;
        }
        if (result instanceof Num) {
            double[] res = new double[]{((Num)result).doubleValue(), 0.0};
            return res;
        }
        throw new UnsupportedOperationException();
    }
}

