/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.util.Comparator;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Comparators;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.ISymbol;

public class EvalAttributes {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void checkCachedHashcode(IAST ast) {
        int hash = ast.getHashCache();
        if (hash != 0) {
            ast.clearHashCache();
            if (hash != ast.hashCode()) {
                throw new UnsupportedOperationException("Different hash codes for:" + ast.toString());
            }
        }
    }

    public static IASTAppendable flattenDeep(IAST ast) {
        IASTAppendable result;
        if ((ast.getEvalFlags() & 0x100) == 256) {
            return F.NIL;
        }
        IExpr sym = ast.head();
        if (sym.isSymbol() && ast.isAST(sym) && (result = EvalAttributes.flattenDeep((ISymbol)sym, ast)).isPresent()) {
            result.addEvalFlags(256);
            return result;
        }
        ast.addEvalFlags(256);
        return F.NIL;
    }

    public static IExpr simpleEval(IASTMutable result) {
        IASTAppendable t;
        IASTMutable temp = result;
        if (temp.isFlatAST() && (t = EvalAttributes.flatten(temp)).isPresent()) {
            temp = t;
        }
        if (temp.isOrderlessAST()) {
            IAST rest;
            EvalAttributes.sort(temp);
            if (temp.isPlus()) {
                if (temp.first().isZero()) {
                    rest = temp.rest();
                    rest.isFreeOfPatterns();
                    return rest.oneIdentity0();
                }
            } else if (temp.isTimes() && temp.first().isOne()) {
                rest = temp.rest();
                rest.isFreeOfPatterns();
                return rest.oneIdentity1();
            }
        }
        if (temp.isOneIdentityAST1()) {
            return temp.first();
        }
        temp.isFreeOfPatterns();
        return temp;
    }

    public static IASTAppendable flatten(IAST ast) {
        IASTAppendable result;
        if (ast.isEvalFlagOn(256)) {
            return F.NIL;
        }
        IExpr sym = ast.head();
        if (sym.isSymbol() && ast.isAST(sym) && (result = EvalAttributes.flatten((ISymbol)sym, ast)).isPresent()) {
            result.addEvalFlags(256);
            return result;
        }
        ast.addEvalFlags(256);
        return F.NIL;
    }

    public static IASTAppendable flattenDeep(ISymbol head, IAST ast) {
        int[] newSize = new int[]{0};
        boolean[] flattened = new boolean[]{false};
        ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)expr -> {
            if (expr.isAST(head)) {
                flattened[0] = true;
                int temp = EvalAttributes.flattenAlloc(head, (IAST)expr);
                newSize[0] = newSize[0] + temp;
            } else {
                newSize[0] = newSize[0] + 1;
            }
        }));
        if (flattened[0]) {
            IASTAppendable result = F.ast(ast.head(), newSize[0]);
            ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)expr -> {
                if (expr.isAST(head)) {
                    result.appendArgs(EvalAttributes.flattenDeep(head, (IAST)expr).orElse((IAST)expr));
                } else {
                    result.append((IExpr)expr);
                }
            }));
            return result;
        }
        return F.NIL;
    }

    public static IASTAppendable flatten(ISymbol head, IAST ast) {
        int[] newSize = new int[]{0};
        boolean[] flattened = new boolean[]{false};
        ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)expr -> {
            if (expr.isAST(head) || expr.isUnevaluated() && expr.first().head().equals(head) && expr.first().isAST()) {
                flattened[0] = true;
                int temp = ((IAST)expr).argSize();
                newSize[0] = newSize[0] + temp;
            } else {
                newSize[0] = newSize[0] + 1;
            }
        }));
        if (flattened[0]) {
            IASTAppendable result = F.ast(ast.head(), newSize[0]);
            ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)expr -> {
                if (expr.isAST(head)) {
                    result.appendArgs((IAST)expr);
                } else if (expr.isUnevaluated() && expr.first().head().equals(head) && expr.first().isAST()) {
                    IAST unevaluated = (IAST)expr.first();
                    result.appendArgs(unevaluated.map(head, x -> F.Unevaluated(x)));
                } else {
                    result.append((IExpr)expr);
                }
            }));
            return result;
        }
        return F.NIL;
    }

    public static IASTAppendable flattenAt(ISymbol head, IAST ast, int[] positions) {
        IExpr expr;
        int astSize = ast.size();
        int newSize = 0;
        boolean flattened = false;
        for (int i = 1; i < astSize; ++i) {
            expr = ast.get(i);
            if (expr.isAST() && EvalAttributes.containsPosition(i, positions)) {
                flattened = true;
                int temp = EvalAttributes.flattenAlloc(head, (IAST)expr);
                newSize += temp;
                continue;
            }
            ++newSize;
        }
        if (flattened) {
            IASTAppendable result = F.ast(ast.head(), newSize);
            for (int i = 1; i < astSize; ++i) {
                expr = ast.get(i);
                if (expr.isAST() && EvalAttributes.containsPosition(i, positions)) {
                    result.appendArgs(EvalAttributes.flattenAt(head, (IAST)expr, positions).orElse((IAST)expr));
                    continue;
                }
                result.append(expr);
            }
            return result;
        }
        return F.NIL;
    }

    private static boolean containsPosition(int position, int[] positions) {
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] != position) continue;
            return true;
        }
        return false;
    }

    public static int flattenAlloc(ISymbol head, IAST ast) {
        int[] newSize = new int[1];
        ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)expr -> {
            newSize[0] = expr.isAST(head) ? newSize[0] + EvalAttributes.flattenAlloc(head, (IAST)expr) : newSize[0] + 1;
        }));
        return newSize[0];
    }

    public static boolean flatten(ISymbol head, IAST sublist, IASTAppendable result, int recursionCounter, int level) {
        boolean[] flattened = new boolean[]{false};
        sublist.forEach(1, sublist.size(), expr -> {
            if (expr.isAST(head) && recursionCounter < level) {
                flattened[0] = true;
                EvalAttributes.flatten(head, (IAST)expr, result, recursionCounter + 1, level);
            } else {
                result.append((IExpr)expr);
            }
        });
        return flattened[0];
    }

    public static final IAST copySort(IAST ast) {
        IASTMutable sortedList = ast.copy();
        EvalAttributes.sort(sortedList);
        return sortedList;
    }

    public static final IAST copySortLess(IAST ast) {
        IASTMutable sortedList = ast.copy();
        EvalAttributes.sortLess(sortedList);
        return sortedList;
    }

    public static final boolean sortLess(IASTMutable ast) {
        return EvalAttributes.sort(ast, new Predicates.IsBinaryFalse(S.Less));
    }

    public static final boolean sort(IASTMutable ast) {
        int astSize = ast.size();
        if (astSize > 2) {
            switch (astSize) {
                case 3: {
                    return EvalAttributes.sort2Args(ast, false);
                }
                case 4: {
                    return EvalAttributes.sort3Args(ast, false);
                }
            }
            if (EvalAttributes.sort(ast, Comparators.CANONICAL_COMPARATOR)) {
                if (LOGGER.isDebugEnabled()) {
                    EvalAttributes.checkCachedHashcode(ast);
                }
                return true;
            }
        }
        return false;
    }

    public static final boolean sortWithFlags(IASTMutable ast) {
        if (ast.isEvalFlagOn(512)) {
            return false;
        }
        int astSize = ast.size();
        if (astSize > 2) {
            switch (astSize) {
                case 3: {
                    return EvalAttributes.sort2Args(ast, true);
                }
                case 4: {
                    return EvalAttributes.sort3Args(ast, true);
                }
            }
            if (EvalAttributes.sort(ast, Comparators.CANONICAL_COMPARATOR)) {
                ast.addEvalFlags(512);
                if (LOGGER.isDebugEnabled()) {
                    EvalAttributes.checkCachedHashcode(ast);
                }
                return true;
            }
        }
        ast.addEvalFlags(512);
        return false;
    }

    public static final boolean isSorted(IAST ast, Comparator<IExpr> comparator) {
        return EvalAttributes.isSorted(ast, 1, comparator);
    }

    public static final boolean isSorted(IAST ast, int fromPosition, Comparator<IExpr> comparator) {
        if (ast.size() < fromPosition + 2) {
            return true;
        }
        IExpr previous = ast.get(fromPosition);
        for (int i = fromPosition + 1; i < ast.size(); ++i) {
            IExpr current = ast.get(i);
            if (comparator.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static final boolean sort(IASTMutable ast, Comparator<IExpr> comparator) {
        if (ast.isAssociation()) {
            throw new UnsupportedOperationException("Sort(list, comparator) not implemented for associations.");
        }
        if (ast.size() > 2 && !EvalAttributes.isSorted(ast, comparator)) {
            ast.sortInplace(comparator);
            return true;
        }
        return false;
    }

    private static boolean sort2Args(IASTMutable ast, boolean setFlag) {
        if (ast.arg1().compareTo(ast.arg2()) > 0) {
            IExpr temp = ast.arg2();
            ast.set(2, ast.arg1());
            ast.set(1, temp);
            if (setFlag) {
                ast.addEvalFlags(512);
            }
            if (LOGGER.isDebugEnabled()) {
                EvalAttributes.checkCachedHashcode(ast);
            }
            return true;
        }
        if (setFlag) {
            ast.addEvalFlags(512);
        }
        return false;
    }

    private static boolean sort3Args(IASTMutable ast, boolean setFlag) {
        IExpr temp;
        boolean evaled = false;
        if (ast.arg1().compareTo(ast.arg2()) > 0) {
            temp = ast.arg2();
            ast.set(2, ast.arg1());
            ast.set(1, temp);
            evaled = true;
        }
        if (ast.arg2().compareTo(ast.arg3()) > 0) {
            temp = ast.arg3();
            ast.set(3, ast.arg2());
            ast.set(2, temp);
            evaled = true;
            if (ast.arg1().compareTo(ast.arg2()) > 0) {
                temp = ast.arg2();
                ast.set(2, ast.arg1());
                ast.set(1, temp);
            }
        }
        if (setFlag) {
            ast.addEvalFlags(512);
        }
        if (evaled && LOGGER.isDebugEnabled()) {
            EvalAttributes.checkCachedHashcode(ast);
        }
        return evaled;
    }

    public static IASTMutable threadList(IAST ast, IExpr listHead, IExpr argHead, int listLength) {
        if (listLength == 0) {
            return F.headAST0(listHead);
        }
        IASTMutable result = F.NIL;
        int listSize = ast.size();
        for (int j = 1; j < listLength + 1; ++j) {
            IASTMutable subResult = F.astMutable(argHead, listSize - 1);
            for (int i = 1; i < listSize; ++i) {
                IExpr arg;
                if (listHead == S.List && (ast.get(i).isList() || ast.get(i).isSparseArray())) {
                    if (ast.get(i).isList()) {
                        arg = (IAST)ast.get(i);
                        subResult.set(i, arg.get(j));
                        continue;
                    }
                    if (!ast.get(i).isSparseArray()) continue;
                    arg = (ISparseArray)ast.get(i);
                    subResult.set(i, arg.get(j));
                    continue;
                }
                if (listHead == S.SparseArray) {
                    if (ast.get(i).isList()) {
                        arg = (IAST)ast.get(i);
                        if (j >= arg.size()) {
                            return F.NIL;
                        }
                        subResult.set(i, arg.get(j));
                        continue;
                    }
                    if (ast.get(i).isSparseArray()) {
                        arg = (ISparseArray)ast.get(i);
                        if (j >= arg.size()) {
                            return F.NIL;
                        }
                        subResult.set(i, arg.get(j));
                        continue;
                    }
                    subResult.set(i, ast.get(i));
                    continue;
                }
                if (ast.get(i).isAST(listHead)) {
                    arg = (IAST)ast.get(i);
                    subResult.set(i, arg.get(j));
                    continue;
                }
                subResult.set(i, ast.get(i));
            }
            if (!result.isPresent()) {
                IExpr head = listHead == S.SparseArray ? S.List : listHead;
                switch (listLength) {
                    case 1: {
                        result = F.unaryAST1(head, F.Slot1);
                        break;
                    }
                    case 2: {
                        result = F.binaryAST2(head, F.Slot1, (IExpr)F.Slot2);
                        break;
                    }
                    case 3: {
                        result = F.ternaryAST3(head, F.Slot1, F.Slot2, F.Slot3);
                        break;
                    }
                    default: {
                        result = F.astMutable(head, listLength);
                    }
                }
            }
            result.set(j, subResult);
        }
        if (listHead == S.SparseArray) {
            return F.unaryAST1(S.SparseArray, result);
        }
        return result;
    }

    private EvalAttributes() {
    }
}

