/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.eval.interfaces.ISignedNumberConstant;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class DoubleStackEvaluator {
    public static double evalSymbol(ISymbol symbol) {
        IExpr value = symbol.assignedValue();
        if (value != null) {
            return ((ISignedNumber)value).doubleValue();
        }
        if (symbol.isRealConstant()) {
            return ((ISignedNumberConstant)((Object)((IBuiltInSymbol)symbol).getEvaluator())).evalReal();
        }
        IExpr result = F.evaln(symbol);
        if (result.isReal()) {
            return ((ISignedNumber)result).doubleValue();
        }
        if (result.isInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (result.isNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (result.isIndeterminate()) {
            return Double.NaN;
        }
        throw new UnsupportedOperationException("EvalDouble#evalSymbol() - no value assigned for symbol: " + symbol);
    }

    public static double evalAST(double[] stack, int top, IAST ast) {
        IBuiltInSymbol symbol;
        IEvaluator module;
        if (ast.head().isBuiltInSymbol() && (module = (symbol = (IBuiltInSymbol)ast.head()).getEvaluator()) instanceof INumeric) {
            int newTop = top;
            if (top + ast.size() >= stack.length) {
                stack = new double[ast.size() + 50];
            }
            for (int i = 1; i < ast.size(); ++i) {
                stack[++newTop] = DoubleStackEvaluator.eval(stack, newTop, ast.get(i));
            }
            return ((INumeric)((Object)module)).evalReal(stack, newTop, ast.argSize());
        }
        IExpr result = F.evaln(ast);
        if (result.isReal()) {
            return ((ISignedNumber)result).doubleValue();
        }
        if (result instanceof IComplexNum && F.isZero(((IComplexNum)result).imDoubleValue())) {
            return ((IComplexNum)result).reDoubleValue();
        }
        throw new UnsupportedOperationException("EvalDouble#evalAST(): " + ast);
    }

    public static double eval(double[] stack, int top, IExpr expr) {
        if (expr instanceof IAST) {
            return DoubleStackEvaluator.evalAST(stack, top, (IAST)expr);
        }
        if (expr instanceof ISignedNumber) {
            return ((ISignedNumber)expr).doubleValue();
        }
        if (expr instanceof IComplexNum && F.isZero(((IComplexNum)expr).imDoubleValue())) {
            return ((IComplexNum)expr).reDoubleValue();
        }
        if (expr instanceof ISymbol) {
            return DoubleStackEvaluator.evalSymbol((ISymbol)expr);
        }
        throw new UnsupportedOperationException("EvalDouble#eval(): " + expr);
    }
}

