/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.data;

import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.data.ElementData1;
import org.matheclipse.core.data.ElementData2;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class ElementData
extends AbstractFunctionEvaluator {
    public static final String[] PROPERTIES_DATA = new String[]{"StandardName", "AtomicNumber", "Abbreviation", "AbsoluteBoilingPoint", "AbsoluteMeltingPoint", "AtomicRadius", "AtomicWeight", "Block", "BoilingPoint", "BrinellHardness", "BulkModulus", "CovalentRadius", "CrustAbundance", "Density", "DiscoveryYear", "ElectroNegativity", "ElectronAffinity", "ElectronConfiguration", "ElectronConfigurationString", "ElectronShellConfiguration", "FusionHeat", "Group", "IonizationEnergies", "LiquidDensity", "MeltingPoint", "MohsHardness", "Name", "Period", "PoissonRatio", "Series", "ShearModulus", "SpecificHeat", "ThermalConductivity", "VanDerWaalsRadius", "VaporizationHeat", "VickersHardness", "YoungModulus"};
    private static Map<IExpr, IExpr> MAP_NUMBER_NAME = new HashMap<IExpr, IExpr>();
    private static Map<IExpr, IAST> MAP_NAME_DATA = new HashMap<IExpr, IAST>();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IAST temp;
        if (ast.size() == 2) {
            IExpr temp2;
            if (ast.arg1().isInteger() && (temp2 = MAP_NUMBER_NAME.get(ast.arg1())) != null) {
                return temp2;
            }
            if (ast.arg1() instanceof IStringX && ast.arg1().toString().equals("Properties")) {
                IASTAppendable list = F.ListAlloc(PROPERTIES_DATA.length);
                for (int i = 0; i < PROPERTIES_DATA.length; ++i) {
                    list.append(F.$str(PROPERTIES_DATA[i]));
                }
                return list;
            }
        } else if ((ast.arg1() instanceof IStringX || ast.arg1().isInteger()) && (temp = MAP_NAME_DATA.get(ast.arg1())) != null) {
            return this.dataPoint(ast, temp);
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_2;
    }

    private IExpr dataPoint(IAST ast, IAST propertyList) {
        String propertyStr = ast.arg2().toString();
        if (propertyStr.equals("AtomicNumber")) {
            return propertyList.arg1();
        }
        if (propertyStr.equals("Abbreviation")) {
            return propertyList.arg2();
        }
        if (propertyStr.equals("StandardName")) {
            return propertyList.arg3();
        }
        if (propertyStr.equals("Name")) {
            return propertyList.arg4();
        }
        if (propertyStr.equals("Block")) {
            return propertyList.arg5();
        }
        if (propertyStr.equals("Group")) {
            return propertyList.get(6);
        }
        if (propertyStr.equals("Period")) {
            return propertyList.get(7);
        }
        if (propertyStr.equals("Series")) {
            return propertyList.get(8);
        }
        if (propertyStr.equals("AtomicWeight")) {
            return propertyList.get(9);
        }
        if (propertyStr.equals("DiscoveryYear")) {
            return propertyList.get(10);
        }
        if (propertyStr.equals("LiquidDensity")) {
            return propertyList.get(11);
        }
        if (propertyStr.equals("Density")) {
            return propertyList.get(12);
        }
        if (propertyStr.equals("AbsoluteMeltingPoint")) {
            return propertyList.get(13);
        }
        if (propertyStr.equals("MeltingPoint")) {
            return propertyList.get(14);
        }
        if (propertyStr.equals("AbsoluteBoilingPoint")) {
            return propertyList.get(15);
        }
        if (propertyStr.equals("BoilingPoint")) {
            return propertyList.get(16);
        }
        if (propertyStr.equals("SpecificHeat")) {
            return propertyList.get(17);
        }
        if (propertyStr.equals("FusionHeat")) {
            return propertyList.get(18);
        }
        if (propertyStr.equals("VaporizationHeat")) {
            return propertyList.get(19);
        }
        if (propertyStr.equals("ElectroNegativity")) {
            return propertyList.get(20);
        }
        if (propertyStr.equals("CrustAbundance")) {
            return propertyList.get(21);
        }
        if (propertyStr.equals("MohsHardness")) {
            return propertyList.get(22);
        }
        if (propertyStr.equals("VickersHardness")) {
            return propertyList.get(23);
        }
        if (propertyStr.equals("BrinellHardness")) {
            return propertyList.get(24);
        }
        if (propertyStr.equals("AtomicRadius")) {
            return propertyList.get(25);
        }
        if (propertyStr.equals("VanDerWaalsRadius")) {
            return propertyList.get(26);
        }
        if (propertyStr.equals("CovalentRadius")) {
            return propertyList.get(27);
        }
        if (propertyStr.equals("IonizationEnergies")) {
            return propertyList.get(28);
        }
        if (propertyStr.equals("ElectronAffinity")) {
            return propertyList.get(29);
        }
        if (propertyStr.equals("ThermalConductivity")) {
            return propertyList.get(30);
        }
        if (propertyStr.equals("YoungModulus")) {
            return propertyList.get(31);
        }
        if (propertyStr.equals("PoissonRatio")) {
            return propertyList.get(32);
        }
        if (propertyStr.equals("BulkModulus")) {
            if (propertyList.size() > 33) {
                return propertyList.get(33);
            }
            return F.Missing(S.NotAvailable);
        }
        if (propertyStr.equals("ShearModulus")) {
            if (propertyList.size() > 34) {
                return propertyList.get(34);
            }
            return F.Missing(S.NotAvailable);
        }
        if (propertyStr.equals("ElectronConfiguration")) {
            if (propertyList.size() > 35) {
                return propertyList.get(35);
            }
            return F.Missing(S.NotAvailable);
        }
        if (propertyStr.equals("ElectronConfigurationString")) {
            if (propertyList.size() > 36) {
                return propertyList.get(36);
            }
            return F.Missing(S.NotAvailable);
        }
        if (propertyStr.equals("ElectronShellConfiguration")) {
            if (propertyList.size() > 37) {
                return propertyList.get(37);
            }
            return F.Missing(S.NotAvailable);
        }
        return F.NIL;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        int j;
        IASTAppendable subList;
        int i;
        IAST[] list = ElementData1.ELEMENTS;
        for (i = 0; i < list.length; ++i) {
            MAP_NUMBER_NAME.put(list[i].arg1(), list[i].arg3());
            subList = F.ListAlloc(list[i].size());
            for (j = 1; j < list[i].size(); ++j) {
                subList.append(list[i].get(j));
            }
            MAP_NAME_DATA.put(list[i].arg1(), subList);
            MAP_NAME_DATA.put(list[i].arg2(), subList);
            MAP_NAME_DATA.put(list[i].arg3(), subList);
        }
        list = ElementData2.ELEMENTS;
        for (i = 0; i < list.length; ++i) {
            MAP_NUMBER_NAME.put(list[i].arg1(), list[i].arg3());
            subList = F.ListAlloc(list[i].size());
            for (j = 1; j < list[i].size(); ++j) {
                subList.append(list[i].get(j));
            }
            MAP_NAME_DATA.put(list[i].arg1(), subList);
            MAP_NAME_DATA.put(list[i].arg2(), subList);
            MAP_NAME_DATA.put(list[i].arg3(), subList);
        }
    }
}

