/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.AbstractVisitorBoolean;
import org.matheclipse.core.visit.VisitorCollectionBoolean;

public class VariablesSet {
    private final Set<IExpr> fVariablesSet = new TreeSet<IExpr>();

    public static IAST addAlgebraicVariables(Set<IExpr> fVariablesSet, IExpr expr) {
        expr.accept(new AlgebraVariablesVisitor((Collection<IExpr>)fVariablesSet));
        Iterator<IExpr> iter = fVariablesSet.iterator();
        IASTAppendable list = F.ListAlloc(fVariablesSet.size());
        while (iter.hasNext()) {
            list.append(iter.next());
        }
        return list;
    }

    public static IAST addVariables(Set<IExpr> fVariablesSet, IExpr expr) {
        expr.accept(new VariablesVisitor((Collection<IExpr>)fVariablesSet));
        Iterator<IExpr> iter = fVariablesSet.iterator();
        IASTAppendable list = F.ListAlloc(fVariablesSet.size());
        while (iter.hasNext()) {
            list.append(iter.next());
        }
        return list;
    }

    public static IAST getAlgebraicVariables(IExpr expr) {
        TreeSet<IExpr> fVariablesSet = new TreeSet<IExpr>();
        return VariablesSet.addAlgebraicVariables(fVariablesSet, expr);
    }

    public static IAST getVariables(IExpr expr) {
        TreeSet<IExpr> fVariablesSet = new TreeSet<IExpr>();
        return VariablesSet.addVariables(fVariablesSet, expr);
    }

    public static Predicate<IExpr> isFree(final VariablesSet exprVar) {
        return new Predicate<IExpr>(){
            final IsMemberVisitor visitor;
            {
                this.visitor = new IsMemberVisitor();
            }

            @Override
            public boolean test(IExpr input) {
                return !input.accept(this.visitor);
            }
        };
    }

    public VariablesSet() {
    }

    public VariablesSet(IExpr expression) {
        expression.accept(new VariablesVisitor((Collection<IExpr>)this.fVariablesSet));
    }

    public VariablesSet(int offset, IExpr expression) {
        expression.accept(new VariablesVisitor(offset, (Collection<IExpr>)this.fVariablesSet));
    }

    public void add(IExpr symbol) {
        symbol.accept(new VariablesVisitor((Collection<IExpr>)this.fVariablesSet));
    }

    public boolean addAll(Set<? extends IExpr> symbols) {
        return this.fVariablesSet.addAll(symbols);
    }

    public void addBooleanVarList(IExpr expression) {
        expression.accept(new BooleanVariablesVisitor((Collection<IExpr>)this.fVariablesSet));
    }

    public void addVarList(IAST ast, int fromIndex) {
        for (int i = fromIndex; i < ast.size(); ++i) {
            IExpr temp = ast.get(i);
            if (temp.isRuleAST()) {
                return;
            }
            temp.accept(new VariablesVisitor((Collection<IExpr>)this.fVariablesSet));
        }
    }

    public void addVarList(IExpr expression) {
        expression.accept(new VariablesVisitor((Collection<IExpr>)this.fVariablesSet));
    }

    public List<IExpr> appendToList(IAST ast) {
        ArrayList<IExpr> list = new ArrayList<IExpr>();
        for (int i = 1; i < ast.size(); ++i) {
            list.add(ast.get(i));
        }
        return list;
    }

    public List<IExpr> appendToList(List<IExpr> list) {
        Iterator<IExpr> iter = this.fVariablesSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public void clear() {
        this.fVariablesSet.clear();
    }

    public boolean contains(IExpr o) {
        return this.fVariablesSet.contains(o);
    }

    public boolean containsAll(Collection<? extends IExpr> c) {
        return this.fVariablesSet.containsAll(c);
    }

    public List<IExpr> getArrayList() {
        Iterator<IExpr> iter = this.fVariablesSet.iterator();
        ArrayList<IExpr> list = new ArrayList<IExpr>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public IASTAppendable getVarList() {
        Iterator<IExpr> iter = this.fVariablesSet.iterator();
        IASTAppendable list = F.ListAlloc(this.fVariablesSet.size());
        while (iter.hasNext()) {
            list.append(iter.next());
        }
        return list;
    }

    public String[] getVarListAsString() {
        String[] result = new String[this.fVariablesSet.size()];
        Iterator<IExpr> iter = this.fVariablesSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = iter.next().toString();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.fVariablesSet.isEmpty();
    }

    public boolean isSize(int numberOfVars) {
        return this.fVariablesSet.size() == numberOfVars;
    }

    public int size() {
        return this.fVariablesSet.size();
    }

    public IExpr[] toArray(IExpr[] a) {
        return this.fVariablesSet.toArray(a);
    }

    public void putAllSymbols(Map<ISymbol, IExpr> scopedVariablesMap) {
        for (IExpr expr : this.fVariablesSet) {
            if (!expr.isSymbol()) continue;
            scopedVariablesMap.put((ISymbol)expr, F.NIL);
        }
    }

    public String toString() {
        return "VariablesSet = " + this.fVariablesSet.toString();
    }

    static class VariablesVisitor
    extends VisitorCollectionBoolean<IExpr> {
        public VariablesVisitor(int offset, Collection<IExpr> collection) {
            super(offset, collection);
        }

        public VariablesVisitor(Collection<IExpr> collection) {
            this(1, collection);
        }

        @Override
        public boolean visit(IAST list) {
            if (!list.isPresent()) {
                return false;
            }
            if (list instanceof ASTSeriesData) {
                this.fCollection.add(((ASTSeriesData)list).getX());
                return true;
            }
            IExpr head = list.head();
            if (head.isVariable() && list.forAll(x -> x.isInteger()) && !list.isNumericFunction(true)) {
                this.fCollection.add(list);
                return true;
            }
            return super.visit(list);
        }

        @Override
        public boolean visit(ISymbol symbol) {
            if (symbol.isVariable()) {
                this.fCollection.add(symbol);
                return true;
            }
            return false;
        }
    }

    class IsMemberVisitor
    extends AbstractVisitorBoolean {
        @Override
        public boolean visit(IAST list) {
            return list.exists(x -> x.accept(this));
        }

        @Override
        public boolean visit(ISymbol symbol) {
            if (symbol.isVariable()) {
                return VariablesSet.this.fVariablesSet.contains(symbol);
            }
            return false;
        }
    }

    static class BooleanVariablesVisitor
    extends VisitorCollectionBoolean<IExpr> {
        public BooleanVariablesVisitor(Collection<IExpr> collection) {
            super(collection);
        }

        @Override
        public boolean visit(IAST ast) {
            ISymbol[] logicEquationHeads = new ISymbol[]{S.And, S.Or, S.Not, S.Xor, S.Nand, S.Nor, S.Implies, S.Equivalent, S.Equal, S.Unequal};
            for (int i = 0; i < logicEquationHeads.length; ++i) {
                if (!ast.isAST(logicEquationHeads[i])) continue;
                ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> x.accept(this)));
                break;
            }
            return false;
        }

        @Override
        public boolean visit(ISymbol symbol) {
            if (symbol.isVariable()) {
                this.fCollection.add(symbol);
                return true;
            }
            return false;
        }
    }

    static class AlgebraVariablesVisitor
    extends VisitorCollectionBoolean<IExpr> {
        public AlgebraVariablesVisitor(Collection<IExpr> collection) {
            super(collection);
        }

        @Override
        public boolean visit(IAST list) {
            if (list.isList() || list.isPlus() || list.isTimes()) {
                list.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> x.accept(this)));
                return false;
            }
            if (list.isPower()) {
                IExpr base = list.base();
                IExpr exponent = list.exponent();
                if (exponent.isRational()) {
                    list.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> x.accept(this)));
                    return false;
                }
                if (exponent.isNumber()) {
                    this.fCollection.add(list);
                } else if (!base.isNumericFunction(true)) {
                    this.fCollection.add(list);
                }
            } else if (!(list.head().isBuiltInSymbol() && !((ISymbol)list.head()).isNumericFunctionAttribute() || list.isNumericFunction(true))) {
                this.fCollection.add(list);
            }
            return true;
        }

        @Override
        public boolean visit(ISymbol symbol) {
            if (symbol.isVariable()) {
                this.fCollection.add(symbol);
                return true;
            }
            return false;
        }
    }
}

