/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import java.io.Serializable;

public class RGBColor
implements Serializable {
    private static final long serialVersionUID = 9105970624690865276L;
    public static final RGBColor white;
    public static final RGBColor WHITE;
    public static final RGBColor lightGray;
    public static final RGBColor LIGHT_GRAY;
    public static final RGBColor gray;
    public static final RGBColor GRAY;
    public static final RGBColor darkGray;
    public static final RGBColor DARK_GRAY;
    public static final RGBColor black;
    public static final RGBColor BLACK;
    public static final RGBColor red;
    public static final RGBColor RED;
    public static final RGBColor pink;
    public static final RGBColor PINK;
    public static final RGBColor orange;
    public static final RGBColor ORANGE;
    public static final RGBColor yellow;
    public static final RGBColor YELLOW;
    public static final RGBColor green;
    public static final RGBColor GREEN;
    public static final RGBColor magenta;
    public static final RGBColor MAGENTA;
    public static final RGBColor cyan;
    public static final RGBColor CYAN;
    public static final RGBColor blue;
    public static final RGBColor BLUE;
    int value;
    private float[] frgbvalue;
    private float[] fvalue;
    private float falpha;
    private static final double SCALE_FACTOR = 0.7;
    private static final int MIN_SCALABLE = 3;

    public RGBColor(int rgba, boolean hasAlpha) {
        this.value = !hasAlpha ? rgba | 0xFF000000 : rgba;
    }

    public RGBColor(int r, int g, int b, int a) {
        if ((r & 0xFF) != r || (g & 0xFF) != g || (b & 0xFF) != b || (a & 0xFF) != a) {
            throw new IllegalArgumentException("RGBColor parameter outside of expected range");
        }
        this.value = b | g << 8 | r << 16 | a << 24;
    }

    public RGBColor(int r, int g, int b) {
        if ((r & 0xFF) != r || (g & 0xFF) != g || (b & 0xFF) != b) {
            throw new IllegalArgumentException("RGBColor parameter outside of expected range");
        }
        this.value = b | g << 8 | r << 16 | 0xFF000000;
    }

    public RGBColor(int rgb) {
        this.value = rgb | 0xFF000000;
    }

    public RGBColor(float r, float g, float b, float a) {
        this((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5), (int)((double)(a * 255.0f) + 0.5));
        this.falpha = a;
        this.fvalue = new float[3];
        this.fvalue[0] = r;
        this.fvalue[1] = g;
        this.fvalue[2] = b;
        this.frgbvalue = this.fvalue;
    }

    public RGBColor(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof RGBColor) {
            return ((RGBColor)obj).value == this.value;
        }
        return false;
    }

    public RGBColor darker() {
        return new RGBColor((int)((double)this.getRed() * 0.7), (int)((double)this.getGreen() * 0.7), (int)((double)this.getBlue() * 0.7));
    }

    public RGBColor brighter() {
        int r = this.getRed();
        int b = this.getBlue();
        int g = this.getGreen();
        if (r == 0 && b == 0 && g == 0) {
            return new RGBColor(3, 3, 3);
        }
        if (r < 3 && r != 0) {
            r = 3;
        } else {
            int n = r = (r = (int)((double)r / 0.7)) > 255 ? 255 : r;
        }
        if (b < 3 && b != 0) {
            b = 3;
        } else {
            int n = b = (b = (int)((double)b / 0.7)) > 255 ? 255 : b;
        }
        g = g < 3 && g != 0 ? 3 : ((g = (int)((double)g / 0.7)) > 255 ? 255 : g);
        return new RGBColor(r, g, b);
    }

    public float[] getRGBComponents(float[] components) {
        if (components == null) {
            components = new float[4];
        }
        components[3] = this.frgbvalue != null ? this.falpha : (float)this.getAlpha() / 255.0f;
        this.getRGBColorComponents(components);
        return components;
    }

    public float[] getRGBColorComponents(float[] components) {
        if (components == null) {
            components = new float[3];
        }
        if (this.frgbvalue != null) {
            components[2] = this.frgbvalue[2];
            components[1] = this.frgbvalue[1];
            components[0] = this.frgbvalue[0];
        } else {
            components[2] = (float)this.getBlue() / 255.0f;
            components[1] = (float)this.getGreen() / 255.0f;
            components[0] = (float)this.getRed() / 255.0f;
        }
        return components;
    }

    public float[] getComponents(float[] components) {
        if (this.fvalue == null) {
            return this.getRGBComponents(components);
        }
        int nColorComps = this.fvalue.length;
        if (components == null) {
            components = new float[nColorComps + 1];
        }
        this.getColorComponents(components);
        components[nColorComps] = this.falpha;
        return components;
    }

    public float[] getColorComponents(float[] components) {
        if (this.fvalue == null) {
            return this.getRGBColorComponents(components);
        }
        if (components == null) {
            components = new float[this.fvalue.length];
        }
        for (int i = 0; i < this.fvalue.length; ++i) {
            components[i] = this.fvalue[i];
        }
        return components;
    }

    public int hashCode() {
        return this.value;
    }

    public int getRed() {
        return this.value >> 16 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public int getGreen() {
        return this.value >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.value & 0xFF;
    }

    public int getAlpha() {
        return this.value >> 24 & 0xFF;
    }

    public static RGBColor getColor(String nm, RGBColor def) {
        Integer integer = Integer.getInteger(nm);
        if (integer == null) {
            return def;
        }
        return new RGBColor(integer);
    }

    public static RGBColor getColor(String nm, int def) {
        Integer integer = Integer.getInteger(nm);
        if (integer == null) {
            return new RGBColor(def);
        }
        return new RGBColor(integer);
    }

    public static RGBColor getColor(String nm) {
        Integer integer = Integer.getInteger(nm);
        if (integer == null) {
            return null;
        }
        return new RGBColor(integer);
    }

    public static RGBColor decode(String nm) throws NumberFormatException {
        Integer integer = Integer.decode(nm);
        return new RGBColor(integer);
    }

    public static RGBColor getHSBColor(float h, float s, float b) {
        return new RGBColor(RGBColor.HSBtoRGB(h, s, b));
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float H;
        float S2;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int V = Math.max(b, Math.max(r, g));
        int temp = Math.min(b, Math.min(r, g));
        float B = (float)V / 255.0f;
        if (V == temp) {
            S2 = 0.0f;
            H = 0.0f;
        } else {
            S2 = (float)(V - temp) / (float)V;
            float Cr = (float)(V - r) / (float)(V - temp);
            float Cg = (float)(V - g) / (float)(V - temp);
            float Cb = (float)(V - b) / (float)(V - temp);
            H = r == V ? Cb - Cg : (g == V ? 2.0f + Cr - Cb : 4.0f + Cg - Cr);
            if ((H /= 6.0f) < 0.0f) {
                H += 1.0f;
            }
        }
        hsbvals[0] = H;
        hsbvals[1] = S2;
        hsbvals[2] = B;
        return hsbvals;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        float fr;
        float fg;
        float fb;
        if (saturation == 0.0f) {
            fg = fb = brightness;
            fr = fb;
        } else {
            float H = (hue - (float)Math.floor(hue)) * 6.0f;
            int I2 = (int)Math.floor(H);
            float F2 = H - (float)I2;
            float M = brightness * (1.0f - saturation);
            float N2 = brightness * (1.0f - saturation * F2);
            float K = brightness * (1.0f - saturation * (1.0f - F2));
            switch (I2) {
                case 0: {
                    fr = brightness;
                    fg = K;
                    fb = M;
                    break;
                }
                case 1: {
                    fr = N2;
                    fg = brightness;
                    fb = M;
                    break;
                }
                case 2: {
                    fr = M;
                    fg = brightness;
                    fb = K;
                    break;
                }
                case 3: {
                    fr = M;
                    fg = N2;
                    fb = brightness;
                    break;
                }
                case 4: {
                    fr = K;
                    fg = M;
                    fb = brightness;
                    break;
                }
                case 5: {
                    fr = brightness;
                    fg = M;
                    fb = N2;
                    break;
                }
                default: {
                    fg = 0.0f;
                    fb = 0.0f;
                    fr = 0.0f;
                }
            }
        }
        int r = (int)((double)fr * 255.0 + 0.5);
        int g = (int)((double)fg * 255.0 + 0.5);
        int b = (int)((double)fb * 255.0 + 0.5);
        return r << 16 | g << 8 | b | 0xFF000000;
    }

    static {
        WHITE = white = new RGBColor(255, 255, 255);
        LIGHT_GRAY = lightGray = new RGBColor(192, 192, 192);
        GRAY = gray = new RGBColor(128, 128, 128);
        DARK_GRAY = darkGray = new RGBColor(64, 64, 64);
        BLACK = black = new RGBColor(0, 0, 0);
        RED = red = new RGBColor(255, 0, 0);
        PINK = pink = new RGBColor(255, 175, 175);
        ORANGE = orange = new RGBColor(255, 200, 0);
        YELLOW = yellow = new RGBColor(255, 255, 0);
        GREEN = green = new RGBColor(0, 255, 0);
        MAGENTA = magenta = new RGBColor(255, 0, 255);
        CYAN = cyan = new RGBColor(0, 255, 255);
        BLUE = blue = new RGBColor(0, 0, 255);
    }
}

