/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apfloat.Apfloat;
import org.hipparchus.complex.Complex;
import org.hipparchus.fraction.Fraction;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.DateObjectExpr;
import org.matheclipse.core.expression.data.JavaObjectExpr;
import org.matheclipse.core.expression.data.TimeObjectExpr;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;

public class Object2Expr {
    public static IExpr convert(Object obj, boolean parseString, boolean javaObject) {
        if (obj == null) {
            return S.Null;
        }
        if (obj instanceof IExpr) {
            return (IExpr)obj;
        }
        if (obj instanceof String) {
            if (parseString) {
                ExprParser parser = new ExprParser(EvalEngine.get());
                return parser.parse((String)obj);
            }
            return F.stringx((String)obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? S.True : S.False;
        }
        if (obj instanceof Number) {
            if (obj instanceof Fraction) {
                Fraction frac = (Fraction)obj;
                return F.fraction(frac.getNumerator(), frac.getDenominator());
            }
            return Object2Expr.convert((Number)obj);
        }
        if (obj instanceof Collection) {
            return Object2Expr.convertList((Collection)obj, parseString, javaObject);
        }
        if (obj instanceof Complex) {
            Complex cmp = (Complex)obj;
            return F.complexNum(cmp.getReal(), cmp.getImaginary());
        }
        if (obj instanceof int[]) {
            return F.ast((ISymbol)S.List, (int[])obj);
        }
        if (obj instanceof double[]) {
            return new ASTRealVector((double[])obj, true);
        }
        if (obj instanceof double[][]) {
            return new ASTRealMatrix((double[][])obj, true);
        }
        if (obj instanceof Complex[]) {
            return F.ast((ISymbol)S.List, (Complex[])obj);
        }
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            int length = array.length;
            IASTAppendable list = F.ListAlloc(length);
            return list.appendArgs(0, length, i -> Object2Expr.convert(array[i], parseString, javaObject));
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            IASTAppendable list = F.ListAlloc(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.append(array[i2] ? S.True : S.False);
            }
            return list;
        }
        if (obj instanceof LocalDateTime) {
            return DateObjectExpr.newInstance((LocalDateTime)obj);
        }
        if (obj instanceof LocalTime) {
            return TimeObjectExpr.newInstance((LocalTime)obj);
        }
        if (javaObject) {
            return JavaObjectExpr.newInstance(obj);
        }
        return F.$str(obj.toString());
    }

    public static IExpr convertString(Object obj) {
        if (obj instanceof String) {
            return F.stringx((String)obj);
        }
        return Object2Expr.convert(obj, true, false);
    }

    private static IExpr convert(Number n) {
        if (n instanceof Integer) {
            return F.ZZ(((Integer)n).longValue());
        }
        if (n instanceof Double) {
            return F.num((Double)n);
        }
        if (n instanceof Long) {
            return F.ZZ((Long)n);
        }
        if (n instanceof BigInteger) {
            return F.ZZ((BigInteger)n);
        }
        if (n instanceof BigDecimal) {
            return F.num(new Apfloat((BigDecimal)n));
        }
        if (n instanceof Float) {
            return F.num(((Float)n).doubleValue());
        }
        if (n instanceof AtomicDouble) {
            return F.num(((AtomicDouble)n).doubleValue());
        }
        if (n instanceof AtomicInteger) {
            return F.ZZ(((AtomicInteger)n).longValue());
        }
        if (n instanceof AtomicLong) {
            return F.ZZ(((AtomicLong)n).longValue());
        }
        return F.num(n.doubleValue());
    }

    public static IExpr convertList(Collection<?> lst, boolean parseString, boolean javaObject) {
        if (lst.size() == 0) {
            return F.List();
        }
        int size = lst.size();
        IASTAppendable list = F.ast((IExpr)S.List, size);
        for (Object element : lst) {
            list.append(Object2Expr.convert(element, parseString, javaObject));
        }
        return list;
    }

    public static IASTMutable convertComplex(boolean evalComplex, Complex[] array) {
        return F.ast(S.List, evalComplex, array);
    }
}

