/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class JASModInteger {
    private final ModLongRing fRingFactory;
    private final TermOrder fTermOrder;
    private final GenPolynomialRing<ModLong> fPolyFactory;
    private final List<? extends IExpr> fVariables;

    public JASModInteger(IExpr variable, ModLongRing ringFactory) {
        ArrayList<? extends IExpr> varList = new ArrayList<IExpr>();
        varList.add(variable);
        this.fRingFactory = ringFactory;
        this.fVariables = varList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = TermOrderByName.Lexicographic;
        this.fPolyFactory = new GenPolynomialRing((RingFactory)this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
    }

    public JASModInteger(List<? extends IExpr> variablesList, ModLongRing ringFactory) {
        this(variablesList, ringFactory, TermOrderByName.Lexicographic);
    }

    public JASModInteger(List<? extends IExpr> variablesList, ModLongRing ringFactory, TermOrder termOrder) {
        this.fRingFactory = ringFactory;
        this.fVariables = variablesList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = termOrder;
        this.fPolyFactory = new GenPolynomialRing((RingFactory)this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
    }

    public GenPolynomial<ModLong> expr2JAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.expr2Poly(exprPoly, false);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    public GenPolynomial<ModLong> numericExpr2JAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.numericExpr2Poly(exprPoly);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    public GenPolynomial<ModLong> expr2IExprJAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.expr2IExprPoly(exprPoly);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    private GenPolynomial<ModLong> numericExpr2Poly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        return this.expr2Poly(exprPoly, true);
    }

    private GenPolynomial<ModLong> expr2Poly(IExpr exprPoly, boolean numeric2Rational) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial result = this.fPolyFactory.getZERO();
            GenPolynomial<ModLong> p = this.fPolyFactory.getZERO();
            if (ast.isPlus()) {
                IExpr expr = ast.arg1();
                result = this.expr2Poly(expr, numeric2Rational);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.expr2Poly(expr, numeric2Rational);
                    result = result.sum(p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = ast.arg1();
                result = this.expr2Poly(expr, numeric2Rational);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.expr2Poly(expr, numeric2Rational);
                    result = result.multiply(p);
                }
                return result;
            }
            if (ast.isPower()) {
                IExpr base = ast.base();
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(base)) continue;
                    int exponent = ast.exponent().toIntDefault();
                    if (exponent < 0) {
                        throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ast.exponent().toString());
                    }
                    ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)exponent);
                    return this.fPolyFactory.valueOf(e);
                }
            }
        } else if (exprPoly instanceof ISymbol) {
            for (int i = 0; i < this.fVariables.size(); ++i) {
                if (!this.fVariables.get(i).equals(exprPoly)) continue;
                ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)1L);
                return this.fPolyFactory.getONE().multiply(e);
            }
        } else if (exprPoly instanceof IInteger) {
            return this.fPolyFactory.fromInteger((BigInteger)((IInteger)exprPoly).asType(BigInteger.class));
        }
        throw new ClassCastException(exprPoly.toString());
    }

    private GenPolynomial<ModLong> fraction2Poly(IFraction exprPoly) {
        BigInteger n = exprPoly.toBigNumerator();
        BigInteger d = exprPoly.toBigDenominator();
        BigRational nr = new BigRational(n);
        BigRational dr = new BigRational(d);
        BigRational r = nr.divide(dr);
        return new GenPolynomial(this.fPolyFactory, (RingElem)r);
    }

    private GenPolynomial<ModLong> expr2IExprPoly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial result = this.fPolyFactory.getZERO();
            GenPolynomial<ModLong> p = this.fPolyFactory.getZERO();
            if (ast.isPlus()) {
                IExpr expr = ast.arg1();
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.sum(p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = ast.arg1();
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.multiply(p);
                }
                return result;
            }
            if (ast.isPower()) {
                IExpr base = ast.base();
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(base)) continue;
                    int exponent = ast.exponent().toIntDefault();
                    if (exponent < 0) {
                        throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ast.exponent().toString());
                    }
                    ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)exponent);
                    return this.fPolyFactory.getONE().multiply(e);
                }
            }
        } else {
            if (exprPoly instanceof ISymbol) {
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(exprPoly)) continue;
                    ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)1L);
                    return this.fPolyFactory.getONE().multiply(e);
                }
                return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
            }
            if (exprPoly instanceof IInteger) {
                return this.fPolyFactory.fromInteger((BigInteger)((IInteger)exprPoly).asType(BigInteger.class));
            }
            if (exprPoly instanceof IFraction) {
                return this.fraction2Poly((IFraction)exprPoly);
            }
        }
        if (exprPoly.isFree(t -> this.fVariables.contains(t), true)) {
            return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
        }
        for (int i = 0; i < this.fVariables.size(); ++i) {
            if (!this.fVariables.get(i).equals(exprPoly)) continue;
            ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)1L);
            return this.fPolyFactory.getONE().multiply(e);
        }
        throw new ClassCastException(exprPoly.toString());
    }

    public GenPolynomialRing<ModLong> getPolynomialRingFactory() {
        return this.fPolyFactory;
    }

    public IExpr modLongPoly2Expr(GenPolynomial<ModLong> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IASTAppendable result = F.PlusAlloc(poly.length());
        for (Monomial monomial : poly) {
            ModLong coeff = (ModLong)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IInteger coeffValue = F.ZZ(coeff.getVal());
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            this.monomialToExpr(coeffValue, exp, monomTimes);
            result.append(monomTimes.oneIdentity1());
        }
        return result.oneIdentity0();
    }

    public boolean monomialToExpr(IInteger coeff, ExpVector exp, IASTAppendable monomTimes) {
        ExpVector leer = this.fPolyFactory.evzero;
        if (!coeff.isOne()) {
            monomTimes.append(coeff);
        }
        for (int i = 0; i < exp.length(); ++i) {
            long lExp = exp.getVal(i);
            if (lExp == 0L) continue;
            int ix = leer.varIndex(i);
            if (ix >= 0) {
                if (lExp == 1L) {
                    monomTimes.append(this.fVariables.get(ix));
                    continue;
                }
                monomTimes.append(F.Power(this.fVariables.get(ix), F.ZZ(lExp)));
                continue;
            }
            return false;
        }
        return true;
    }

    public static ModLongRing option2ModLongRing(ISignedNumber option) throws ArithmeticException {
        long longValue = option.toLong();
        BigInteger value = BigInteger.valueOf(longValue);
        return new ModLongRing(longValue, value.isProbablePrime(32));
    }
}

