/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.Complex;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.longexponent.ExpVectorLong;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;

public class JASIExpr {
    private final RingFactory<IExpr> fRingFactory;
    private final TermOrder fTermOrder;
    private final GenPolynomialRing<IExpr> fPolyFactory;
    private final GenPolynomialRing<BigInteger> fBigIntegerPolyFactory;
    private final List<? extends IExpr> fVariables;
    private boolean fNumericFunction = false;

    public JASIExpr(IExpr variable, boolean numericFunction) {
        this(variable, ExprRingFactory.CONST, numericFunction);
    }

    public JASIExpr(IExpr variable, RingFactory<IExpr> ringFactory) {
        this(variable, ringFactory, false);
    }

    public JASIExpr(IExpr variable, RingFactory<IExpr> ringFactory, boolean numericFunction) {
        this.fNumericFunction = numericFunction;
        ArrayList<? extends IExpr> varList = new ArrayList<IExpr>();
        varList.add(variable);
        this.fRingFactory = ringFactory;
        this.fVariables = varList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = TermOrderByName.INVLEX;
        this.fPolyFactory = new GenPolynomialRing(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing((RingFactory)BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public JASIExpr(List<? extends IExpr> variablesList) {
        this(variablesList, ExprRingFactory.CONST, TermOrderByName.INVLEX, false);
    }

    public JASIExpr(List<? extends IExpr> variablesList, boolean numericFunction) {
        this(variablesList, ExprRingFactory.CONST, TermOrderByName.INVLEX, numericFunction);
    }

    public JASIExpr(List<? extends IExpr> variablesList, RingFactory<IExpr> ringFactory) {
        this(variablesList, ringFactory, TermOrderByName.INVLEX, false);
    }

    public JASIExpr(List<? extends IExpr> variablesList, RingFactory<IExpr> ringFactory, TermOrder termOrder, boolean numericFunction) {
        this.fNumericFunction = numericFunction;
        this.fRingFactory = ringFactory;
        this.fVariables = variablesList;
        int size = this.fVariables.size();
        String[] vars = new String[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = termOrder;
        this.fPolyFactory = new GenPolynomialRing(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing((RingFactory)BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public IExpr complexPoly2Expr(GenPolynomial<Complex<BigRational>> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(poly.length());
        for (Monomial monomial : poly) {
            Complex coeff = (Complex)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            BigRational re = (BigRational)coeff.getRe();
            BigRational im = (BigRational)coeff.getIm();
            IASTAppendable monomTimes = F.Times((IExpr)F.complex(F.fraction(re.numerator(), re.denominator()), F.fraction(im.numerator(), im.denominator())));
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.append(F.Power(this.fVariables.get(i), F.ZZ(lExp)));
            }
            if (monomTimes.isAST1()) {
                result.append(monomTimes.arg1());
                continue;
            }
            result.append(monomTimes);
        }
        if (result.isAST1()) {
            return result.arg1();
        }
        return result;
    }

    public GenPolynomial<IExpr> expr2IExprJAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.expr2IExprPoly(exprPoly);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    public GenPolynomial<IExpr> expr2IExprJAS(ExprPolynomial exprPoly) {
        GenPolynomial result = new GenPolynomial(this.fPolyFactory);
        SortedMap<ExpVectorLong, IExpr> monoms = exprPoly.getMap();
        for (Map.Entry<ExpVectorLong, IExpr> entry : monoms.entrySet()) {
            long[] arr = entry.getKey().getVal();
            result.doPutToMap(ExpVector.create((long[])arr), (RingElem)((IExpr)monoms.get(entry.getKey())));
        }
        return result;
    }

    private GenPolynomial<IExpr> expr2IExprPoly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial result = this.fPolyFactory.getZERO();
            GenPolynomial<IExpr> p = this.fPolyFactory.getZERO();
            if (ast.isPlus()) {
                IExpr expr = ast.arg1();
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.sum(p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = ast.arg1();
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.multiply(p);
                }
                return result;
            }
            if (ast.isPower()) {
                ExpVector leer;
                int ix;
                IExpr base = ast.base();
                if (base instanceof ISymbol && (ix = (leer = this.fPolyFactory.evzero).indexVar(base.toString(), this.fPolyFactory.getVars())) >= 0) {
                    int exponent = ast.exponent().toIntDefault();
                    if (exponent < 0) {
                        throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ast.exponent().toString());
                    }
                    ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)ix, (long)exponent);
                    return this.fPolyFactory.getONE().multiply(e);
                }
            } else if (this.fNumericFunction && ast.isNumericFunction(true)) {
                return new GenPolynomial(this.fPolyFactory, (RingElem)ast);
            }
        } else {
            if (exprPoly instanceof ISymbol) {
                ExpVector leer = this.fPolyFactory.evzero;
                int ix = leer.indexVar(exprPoly.toString(), this.fPolyFactory.getVars());
                if (ix >= 0) {
                    ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)ix, (long)1L);
                    return this.fPolyFactory.getONE().multiply(e);
                }
                if (this.fNumericFunction) {
                    if (exprPoly.isNumericFunction(true)) {
                        return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
                    }
                    throw new ClassCastException(exprPoly.toString());
                }
                return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
            }
            if (exprPoly instanceof IInteger) {
                return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
            }
            if (exprPoly instanceof IFraction) {
                return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
            }
        }
        if (exprPoly.isFree(t -> this.fVariables.contains(t), true)) {
            return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
        }
        for (int i = 0; i < this.fVariables.size(); ++i) {
            if (!this.fVariables.get(i).equals(exprPoly)) continue;
            ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)1L);
            return this.fPolyFactory.getONE().multiply(e);
        }
        if (exprPoly instanceof ASTSeriesData) {
            return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
        }
        throw new ClassCastException(exprPoly.toString());
    }

    public IExpr exprPoly2Expr(GenPolynomial<IExpr> poly) {
        return this.exprPoly2Expr(poly, null);
    }

    public IExpr exprPoly2Expr(GenPolynomial<IExpr> poly, IExpr variable) {
        if (poly.length() == 0) {
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(poly.length());
        for (Monomial monomial : poly) {
            IExpr coeff = (IExpr)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            this.monomialToExpr(coeff, exp, monomTimes);
            result.append(monomTimes.oneIdentity1());
        }
        return result.oneIdentity0();
    }

    public boolean monomialToExpr(IExpr coeff, ExpVector exp, IASTAppendable monomTimes) {
        if (!coeff.isOne()) {
            monomTimes.append(coeff);
        }
        ExpVector leer = this.fPolyFactory.evzero;
        for (int i = 0; i < exp.length(); ++i) {
            long lExp = exp.getVal(i);
            if (lExp == 0L) continue;
            int ix = leer.varIndex(i);
            if (ix >= 0) {
                if (lExp == 1L) {
                    monomTimes.append(this.fVariables.get(ix));
                    continue;
                }
                monomTimes.append(F.Power(this.fVariables.get(ix), F.ZZ(lExp)));
                continue;
            }
            return false;
        }
        return true;
    }

    public GenPolynomialRing<IExpr> getPolynomialRingFactory() {
        return this.fPolyFactory;
    }

    public GenPolynomial<BigInteger> integerFromRationalCoefficients(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficients(this.fBigIntegerPolyFactory, A);
    }

    public IExpr integerPoly2Expr(GenPolynomial<BigInteger> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(poly.length());
        for (Monomial monomial : poly) {
            BigInteger coeff = (BigInteger)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IInteger coeffValue = F.integer(coeff.getVal());
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            monomTimes.append(coeffValue);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.append(F.Power(this.fVariables.get(i), F.ZZ(lExp)));
            }
            if (monomTimes.isAST1()) {
                result.append(monomTimes.arg1());
                continue;
            }
            result.append(monomTimes);
        }
        if (result.isAST1()) {
            return result.arg1();
        }
        return result;
    }

    public static boolean isInexactCoefficient(GenPolynomial<IExpr> polynomial) {
        Iterator iter = polynomial.coefficientIterator();
        while (iter.hasNext()) {
            IExpr expr = (IExpr)iter.next();
            if (!expr.isInexactNumber()) continue;
            return true;
        }
        return false;
    }

    public static TermOrder monomialOrder(OptionArgs optionArgs, TermOrder defaultTermOrder) {
        TermOrder termOrder = defaultTermOrder;
        IExpr option = optionArgs.getOption(S.MonomialOrder);
        if (option.isSymbol()) {
            termOrder = JASIExpr.monomialOrder((ISymbol)option, termOrder);
        }
        return termOrder;
    }

    public static TermOrder monomialOrder(ISymbol orderOption, TermOrder defaultTermOrder) {
        TermOrder termOrder = defaultTermOrder;
        if (orderOption == S.Lexicographic) {
            termOrder = TermOrderByName.Lexicographic;
        } else if (orderOption == S.NegativeLexicographic) {
            termOrder = TermOrderByName.NegativeLexicographic;
        } else if (orderOption == S.DegreeLexicographic) {
            termOrder = TermOrderByName.DegreeLexicographic;
        } else if (orderOption == S.DegreeReverseLexicographic) {
            termOrder = TermOrderByName.DegreeReverseLexicographic;
        } else if (orderOption == S.NegativeDegreeLexicographic) {
            termOrder = TermOrderByName.NegativeDegreeLexicographic;
        } else if (orderOption == S.NegativeDegreeReverseLexicographic) {
            termOrder = TermOrderByName.NegativeDegreeReverseLexicographic;
        }
        return termOrder;
    }
}

