/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModIntegerRing;
import edu.jas.integrate.Integral;
import edu.jas.integrate.LogIntegral;
import edu.jas.integrate.QuotIntegral;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import edu.jas.ufd.Quotient;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class JASConvert<C extends RingElem<C>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RingFactory<C> fRingFactory;
    private final TermOrder fTermOrder;
    private final GenPolynomialRing<C> fPolyFactory;
    private final GenPolynomialRing<edu.jas.arith.BigInteger> fBigIntegerPolyFactory;
    private final List<? extends IExpr> fVariables;

    public static IComplex jas2Complex(edu.jas.poly.Complex<BigRational> c) {
        IFraction re = F.fraction(((BigRational)c.getRe()).numerator(), ((BigRational)c.getRe()).denominator());
        IFraction im = F.fraction(((BigRational)c.getIm()).numerator(), ((BigRational)c.getIm()).denominator());
        return F.complex(re, im);
    }

    public static INumber jas2Numeric(edu.jas.poly.Complex<BigRational> c, double epsilon) {
        IFraction re = F.fraction(((BigRational)c.getRe()).numerator(), ((BigRational)c.getRe()).denominator());
        double red = re.doubleValue();
        IFraction im = F.fraction(((BigRational)c.getIm()).numerator(), ((BigRational)c.getIm()).denominator());
        double imd = im.doubleValue();
        return F.chopNumber(F.complexNum(red, imd), epsilon);
    }

    public static INumber jas2Numeric(Complex c, double epsilon) {
        double red = c.getReal();
        double imd = c.getImaginary();
        return F.chopNumber(F.complexNum(red, imd), epsilon);
    }

    public static ModIntegerRing option2ModIntegerRing(ISignedNumber option) {
        long longValue = option.toLong();
        BigInteger value = BigInteger.valueOf(longValue);
        return new ModIntegerRing(longValue, value.isProbablePrime(32));
    }

    public static Object[] rationalFromRationalCoefficientsFactor(GenPolynomialRing<BigRational> fac, GenPolynomial<BigRational> A) {
        Object[] result = new Object[3];
        if (A == null || A.isZERO()) {
            result[0] = BigInteger.ONE;
            result[1] = BigInteger.ZERO;
            result[2] = fac.getZERO();
            return result;
        }
        BigInteger gcd = null;
        BigInteger lcm = null;
        int sLCM = 0;
        int sGCD = 0;
        Iterator iter = A.coefficientIterator();
        while (iter.hasNext()) {
            BigRational y = (BigRational)iter.next();
            BigInteger numerator = y.numerator();
            BigInteger denominator = y.denominator();
            if (lcm == null) {
                lcm = denominator;
                sLCM = denominator.signum();
            } else {
                BigInteger d = lcm.gcd(denominator);
                lcm = lcm.multiply(denominator.divide(d));
            }
            if (gcd == null) {
                gcd = numerator;
                sGCD = numerator.signum();
                continue;
            }
            gcd = gcd.gcd(numerator);
        }
        if (sLCM < 0) {
            lcm = lcm.negate();
        }
        if (sGCD < 0) {
            gcd = gcd.negate();
        }
        result[0] = gcd;
        result[1] = lcm;
        result[2] = PolyUtil.map(fac, A, (UnaryFunctor)new RatToRatFactor(gcd, lcm));
        return result;
    }

    public JASConvert(IExpr variable, RingFactory<C> ringFactory) {
        ArrayList<? extends IExpr> varList = new ArrayList<IExpr>();
        varList.add(variable);
        this.fRingFactory = ringFactory;
        this.fVariables = varList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = TermOrderByName.INVLEX;
        this.fPolyFactory = new GenPolynomialRing(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing((RingFactory)edu.jas.arith.BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public JASConvert(List<? extends IExpr> variablesList, RingFactory<C> ringFactory) {
        this(variablesList, ringFactory, TermOrderByName.INVLEX);
    }

    public JASConvert(List<? extends IExpr> variablesList, RingFactory<C> ringFactory, TermOrder termOrder) {
        this.fRingFactory = ringFactory;
        this.fVariables = variablesList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = termOrder;
        this.fPolyFactory = new GenPolynomialRing(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing((RingFactory)edu.jas.arith.BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public IAST algebraicNumber2Expr(AlgebraicNumber<BigRational> coeff) throws ArithmeticException {
        GenPolynomial val = coeff.val;
        return this.rationalPoly2Expr((GenPolynomial<BigRational>)val, false);
    }

    private GenPolynomial<C> complex2Poly(IComplex complexValue) throws JASConversionException {
        IRational reRational = complexValue.reRational();
        IRational imRational = complexValue.imRational();
        BigRational nre = new BigRational(reRational.toBigNumerator());
        BigRational dre = new BigRational(reRational.toBigDenominator());
        BigRational re = nre.divide(dre);
        BigRational nim = new BigRational(imRational.toBigNumerator());
        BigRational dim = new BigRational(imRational.toBigDenominator());
        BigRational im = nim.divide(dim);
        if (this.fRingFactory instanceof ComplexRing) {
            ComplexRing ring = (ComplexRing)this.fRingFactory;
            edu.jas.poly.Complex c = new edu.jas.poly.Complex(ring, (RingElem)re, (RingElem)im);
            return new GenPolynomial(this.fPolyFactory, (RingElem)c);
        }
        throw new JASConversionException();
    }

    public IExpr complexIntegerPoly2Expr(GenPolynomial<edu.jas.poly.Complex<edu.jas.arith.BigInteger>> poly) throws ArithmeticException, JASConversionException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(poly.length());
        for (Monomial monomial : poly) {
            edu.jas.poly.Complex coeff = (edu.jas.poly.Complex)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            this.monomialIntegerToExpr((edu.jas.poly.Complex<edu.jas.arith.BigInteger>)coeff, exp, monomTimes);
            result.append(monomTimes.oneIdentity1());
        }
        return result.oneIdentity0();
    }

    public IExpr complexPoly2Expr(GenPolynomial<edu.jas.poly.Complex<BigRational>> poly) throws ArithmeticException, JASConversionException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(poly.length());
        for (Monomial monomial : poly) {
            edu.jas.poly.Complex coeff = (edu.jas.poly.Complex)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            this.monomialToExpr((edu.jas.poly.Complex<BigRational>)coeff, exp, monomTimes);
            result.append(monomTimes.oneIdentity1());
        }
        return result.oneIdentity0();
    }

    public GenPolynomial<C> expr2JAS(IExpr exprPoly, boolean numeric2Rational) throws JASConversionException {
        try {
            return this.expr2Poly(exprPoly, numeric2Rational);
        }
        catch (JASConversionException jce) {
            throw jce;
        }
        catch (RuntimeException rex) {
            LOGGER.debug("JASConvert.expr2JAS() failed", (Throwable)rex);
            throw new JASConversionException();
        }
    }

    private GenPolynomial<C> expr2Poly(IExpr exprPoly, boolean numeric2Rational) throws ArithmeticException, JASConversionException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            if (ast.isSlot()) {
                try {
                    return this.fPolyFactory.univariate(ast.toString(), 1L);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            } else {
                GenPolynomial result = this.fPolyFactory.getZERO();
                GenPolynomial<C> p = this.fPolyFactory.getZERO();
                if (ast.isPlus()) {
                    IExpr expr = ast.arg1();
                    result = this.expr2Poly(expr, numeric2Rational);
                    for (int i = 2; i < ast.size(); ++i) {
                        expr = ast.get(i);
                        p = this.expr2Poly(expr, numeric2Rational);
                        result = result.sum(p);
                    }
                    return result;
                }
                if (ast.isTimes()) {
                    IExpr expr = ast.arg1();
                    result = this.expr2Poly(expr, numeric2Rational);
                    for (int i = 2; i < ast.size(); ++i) {
                        expr = ast.get(i);
                        p = this.expr2Poly(expr, numeric2Rational);
                        result = result.multiply(p);
                    }
                    return result;
                }
                if (ast.isPower() && ast.base().isSymbol()) {
                    ISymbol base = (ISymbol)ast.base();
                    int exponent = ast.exponent().toIntDefault();
                    if (exponent < 0) {
                        throw new JASConversionException();
                    }
                    try {
                        return this.fPolyFactory.univariate(base.getSymbolName(), (long)exponent);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                } else if (ast.isPower() && ast.arg1().isSlot()) {
                    IAST base = (IAST)ast.arg1();
                    int exponent = ast.exponent().toIntDefault();
                    if (exponent < 0) {
                        throw new JASConversionException();
                    }
                    try {
                        return this.fPolyFactory.univariate(base.toString(), (long)exponent);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        } else if (exprPoly instanceof ISymbol) {
            try {
                if (exprPoly.isIndeterminate()) {
                    throw new JASConversionException();
                }
                return this.fPolyFactory.univariate(((ISymbol)exprPoly).getSymbolName(), 1L);
            }
            catch (IllegalArgumentException ast) {}
        } else {
            if (exprPoly instanceof IInteger) {
                return this.fPolyFactory.fromInteger((BigInteger)((IInteger)exprPoly).asType(BigInteger.class));
            }
            if (exprPoly instanceof IFraction) {
                return this.fraction2Poly((IFraction)exprPoly);
            }
            if (exprPoly instanceof IComplex) {
                return this.complex2Poly((IComplex)exprPoly);
            }
            if (exprPoly instanceof INum && numeric2Rational) {
                IFraction frac = F.fraction(((INum)exprPoly).getRealPart());
                return this.fraction2Poly(frac);
            }
            if (exprPoly instanceof IComplexNum && numeric2Rational && F.isZero(((IComplexNum)exprPoly).getImaginaryPart())) {
                IFraction frac = F.fraction(((INum)exprPoly).getRealPart());
                return this.fraction2Poly(frac);
            }
        }
        throw new JASConversionException();
    }

    private boolean expVectorToExpr(ExpVector exp, IASTAppendable monomTimes) {
        ExpVector leer = this.fPolyFactory.evzero;
        for (int i = 0; i < exp.length(); ++i) {
            long lExp = exp.getVal(i);
            if (lExp == 0L) continue;
            int ix = leer.varIndex(i);
            if (ix >= 0) {
                if (lExp == 1L) {
                    monomTimes.append(this.fVariables.get(ix));
                    continue;
                }
                monomTimes.append(F.Power(this.fVariables.get(ix), F.ZZ(lExp)));
                continue;
            }
            return false;
        }
        return true;
    }

    public Object[] factorTerms(GenPolynomial<BigRational> poly) {
        return PolyUtil.integerFromRationalCoefficientsFactor(this.fBigIntegerPolyFactory, poly);
    }

    private GenPolynomial<C> fraction2Poly(IFraction exprPoly) {
        BigInteger n = exprPoly.toBigNumerator();
        BigInteger d = exprPoly.toBigDenominator();
        BigRational nr = new BigRational(n);
        BigRational dr = new BigRational(d);
        BigRational r = nr.divide(dr);
        if (this.fRingFactory instanceof ComplexRing) {
            ComplexRing ring = (ComplexRing)this.fRingFactory;
            edu.jas.poly.Complex c = new edu.jas.poly.Complex(ring, (RingElem)r);
            return new GenPolynomial(this.fPolyFactory, (RingElem)c);
        }
        return new GenPolynomial(this.fPolyFactory, (RingElem)r);
    }

    public RingFactory<C> getCoefficientRingFactory() {
        return this.fRingFactory;
    }

    public GenPolynomialRing<C> getPolynomialRingFactory() {
        return this.fPolyFactory;
    }

    public GenPolynomial<edu.jas.arith.BigInteger> integerFromRationalCoefficients(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficients(this.fBigIntegerPolyFactory, A);
    }

    public IExpr integerPoly2Expr(GenPolynomial<edu.jas.arith.BigInteger> poly) throws ArithmeticException, JASConversionException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IASTAppendable result = F.PlusAlloc(poly.length());
        for (Monomial monomial : poly) {
            edu.jas.arith.BigInteger coeff = (edu.jas.arith.BigInteger)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            this.monomialToExpr(coeff, exp, monomTimes);
            result.append(monomTimes.oneIdentity1());
        }
        return result.oneIdentity0();
    }

    public IAST integral2Expr(Integral<BigRational> integral) {
        GenPolynomial pol = integral.pol;
        List rational = integral.rational;
        List logarithm = integral.logarithm;
        IASTAppendable sum = F.PlusAlloc(rational.size() + logarithm.size());
        if (!pol.isZERO()) {
            sum.append(this.rationalPoly2Expr((GenPolynomial<BigRational>)pol, false));
        }
        if (rational.size() != 0) {
            int i = 0;
            while (i < rational.size()) {
                sum.append(F.Times((IExpr)this.rationalPoly2Expr((GenPolynomial<BigRational>)((GenPolynomial)rational.get(i++)), false), (IExpr)F.Power((IExpr)this.rationalPoly2Expr((GenPolynomial<BigRational>)((GenPolynomial)rational.get(i++)), false), F.CN1)));
            }
        }
        if (logarithm.size() != 0) {
            for (LogIntegral pf : logarithm) {
                sum.append(this.logIntegral2Expr((LogIntegral<BigRational>)pf));
            }
        }
        return sum;
    }

    public IAST logIntegral2Expr(LogIntegral<BigRational> logIntegral) {
        int i;
        List cfactors = logIntegral.cfactors;
        List cdenom = logIntegral.cdenom;
        List afactors = logIntegral.afactors;
        List adenom = logIntegral.adenom;
        IASTAppendable plus = F.PlusAlloc(cfactors.size() + afactors.size());
        if (cfactors.size() > 0) {
            for (i = 0; i < cfactors.size(); ++i) {
                BigRational cp = (BigRational)cfactors.get(i);
                GenPolynomial p = (GenPolynomial)cdenom.get(i);
                plus.append(F.Times((IExpr)F.fraction(cp.numerator(), cp.denominator()), (IExpr)F.Log(this.rationalPoly2Expr((GenPolynomial<BigRational>)p, false))));
            }
        }
        if (afactors.size() > 0) {
            for (i = 0; i < afactors.size(); ++i) {
                AlgebraicNumber ap = (AlgebraicNumber)afactors.get(i);
                AlgebraicNumberRing ar = ap.factory();
                GenPolynomial p = (GenPolynomial)adenom.get(i);
                if (p.degree(0) >= ar.modul.degree(0) || ar.modul.degree(0) > 2L) {
                    // empty if block
                }
                GenPolynomial v = ap.getVal();
                IASTAppendable times = F.TimesAlloc(2);
                if (p.degree(0) < ar.modul.degree(0) && ar.modul.degree(0) > 2L) {
                    IASTAppendable rootOf = F.ast(S.RootOf);
                    rootOf.append(this.rationalPoly2Expr((GenPolynomial<BigRational>)ar.modul, false));
                    times.append(rootOf);
                    throw new UnsupportedOperationException("JASConvert#logIntegral2Expr()");
                }
                times.append(this.rationalPoly2Expr((GenPolynomial<BigRational>)v, false));
                times.append(F.Log(this.polyAlgebraicNumber2Expr((GenPolynomial<AlgebraicNumber<BigRational>>)p)));
                plus.append(times);
            }
        }
        return plus;
    }

    public boolean monomialIntegerToExpr(edu.jas.poly.Complex<edu.jas.arith.BigInteger> coeff, ExpVector exp, IASTAppendable monomTimes) {
        edu.jas.arith.BigInteger re = (edu.jas.arith.BigInteger)coeff.getRe();
        edu.jas.arith.BigInteger im = (edu.jas.arith.BigInteger)coeff.getIm();
        monomTimes.append(F.complex(F.integer(re.getVal()), F.integer(im.getVal())));
        return this.expVectorToExpr(exp, monomTimes);
    }

    public boolean monomialToExpr(AlgebraicNumber<BigRational> coeff, ExpVector exp, IASTAppendable monomTimes) {
        if (!coeff.isONE()) {
            monomTimes.append(this.algebraicNumber2Expr(coeff));
        }
        return this.expVectorToExpr(exp, monomTimes);
    }

    public boolean monomialToExpr(BigRational coeff, ExpVector exp, IASTAppendable monomTimes) {
        if (!coeff.isONE()) {
            IFraction coeffValue = F.fraction(coeff.numerator(), coeff.denominator());
            monomTimes.append(coeffValue);
        }
        return this.expVectorToExpr(exp, monomTimes);
    }

    public boolean monomialToExpr(edu.jas.poly.Complex<BigRational> coeff, ExpVector exp, IASTAppendable monomTimes) {
        BigRational re = (BigRational)coeff.getRe();
        BigRational im = (BigRational)coeff.getIm();
        monomTimes.append(F.complex(F.fraction(re.numerator(), re.denominator()).normalize(), F.fraction(im.numerator(), im.denominator()).normalize()));
        return this.expVectorToExpr(exp, monomTimes);
    }

    public boolean monomialToExpr(edu.jas.arith.BigInteger coeff, ExpVector exp, IASTAppendable monomTimes) {
        if (!coeff.isONE()) {
            IInteger coeffValue = F.integer(coeff.getVal());
            monomTimes.append(coeffValue);
        }
        return this.expVectorToExpr(exp, monomTimes);
    }

    public GenPolynomial<C> numericExpr2JAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.numericExpr2Poly(exprPoly);
        }
        catch (RuntimeException rex) {
            throw new JASConversionException();
        }
    }

    private GenPolynomial<C> numericExpr2Poly(IExpr exprPoly) throws ArithmeticException, JASConversionException {
        return this.expr2Poly(exprPoly, true);
    }

    public IAST polyAlgebraicNumber2Expr(GenPolynomial<AlgebraicNumber<BigRational>> poly) throws ArithmeticException, JASConversionException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        SortedMap val = poly.getMap();
        if (val.size() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IASTAppendable result = F.PlusAlloc(val.size());
        for (Map.Entry m : val.entrySet()) {
            AlgebraicNumber coeff = (AlgebraicNumber)m.getValue();
            ExpVector exp = (ExpVector)m.getKey();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            this.monomialToExpr((AlgebraicNumber<BigRational>)coeff, exp, monomTimes);
            result.append(monomTimes.oneIdentity1());
        }
        return result;
    }

    public IAST quotIntegral2Expr(QuotIntegral<BigRational> integral) {
        List rational = integral.rational;
        List logarithm = integral.logarithm;
        if (rational.size() != 0) {
            IASTAppendable sum = F.PlusAlloc(rational.size());
            for (int i = 0; i < rational.size(); ++i) {
                Quotient qTemp = (Quotient)rational.get(i);
                GenPolynomial qNum = qTemp.num;
                GenPolynomial qDen = qTemp.den;
                sum.append(F.Times((IExpr)this.rationalPoly2Expr((GenPolynomial<BigRational>)qNum, false), (IExpr)F.Power((IExpr)this.rationalPoly2Expr((GenPolynomial<BigRational>)qDen, false), F.CN1)));
            }
            return sum;
        }
        if (logarithm.size() != 0) {
            IASTAppendable sum = F.PlusAlloc(logarithm.size());
            for (LogIntegral pf : logarithm) {
                sum.append(this.logIntegral2Expr((LogIntegral<BigRational>)pf));
            }
            return sum;
        }
        return F.Plus();
    }

    public IAST rationalPoly2Expr(GenPolynomial<BigRational> poly, boolean factorTerms) throws ArithmeticException, JASConversionException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        if (factorTerms) {
            Object[] objects = this.factorTerms(poly);
            GenPolynomial p2 = (GenPolynomial)objects[2];
            BigInteger gcd = (BigInteger)objects[0];
            BigInteger lcm = (BigInteger)objects[1];
            IRational factor = F.fraction(gcd, lcm).normalize();
            IASTAppendable result = F.PlusAlloc(p2.length());
            for (Monomial monomial : p2) {
                edu.jas.arith.BigInteger coeff = (edu.jas.arith.BigInteger)monomial.coefficient();
                ExpVector exp = monomial.exponent();
                IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
                this.monomialToExpr(coeff, exp, monomTimes);
                result.append(monomTimes.oneIdentity1());
            }
            if (factor.isOne()) {
                return result;
            }
            return F.Times((IExpr)F.fraction(gcd, lcm), (IExpr)result);
        }
        IASTAppendable result = F.PlusAlloc(poly.length());
        for (Monomial monomial : poly) {
            BigRational coeff = (BigRational)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
            this.monomialToExpr(coeff, exp, monomTimes);
            result.append(monomTimes.oneIdentity1());
        }
        return result;
    }

    private static boolean isQuadratic(GenPolynomial<BigRational> poly, BigRational[] result) {
        if (poly.degree() <= 2L && poly.numberOfVariables() == 1) {
            result[0] = BigRational.ZERO;
            result[1] = BigRational.ZERO;
            result[2] = BigRational.ZERO;
            for (Monomial monomial : poly) {
                BigRational coeff = (BigRational)monomial.coefficient();
                ExpVector exp = monomial.exponent();
                for (int i = 0; i < exp.length(); ++i) {
                    result[(int)exp.getVal((int)i)] = coeff;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isQuadratic(GenPolynomial<edu.jas.arith.BigInteger> poly, edu.jas.arith.BigInteger[] result) {
        if (poly.degree() <= 2L && poly.numberOfVariables() == 1) {
            result[0] = edu.jas.arith.BigInteger.ZERO;
            result[1] = edu.jas.arith.BigInteger.ZERO;
            result[2] = edu.jas.arith.BigInteger.ZERO;
            for (Monomial monomial : poly) {
                edu.jas.arith.BigInteger coeff = (edu.jas.arith.BigInteger)monomial.coefficient();
                ExpVector exp = monomial.exponent();
                for (int i = 0; i < exp.length(); ++i) {
                    result[(int)exp.getVal((int)i)] = coeff;
                }
            }
            return true;
        }
        return false;
    }

    static class RatToRatFactor
    implements UnaryFunctor<BigRational, BigRational> {
        final BigInteger lcm;
        final BigInteger gcd;

        public RatToRatFactor(BigInteger gcd, BigInteger lcm) {
            this.gcd = gcd;
            this.lcm = lcm;
        }

        public BigRational eval(BigRational c) {
            if (c == null) {
                return BigRational.ZERO;
            }
            if (this.gcd.equals(BigInteger.ONE)) {
                BigInteger b = this.lcm.divide(c.denominator());
                return BigRational.valueOf((BigInteger)c.numerator().multiply(b));
            }
            BigInteger a = c.numerator().divide(this.gcd);
            BigInteger b = this.lcm.divide(c.denominator());
            return BigRational.valueOf((BigInteger)a.multiply(b));
        }
    }
}

