/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apfloat.Apfloat;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.graphics.IGraphics3D;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.parser.client.Scanner;

public class ExpressionJSONConvert {
    public static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();

    public static String exportExpressionJSONString(IExpr expr) throws IOException, JsonGenerationException, JsonMappingException {
        return ExpressionJSONConvert.exportExpressionJSON(expr).toString();
    }

    public static IStringX exportExpressionJSONIStringX(IExpr expr) throws IOException, JsonGenerationException, JsonMappingException {
        return F.stringx(ExpressionJSONConvert.exportExpressionJSONString(expr));
    }

    public static JsonNode exportExpressionJSON(IExpr expr) throws IOException, JsonGenerationException, JsonMappingException {
        if (expr.isASTOrAssociation()) {
            IAST ast = (IAST)expr;
            ArrayNode temp = JSON_OBJECT_MAPPER.createArrayNode();
            temp.add(ast.head().toString());
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = ast.getRule(i);
                if (arg.isComplexNumeric()) {
                    IComplexNum complexNum = (IComplexNum)arg;
                    ArrayNode complexJson = JSON_OBJECT_MAPPER.createArrayNode();
                    complexJson.add("Complex");
                    complexJson.add(complexNum.reDoubleValue());
                    complexJson.add(complexNum.imDoubleValue());
                    temp.add((JsonNode)complexJson);
                    continue;
                }
                if (arg instanceof Num) {
                    temp.add(((Num)arg).doubleValue());
                    continue;
                }
                if (arg instanceof ApfloatNum) {
                    Apfloat apfloatValue = ((ApfloatNum)arg).apfloatValue();
                    if (apfloatValue.precision() > 20L) {
                        temp.add(apfloatValue.toString());
                        continue;
                    }
                    temp.add(apfloatValue.doubleValue());
                    continue;
                }
                if (arg.isNumber() || arg.isSymbol()) {
                    temp.add(arg.toString());
                    continue;
                }
                if (arg.isString()) {
                    temp.add("'" + arg.toString() + "'");
                    continue;
                }
                temp.add(ExpressionJSONConvert.exportExpressionJSON(arg));
            }
            return temp;
        }
        ArrayNode temp = JSON_OBJECT_MAPPER.createArrayNode();
        temp.add(temp.toString());
        return temp;
    }

    private static JsonNode exportGraphics3DJSON(IExpr data3D) {
        if (data3D.isList()) {
            IAST list = (IAST)data3D;
            ArrayNode temp = JSON_OBJECT_MAPPER.createArrayNode();
            for (int i = 1; i < list.size(); ++i) {
                IAST ast;
                IAST arg = list.getAST(i);
                if (!arg.isAST() || !(ast = arg).head().isBuiltInSymbol()) continue;
                StringBuilder buf = new StringBuilder();
                IBuiltInSymbol symbol = (IBuiltInSymbol)ast.head();
                IEvaluator evaluator = symbol.getEvaluator();
                if (!(evaluator instanceof IGraphics3D)) continue;
            }
            return temp;
        }
        ArrayNode temp = JSON_OBJECT_MAPPER.createArrayNode();
        temp.add(temp.toString());
        return temp;
    }

    public static IExpr importExpressionJSONRecursive(JsonNode node) {
        if (node instanceof ArrayNode) {
            JsonNode next;
            IExpr temp;
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator iter = arrayNode.elements();
            if (iter.hasNext() && (temp = ExpressionJSONConvert.importExpressionJSONRecursive(next = (JsonNode)iter.next())).isPresent()) {
                IASTAppendable ast = F.ast(temp, arrayNode.size() - 1);
                while (iter.hasNext()) {
                    next = (JsonNode)iter.next();
                    temp = ExpressionJSONConvert.importExpressionJSONRecursive(next);
                    if (!temp.isPresent()) continue;
                    ast.append(temp);
                }
                return ast;
            }
            return F.NIL;
        }
        if (node instanceof ObjectNode) {
            IASTAppendable list = F.ListAlloc();
            ObjectNode objectNode = (ObjectNode)node;
            Iterator iter = objectNode.fields();
            while (iter.hasNext()) {
                Map.Entry next = (Map.Entry)iter.next();
                IExpr temp = ExpressionJSONConvert.importExpressionJSONRecursive((JsonNode)next.getValue());
                if (!temp.isPresent()) continue;
                list.append(F.Rule((IExpr)F.$str((String)next.getKey()), temp));
            }
            return list;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            if (valueNode instanceof NumericNode) {
                if (valueNode instanceof DoubleNode) {
                    return F.num(valueNode.doubleValue());
                }
                if (valueNode instanceof FloatNode) {
                    return F.num(valueNode.doubleValue());
                }
                if (valueNode instanceof IntNode) {
                    return F.ZZ(valueNode.intValue());
                }
                if (valueNode instanceof LongNode) {
                    return F.ZZ(valueNode.longValue());
                }
                if (valueNode instanceof ShortNode) {
                    return F.ZZ(valueNode.intValue());
                }
                if (valueNode instanceof BigIntegerNode) {
                    return F.ZZ(valueNode.bigIntegerValue());
                }
                if (valueNode instanceof DecimalNode) {
                    return F.num(new Apfloat(valueNode.decimalValue()));
                }
            }
            if (valueNode instanceof BooleanNode) {
                return valueNode.booleanValue() ? S.True : S.False;
            }
            if (valueNode instanceof NullNode) {
                return S.Null;
            }
            if (valueNode instanceof TextNode) {
                String symbolName = valueNode.textValue();
                if (symbolName.length() > 1 && symbolName.charAt(0) == '\'' && symbolName.charAt(symbolName.length() - 1) == '\'') {
                    return F.$str(symbolName.substring(1, symbolName.length() - 1));
                }
                if (Scanner.isIdentifier((String)symbolName)) {
                    return F.symbol(symbolName);
                }
                return F.$str(symbolName);
            }
            return F.$str(valueNode.toString());
        }
        return F.NIL;
    }

    public static IExpr importExpressionJSON(String jsonStr) throws JsonMappingException, JsonProcessingException {
        JsonNode node = JSON_OBJECT_MAPPER.readTree(jsonStr);
        return ExpressionJSONConvert.importExpressionJSONRecursive(node);
    }
}

