/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import org.hipparchus.util.OpenIntToDoubleHashMap;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;

public class Expr2Object {
    public static double[] toPolynomial(IExpr expr, IExpr sym) {
        int n;
        int k;
        OpenIntToDoubleHashMap map = Expr2Object.toPolynomialMap(expr, sym);
        if (map == null) {
            return null;
        }
        int max = 5;
        OpenIntToDoubleHashMap.Iterator iterator = map.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            k = iterator.key();
            if (k <= max) continue;
            max = k;
        }
        double[] array = new double[max + 1];
        OpenIntToDoubleHashMap.Iterator iterator2 = map.iterator();
        while (iterator2.hasNext()) {
            iterator2.advance();
            k = iterator2.key();
            array[k] = iterator2.value();
        }
        for (n = array.length; n > 1 && array[n - 1] == 0.0; --n) {
        }
        if (n < array.length) {
            double[] coefficients = new double[n];
            System.arraycopy(array, 0, coefficients, 0, n);
            return coefficients;
        }
        return array;
    }

    private static OpenIntToDoubleHashMap toPolynomialMap(IExpr expr, IExpr variable) {
        try {
            OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap();
            if (expr.isPlus()) {
                IAST plus = (IAST)expr;
                for (int i = 1; i < plus.size(); ++i) {
                    if (plus.get(i).isTimes()) {
                        IAST times = (IAST)plus.get(i);
                        double coeff = 0.0;
                        int exp = -1;
                        for (int j = 1; j < times.size(); ++j) {
                            if (times.get(j).isPower()) {
                                IAST power = (IAST)times.get(j);
                                if (power.base().equals(variable)) {
                                    if (exp != -1) {
                                        return null;
                                    }
                                    IExpr res = F.evaln(power.exponent());
                                    if (!(res instanceof INum)) {
                                        return null;
                                    }
                                    exp = DoubleMath.roundToInt((double)((INum)res).doubleValue(), (RoundingMode)RoundingMode.UNNECESSARY);
                                    if (exp >= 0) continue;
                                    return null;
                                }
                            } else if (times.get(j).isSymbol() && times.get(j).equals(variable)) {
                                if (exp != -1) {
                                    return null;
                                }
                                exp = 1;
                                continue;
                            }
                            if (times.get(j) instanceof INum) {
                                coeff += ((INum)times.get(j)).doubleValue();
                                continue;
                            }
                            IExpr res = F.evaln(times.get(j));
                            if (!(res instanceof INum)) {
                                return null;
                            }
                            coeff += ((INum)res).doubleValue();
                        }
                        if (exp == -1) {
                            exp = 0;
                        }
                        Expr2Object.addCoefficient(map, coeff, exp);
                        continue;
                    }
                    if (plus.get(i).isPower()) {
                        IAST power = (IAST)plus.get(i);
                        if (power.arg1().equals(variable)) {
                            IExpr res = F.evaln(power.arg2());
                            if (!(res instanceof INum)) {
                                return null;
                            }
                            int exp = DoubleMath.roundToInt((double)((INum)res).doubleValue(), (RoundingMode)RoundingMode.UNNECESSARY);
                            if (exp < 0) {
                                return null;
                            }
                            Expr2Object.addCoefficient(map, 1.0, exp);
                            continue;
                        }
                        return null;
                    }
                    if (plus.get(i).isSymbol()) {
                        if (plus.equalsAt(i, variable)) {
                            Expr2Object.addCoefficient(map, 1.0, 1);
                            continue;
                        }
                        return null;
                    }
                    if (plus.get(i) instanceof INum) {
                        Expr2Object.addCoefficient(map, ((INum)plus.get(i)).doubleValue(), 0);
                        continue;
                    }
                    IExpr res = F.evaln(plus.get(i));
                    if (!(res instanceof INum)) {
                        return null;
                    }
                    Expr2Object.addCoefficient(map, ((INum)res).doubleValue(), 0);
                }
                return map;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private static void addCoefficient(OpenIntToDoubleHashMap map, double v, int k) {
        double value = map.get(k);
        if (Double.isNaN(value)) {
            map.put(k, v);
        } else {
            map.put(k, value + v);
        }
    }
}

