/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import java.util.List;
import org.hipparchus.optim.linear.LinearConstraint;
import org.hipparchus.optim.linear.LinearObjectiveFunction;
import org.hipparchus.optim.linear.Relationship;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Expr2LP {
    private final IExpr fExpr;
    private final List<? extends IExpr> fVariables;
    private final VariablesSet fVariablesSet;

    public Expr2LP(IExpr expr) {
        this(expr, new VariablesSet(expr));
    }

    public Expr2LP(IExpr expr, VariablesSet variableSet) {
        this.fExpr = expr;
        this.fVariablesSet = variableSet;
        this.fVariables = this.fVariablesSet.getArrayList();
    }

    public LinearConstraint expr2Constraint() {
        double[] coefficients = new double[this.fVariables.size()];
        if (this.fExpr.isAST()) {
            IAST ast = (IAST)this.fExpr;
            if (ast.isEqual()) {
                IExpr expr = F.eval(F.Subtract(ast.arg1(), ast.arg2()));
                ISignedNumber num = this.expr2ObjectiveFunction(expr, coefficients);
                if (num == null) {
                    return new LinearConstraint(coefficients, Relationship.EQ, 0.0);
                }
                return new LinearConstraint(coefficients, Relationship.EQ, -1.0 * num.doubleValue());
            }
            if (ast.isAST(S.GreaterEqual, 3)) {
                IExpr expr = F.eval(F.Subtract(ast.arg1(), ast.arg2()));
                ISignedNumber num = this.expr2ObjectiveFunction(expr, coefficients);
                if (num == null) {
                    return new LinearConstraint(coefficients, Relationship.GEQ, 0.0);
                }
                return new LinearConstraint(coefficients, Relationship.GEQ, -1.0 * num.doubleValue());
            }
            if (ast.isAST(S.LessEqual, 3)) {
                IExpr expr = F.eval(F.Subtract(ast.arg1(), ast.arg2()));
                ISignedNumber num = this.expr2ObjectiveFunction(expr, coefficients);
                if (num == null) {
                    return new LinearConstraint(coefficients, Relationship.LEQ, 0.0);
                }
                return new LinearConstraint(coefficients, Relationship.LEQ, -1.0 * num.doubleValue());
            }
        }
        throw new ArgumentTypeException("conversion from expression to linear programming expression failed for " + this.fExpr.toString());
    }

    public LinearObjectiveFunction expr2ObjectiveFunction() {
        double[] coefficients = new double[this.fVariables.size()];
        ISignedNumber num = this.expr2ObjectiveFunction(this.fExpr, coefficients);
        if (num == null) {
            return new LinearObjectiveFunction(coefficients, 0.0);
        }
        return new LinearObjectiveFunction(coefficients, num.doubleValue());
    }

    private ISignedNumber expr2ObjectiveFunction(IExpr expr, double[] coefficients) throws ArithmeticException, ClassCastException {
        ISignedNumber num;
        if (expr instanceof IAST) {
            IAST ast = (IAST)expr;
            if (ast.isPlus()) {
                double constantTerm = 0.0;
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr temp = ast.get(i);
                    ISignedNumber num2 = this.expr2ObjectiveFunction(temp, coefficients);
                    if (num2 == null) continue;
                    constantTerm += num2.doubleValue();
                }
                return F.num(constantTerm);
            }
            if (ast.isTimes()) {
                int i;
                ISymbol variable = null;
                double value = 1.0;
                for (i = 1; i < ast.size(); ++i) {
                    IExpr temp = ast.get(i);
                    if (temp.isVariable()) {
                        if (variable != null) {
                            throw new ArgumentTypeException("conversion from expression to linear programming expression failed for " + temp.toString());
                        }
                        variable = (ISymbol)temp;
                        continue;
                    }
                    ISignedNumber num3 = temp.evalReal();
                    if (num3 != null) {
                        value *= num3.doubleValue();
                        continue;
                    }
                    throw new ArgumentTypeException("conversion from expression to linear programming expression failed for " + temp.toString());
                }
                if (variable != null) {
                    for (i = 0; i < coefficients.length; ++i) {
                        if (!variable.equals(this.fVariables.get(i))) continue;
                        int n = i;
                        coefficients[n] = coefficients[n] + value;
                        return null;
                    }
                    throw new ArgumentTypeException("conversion from expression to linear programming expression failed for " + ast.toString());
                }
                return F.num(value);
            }
        } else if (expr.isVariable()) {
            ISymbol variable = (ISymbol)expr;
            for (int i = 0; i < coefficients.length; ++i) {
                if (!variable.equals(this.fVariables.get(i))) continue;
                int n = i;
                coefficients[n] = coefficients[n] + 1.0;
                return null;
            }
            throw new ArgumentTypeException("conversion from expression to linear programming expression failed for " + expr.toString());
        }
        if ((num = expr.evalReal()) != null) {
            return num;
        }
        throw new ArgumentTypeException("conversion from expression to linear programming expression failed for " + expr.toString());
    }
}

