/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.ac.kobe_u.cs.cream.DefaultSolver;
import jp.ac.kobe_u.cs.cream.IntVariable;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Solution;
import jp.ac.kobe_u.cs.cream.SolutionHandler;
import jp.ac.kobe_u.cs.cream.Solver;
import jp.ac.kobe_u.cs.cream.Variable;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class CreamConvert {
    TreeMap<ISymbol, IntVariable> map = new TreeMap();

    public Network expr2Cream(IAST list, IAST variables) throws ClassCastException {
        Network net = new Network();
        for (int i = 1; i < variables.size(); ++i) {
            if (!(variables.get(i) instanceof ISymbol)) continue;
            this.map.put((ISymbol)variables.get(i), new IntVariable(net));
        }
        for (int i = 1; i < list.size(); ++i) {
            IAST temp;
            if (!(list.get(i) instanceof IAST) || !(temp = (IAST)list.get(i)).isAST2()) continue;
            IntVariable lhs = this.integerVariable(net, temp.arg1());
            IntVariable rhs = this.integerVariable(net, temp.arg2());
            if (temp.isEqual()) {
                lhs.equals(rhs);
                continue;
            }
            if (temp.isAST(S.Unequal, 3)) {
                lhs.notEquals(rhs);
                continue;
            }
            if (temp.isAST(S.Greater, 3)) {
                lhs.gt(rhs);
                continue;
            }
            if (temp.isAST(S.GreaterEqual, 3)) {
                lhs.ge(rhs);
                continue;
            }
            if (temp.isAST(S.LessEqual, 3)) {
                lhs.le(rhs);
                continue;
            }
            if (temp.isAST(S.Less, 3)) {
                lhs.lt(rhs);
                continue;
            }
            return null;
        }
        return net;
    }

    private IntVariable integerVariable(Network net, IExpr expr) throws ArithmeticException {
        if (expr instanceof ISymbol) {
            IntVariable temp = this.map.get(expr);
            if (temp == null) {
                temp = new IntVariable(net);
                this.map.put((ISymbol)expr, temp);
            }
            return temp;
        }
        if (expr instanceof IInteger) {
            int value = ((IInteger)expr).toInt();
            return new IntVariable(net, value);
        }
        if (expr.isAST()) {
            IAST ast = (IAST)expr;
            if (ast.isPlus()) {
                IntVariable result = this.integerVariable(net, ast.arg1());
                for (int i = 2; i < ast.size(); ++i) {
                    result = result.add(this.integerVariable(net, ast.get(i)));
                }
                return result;
            }
            if (ast.isTimes()) {
                IntVariable result = this.integerVariable(net, ast.arg1());
                for (int i = 2; i < ast.size(); ++i) {
                    result = result.multiply(this.integerVariable(net, ast.get(i)));
                }
                return result;
            }
            if (ast.isPower()) {
                int value;
                IExpr exponent = ast.exponent();
                if (exponent.isInteger() && (value = ((IInteger)exponent).toInt()) > 0) {
                    IExpr base = ast.base();
                    IntVariable result = this.integerVariable(net, base);
                    for (int i = 1; i < value; ++i) {
                        result = result.multiply(this.integerVariable(net, base));
                    }
                    return result;
                }
            } else {
                if (ast.isSameHeadSizeGE(S.Max, 3)) {
                    IntVariable result = this.integerVariable(net, ast.arg1());
                    for (int i = 2; i < ast.size(); ++i) {
                        result = result.max(this.integerVariable(net, ast.get(i)));
                    }
                    return result;
                }
                if (ast.isSameHeadSizeGE(S.Min, 3)) {
                    IntVariable result = this.integerVariable(net, ast.arg1());
                    for (int i = 2; i < ast.size(); ++i) {
                        result = result.min(this.integerVariable(net, ast.get(i)));
                    }
                    return result;
                }
                if (ast.isAbs()) {
                    return this.integerVariable(net, ast.arg1()).abs();
                }
                if (ast.isAST(S.Sign, 2)) {
                    return this.integerVariable(net, ast.arg1()).sign();
                }
            }
        }
        throw new ArgumentTypeException(expr.toString() + " is no int variable found for Solve(..., Integers)");
    }

    public Map<ISymbol, IntVariable> variableMap() {
        return this.map;
    }

    public IAST integerSolve(IAST list, IAST equationVariables, IAST userDefinedVariables, int maximumNumberOfResults, EvalEngine engine) {
        IASTAppendable result = F.ListAlloc();
        DefaultSolver solver = new DefaultSolver(this.expr2Cream(list, equationVariables), -1);
        solver.findAll((SolutionHandler)new CreamSolutionHandler(result, equationVariables, userDefinedVariables, maximumNumberOfResults, engine), 10000L);
        return result;
    }

    private final class CreamSolutionHandler
    implements SolutionHandler {
        private final IAST userDefinedVariables;
        private final IASTAppendable result;
        private final int maximumNumberOfResults;
        private final IAST equationVariables;
        private final EvalEngine engine;

        private CreamSolutionHandler(IASTAppendable result, IAST equationVariables, IAST userDefinedVariables, int maximumNumberOfResults, EvalEngine engine) {
            this.userDefinedVariables = userDefinedVariables;
            this.result = result;
            this.maximumNumberOfResults = maximumNumberOfResults;
            this.equationVariables = equationVariables;
            this.engine = engine;
        }

        public boolean solved(Solver solver, Solution solution) {
            if (solution != null) {
                IExpr listOfZZVariables = F.NIL;
                IExpr complement = S.Complement.of(this.engine, this.userDefinedVariables, this.equationVariables);
                if (complement.size() > 1 && complement.isList()) {
                    listOfZZVariables = S.Apply.of(this.engine, S.And, ((IAST)complement).mapThread(F.Element(F.Slot1, S.Integers), 1));
                }
                Set<Map.Entry<ISymbol, IntVariable>> set = CreamConvert.this.map.entrySet();
                IASTAppendable temp = F.ListAlloc(set.size());
                for (Map.Entry<ISymbol, IntVariable> entry : set) {
                    ISymbol variable = entry.getKey();
                    if (listOfZZVariables.isPresent()) {
                        temp.append(F.Rule((IExpr)variable, (IExpr)F.ConditionalExpression(F.ZZ(solution.getIntValue((Variable)entry.getValue())), listOfZZVariables)));
                        continue;
                    }
                    temp.append(F.Rule((IExpr)variable, (IExpr)F.ZZ(solution.getIntValue((Variable)entry.getValue()))));
                }
                this.result.append(temp);
                if (this.result.size() - 1 >= this.maximumNumberOfResults) {
                    return false;
                }
            }
            return true;
        }
    }
}

