/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.complex.Complex;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.RGBColor;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.SparseArrayExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;

public class Convert {
    public static Map<IExpr, IExpr> rules2Map(IAST astRules) {
        HashMap<IExpr, IExpr> map = new HashMap<IExpr, IExpr>();
        if (!astRules.isListOfLists()) {
            if (astRules.isList()) {
                if (astRules.size() > 1) {
                    for (IExpr expr : astRules) {
                        if (!expr.isRuleAST()) continue;
                        IAST rule = (IAST)expr;
                        map.put(rule.arg1(), rule.arg2());
                    }
                }
            } else if (astRules.isRuleAST()) {
                IAST rule = astRules;
                map.put(rule.arg1(), rule.arg2());
            }
        }
        return map;
    }

    private static IExpr[][] list2Array(IExpr expr, boolean ifNumericReturnNull) throws ClassCastException, IndexOutOfBoundsException {
        if (expr == null) {
            return null;
        }
        int[] dim = expr.isMatrix(false);
        if (dim == null || dim[0] == 0 || dim[1] == 0) {
            return null;
        }
        if (expr.isList()) {
            IAST list = (IAST)expr;
            IAST currInRow = (IAST)list.arg1();
            if (currInRow.isAST0()) {
                IExpr[][] array = new IExpr[0][0];
                return array;
            }
            int rowSize = expr.argSize();
            int colSize = currInRow.argSize();
            if (ifNumericReturnNull) {
                boolean hasInexactNumber = false;
                boolean isNoNumericFunction = true;
                for (int i = 1; i < rowSize + 1; ++i) {
                    currInRow = (IAST)list.get(i);
                    if (currInRow.isVector() < 0 || colSize != currInRow.argSize()) {
                        return null;
                    }
                    for (int j = 1; j < colSize + 1; ++j) {
                        IExpr arg = currInRow.get(j);
                        if (arg.isInexactNumber()) {
                            hasInexactNumber = true;
                        }
                        if (arg.isNumericFunction()) continue;
                        isNoNumericFunction = false;
                        break;
                    }
                    if (!isNoNumericFunction) break;
                }
                if (hasInexactNumber && isNoNumericFunction && !EvalEngine.get().isArbitraryMode()) {
                    return null;
                }
            }
            IExpr[][] elements = new IExpr[rowSize][colSize];
            for (int i = 1; i < rowSize + 1; ++i) {
                currInRow = (IAST)list.get(i);
                if (currInRow.isVector() < 0 || colSize != currInRow.argSize()) {
                    return null;
                }
                for (int j = 1; j < colSize + 1; ++j) {
                    elements[i - 1][j - 1] = currInRow.get(j);
                }
            }
            return elements;
        }
        return null;
    }

    public static FieldMatrix<IExpr> list2Matrix(IExpr expr) throws ClassCastException, IndexOutOfBoundsException {
        return Convert.list2Matrix(expr, false);
    }

    public static FieldMatrix<IExpr> list2Matrix(IExpr expr, boolean ifNumericReturnNull) throws ClassCastException, IndexOutOfBoundsException {
        IExpr[][] elements;
        if (expr == null) {
            return null;
        }
        int[] dim = expr.isMatrix(false);
        if (dim == null || dim[0] == 0 || dim[1] == 0) {
            return null;
        }
        if (expr.isSparseArray()) {
            ISparseArray array = (ISparseArray)expr;
            return array.toFieldMatrix(false);
        }
        if (expr.isList() && (elements = Convert.list2Array(expr, ifNumericReturnNull)) != null) {
            return new Array2DRowFieldMatrix((FieldElement[][])elements, false);
        }
        return null;
    }

    public static List<FieldVector<IExpr>> list2ListOfVectors(IExpr expr) throws ClassCastException, IndexOutOfBoundsException {
        return Convert.list2ListOfVectors(expr, false);
    }

    public static List<FieldVector<IExpr>> list2ListOfVectors(IExpr expr, boolean ifNumericReturnNull) throws ClassCastException, IndexOutOfBoundsException {
        IExpr[][] elements;
        if (expr == null) {
            return null;
        }
        int[] dim = expr.isMatrix(false);
        if (dim == null || dim[0] == 0 || dim[1] == 0) {
            return null;
        }
        if (expr.isList() && (elements = Convert.list2Array(expr, ifNumericReturnNull)) != null) {
            int length = elements.length;
            ArrayList<FieldVector<IExpr>> listOfVectors = new ArrayList<FieldVector<IExpr>>(length);
            for (int i = 0; i < length; ++i) {
                listOfVectors.add((FieldVector<IExpr>)new ArrayFieldVector((FieldElement[])elements[i], false));
            }
            return listOfVectors;
        }
        return null;
    }

    public static IASTAppendable listOfVectors2ListOfLists(List<FieldVector<IExpr>> listOfVectors) {
        if (listOfVectors == null) {
            return F.NIL;
        }
        int rowSize = listOfVectors.size();
        if (rowSize <= 0) {
            return F.NIL;
        }
        IASTAppendable result = F.ListAlloc(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            FieldVector<IExpr> fieldVector = listOfVectors.get(i);
            int colSize = fieldVector.getDimension();
            IASTAppendable currOutRow = F.ListAlloc(colSize);
            result.append(currOutRow);
            for (int j = 0; j < colSize; ++j) {
                IExpr expr = (IExpr)fieldVector.getEntry(j);
                if (expr.isNumber()) {
                    currOutRow.append(expr);
                    continue;
                }
                currOutRow.append(expr);
            }
        }
        return result;
    }

    public static FieldMatrix<Complex> list2ComplexMatrix(IExpr expr) throws ClassCastException, IndexOutOfBoundsException {
        if (expr == null) {
            return null;
        }
        int[] dim = expr.isMatrix();
        if (dim == null || dim[0] == 0 || dim[1] == 0) {
            return null;
        }
        if (expr.isSparseArray()) {
            expr = ((ISparseArray)expr).normal(false);
        }
        if (expr.isList()) {
            try {
                IAST list = (IAST)expr;
                IAST currInRow = (IAST)list.arg1();
                if (currInRow.isAST0()) {
                    Complex[][] array = new Complex[0][0];
                    return new Array2DRowFieldMatrix((FieldElement[][])array, false);
                }
                int rowSize = expr.argSize();
                int colSize = currInRow.argSize();
                Complex[][] elements = new Complex[rowSize][colSize];
                for (int i = 1; i < rowSize + 1; ++i) {
                    currInRow = (IAST)list.get(i);
                    if (currInRow.isVector() < 0 || colSize != currInRow.argSize()) {
                        return null;
                    }
                    for (int j = 1; j < colSize + 1; ++j) {
                        elements[i - 1][j - 1] = currInRow.get(j).evalComplex();
                    }
                }
                return new Array2DRowFieldMatrix((FieldElement[][])elements, false);
            }
            catch (ValidateException validateException) {
                // empty catch block
            }
        }
        return null;
    }

    public static FieldMatrix<IExpr> list2Matrix(IAST listMatrix, IAST listVector) throws ClassCastException, IndexOutOfBoundsException {
        if (listMatrix == null || listVector == null) {
            return null;
        }
        if (!listMatrix.isList() || !listVector.isList()) {
            return null;
        }
        if (listMatrix.size() != listVector.size()) {
            return null;
        }
        IAST currInRow = (IAST)listMatrix.arg1();
        if (currInRow.isAST0()) {
            IExpr[][] array = new IExpr[0][0];
            return new Array2DRowFieldMatrix((FieldElement[][])array, false);
        }
        int rowSize = listMatrix.argSize();
        int colSize = currInRow.argSize();
        IExpr[][] elements = new IExpr[rowSize][colSize + 1];
        for (int i = 1; i < rowSize + 1; ++i) {
            currInRow = (IAST)listMatrix.get(i);
            if (currInRow.head() != S.List || colSize != currInRow.argSize()) {
                return null;
            }
            for (int j = 1; j < colSize + 1; ++j) {
                elements[i - 1][j - 1] = currInRow.get(j);
            }
            elements[i - 1][colSize] = listVector.get(i);
        }
        return new Array2DRowFieldMatrix((FieldElement[][])elements, false);
    }

    public static GenMatrix<IExpr> list2GenMatrix(IExpr expr, boolean ifNumericReturnNull) throws ClassCastException, IndexOutOfBoundsException {
        if (expr == null) {
            return null;
        }
        int[] dim = expr.isMatrix();
        if (dim == null || dim[0] == 0 || dim[1] == 0) {
            return null;
        }
        if (expr.isList()) {
            IAST list = (IAST)expr;
            IAST currInRow = (IAST)list.arg1();
            if (currInRow.isAST0()) {
                IExpr[][] array = new IExpr[0][0];
                GenMatrixRing ring = new GenMatrixRing((RingFactory)ExprRingFactory.CONST, 0, 0);
                return new GenMatrix(ring, (RingElem[][])array);
            }
            int rowSize = expr.argSize();
            int colSize = currInRow.argSize();
            if (ifNumericReturnNull) {
                boolean hasInexactNumber = false;
                boolean isNoNumericFunction = true;
                for (int i = 1; i < rowSize + 1; ++i) {
                    currInRow = (IAST)list.get(i);
                    if (currInRow.isVector() < 0 || colSize != currInRow.argSize()) {
                        return null;
                    }
                    for (int j = 1; j < colSize + 1; ++j) {
                        IExpr arg = currInRow.get(j);
                        if (arg.isInexactNumber()) {
                            hasInexactNumber = true;
                        }
                        if (arg.isNumericFunction()) continue;
                        isNoNumericFunction = false;
                        break;
                    }
                    if (!isNoNumericFunction) break;
                }
                if (hasInexactNumber && isNoNumericFunction && !EvalEngine.get().isArbitraryMode()) {
                    return null;
                }
            }
            IExpr[][] elements = new IExpr[rowSize][colSize];
            for (int i = 1; i < rowSize + 1; ++i) {
                currInRow = (IAST)list.get(i);
                if (currInRow.isVector() < 0 || colSize != currInRow.argSize()) {
                    return null;
                }
                for (int j = 1; j < colSize + 1; ++j) {
                    elements[i - 1][j - 1] = currInRow.get(j);
                }
            }
            GenMatrixRing ring = new GenMatrixRing((RingFactory)ExprRingFactory.CONST, rowSize, colSize);
            return new GenMatrix(ring, (RingElem[][])elements);
        }
        return null;
    }

    public static FieldMatrix<IExpr> augmentedFieldMatrix(FieldMatrix<IExpr> listMatrix, FieldVector<IExpr> listVector) throws ClassCastException, IndexOutOfBoundsException {
        if (listMatrix == null || listVector == null) {
            return null;
        }
        int matrixRows = listMatrix.getRowDimension();
        int matrixColumns = listMatrix.getColumnDimension();
        int vectorDimension = listVector.getDimension();
        if (matrixRows != vectorDimension) {
            return null;
        }
        if (matrixColumns == 0) {
            IExpr[][] array = new IExpr[0][0];
            return new Array2DRowFieldMatrix((FieldElement[][])array, false);
        }
        IExpr[][] elements = new IExpr[matrixRows][matrixColumns + 1];
        for (int i = 0; i < matrixRows; ++i) {
            for (int j = 0; j < matrixColumns; ++j) {
                elements[i][j] = (IExpr)listMatrix.getEntry(i, j);
            }
            elements[i][matrixColumns] = (IExpr)listVector.getEntry(i);
        }
        return new Array2DRowFieldMatrix((FieldElement[][])elements, false);
    }

    public static void joinToString(double[] vector, StringBuilder builder, CharSequence delimiter) {
        int size = vector.length;
        for (int i = 0; i < size; ++i) {
            builder.append(Double.toString(vector[i]));
            if (i >= size - 1) continue;
            builder.append(delimiter);
        }
    }

    @Deprecated
    public static RealMatrix list2RealMatrix(IAST listMatrix) throws ClassCastException, IndexOutOfBoundsException {
        if (listMatrix == null) {
            return null;
        }
        if (listMatrix instanceof ASTRealMatrix) {
            return ((ASTRealMatrix)listMatrix).getRealMatrix();
        }
        IExpr header = listMatrix.head();
        if (header != S.List) {
            return null;
        }
        IAST currInRow = (IAST)listMatrix.arg1();
        if (currInRow.isAST0()) {
            double[][] array = new double[0][0];
            return new Array2DRowRealMatrix(array, false);
        }
        double[][] elements = listMatrix.toDoubleMatrix();
        if (elements == null) {
            return null;
        }
        return new Array2DRowRealMatrix(elements, false);
    }

    @Deprecated
    public static RealVector list2RealVector(IAST listVector) throws ClassCastException, IndexOutOfBoundsException {
        if (listVector instanceof ASTRealVector) {
            return ((ASTRealVector)listVector).getRealVector();
        }
        IExpr header = listVector.head();
        if (header != S.List) {
            return null;
        }
        double[] elements = listVector.toDoubleVector();
        if (elements == null) {
            return null;
        }
        return new ArrayRealVector(elements, false);
    }

    public static FieldVector<IExpr> list2Vector(IExpr expr) throws ClassCastException {
        if (expr == null) {
            return null;
        }
        int dim = expr.isVector();
        if (dim <= 0) {
            return null;
        }
        if (expr.isSparseArray()) {
            ISparseArray array = (ISparseArray)expr;
            return array.toFieldVector(false);
        }
        if (expr.isList()) {
            int rowSize = expr.argSize();
            IAST list = (IAST)expr;
            IExpr[] elements = new IExpr[rowSize];
            for (int i = 0; i < rowSize; ++i) {
                elements[i] = list.get(i + 1);
            }
            return new ArrayFieldVector((FieldElement[])elements, false);
        }
        return null;
    }

    public static FieldVector<Complex> list2ComplexVector(IExpr expr) throws ClassCastException {
        if (expr == null) {
            return null;
        }
        int dim = expr.isVector();
        if (dim <= 0) {
            return null;
        }
        if (expr.isSparseArray()) {
            expr = ((ISparseArray)expr).normal(false);
        }
        if (expr.isList()) {
            try {
                int rowSize = expr.argSize();
                IAST list = (IAST)expr;
                Complex[] elements = new Complex[rowSize];
                for (int i = 0; i < rowSize; ++i) {
                    elements[i] = list.get(i + 1).evalComplex();
                }
                return new ArrayFieldVector((FieldElement[])elements, false);
            }
            catch (ValidateException validateException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Complex[] list2Complex(IAST vector) throws ClassCastException {
        if (vector == null) {
            return null;
        }
        IExpr header = vector.head();
        if (header != S.List) {
            return null;
        }
        int size = vector.argSize();
        Complex[] elements = new Complex[size];
        EvalEngine engine = EvalEngine.get();
        for (int i = 0; i < size; ++i) {
            IExpr element = vector.get(i + 1);
            elements[i] = engine.evalComplex(element);
        }
        return elements;
    }

    public static IAST toVector(Complex[] vector) {
        if (vector == null) {
            return F.NIL;
        }
        IASTAppendable result = F.ListAlloc(vector.length);
        for (int i = 0; i < vector.length; ++i) {
            result.append(F.complexNum(vector[i]));
        }
        return result;
    }

    public static IASTAppendable matrix2List(FieldMatrix<IExpr> matrix) {
        return Convert.matrix2List(matrix, true);
    }

    public static IExpr matrix2Expr(FieldMatrix<IExpr> matrix) {
        if (matrix instanceof SparseArrayExpr.SparseExprMatrix) {
            return ((SparseArrayExpr.SparseExprMatrix)matrix).getSparseArray();
        }
        return Convert.matrix2List(matrix);
    }

    public static IASTAppendable matrix2List(FieldMatrix<IExpr> matrix, boolean matrixFormat) {
        if (matrix == null) {
            return F.NIL;
        }
        int rowSize = matrix.getRowDimension();
        int colSize = matrix.getColumnDimension();
        IASTAppendable result = F.ListAlloc(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            IASTAppendable currOutRow = F.ListAlloc(colSize);
            result.append(currOutRow);
            for (int j = 0; j < colSize; ++j) {
                IExpr expr = (IExpr)matrix.getEntry(i, j);
                if (expr.isNumber()) {
                    currOutRow.append(expr);
                    continue;
                }
                currOutRow.append(expr);
            }
        }
        if (matrixFormat) {
            result.isMatrix(true);
        }
        return result;
    }

    public static IASTAppendable genmatrix2List(GenMatrix<IExpr> matrix, boolean matrixFormat) {
        if (matrix == null) {
            return F.NIL;
        }
        int rowSize = matrix.ring.rows;
        int colSize = matrix.ring.cols;
        IASTAppendable out = F.ListAlloc(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            IASTAppendable currOutRow = F.ListAlloc(colSize);
            out.append(currOutRow);
            for (int j = 0; j < colSize; ++j) {
                IExpr expr = (IExpr)matrix.get(i, j);
                if (expr.isNumber()) {
                    currOutRow.append(expr);
                    continue;
                }
                currOutRow.append(expr);
            }
        }
        if (matrixFormat) {
            out.isMatrix(true);
        }
        return out;
    }

    public static IASTAppendable complexMatrix2List(FieldMatrix<Complex> matrix) {
        return Convert.complexMatrix2List(matrix, true);
    }

    public static IASTAppendable complexMatrix2List(FieldMatrix<Complex> matrix, boolean matrixFormat) {
        if (matrix == null) {
            return F.NIL;
        }
        int rowSize = matrix.getRowDimension();
        int colSize = matrix.getColumnDimension();
        IASTAppendable out = F.ListAlloc(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            IASTAppendable currOutRow = F.ListAlloc(colSize);
            out.append(currOutRow);
            for (int j = 0; j < colSize; ++j) {
                Complex expr = (Complex)matrix.getEntry(i, j);
                currOutRow.append(F.complexNum(expr));
            }
        }
        if (matrixFormat) {
            out.isMatrix(true);
        }
        return out;
    }

    public static IASTAppendable matrix2List(RealMatrix matrix) {
        return Convert.matrix2List(matrix, true);
    }

    public static IASTAppendable matrix2List(RealMatrix matrix, boolean matrixFormat) {
        if (matrix == null) {
            return F.NIL;
        }
        int rowSize = matrix.getRowDimension();
        int colSize = matrix.getColumnDimension();
        IASTAppendable result = F.ListAlloc(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            IASTAppendable currOutRow = F.ListAlloc(colSize);
            result.append(currOutRow);
            for (int j = 0; j < colSize; ++j) {
                INum expr = F.num(matrix.getEntry(i, j));
                if (expr.isNumber()) {
                    currOutRow.append(expr);
                    continue;
                }
                currOutRow.append(expr);
            }
        }
        if (matrixFormat) {
            result.isMatrix(true);
        }
        return result;
    }

    public static IExpr polynomialFunction2Expr(double[] coefficients, ISymbol sym) {
        if (coefficients[0] == 0.0 && coefficients.length == 1) {
            return F.C0;
        }
        IASTAppendable sum = F.PlusAlloc(coefficients.length);
        sum.append(coefficients[0]);
        for (int i = 1; i < coefficients.length; ++i) {
            if (coefficients[i] == 0.0) continue;
            sum.append(F.Times((IExpr)F.num(coefficients[i]), (IExpr)F.Power((IExpr)sym, F.ZZ(i))));
        }
        return sum;
    }

    public static IExpr polynomialFunction2Expr(PolynomialFunction pf, ISymbol sym) {
        double[] coefficients = pf.getCoefficients();
        return Convert.polynomialFunction2Expr(coefficients, sym);
    }

    public static IASTMutable realMatrix2List(RealMatrix matrix) {
        if (matrix == null) {
            return F.NIL;
        }
        return new ASTRealMatrix(matrix, false);
    }

    public static IASTMutable realVectors2List(RealVector vector) {
        if (vector == null) {
            return F.NIL;
        }
        return new ASTRealVector(vector, false);
    }

    public static IASTAppendable complexVector2List(FieldVector<Complex> vector) {
        return Convert.complexVector2List(vector, true);
    }

    public static IASTAppendable complexVector2List(FieldVector<Complex> vector, boolean vectorFormat) {
        if (vector == null) {
            return F.NIL;
        }
        int rowSize = vector.getDimension();
        IASTAppendable out = F.ListAlloc(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            out.append(F.complexNum((Complex)vector.getEntry(i)));
        }
        out.addEvalFlags(64);
        return out;
    }

    public static IASTAppendable vector2List(RealVector vector) {
        return Convert.vector2List(vector, true);
    }

    public static IASTAppendable vector2List(RealVector vector, boolean vectorFormat) {
        if (vector == null) {
            return F.NIL;
        }
        int rowSize = vector.getDimension();
        IASTAppendable out = F.ListAlloc(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            out.append(vector.getEntry(i));
        }
        out.addEvalFlags(64);
        return out;
    }

    public static double[][] toDoubleTransposed(double[][] dd) {
        int columnLength = dd[0].length;
        int rowLength = dd.length;
        double[][] result = new double[columnLength][rowLength];
        for (int i = 0; i < columnLength; ++i) {
            for (int j = 0; j < rowLength; ++j) {
                result[i][j] = dd[j][i];
            }
        }
        return result;
    }

    public static IAST toExprTransposed(double[][] dd) {
        try {
            int columnLength = dd[0].length;
            int rowLength = dd.length;
            IASTAppendable list = F.ListAlloc(columnLength);
            for (int i = 0; i < columnLength; ++i) {
                IASTAppendable row = F.ListAlloc(rowLength);
                for (int j = 0; j < rowLength; ++j) {
                    row.append(dd[j][i]);
                }
                list.append(row);
            }
            list.isMatrix(true);
            return list;
        }
        catch (Exception exception) {
            return F.NIL;
        }
    }

    public static IAST vector2List(FieldVector<IExpr> vector) {
        if (vector == null) {
            return F.NIL;
        }
        int rowSize = vector.getDimension();
        IASTAppendable out = F.ListAlloc(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            out.append((IExpr)vector.getEntry(i));
        }
        out.addEvalFlags(64);
        return out;
    }

    public static IExpr vector2Expr(FieldVector<IExpr> vector) {
        if (vector == null) {
            return F.NIL;
        }
        if (vector instanceof SparseArrayExpr.SparseExprVector) {
            return ((SparseArrayExpr.SparseExprVector)vector).getSparseArray();
        }
        return Convert.vector2List(vector);
    }

    private Convert() {
    }

    public static List<String> toStringList(IExpr expr) {
        if (expr.isList()) {
            ArrayList<String> result = new ArrayList<String>(expr.size() - 1);
            IAST listOfStrings = (IAST)expr;
            for (int i = 1; i < listOfStrings.size(); ++i) {
                if (!(listOfStrings.get(i) instanceof IStringX)) {
                    return null;
                }
                result.add(listOfStrings.get(i).toString());
            }
            return result;
        }
        ArrayList<String> result = new ArrayList<String>(1);
        if (expr instanceof IStringX) {
            result.add(expr.toString());
            return result;
        }
        return null;
    }

    public static int[] checkNonEmptySquareMatrix(ISymbol symbol, IExpr arg1) {
        int[] dim = arg1.isMatrix();
        if ((dim == null || dim[0] != dim[1] || dim[1] == 0) && (arg1.isListOrAssociation() || arg1.isSparseArray())) {
            if (arg1.isAST()) {
                ((IAST)arg1).setEvalFlags(0);
            }
            IOFunctions.printMessage(symbol, "matsq", F.list(arg1, F.C1), EvalEngine.get());
            return null;
        }
        return dim;
    }

    public static int[] checkNonEmptyRectangularMatrix(ISymbol symbol, IExpr arg1) {
        int[] dim = arg1.isMatrix();
        if (dim == null || dim[1] == 0) {
            if (arg1.isListOrAssociation() || arg1.isSparseArray()) {
                if (arg1.isAST()) {
                    ((IAST)arg1).setEvalFlags(0);
                }
                IOFunctions.printMessage(symbol, "matrix", F.list(arg1, F.C1), EvalEngine.get());
            }
            return null;
        }
        return dim;
    }

    public static RGBColor toAWTColor(IExpr rgbColorAST) {
        return Convert.toAWTColorDefault(rgbColorAST, null);
    }

    public static RGBColor toAWTColorDefault(IExpr rgbColorAST, RGBColor defaultColor) {
        if (rgbColorAST.isAST((IExpr)S.RGBColor, 4, 5)) {
            IAST rgbColor = (IAST)rgbColorAST;
            float r = (float)rgbColor.arg1().evalDouble();
            float g = (float)rgbColor.arg2().evalDouble();
            float b = (float)rgbColor.arg3().evalDouble();
            return new RGBColor(r, g, b);
        }
        return defaultColor;
    }

    public static RGBColor toAWTColorDefault(IAST rgbColor) {
        return Convert.toAWTColorDefault(rgbColor, RGBColor.BLACK);
    }

    public static String toHex(RGBColor c) {
        return "#" + Integer.toHexString(c.getRGB()).substring(2);
    }
}

