/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.combinatoric;

import java.util.Iterator;
import org.matheclipse.core.combinatoric.ArrayUtils;

public class RosenNumberPartitionIterator
implements Iterator<int[]> {
    protected final int n;
    protected final int k;
    private int[] a;
    protected long count;

    public static long count(int n, int k) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("0 <= k <= " + n + "!");
        }
        long count = 1L;
        for (int i = 0; i < k; ++i) {
            count = count * (long)(n - i) / (long)(i + 1);
        }
        return count;
    }

    public RosenNumberPartitionIterator(int n, int k) {
        this.n = n - 1;
        this.k = k - 1;
        if (k > n || k < 1) {
            throw new IllegalArgumentException("RosenNumberPartitionIterator: k " + k + " > " + n);
        }
        this.count = RosenNumberPartitionIterator.count(this.n, this.k);
    }

    @Override
    public final boolean hasNext() {
        return this.count > 0L;
    }

    @Override
    public final int[] next() {
        if (this.a == null) {
            this.a = ArrayUtils.identityPermutation(this.k);
        } else {
            int i = this.k - 1;
            while (this.a[i] == this.n - this.k + i) {
                --i;
            }
            int n = i;
            int n2 = this.a[n] + 1;
            this.a[n] = n2;
            int t = n2 - i++;
            int j = i;
            while (j < this.k) {
                this.a[j] = t + j++;
            }
        }
        --this.count;
        int kPlus1 = this.k + 1;
        int[] temp = new int[kPlus1];
        for (int i = 0; i < kPlus1; ++i) {
            temp[i] = i == 0 ? this.a[i] + 1 : (i == this.k ? this.n - this.a[i - 1] : this.a[i] - this.a[i - 1]);
        }
        return temp;
    }

    public void reset() {
        this.count = RosenNumberPartitionIterator.count(this.n, this.k);
        this.a = null;
    }
}

