/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.combinatoric;

import org.matheclipse.core.combinatoric.ArrayUtils;
import org.matheclipse.core.combinatoric.MultisetCombinationIterator;
import org.matheclipse.core.combinatoric.RosenNumberPartitionIterator;
import org.matheclipse.core.patternmatching.FlatOrderlessStepVisitor;

public class MultisetPartitionsIterator {
    private final int n;
    private final int[] multiset;
    private final int[][] result;
    private RosenNumberPartitionIterator rosen;
    private int[] currentRosen;
    private final FlatOrderlessStepVisitor handler;

    public MultisetPartitionsIterator(FlatOrderlessStepVisitor visitor, int k) {
        int[] mset = visitor.getMultisetArray();
        this.n = mset.length;
        if (k > this.n || k < 1) {
            throw new IllegalArgumentException("MultisetPartitionsIterator: k " + k + " > " + this.n);
        }
        this.multiset = mset;
        this.result = new int[k][];
        this.rosen = new RosenNumberPartitionIterator(this.n, k);
        this.handler = visitor;
    }

    public void reset() {
        this.rosen.reset();
        for (int i = 0; i < this.result.length; ++i) {
            this.result[i] = null;
        }
        this.initPatternMap();
    }

    public void initPatternMap() {
        this.handler.initPatternMap();
    }

    public boolean execute() {
        while (this.rosen.hasNext()) {
            this.currentRosen = this.rosen.next();
            if (!this.multisetCombinationRecursive(this.multiset, 0)) continue;
            return false;
        }
        return true;
    }

    private boolean multisetCombinationRecursive(int[] multiset, int i) {
        if (i < this.currentRosen.length) {
            MultisetCombinationIterator iter = new MultisetCombinationIterator(multiset, this.currentRosen[i]);
            while (iter.hasNext()) {
                int[] currentSubset = iter.next();
                this.result[i] = currentSubset;
                int[] wc = ArrayUtils.deleteSubset(multiset, currentSubset);
                if (!this.multisetCombinationRecursive(wc, i + 1)) continue;
                return true;
            }
            return false;
        }
        return !this.handler.visit(this.result);
    }

    public String toString() {
        return this.handler.toString(this.result);
    }
}

