/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.combinatoric;

import java.util.Iterator;

public class MultisetCombinationIterator
implements Iterator<int[]> {
    private int[] result;
    private final int[] multiset;
    private final int n;
    private final int k;

    public MultisetCombinationIterator(int[] multiset, int k) {
        this.multiset = multiset;
        this.n = multiset.length;
        this.k = k;
        if (k > this.n || k < 1) {
            throw new IllegalArgumentException("MultisetCombinationIterator: k " + k + " > " + this.n);
        }
        this.result = null;
    }

    public void reset() {
        this.result = null;
    }

    @Override
    public int[] next() {
        if (this.result == null) {
            this.result = new int[this.k];
            System.arraycopy(this.multiset, 0, this.result, 0, this.k);
        } else {
            for (int i = this.k - 1; i >= 0; --i) {
                if (this.result[i] >= this.multiset[i + (this.n - this.k)]) continue;
                int j = 0;
                while (this.multiset[j] <= this.result[i]) {
                    ++j;
                }
                this.result[i] = this.multiset[j];
                if (i < this.k - 1) {
                    int l = i + 1;
                    ++j;
                    while (l < this.k) {
                        this.result[l] = this.multiset[j];
                        ++l;
                        ++j;
                    }
                }
                return this.result;
            }
        }
        return this.result;
    }

    @Override
    public final boolean hasNext() {
        if (this.result == null) {
            return true;
        }
        for (int i = this.k - 1; i >= 0; --i) {
            if (this.result[i] >= this.multiset[i + (this.n - this.k)]) continue;
            return true;
        }
        return false;
    }
}

