/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.combinatoric;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KSubsets {
    public static <E, T extends List<E>> KSubsetsList<E, T> createKSubsets(T list, int k, int offset) {
        return new KSubsetsList(list, k, offset);
    }

    public static long binomial(long n, long k) {
        long bin = 1L;
        long kSub = k;
        if (kSub > n / 2L) {
            kSub = n - kSub;
        }
        for (long i = 1L; i <= kSub; ++i) {
            bin = bin * (n - i + 1L) / i;
        }
        return bin;
    }

    public static final class KSubsetsList<E, T extends List<E>>
    implements Iterable<T> {
        private final T fList;
        private final int fOffset;
        private final int fK;

        public KSubsetsList(T list, int k, int offset) {
            this.fList = list;
            this.fK = k;
            this.fOffset = offset;
        }

        @Override
        public Iterator<T> iterator() {
            return new KSubsetsListIterator();
        }

        private class KSubsetsListIterator
        implements Iterator<T> {
            private final Iterator<int[]> fIterable;

            private KSubsetsListIterator() {
                this.fIterable = new KSubsetsIterable(KSubsetsList.this.fList.size() - KSubsetsList.this.fOffset, KSubsetsList.this.fK).iterator();
            }

            @Override
            public T next() {
                int[] j = this.fIterable.next();
                if (j == null) {
                    return null;
                }
                ArrayList temp = new ArrayList(KSubsetsList.this.fK);
                for (int i = 0; i < KSubsetsList.this.fK; ++i) {
                    temp.add(KSubsetsList.this.fList.get(j[i] + KSubsetsList.this.fOffset));
                }
                return temp;
            }

            @Override
            public boolean hasNext() {
                return this.fIterable.hasNext();
            }
        }
    }

    public static final class KSubsetsIterable
    implements Iterable<int[]> {
        private final int n;
        private final int k;
        private long bin;
        private boolean first;

        public KSubsetsIterable(int len, int parts) {
            this.n = len;
            this.k = parts;
            if (this.k > this.n || this.k < 0) {
                throw new IllegalArgumentException("KSubsets: k>n - " + this.k + " > " + this.n);
            }
            this.bin = KSubsets.binomial(this.n, this.k);
            this.first = true;
        }

        @Override
        public Iterator<int[]> iterator() {
            return new KSubsetsIterator();
        }

        private class KSubsetsIterator
        implements Iterator<int[]> {
            private final int[] x;

            private KSubsetsIterator() {
                this.x = new int[KSubsetsIterable.this.n];
                for (int a = 0; a < KSubsetsIterable.this.n; ++a) {
                    this.x[a] = a;
                }
            }

            @Override
            public int[] next() {
                if (KSubsetsIterable.this.bin-- == 0L) {
                    return null;
                }
                if (KSubsetsIterable.this.first) {
                    KSubsetsIterable.this.first = false;
                    return this.x;
                }
                int i = KSubsetsIterable.this.k - 1;
                while (this.x[i] == KSubsetsIterable.this.n - KSubsetsIterable.this.k + i) {
                    --i;
                }
                this.x[i] = this.x[i] + 1;
                for (int j = i + 1; j < KSubsetsIterable.this.n; ++j) {
                    this.x[j] = this.x[j - 1] + 1;
                }
                return this.x;
            }

            @Override
            public boolean hasNext() {
                return true;
            }
        }
    }
}

